unit untTopicBrowserIE;

interface

uses
  Classes, SHDocVw_TLB, untHTMLDocumentEvent,
  untTopic, untTopicBrowser, untRegExpr, Dialogs,
  Graphics;

type
  TTopicBrowserIE = class(TTopicBrowser)
  private
    FBrowser: TWebBrowser;
    FHtmlEvent: THTMLDocumentEventSink;
    FLogSkipCount:    integer;
    FReceivedIndex:   integer;
    FReplaceMode:     integer;
    FStartIndex:      integer;
    FDownloadComplete: boolean;
    FRestoredPos:      boolean;
    FWaitInitialize:   boolean;
    FNoScroll:         boolean;
    FOutputedHeader:   boolean;
    FReserveRefresh:   boolean;
    NGWords: TStringList;
  protected
    procedure BrowserInitialize;
    procedure Browser_NavigateComplete2(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant);
    procedure Browser_StatusTextChange(Sender: TObject; const Text: WideString);
    procedure Browser_BeforeNavigate(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant; var Flags: OleVariant; var TargetFrameName: OleVariant; var PostData: OleVariant; var Headers: OleVariant; var Cancel: WordBool);
    procedure BrowserOutput(output: string);
//  procedure RestoreScrollPosition; override;
    procedure DisplayMessageByRange;
    procedure SetNGWords;
    function  DatToHtml(body: string): string;
    function  DatToHtml2(body: string; ref: string): string;
    function  ReplaceString(MatchStr: string): string;
    function  OnContextMenu(Sender: TObject): WordBool;
    function  MsgToHtml(msg: TTopicMessage): string;
    function  DeleteTag(strbody: string): string;
  public
//  mBrowser: TWebBrowser;

    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure JumpMessage(const msgNo: integer); override;

    procedure SaveScrollPosition; override;
    procedure RestoreScrollPosition; override;

    procedure ChangeViewLimit(NewLimit: integer); override;
    procedure SearchText(const str: string; mode: boolean); override;
    procedure CloseTopic; override;
    procedure Reload;   override;
    procedure SetTextSize(const TextSize: Integer);
    procedure Topic_MessageReceived(Sender: TObject); override;
    procedure Topic_ChangeDownloadState(Sender: TObject); override;
    function GetTextSize: integer;
    procedure SetFont(fname: string; fsize: integer); override;
//  procedure SetHTMLColor(mes: integer; nam: integer; lnk: integer; bg: integer); override;
    procedure SetHTMLColor(mes: integer; nam: integer; namelink: integer; lnk: integer; bg: integer); override;
    procedure   SetWallpaper(g: TGraphic); override;
    procedure IDSearch(id: string); override;
    procedure IDSearchPopUp(id: string); override;
  end;

implementation

{$WARN SYMBOL_PLATFORM OFF}

uses
  Controls, MSHTML_TLB, SysUtils, untBmRegExp, Forms, StrUtils,
  untOnlineBoard, untGlobal, untTool;

procedure TTopicBrowserIE.DisplayMessageByRange;
var
  msg: TTopicMessage;
  html: string;
  i: integer;

begin
  for i := FReceivedIndex to Topic.MessageList.Count - 1 do
  begin
    if RangeNoList.IndexOf(IntToStr(i + 1)) > -1 then
    begin
      msg := TTopicMessage(Topic.MessageList[i]);
      html := html + MsgToHtml(msg);
    end;
    Inc(FReceivedIndex);
  end;
  BrowserOutput(html);
  Application.ProcessMessages;
  FLoading := false;
end;

// bZ[WM
procedure TTopicBrowserIE.Topic_MessageReceived(Sender: TObject);
var
  msg: TTopicMessage;
  html: string;

begin
  if FLoading or (Topic.MessageList.Count = 0) then
  begin
    exit;
  end;

  //X擾邽тngword.txtǂݍݒ
  SetNGWords();

  FLoading := true;
  FDownloading:= true;

  if FReceivedIndex = 0 then
  begin
    // 1Xڂ͕K\
    msg := TTopicMessage(Topic.MessageList[FReceivedIndex]);
    html := MsgToHtml(msg);
    if msg.IsNewMessage then
    begin
      // 1XڂV̂Ƃ̓XN[Ȃ
      FNoScroll := true;
      msg.IsNewMessage := false;
    end;
    Inc(FReceivedIndex);
    Inc(FLogSkipCount);
  end;

  if (Topic.GotMessageCount > FViewLimit) and (FViewLimit > 0) then
  begin
    // \ȂXXLbv
    while FReceivedIndex < Topic.MessageList.Count do
    begin
      msg := TTopicMessage(Topic.MessageList[FReceivedIndex]);

      if msg.IsNewMessage or
         (FViewLimit + FLogSkipCount >= Topic.GotMessageCount) then
      begin
        break;
      end;
      
      Inc(FLogSkipCount);
      Inc(FReceivedIndex);
    end;
  end;

  while FReceivedIndex < Topic.MessageList.Count do
  begin
    msg := TTopicMessage(Topic.MessageList[FReceivedIndex]);

    if (FStartIndex = 0) and (msg.Index > 1) then
    begin
      FStartIndex := msg.Index;
    end;

    if not FRestoredPos and msg.IsNewMessage then
    begin
      // XN[
      BrowserOutput(html);
      Application.ProcessMessages;
      html := '';
      if StartNo = 0 then
      begin
        RestoreScrollPosition;
      end else if FReceivedIndex >= StartNo then
      begin
        JumpMessage(StartNo);
        StartNo := 0;
      end;
    end;

    // 
    html := html + MsgToHtml(msg);
    msg.IsNewMessage := false;
    Inc(FReceivedIndex);
  end;

  BrowserOutput(html);
  Application.ProcessMessages;
  FLoading := false;

  if FReceivedIndex >= Topic.MessageList.Count then
  begin
    // XN[
    if StartNo = 0 then
    begin
      RestoreScrollPosition;
    end else if FReceivedIndex >= StartNo then
    begin
      JumpMessage(StartNo);
      StartNo := 0;
    end;
  end;

end;

// Xe[^Xo[̕ω
procedure TTopicBrowserIE.Browser_StatusTextChange(Sender: TObject;
                                                   const Text: WideString);
begin
  inherited ChangePopup(Text);
end;

constructor TTopicBrowserIE.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FHtmlEvent := nil;

  NGWords := TStringList.Create;

  // uEU̐
  FBrowser := TWebBrowser.Create(self);
  TWinControl(FBrowser).Parent := self;
  FBrowser.Align   := alClient;
  FBrowser.Visible := true;
  FBrowser.OnNavigateComplete2 := Browser_NavigateComplete2;
  FBrowser.OnStatusTextChange  := Browser_StatusTextChange;
  FBrowser.OnBeforeNavigate2   := Browser_BeforeNavigate;

  BrowserInitialize();

end;

destructor TTopicBrowserIE.Destroy;
begin
  FBrowser.Free;
  FHtmlEvent.Free;

  NGWords.Free;

  inherited;
end;

procedure TTopicBrowserIE.Reload;
begin
  FLogSkipCount := 0;
  inherited;
end;

procedure TTopicBrowserIE.ChangeViewLimit(NewLimit: integer);
begin

  FViewLimit := newlimit;
	if Assigned(Topic) then
  begin
    //Topic.CancelDownload;

    SaveScrollPosition();
    Topic.SaveIdx();

    // ʃNA
    BrowserInitialize();
    // V擾
    Reload;
  end;
end;

// uEȔ
procedure TTopicBrowserIE.Browser_NavigateComplete2(Sender: TObject;
                                                    const pDisp: IDispatch;
                                                    var URL: OleVariant);
var
  Disp: DispHTMLDocument;//ISimpleCom;

begin
  if FWaitInitialize = true then
  begin
 		FWaitInitialize := false;

    Disp := FBrowser.Document as DispHTMLDocument;
    FHtmlEvent := THTMLDocumentEventSink.Create(Self, Disp, HTMLDocumentEvents2);
    FHtmlEvent.OnContextMenu := OnContextMenu;
  end;
end;

function TTopicBrowserIE.OnContextMenu(Sender: TObject): WordBool;
var
	doc: IHtmlDocument2;
	range: IHTMLTxtRange;
	s: string;
  msgNo: integer;

begin
  result := True;

	doc := FBrowser.Document as IHtmlDocument2;
	range := doc.selection.createRange as IHTMLTxtRange;
	s := StringReplace(range.text, '@', ' ', [rfReplaceAll]);
	s := ZenkakuToHankaku(Trim(s));
  msgNo := StrToIntNeo(s);
  if (msgNo > 0) and inherited ChangePopup('jump://goto/' + IntToStr(msgNo)) then
  begin
    result := false;
  end;
end;

procedure TTopicBrowserIE.BrowserInitialize();
begin
  FReceivedIndex  := 0;
  FLogSkipCount   := 0;
  FStartIndex     := 0;
  FReserveRefresh := false;
  FRestoredPos    := false;
  FOutputedHeader := false;
  FWaitInitialize := true;

  if FBrowser.Document<>Nil then
  begin
//  FBrowser.OleObject.Document.Write('');
    FBrowser.Navigate('about:blank');
    // o܂ő҂
    while FWaitInitialize do
    begin
      Application.ProcessMessages;
    end;
  end else
  begin
    FBrowser.Navigate('about:blank');
    // o܂ő҂
    while FWaitInitialize do
    begin
      Application.ProcessMessages;
    end;
  end;
end;
//------------------------------------------------------------------
//
// XN[ʒuۑ
//
//------------------------------------------------------------------
procedure TTopicBrowserIE.SaveScrollPosition;
var
//body: Variant;
  body: OleVariant;
  top, scrollheight, lastspace: integer;

begin
inherited;
	try
		if Assigned(Topic) and Assigned(FBrowser) then
		begin
			body := (FBrowser.Document as IHTMLDocument2).body;
			scrollheight := body.scrollHeight;
			top          := body.scrollTop;
			lastspace    := scrollheight  -  top;
			Topic.ScrollPosition := lastspace;
			Topic.PhysicalScrollPositionIE := top;
		end;
	//	except on e: EAccessViolation do
		except on e: Exception do
		begin
		end;
	end;
end;
//
//
//
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TTopicBrowserIE.BrowserOutput(output: string);
begin
  if output = '' then
  begin
    exit;
  end;

  if FReserveRefresh then
  begin
    BrowserInitialize;
  end;

  if not FOutputedHeader then
  begin

    output := StringReplace(gConfig.HeaderHtml,
                            '&THREADURL',
                            Topic.BrowserUrl,
                            [rfReplaceAll]) + output;
    output := StringReplace(output, '<THREADURL/>', Topic.BrowserUrl, [rfReplaceAll]);

    FOutputedHeader := true;
  end;
  //OleVariant(FBrowser.Document as IHTMLDocument2).write(output);
   FBrowser.OleObject.Document.Write(output);
end;

procedure TTopicBrowserIE.SearchText(const str: string; mode: boolean);
var
  i: integer;
  msg: TTopicMessage;
  html: string;
  find: boolean;

  RegEx: TRegExpr;
begin
  BrowserInitialize;

  RegEx := TRegExpr.Create;
  try
  RegEx.Expression := str;

  for i := 0 to Topic.MessageList.Count -1 do
  begin
    find := false;
    msg := TTopicMessage(Topic.MessageList[i]);

    if RegEx.Exec(DeleteTag(msg.PostName)) then
    find := true
    else
      if RegEx.Exec(msg.Postemail) then
      find := true
      else
        if RegEx.Exec(msg.RestStr) then
        find := true
        else
          if RegEx.Exec(msg.Body) then
          find := true;
{
    find := AnsiContainsText(DeleteTag(msg.PostName), str);
    if not find then
    begin
      find := AnsiContainsText(msg.Postemail, str);
      if not find then
      begin
        find := AnsiContainsText(msg.RestStr, str);
        if not find then
        begin
          find := AnsiContainsText(msg.Body, str);
        end;
      end;
    end;
}
    if find then
    begin
      msg  := TTopicMessage(Topic.MessageList[I]);
      html := MsgToHtml(msg);
      BrowserOutput(html);
      Application.ProcessMessages;
    end;
  end;

  finally
  RegEx.Free;
  end;

  FReserveRefresh := true;
end;
{
procedure TTopicBrowserIE.RestoreScrollPosition;
var
  body: OleVariant;
  scrollheight, top: integer;

begin
  inherited;

  if FRestoredPos then
  begin
    exit;
  end;
  FRestoredPos := true;

  if FNoScroll then
  begin
    FNoScroll := false;
    exit;
  end;
  body := (FBrowser.Document as IHTMLDocument2).body;
  scrollheight := body.scrollHeight;
  top := scrollheight  -  Topic.ScrollPosition;
  body.scrollTop := top;

end;
}
//------------------------------------------------------------------
//
// XN[ʒu̕A
//
//------------------------------------------------------------------
procedure TTopicBrowserIE.RestoreScrollPosition;
var
  body: OleVariant;
  scrollheight, top: integer;
//str:string;
//_body :IHTMLElement2;
begin
  inherited;

//	str:=FBrowser.LocationURL;
	//	body := (FBrowser.Document as IHTMLDocument2).body;
	//	(void *)document=WebBrowser1->Document;
	//	document->get_body(&body);
	//	body.get_outerHTML(str);
//		_body := (FBrowser.Document as IHTMLDocument2).body as IHTMLElement2;
//		scrollheight := _body.scrollHeight;

//FRestoredPos := false;		// 2008.08.16 TEST
  if FRestoredPos then
  begin
    exit;
  end;

  if FNoScroll then
  begin
    FNoScroll := false;
    exit;
  end;

  // New Scroll 
  if Topic.PhysicalScrollPositionIE <> -1 then
  begin
    body := (FBrowser.Document as IHTMLDocument2).body;
    scrollheight := body.scrollHeight;
    top := scrollheight - Topic.ScrollPosition;
    
    if scrollheight>=Topic.PhysicalScrollPositionIE then
    begin
      body.scrollTop := Topic.PhysicalScrollPositionIE;
//    FRestoredPos := true;
    end;
  end else
  begin
    body := (FBrowser.Document as IHTMLDocument2).body;
    scrollheight := body.scrollHeight;
    top := scrollheight  -  Topic.ScrollPosition;
    body.scrollTop := top;
    FRestoredPos := true;
  end;

//	mBrowser:=FBrowser;			// 
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TTopicBrowserIE.Browser_BeforeNavigate(Sender: TObject;
                                                 const pDisp: IDispatch;
                                                 var URL,
                                                     Flags,
                                                     TargetFrameName,
                                                     PostData,
                                                     Headers: OleVariant;
                                                 var Cancel: WordBool);
begin
  if URL = 'about:blank' then exit;

  Cancel := true;
  inherited RaiseNavigateUrlEvent(URL);
end;

procedure TTopicBrowserIE.JumpMessage(const msgNo: integer);
begin
  if msgNo < FStartIndex then
  begin
    FNoScroll := true;
    ChangeViewLimit(Topic.GotMessageCount - msgno + 1);
  end else
  begin
    OleVariant(FBrowser.Document).body.scrollTop
	  	:= OleVariant(FBrowser.Document).anchors.item('a' + IntToStr(msgno) ).offsetTop;
  end;
end;

// >>1 ̕ϊ
function TTopicBrowserIE.DatToHtml(body: string): string;
var
  awk: TAwkStr;
begin
  body := EraseATag(body);
  awk := TAwkStr.Create(nil);
  awk.OnReplaceString := ReplaceString;

  // XԍɃN\
  FReplaceMode := 1;
  awk.RegExp := '(&gt;|)+[0-9O-X]+([-|[][0-9O-X]+)?';
  awk.GSub('', body);

  // URLɃN\
  FReplaceMode := 2;
  awk.RegExp := 'h*t+p://[a-zA-Z_/%@\-~\.0-9&=%\?#;:\,\+]+';
  awk.GSub('', body);

  awk.Free;

  result := body;
end;

// BE̎dlɍ킹ăN𒣂
function TTopicBrowserIE.DatToHtml2(body: string; ref: string): string;
var
  match: boolean;
  regEx: TRegExpr;
  strDate: String;
  strLink: String;
  strID: String;
  strMark: String;
begin
  regEx := TRegExpr.Create;


  //tƎԂ̐`FbN

  regEx.Expression := '.+ [0-9\:]+ ';
  match := regEx.Exec(body);
  if (match = false) then
  begin
     result := body;
     regEx.Free;
     exit;
  end;
  strDate := regEx.Match[0];

  //be.2ch.net/be́ADatJavaScriptߍ܂ꂽ
  //P[XBEIDT
  regEx.Expression := '/test/[a-zA-Z\.\?=]+[0-9]+';
  match := regEx.Exec(body);

  if (match) then strLink := regEx.Match[0];

  if (match = false) then
  begin
    //JavaScriptȂP[X
    regEx.Expression := '[ <]BE:([0-9]+)';
    match := regEx.Exec(body);

    if (match = false) then
    begin
     result := body;
     regEx.Free;
     exit;
    end;

    strLink := '/test/p.php?i=' + regEx.Match[1];
  end;

  strLink := strLink + '&u=d:' + ref;

  //ID̐`FbN
  regEx.Expression := 'ID:[a-zA-Z0-9\.?\+\/]+';

  match := regEx.Exec(body);

  if (match) then strID := regEx.Match[0];

  if (match = false) then
  begin
     regEx.Expression := ' (.+) BE:';
     match := regEx.Exec(body);
     if (match = false) then
     begin
       result := body;
       regEx.Free;
       exit;
     end;
     strID := regEx.Match[1];
  end;

  //JavaScriptP[X
  regEx.Expression := '>(.+)</a>';
  match := regEx.Exec(body);

  if (match) then strMark := regEx.Match[1];

  if (match = false) then
  begin
    //JavaScriptȂP[X
    regEx.Expression := ' BE:[0-9]+-(.+)';
    match := regEx.Exec(body);

    if (match) then
      //N̕IEƂ킹邽߂ɐ擪?
      strMark := '?' + regEx.Match[1]
    else
    begin
      //BEVdl̒ Level\
      regEx.Expression := '<BE:[0-9]+:([0-9]+)>';
      regEx.Exec(body);
      //match := regEx.Exec(body);
      strMark := 'Lv.' + regEx.Match[1];
    end;
  end;

  regEx.Free;

  //`𐮂ďo
  result := strDate + strID + ' <a href="http://be.2ch.net' + strLink + '">' + strMark + '</a>';

end;


function TTopicBrowserIE.ReplaceString(MatchStr: string): string;
var
  strNum, check: string;
  i: integer;
  isNum: char;

begin
  case FReplaceMode of
    1:
    begin
      check := ZenkakuToHankaku(MatchStr);
      for i := Length(check)  downto 1 do
      begin
        isNum := check[i];
        if (isNum in ['0'..'9']) or (isNum = '-') then
        begin
          strNum := isNum + strNum;
        end;
      end;

      result := '<A HREF="jump://goto/' + strNum + '">' + MatchStr + '</A>';
    end;
    2:
    begin
      check := Matchstr;
      if Copy(check, 1, 1) <> 'h' then
      begin
        if Copy(check, 1, 2) <> 'tt' then
        begin
          check := 't' + check;
        end;

        check := 'h' + check;
      end;


      if Pos('#', check) <> 0 then
      begin
        result := '<a href="' + AnsiReplaceText(check, '#', '[%23]') + '">' + MatchStr + '</a>'
      end else
      begin
        result := '<a href="' + check + '">' + MatchStr + '</a>';
      end;

    end;
  end;
end;

procedure TTopicBrowserIE.Topic_ChangeDownloadState(Sender: TObject);
begin
  inherited;

  Case Topic.State of
    dsNone:
    begin
      FDownloadComplete := true;
    end;
    else
    begin
      FDownloadComplete := false;
    end;
  end;
end;

procedure TTopicBrowserIE.CloseTopic;
begin
  inherited;

  FHtmlEvent.Free;
  BrowserInitialize();
end;

procedure TTopicBrowserIE.SetTextSize(const TextSize: Integer);
var
  size, rc: OleVariant;

begin
  if (TextSize < 0) or (TextSize > 4) then
  begin
    Exit;
  end;

  if Assigned(FBrowser.Document) then
  begin
    size := TextSize;
    FBrowser.ExecWB(OLECMDID_ZOOM, OLECMDEXECOPT_DONTPROMPTUSER, size, rc);
  end;

  //tHgTCYςAĕ`悷
  self.DoubleBuffered := true;
  self.Repaint;
  self.DoubleBuffered := false;

end;

function TTopicBrowserIE.GetTextSize: integer;
var
  size, rc: OleVariant;

begin
  if Assigned(FBrowser.Document) then
  begin
    FBrowser.ExecWB(OLECMDID_ZOOM, OLECMDEXECOPT_DONTPROMPTUSER, rc, size);
    result := size;
  end else
  begin
    result := 0;
  end;
end;

{WXLLevel1
<NUMBER/>	      '<a href="menu://at/' + IntToStr(msg.Index) + '">'
                + IntToStr(msg.Index) + '</a>'
                            Xԍij[j
<PLAINNUMBER/>  msg.Index   Xԍij[Ȃj
<NAME/>		      str2chName  Oi|bvAbvȂj
<MAILNAME/>	    mailName    Oi|bvAbvj
<MAIL/>		      str2chMail  [AhX
<DATE/>		      str2chID    tyID
<MESSAGE/>	    str2chBody  X̖{
<THREADNAME/>	  Topic.Title Xbh̖O
<THREADURL/>	  Topic.BrowserUrl  XbhURL
<SKINPATH/>	    gConfig.SkinPath  XL̃pX
<GETRESCOUNT/>	Topic.GotMessageCount   VX擾ÕX
<NEWRESCOUNT/>	NewMsgCount   VX
<ALLRESCOUNT/>	Topic.GotMessageCount + NewMsgCount  ƐVX̍v

<SIZE/>		      Topic.DatSize           datTCYibytePʁj
<SIZEKB/>	      Topic.DatSize div 1024  datTCYiKbytePʁj

<BBSNAME/>          BBS̖O
<BOARDNAME/>        ̖O
<BOARDURL/>         URL
}
function TTopicBrowserIE.MsgToHtml(msg: TTopicMessage): string;
var
  outputHtml, mailName: string;
  i,intInStr: integer;
  ansistr: AnsiString;
  str2chName: String;
  str2chID: String;
  str2chMail: String;
  str2chBody: String;
  str2chReferer: String;
  str2chThreadTitle: String;
  strOneLine: AnsiString;
  intCammaPos: integer;
  strTitle,strMes: String;

  NewMsgCount : integer;

  regEx: TRegExpr;
begin
  if msg.IsNewMessage then
  begin
    if (Topic.NewMarkCount + 1) = msg.Index then
    outputHtml := gConfig.NewMarkHtml + #13#10 + gConfig.NewResHtml
    else
    outputHtml := gConfig.NewResHtml;
    Inc(Topic.DisplayMsgCount);
  end else
  begin
    outputHtml := gConfig.ResHtml;

    Topic.NewMarkCount := Topic.GotMessageCount;
  end;

  str2chName := msg.PostName;
  str2chID := msg.RestStr;
  str2chBody := msg.Body;
  str2chMail := msg.PostEmail;

  //ځ`񂵂X̔f
  regEx := TRegExpr.Create;
  regEx.Expression := '<K88_ABONE>';
  if regEx.Exec(str2chMail) then
  begin
     str2chName := 'ځ[';
     str2chID := 'ځ[';
     str2chBody := '';
     str2chMail := APP_NAME;
  end;
  regEx.Free;

  //X^Cۑ
  str2chThreadTitle := Caption;

  //NG WordsɊY邩̃`FbN

  intInStr := 0; //0ȂY 1ȏŊY

  for i:=0 to NGWords.Count-1 do
  begin

    strOneLine := NGWords.Strings[i];

    intCammaPos := Pos(',',strOneLine);

    //S̃Xɑ΂A{[iJ}Ȃj
    if (intCammaPos = 0) then
    begin

      //DeleteTagŃ^Ô<B>ŋ܂gbv΍
      ansistr := DeleteTag(str2chName);
      intInStr := intInstr + Pos(strOneLine,ansistr);
      //ID̃A{[͕sv
      //ansistr := str2chID;
      //intInStr := intInstr + Pos(strOneLine,ansistr);
      ansistr := str2chBody;
      intInStr := intInstr + Pos(strOneLine,ansistr);
      //[̃A{[sv
      //ansistr := str2chMail;
      //intInStr := intInstr + Pos(strOneLine,ansistr);
    end
    else
    begin
      //gݍ킹A{[@iJ}j
      strTitle := Copy(strOneLine,0,intCammaPos-1);
      strMes := Copy(strOneLine,intCammaPos+1,Length(strOneLine) - intCammaPos);

      //YX^C̏ꍇ
      if (Pos(strTitle,Caption) > 0) then
      begin
        ansistr := DeleteTag(str2chName);
        intInStr := intInstr + Pos(strMes,ansistr);
        ansistr := str2chBody;
        intInStr := intInstr + Pos(strMes,ansistr);
      end;
    end;

    if intInstr > 0 then Break;
  end;

  if (intInStr) > 0 then
   begin
    str2chName := '<FONT COLOR=BLUE>NGځ[</FONT>';
    //tID͂̂܂܎c
    //str2chID := 'ځ[';
    str2chBody := '<BR><FONT COLOR=BLUE>ځ[</FONT>';
    //NG[hځ[̂Ƃ[Katju88ƕ\
    //str2chMail := 'ځ[';
    str2chMail := APP_NAME;
   end;

  //Oƃ[
  if str2chMail <> '' then
  begin
    if not gConfig.DispMailAddress then
      mailName := '<B><A HREF="mailto:' + str2chMail+ '">' +
                  str2chName +
                  '</A></B>'
     else
      mailName := '<B><A HREF="mailto:' + str2chMail+ '">' +
                  str2chName +
                  '</A></B>'+ ' [' + str2chMail+ ']';
  end
  else
     mailName := '<B>' + str2chName + '</B>';


  if (Topic.NewMessageCount < 0) then
    NewMsgCount := 0
  else
    NewMsgCount := Topic.NewMessageCount;


  outputHtml := StringReplace(outputHtml,
                              '&MAILNAME',
                              mailName ,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '&NUMBER',
                              '<a href="menu://at/' + IntToStr(msg.Index) + '">' +
                              IntToStr(msg.Index) + '</a>',
                              [rfReplaceAll]);

  //BE̃XURLɊ܂܂郊N𒊏o
  str2chReferer := Topic.BrowserUrl + IntToStr(msg.Index);
  str2chID := DatToHtml2(str2chID,str2chReferer);


  outputHtml := StringReplace(outputHtml,
                              '&DATE',
                              str2chID,
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&PLAINNUMBER',
                              IntToStr(msg.Index),
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&MAIL',
                              str2chMail,
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&NAME',
                              '<B>' + msg.PostName + '</B>',
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&THREADURL',
                              Topic.BrowserUrl,
                              [rfReplaceAll]);


  //URL̃N𒣂镔
  str2chBody := DatToHtml(str2chBody);

  outputHtml := StringReplace(outputHtml,
                              '&MESSAGE',
                              str2chBody,
                              [rfReplaceAll]);



  outputHtml := StringReplace(outputHtml,
                              '<MAILNAME/>',
                              mailName,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<NUMBER/>',
                              '<a href="menu://at/' + IntToStr(msg.Index) + '">' +
                              IntToStr(msg.Index) + '</a>',
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<DATE/>',
                              str2chID,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<PLAINNUMBER/>',
                              IntToStr(msg.Index),
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<MAIL/>',
                              str2chMail,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<NAME/>',
                              '<B>' + msg.PostName + '</B>',
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<THREADNAME/>',
                              Topic.Title,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<THREADURL/>',
                              Topic.BrowserUrl,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<SKINPATH/>',
                              gConfig.SkinPath,
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<GETRESCOUNT/>',
                              IntToStr(Topic.GotMessageCount),
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<NEWRESCOUNT/>',
                              IntToStr(NewMsgCount),
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<ALLRESCOUNT/>',
                              IntToStr(NewMsgCount + Topic.GotMessageCount),
                              [rfReplaceAll]);

{
  outputHtml := StringReplace(outputHtml,
                              '<SIZE/>',
                              IntToStr(Topic.DatSize),
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<SIZEKB/>',
                              IntToStr(Topic.DatSize div 1024),
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<BBSNAME/>',
                              '',
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<BOARDNAME/>',
                              '',
                              [rfReplaceAll]);

  outputHtml := StringReplace(outputHtml,
                              '<BOARDURL/>',
                              '',
                              [rfReplaceAll]);
}

  outputHtml := StringReplace(outputHtml,
                              '<MESSAGE/>',
                              str2chBody,
                              [rfReplaceAll]);

  outputHtml := '<a name="a' + IntToStr(msg.Index) + '"></a>' +
                outputhtml + #13#10;

  result := outputHtml;
end;

//ngword.txt ̓e NGWords ɋL
procedure TTopicBrowserIE.SetNGWords();
begin
  NGWords.Clear;
  NGWords.LoadFromFile(Apppath('ngword.txt'));
end;


//^O߂̊֐
function TTopicBrowserIE.DeleteTag(strbody: string): string;
var
  intPos   : Integer;
  strRest   : string;
  strResult : string;
begin

  strRest := strbody;

  while true do
  begin
    intPos := Pos('<', strRest);
    if intPos < 1 then break;
    strResult := strResult + Copy(strRest, 1, intPos - 1);
    strRest := CopyAfter(strRest, intPos + 1);

    intPos := Pos('>', strRest);
    if intPos < 1 then break;
    strRest := CopyAfter(strRest, intPos + 1);
  end;

  strResult := strResult + strRest;
  result := StringReplace(strResult, '</', '', [rfReplaceAll]);
end;

//gȂKv
procedure TTopicBrowserIE.SetFont(fname: string; fsize: integer);
begin

end;

//gȂKv
//procedure TTopicBrowserIE.SetHTMLColor(mes: integer; nam: integer; lnk: integer; bg: integer);
procedure TTopicBrowserIE.SetHTMLColor(mes: integer; nam: integer; namelink: integer; lnk: integer; bg: integer);

begin

end;

//gȂKv
procedure TTopicBrowserIE.SetWallpaper(g: TGraphic);
begin

end;

//gȂKv
procedure TTopicBrowserIE.IDSearch(id: string);
begin

end;

//gȂKv
procedure TTopicBrowserIE.IDSearchPopUp(id: string);
begin

end;

end.
