unit untTopicJBBS;

interface

uses
  IdComponent, IdHttp,
  untTopic, untOnlineBoard;

type
  TTopicJBBS = class(TTopic)
  private
    FReceivedIndex: integer;
    FArticleIndex: integer;
    FBufferLines: string;
    BBS_TYPE: string;
    //----̒ǉ2006/11/23
    //ǂݍ݃^CAEgp
    FReadTimeOut: TDateTime;
    //----܂
//procedure SaveTo(intCode: integer; line: string);

  protected
    procedure SendTopic; override;
    procedure HttpReceived(Sender: TObject); override;
    procedure HTTPRedirect(Sender: TObject;
                           var dest: String;
                           var NumRedirect: Integer;
                           var Handled: Boolean;
                           var VMethod: TIdHTTPMethod);
    function  GetTopicURL: string; override;
    function  GetBrowserURL: string; override;
  public
    procedure Post(PostName, PostEmail, Body: string); override;
    constructor Create(b: TOnlineBoard; TopicId: string);
  end;

implementation

uses
  Classes, IdCookieManager, jconvert, untDzURL, SysUtils,
  untRegExpr,  untHttp, untGlobal,
  untConfig, untTool, untBoardList;

function TTopicJBBS.GetTopicUrl: string;
var
  strSvr: string;
  strSr: string;
  intPos: integer;
  intLen: integer;
begin
  if DatUrl = '' then
  begin
  //ΑΉ ܂Ή
   strSvr := (OnlineBoard as TOnlineBoard).Server;

  intPos := Pos('.jp',strSvr);

  if (intPos = 0) then
  begin
  //܂BBS
    result := 'http://' + (OnlineBoard as TOnlineBoard).Server +
//                        '/bbs/read.pl?BBS=' +
                          '/bbs/read.cgi?BBS=' +
                          (OnlineBoard as TOnlineBoard).BoardName +
                          '&KEY=' + TopicId;
    //HttpReceivedŉ͂ƂɕKvȃ^Cv
    BBS_TYPE := 'MACHI';
    exit;
  end;

  //JBBS
  intLen := Length(strSvr);
  strSr := copy(strSvr,intPos + 4,intLen - intPos + 4);

    result := 'http://jbbs.livedoor.jp/bbs/read.cgi/' +
                          strSr + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName +
                          '/' + TopicId + '/';
    BBS_TYPE := 'JBBS';

  end else
  begin
    result := DatUrl;
  end;
end;

function TTopicJBBS.GetBrowserUrl: string;
var
  strSvr: string;
  strSr: string;
  intPos: integer;
  intLen: integer;
begin
  if DatUrl = '' then
  begin

   strSvr := (OnlineBoard as TOnlineBoard).Server;
   intPos := Pos('.jp',strSvr);

   if (BBS_TYPE = 'MACHI') then
   begin
   //܂BBS
    result := 'http://' + (OnlineBoard as TOnlineBoard).Server +
//                        '/bbs/read.pl?BBS=' + (OnlineBoard as TOnlineBoard).BoardName +
                          '/bbs/read.cgi?BBS=' + (OnlineBoard as TOnlineBoard).BoardName +
                          '&KEY=' + TopicId;
    exit;
   end;

   //JBBS
   intLen := Length(strSvr);
   strSr := copy(strSvr,intPos + 4,intLen - intPos + 4);

    result := 'http://jbbs.livedoor.jp/bbs/read.cgi/' +
                          strSr + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName +
                          '/' + TopicId + '/';
  end else
  begin
    result := DatUrl;
  end;
end;

constructor TTopicJBBS.Create(b: TOnlineBoard; TopicId: string);
begin
  inherited Create(b, TopicId);
end;

procedure TTopicJBBS.Post(PostName, PostEmail, Body: string);
var
  postData: TStringList;
  intTime: integer;
  response, ErrorMsg: string;

  strRef: string;
  strCookie: string;

  strSvr: string;
  strSr: string;
  intPos: integer;
  intLen: integer;
  strPostURL: string;

begin
  inherited;

   strSvr := (OnlineBoard as TOnlineBoard).Server;
   intPos := Pos('.jp',strSvr);

  if (BBS_TYPE = 'MACHI') then
  begin
   //܂BBS

    strRef := 'http://' +  (OnlineBoard as TOnlineBoard).Server + '/' +
       (OnlineBoard as TOnlineBoard).BoardName + '/index2.html';
  end else
  begin
   //JBBS
   intLen := Length(strSvr);
   strSr := copy(strSvr,intPos + 4,intLen - intPos + 4);

    strRef := 'http://jbbs.livedoor.jp/' +
                          strSr + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName +
                          '/';
  end;

  strCookie := 'Cookie: NAME=' + PostName + '; MAIL=' + PostEmail + ';';

  with FPostHttp do
  begin
    Request.Referer := strRef;
    CookieManager   := TIdCookieManager.Create(nil);
    HTTPOptions := [];
    Request.CustomHeaders.Add(strCookie);
    ConnectTimeout := gConfig.CONNECT_TIMEOUT;
  end;

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400);
  postData := TStringList.Create;

  if (BBS_TYPE = 'MACHI') then
  begin
  //܂
  postData.Add('submit='  + UrlEncode('') + '&' +
               'NAME='    + UrlEncode(PostName) + '&' +
               'MAIL='    + UrlEncode(PostEmail) + '&' +
               'MESSAGE=' + UrlEncode(Body)+ '&' +
               'BBS='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'KEY='     + TopicId + '&' +
               'TIME='    + IntToStr(intTime));
  end else
  begin
  //JBBS
  //JBBSEUCőȂƂȂ
  postData.Add('submit='  + UrlEncode('') + '&' +
               'NAME='    + UrlEncode(sjis2euc(PostName)) + '&' +
               'MAIL='    + UrlEncode(sjis2euc(PostEmail)) + '&' +
               'MESSAGE=' + UrlEncode(sjis2euc(Body))+ '&' +
               'BBS='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'DIR='     + strSr + '&' +
               'KEY='     + TopicId + '&' +
               'TIME='    + IntToStr(intTime));
  end;


  try
      if (BBS_TYPE = 'MACHI') then
      //܂
      begin
      response := FPostHttp.Post('http://' + (OnlineBoard as TOnlineBoard).Server +
                               '/bbs/write.cgi', postData);
      end else
      begin
      //JBBS
      strPostURL := 'http://jbbs.livedoor.jp/' +
                              'bbs/write.cgi/' + strSr + '/' +
                               (OnlineBoard as TOnlineBoard).BoardName +
                               '/' + TopicId + '/';

      response := FPostHttp.Post(strPostURL, postData);

      end;

  except on Exception do
    //302G[N邱Ƃ邯ǂ߂
    ;
  end;

  ErrorMsg := CopyMiddle(response, '<b>', '</b>');
  if ErrorMsg <> '' then
  begin
    RaiseError(etPostArticle, ErrorMsg)
  end else
  begin
    if Assigned(OnComplete) then
    begin
      OnComplete(self);
    end;
  end;
  postData.Free;
  FPostHttp.Free;
end;

procedure TTopicJBBS.HTTPRedirect(Sender: TObject;
                                  var dest: String;
                                  var NumRedirect: Integer;
                                  var Handled: Boolean;
                                  var VMethod: TIdHTTPMethod);
begin
  Handled := false;
end;

procedure TTopicJBBS.HttpReceived(Sender: TObject);
var
  line, msgName, msgEmail, msgRestStr, msgBody: string;
  regExp: TRegExpr;
  i, msgNo: integer;
  regOK: boolean;
  intCode: integer;
  intCodeSJIS: integer;
  intCodeEtc: integer;

begin
//i := 0;
  msgNo := 0;
//regOK := false;
//intCode := 0;
  intCodeSJIS :=0;
  intCodeEtc :=0;
  line := '';
  msgName := '';
  msgEmail := '';
  msgRestStr := '';
  msgBody := '';
  regExp := TRegExpr.Create;


//  R[hn𒲂ׂ() 2008.05.14
  for i := FReceivedIndex to FHttp.ReceivedLines.Count - 1 do
  begin

    line := FHttp.ReceivedLines[i];
    if (line = '') then continue;
    intCode := InCodeCheck(line);

    case intCode of
      0: //  ASCII      = 0;
        ;
      1: //  BINARY     = 1;
        ;
      2: //  JIS83_IN   = 2;
        inc(intCodeEtc);
      3: //  JIS78_IN   = 3;
        inc(intCodeEtc);
      4: //  EUC_IN     = 4;
        inc(intCodeEtc);
      5: //  SJIS_IN    = 5;
       inc(intCodeSJIS);
      6: //  EUCorSJIS_IN = 6;
		// SJIS̔pJiEUC̋ʂtȂꍇ
		// SJISpJíA܂gȂƂ
		// EUCł\Ƃď邱ƂƂ
        inc(intCodeEtc);
    end;
    // SaveTo(intCode,line);  // for debug
  end;

  for i := FReceivedIndex to FHttp.ReceivedLines.Count - 1 do
  begin

     //----̒ǉ2006/11/23
     //^CAEgȂ珈𔲂
     //ŔivIɉ͂𑱂邱Ƃ}
     if (FReadTimeOut < Now()) then
     begin
        FHttp.ReceivedLines.Clear;
        //G[\
        RaiseError(etTimeOut);
        break;
     end;
     //----܂

    line := FHttp.ReceivedLines[i];
    if (line = '') then continue;

    //eucŕԂĂ\̂SJISɃGR[h

//  intCode := InCodeCheck(line);
//  if intCode <> SJIS_IN then
    if(intCodeEtc > intCodeSJIS) then
    begin
        line := euc2sjis(line);
    end;

    FBufferLines := FBufferLines + line;

    regOK := false;

    //}b`O
    //[󔒂̂Ƃ a href=mailtoȂƂ

    //---̒ǉ2006/11/18
    //΂΂ɎdlύXA}b`O𒼂
    //----܂

    if (BBS_TYPE = 'MACHI') then
        RegExp.Expression := '<dt>(.+?) .+<b>(.*?)</[bB]></font>(.*?)<br><dd>(.*?)<br><br>$'
    else
        RegExp.Expression := '<dt>.*?>([0-9]+?)</a> .+<b>(.*?)</b></font>(.*?)<dd>(.*?)<br><br>$';

    if regExp.Exec(FBufferLines) then
    begin
      regOK      := true;
      msgNo      := StrToIntNeo(regExp.Match[1]);
      //[͋
      msgEmail   := '';
      msgName    := regExp.Match[2];
      msgRestStr := regExp.Match[3];
      msgBody    := regExp.Match[4];

    end else
    begin

       //[ݒ肳ĂƂ
       if (BBS_TYPE = 'MACHI') then
           RegExp.Expression := '<dt>(.+?) .+<a href="mailto:(.*?)"><b>(.*?)</[bB]></a> (.*?)<br><dd>(.*?)<br><br>$'
       else
           RegExp.Expression := '<dt>.*?>([0-9]+?)</a> .+<a href="mailto:(.*?)"><b>(.*?)</b></a>(.*?)<dd>(.*?)<br><br>$';


      if regExp.Exec(FBufferLines) then
      begin
        regOK      := true;
        msgNo      := StrToIntNeo(regExp.Match[1]);
        msgEmail   := regExp.Match[2];
        msgName    := regExp.Match[3];
        msgRestStr := regExp.Match[4];
        msgBody    := regExp.Match[5];
      end;
    end; //--- end if

    if regOK  then
    begin
      //}b`OƂobt@NA
      FBufferLines := '';

      //VȂ𔻒f镔
      if msgNo < (FArticleIndex + 1) then
        continue;

      //sȃXԍ݂̏͂ځ[

      //----̒ǉ2005/03/16
      //RgAEgĂ̂𕜊
      while msgNo > FArticleIndex + 1 do
      begin

        //ArticleList.Add('ځ[<>' + APP_NAME + '<>' +
        ArticleList.Add('<FONT COLOR=BLUE>ځ[</FONT><>' + APP_NAME + '<>' +
                        'ځ[' + '<>' + 'ځ[');
        Inc(FArticleIndex);
      end;
      //----܂

      //XǉV
      ArticleList.Add(msgName + '<>' + msgEmail + '<>' +
                      msgRestStr + '<>' + msgBody);
      Inc(FArticleIndex);

    end; //--- end if regok

  end; //--- end for

  FReceivedIndex := FHttp.ReceivedLines.Count;
  regExp.Free;

  //VƂ
  if (FArticleIndex > 0)  then
      inherited;

end;

procedure TTopicJBBS.SendTopic;
begin
  inherited;

  FHttp.OnReceived := HttpReceived;

  FArticleIndex := DatSize;
  FReceivedIndex := 0;

  //----̒ǉ2006/11/23
  //ǂݍ݃^CAEgݒ肵ĂāA
  //͂ivɑ̂}
  FReadTimeOut := Now();
  //^CAEgݒ肪PbȏȂ Pb=1000~b
  if (gConfig.CONNECT_TIMEOUT > 999) then
     FReadTimeOut := FReadTimeOut + (gConfig.CONNECT_TIMEOUT /1000 / 60 / 60 / 24);
  //----܂

  FHttp.URL := GetTopicURL;
  FHttp.Get;

  //----̒ǉ2005/04/01
  //^CAEgResponseCode-1ɂȂ̂
  //ǉ
  if (FHttp.ResponseCode = -1) then
      RaiseError(etTimeOut);
  //----܂

  DatSize := FArticleIndex;

  inherited HttpComplete;
end;

{procedure TTopicJBBS.SaveTo(intCode: integer; line: string);
var
  f: TextFile;

begin
  AssignFile(f,'A000.txt');
  Append(f);

  case intCode of
    0: //  ASCII      = 0;
      Writeln(f,'ASCII       '); 
    1: //  BINARY     = 1;
      Writeln(f,'BINARY      '); 
    2: //  JIS83_IN   = 2;
      Writeln(f,'JIS83_IN    '); 
    3: //  JIS78_IN   = 3;
      Writeln(f,'JIS78_IN    '); 
    4: //  EUC_IN     = 4;
      Writeln(f,'EUC_IN      '); 
    5: //  SJIS_IN    = 5;
      Writeln(f,'SJIS_IN     '); 
    6: //  EUCorSJIS_IN = 6;
      Writeln(f,'EUCorSJIS_IN'); 
    7:
      Writeln(f,'xxxxxxxxxxxx'); 
  end;

  Writeln(f,line); 
  Flush(f);
  CloseFile(f);

//  if intCode = SJIS_IN then
//  begin
//    AssignFile(f,'_SJIS000.txt');
//    Append(f);
//    Writeln(f,line); 
//    Flush(f);
//    CloseFile(f);
//  end
//
//  if intCode = intCodeEtc then
//  begin
//    AssignFile(f,'_EUC000.txt');
//    Append(f);
//    Writeln(f,line); 
//    Flush(f);
//    CloseFile(f);
//  end;

end;}


end.
