unit untTopicListView;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls,
  ComCtrls, Contnrs, SyncObjs,
  untGlobal, untBoard, untTopic, jconvert;

type
  TTopicListView = class(TListView)
  private
    { Private 錾 }
    FListItemToClear: TObjectList;
    FTopicList: TList;
    FSelectedBoard: TBoard;
    NGThreads : TStringList;
    TimeZoneInfo: _TIME_ZONE_INFORMATION;

//  procedure OnActive(var Msg: TMessage); message WM_ACTIVATE;
    function ThreadnumToStr(s: string): string;

  protected
    { Protected 錾 }
    procedure Board_TopicListReceived(Sender: TObject);
    procedure TopicListViewData(Sender: TObject; Item: TListItem);
    procedure TopicListViewCustomDrawItem(Sender: TCustomListView;
                                          Item: TListItem;
                                          State: TCustomDrawState;
                                          var DefaultDraw: Boolean);
    procedure TopicListViewColumnClick(Sender: TObject;
                                       Column: TListColumn);
    procedure ClearTopic;
    procedure SetOnError;
    procedure SetOnComplete;
    procedure SetOnStatus;
    procedure SyncOnComplete;
    procedure SetNGThreads;
    function IsNGThread(strWord: string): boolean; //̒ǉ2005/01/17
  public
    { Public 錾 }
    CompleteEvent: TSimpleEvent;
    ForceToOpenBoard: boolean;
    procedure TopicListRefresh;
    procedure OpenBoard(Board: TBoard);
    procedure Search(const searchText: string);
    function SelectedTopic: TTopic;
    procedure RemoveTopic(tp: TTopic);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

//  procedure InitTopicViewItem;

  published
    { Published 錾 }
  end;

procedure Register;

implementation

uses
  Math, StrUtils, Graphics,
  untMainForm, untConfig, untOnlineBoard, untBoardCategory,
  untAllSubscribedTopics,  untBoard2ch, untBoardList, untTaskManager,
  untFavoriteBoard, // ̒ǉ2004/12/22
  untTool; // ̒ǉ2005/01/12

var
  FTopicListSortOrder: boolean;
  FTopicListSortIndex: integer;

function GetTopicStateNumber(tp: TTopic): Integer;
begin
  if tp.State = dsNone then
  begin
    if tsFavorite in tp.Status then
    begin
      Result := 1
    end else if tsFreezed in tp.Status then
    begin
      Result := 3
    end else if tsError in tp.Status then
    begin
      Result := 2
    end else if (tp.DatSize > 0) and
                (tp.MessageCount > tp.GotMessageCount) then
    begin
      Result := 5
    end else if (tp.DatSize > 0) and
                (tp.GotMessageCount > 0) then
    begin
      Result := 4
    end else
    begin
      Result := -1;
    end;
  end else begin
    Result := 0
  end;
end;

function TopicListSortCompare(Item1, Item2: Pointer): Integer;
var
  compare: integer;
  topic1, Topic2: TTopic;
  noChange: boolean;

begin
  topic1 := Item1;
  topic2 := Item2;
  noChange := false;
  compare  := 0;

  case FTopicListSortIndex of
    0:
      Compare := CompareValue(GetTopicStateNumber(topic1),
                              GetTopicStateNumber(topic2));
    1:
      Compare := CompareValue(topic1.Priority,
                              topic2.Priority);
    2:
      Compare := CompareValue(topic1.Index,
                              topic2.Index);
    3:
      Compare := AnsiCompareStr(topic1.Title,
                                topic2.Title);
    4:
      Compare := CompareValue(topic1.MessageCount,
                              topic2.MessageCount);
    5:
      Compare := CompareValue(topic1.GotMessageCount,
                              topic2.GotMessageCount);
    6:
      Compare := CompareValue(topic1.NewMessageCount,
                              topic2.NewMessageCount);
    7:
      Compare := AnsiCompareStr(topic1.LastReadDate,
                                topic2.LastReadDate);
    8:
      Compare := AnsiCompareStr(topic1.LastWriteDate,
                                topic2.LastWriteDate);
    9:
      Compare := AnsiCompareStr((topic1.OnlineBoard as TBoard).DisplayName,
                                (topic2.OnlineBoard as TBoard).DisplayName);
   10:
//    noChange := true;
      Compare := AnsiCompareStr(topic1.Memo,
                                topic2.Memo);
   11:
      Compare := AnsiCompareStr(topic1.TopicId,			// 2008.05.20
                                topic2.TopicId);
   12:
//    Compare := AnsiCompareStr(topic1.TopicId,					// 2008.07.03
//                              topic2.TopicId);
      Compare := CompareValue(StrToIntDef(topic1.TopicId,-1),			// 2008.07.03
                              StrToIntDef(topic2.TopicId,-1));
   13:
      Compare := CompareValue(topic1.DatSize,			// 2008.07.03
                              topic2.DatSize);

    else
      noChange := true;
  end;

  if FTopicListSortOrder then
  begin
    compare := -compare;
  end;

  if noChange then
  begin
    compare := CompareValue(topic1.Index, topic2.Index);
  end;
  result := compare;
end;

procedure TTopicListView.SyncOnComplete;
begin
  MainForm.Board_Complete(self);
end;

procedure TTopicListView.RemoveTopic(tp: TTopic);
begin
  FTopicList.Remove(tp);
end;

procedure TTopicListView.Search(const searchText: string);
var
  newTopicList: TList;
  i: integer;
  strAnsiA: AnsiString;
  strAnsiB: AnsiString;
  ascii: Integer;
  blHit:  boolean;
begin

  strAnsiA := searchText;
  strAnsiB := '';

  i := 1;
  while i<=Length(strAnsiA) do
  begin
    ascii := Ord(strAnsiA[i]);

    //130ԈȏオԂΑSp@141Ȃǂ肤
    if (ascii > 129) then
     begin
       //Sp͂̂܂ܕύX
       strAnsiB := strAnsiB + strAnsiA[i] + strAnsiA[i+1];
       inc(i,2);
     end else
       //p͑Spɒ
     begin

       //QoCĝ߂̌vZ
       //啶ƏŌvZĂ̂ŗv
       begin
       if (ascii<48) then
          //ꕶ̃P[X@ϊÂ܂
       else
          //Ȃ
           if (ascii>47) and (ascii<65) then
            begin
            ascii := ascii + 31;
            strAnsiB := strAnsiB + #$82;
            end
       else
           //At@xbg啶
           if (ascii>64) and (ascii<97) then
            begin
            ascii := ascii + 31;
            strAnsiB := strAnsiB + #$82;
            end
       else
           //At@xbg
           if (ascii>96) then
            begin
            ascii := ascii + 32;
            strAnsiB := strAnsiB + #$82;
            end
       end;

       strAnsiB := strAnsiB + Chr(ascii);
       inc(i,1);
     end;
  end;

  newTopicList := TList.Create;
  // gsbNXg猟
  for i := 0 to FTopicList.Count - 1 do
  begin

    //tO𗧂ĂĔf
    blHit := false;
    if AnsiContainsText(TTopic(FTopicList[i]).Title, strAnsiA) then
      blHit := true;

    if AnsiContainsText(TTopic(FTopicList[i]).Title, strAnsiB) then
      blHit := true;

    if (blHit) then
       newTopicList.Add(FTopicList[i]);

  end;

  FTopicList.Clear;
  FTopicList.Assign(newTopicList);
  newTopicList.Free;
  Items.Count := FTopicList.Count;
  TopicListRefresh;
  ForceToOpenBoard := true;
end;
//
// IꂽXbh
//
function TTopicListView.SelectedTopic: TTopic;
begin
  if ItemIndex = -1 then
  begin
    result := nil;
  end else
  begin
    result := FTopicList[ItemIndex];
  end;
end;

procedure TTopicListView.TopicListRefresh;
var
  i: integer;
  item: TListItem;
  t: integer;
begin
  Items.BeginUpdate;
  Items.Clear;
  FListItemToClear.Clear;

  //Xbhځ[ŌZĂJE^
  t := FTopicList.Count -1;

  for i := 0 to FTopicList.Count - 1 do
  begin

    //NGXbhɊYƂ́AXgɒǉȂ

    if IsNGThread(TTopic(FTopicList[i]).Title) then
    begin
    try
      if (i = t) then Break;

      FTopicList.Delete(i);

      t := t -1;

    except
       ;
    end;
   end else
    begin

      item := Items.Add;
      FListItemToClear.Add(item);
    end;

     if (i = t) then Break;
  end;
  Items.EndUpdate;

  //ʍĕ`
  DoubleBuffered := true;
  Repaint;
  DoubleBuffered := false;
end;

// gsbNM
procedure TTopicListView.Board_TopicListReceived(Sender: TObject);
var
  i: integer;
  item: TListItem;
begin

  try
  Items.BeginUpdate;
  FTopicList.Capacity := FSelectedBoard.TopicList.Count;
  for i := FSelectedBoard.ReceivedIndex to FSelectedBoard.TopicList.Count -1 do
  begin
    if IsNGThread(TTopic(FSelectedBoard.TopicList[i]).Title) then
    begin
      ;
    end else
    begin
      FTopicList.Add(FSelectedBoard.TopicList[i]);
      item := Items.Add;
      FListItemToClear.Add(item);
    end;
  end;
  Items.EndUpdate;

  except
      on e: Exception do
      begin
        ; //RaiseError(e.Message);
      end;
  end;

end;

procedure TTopicListView.SetOnError;
begin
  FSelectedBoard.OnError    := MainForm.Board_Error;
end;

procedure TTopicListView.SetOnComplete;
begin
  FSelectedBoard.OnComplete := MainForm.Board_Complete;
end;

procedure TTopicListView.SetOnStatus;
begin
  (FSelectedBoard as TOnlineBoard).OnStateChange := MainForm.Board_StatusChange;
end;

{ --------------------------------------------------------
  pr  : {[hJ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicListView.OpenBoard(Board: TBoard);
var
  subjectFile: string;
  fileStream: TFileStream;
  modifiedTime: TDateTime;
  doClear, hasChange: boolean;

begin

  //肪ƂLZ
  CompleteEvent.ResetEvent;
  if not Assigned(Board) then
  begin
    CompleteEvent.SetEvent;
    exit;
  end;


  doClear := true;
  hasChange := true;

  //Cɓ̕ۑ
  if FSelectedBoard is TFavoriteBoard then
    (FSelectedBoard as TFavoriteBoard).Save;

  //CɓȊÔƂɔǂݍ݂JEg
  if (Board.DisplayName = 'Cɓ') or (Board.DisplayName = 'SX') then
   else
    Inc(gConfig.ToukeiInfo_Board_Load);

  //JƂɁAngthread.txtēǂݍ݂
  SetNGThreads();

  //ItC̕\p
  if (gConfig.Offline) then
  begin

      gSynchronizer.DoSynchronize(ClearTopic);
      FTopicList.Clear;
      FListItemToClear.Clear;
      gSynchronizer.DoSynchronize(SyncOnComplete);
      CompleteEvent.SetEvent;

    FSelectedBoard := Board;
    FSelectedBoard.OnReceived := Board_TopicListReceived;

    ForceToOpenBoard := false;
    FSelectedBoard.SendTopicList;

    gSynchronizer.DoSynchronize(SyncOnComplete);
    CompleteEvent.SetEvent;

  if gConfig.AutoSort then
  begin
     //Ń\[gčĕ\
        FTopicList.Sort(TopicListSortCompare);
        DoubleBuffered := true;
        Repaint;
        DoubleBuffered := false;
  end;

     //uvŃ\[g₷悤
  if gConfig.AutoSort = false then
       FTopicListSortOrder := false;

    exit;
  end;


  if Assigned(FSelectedBoard) then
  begin
    if FSelectedBoard is TOnlineBoard then
    begin
      (FSelectedBoard as TOnlineBoard).CancelDownload;
    end;

    if FSelectedBoard = Board then
    begin
       if FSelectedBoard.IsDownloading then
       begin
          doClear := false;
       end;
       if Board is TBoard2ch and not ForceToOpenBoard then
       begin
          hasChange := (Board as TBoard2ch).HasTopicListChange;
          if not hasChange then
          begin
            doClear := false;
          end;
       end;
    end;

    if doClear then
    begin
      gSynchronizer.DoSynchronize(ClearTopic);
      FTopicList.Clear;
      FListItemToClear.Clear;

      FSelectedBoard.FreeAllTopic;
      (FSelectedBoard.BoardList as TBoardList).GC;
    end;

    FSelectedBoard.OnReceived := nil;
  end;

  FSelectedBoard := Board;
  FSelectedBoard.OnReceived := Board_TopicListReceived;

  gSynchronizer.DoSynchronize(SetOnComplete);
  gSynchronizer.DoSynchronize(SetOnError);

  if FSelectedBoard is TOnlineBoard then
  begin
    gSynchronizer.DoSynchronize(SetOnStatus);
  end;

  // VXmp
  if gConfig.TopicListColorUse and (FSelectedBoard is TOnlineBoard) then
  begin
    if not gFolderAlias.GetFolderPath((FSelectedBoard as TOnlineBoard).Server,
                                      (FSelectedBoard as TOnlineBoard).BoardName,
                                      'subjects',
                                      subjectFile) then
    begin
      subjectFile := subjectFile + 'subjects';
    end;

    if FileExists(subjectFile) then
    begin
      fileStream := TFileStream.Create(subjectFile, fmOpenRead or fmShareDenyNone);
      modifiedTime := FileDateToDateTime(FileGetDate(FileStream.Handle));
      fileStream.Free;
      // datetime2unixtime
      // 32400 = 60 * 60 * 9 => JST=GMT+9  T[oɂĈႤ
      (FSelectedBoard as TOnlineBoard).ModTime := Trunc((modifiedTime - EncodeDate(1970, 1, 1)) * 86400) - 32400;
    end;
  end;

  if hasChange or ForceToOpenBoard then
  begin
    ForceToOpenBoard := false;
    FSelectedBoard.SendTopicList;
  end else
  begin
    gSynchronizer.DoSynchronize(ClearTopic);
    gSynchronizer.DoSynchronize(TopicListRefresh);
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
  CompleteEvent.SetEvent;

  if gConfig.AutoSort then
  begin
     //Ń\[gčĕ\
        FTopicList.Sort(TopicListSortCompare);
        DoubleBuffered := true;
        Repaint;
        DoubleBuffered := false;
  end;

     if gConfig.AutoSort = false then
         FTopicListSortOrder := false;
end;

procedure TTopicListView.ClearTopic;
begin
  Items.Clear;
  DoubleBuffered := true;
  Repaint;
  DoubleBuffered := false;
end;
//
// `敔
//
procedure TTopicListView.TopicListViewData(Sender: TObject; Item: TListItem);
var
  topic: TTopic;
  gotMsg, newMsg: string;

begin

  if (Item.Index < 0) or (Item.Index > (FTopicList.Count - 1)) then
  begin
    exit;
  end;

  topic := TTopic(FTopicList[Item.Index]);

  if not Assigned(topic) then
  begin
    exit;
  end;

  gotMsg := IntToStr(topic.GotMessageCount);		// 擾X
  if topic.GotMessageCount <= 0 then
  begin
    gotMsg := '';
  end;

  newMsg := IntToStr(topic.NewMessageCount);
  if topic.NewMessageCount < 0 then
  begin
    newMsg := '';
  end;

  Item.Caption  := '';
  if topic.Priority < 0 then
  begin
    Item.SubItems.Add(IntToStr(topic.Priority))
  end else if topic.Priority > 0 then
  begin
    Item.SubItems.Add('+' + IntToStr(topic.Priority))
  end else
  begin
    Item.SubItems.Add('');
  end;
  Item.SubItems.Add(IntToStr(topic.Index));

//Item.SubItems.Add(topic.Title);
  Item.SubItems.Add(ReTitle(topic.Title));
  Item.SubItems.Add(IntToStr(topic.MessageCount));
  Item.SubItems.Add(gotMsg);
  Item.SubItems.Add(newMsg);
  Item.SubItems.Add(topic.LastReadDate);
  Item.SubItems.Add(topic.LastWriteDate);

  try

  if topic.OnlineBoard <> nil then
  begin
    Item.SubItems.Add((topic.OnlineBoard as TBoard).DisplayName)
  end else
  begin
    Item.SubItems.Add('');
  end;

  except
     on e: Exception do
      begin
        ; //RaiseError(e.Message);
      end;
   end;

  Item.SubItems.Add(topic.Memo);
  Item.SubItems.Add(topic.TopicId);			// 2008.05.20

  Item.SubItems.Add(ThreadnumToStr(topic.TopicId));		// 2008.07.03
  Item.SubItems.Add(FormatFloat(',0',topic.DatSize));	// 2008.05.20


  // ACR
  Item.ImageIndex := GetTopicStateNumber(topic);
end;
// 
// 
// 
procedure TTopicListView.TopicListViewCustomDrawItem(Sender: TCustomListView;
                                                     Item: TListItem;
                                                     State: TCustomDrawState;
                                                     var DefaultDraw: Boolean);
var
  color: TColor;
  imgIndex: Integer;
  topic: TTopic;

begin
  // 2008.05.08
  if (Item.Index < 0) or (Item.Index > (FTopicList.Count - 1)) then
  begin
    exit;
  end;

  DefaultDraw := true;
  if not gConfig.TopicListColorUse then
  begin
    exit;
  end;
  color := clBlack;

  if Item <> nil then
  begin
    topic := TTopic(FTopicList[Item.Index]);
    imgIndex := Item.ImageIndex;

    case imgIndex of
     -1:
      begin
        color := gConfig.TopicListNotGotColor;
      end;
      1:
      begin
        // Cɓ
        color := gConfig.TopicListFavoriteColor;
        if (Topic.DatSize > 0) then
        begin
          if (topic.MessageCount > topic.GotMessageCount) or
             (topic.NewMessageCount > 0) then
          begin
            color := gConfig.TopicListNewMesColor;
          end;
        end;
      end;
      4:
      begin
        // VȂ
        color := gConfig.TopicListNoNewMesColor;
      end;
      5:
      begin
        // V
        color := gConfig.TopicListNewMesColor;
      end;
    end;

     //X擾ɃG[ꍇAX^C
     //Ԃ\@255
     if tsError in Topic.Status then color := 255;

    Canvas.Font.Color := color;
  end;

  if not (Odd(Item.Index)) and (gConfig.TopicListOddColorUse) then
    Canvas.Brush.Color := gConfig.TopicListOddColor;

  with Sender.Canvas do
    if Assigned(Font.OnChange) then Font.OnChange(Font);
end;
//
// Xgr[\[g
//
procedure TTopicListView.TopicListViewColumnClick(Sender: TObject;
                                                  Column: TListColumn);
begin

  if Column.Index = FTopicListSortIndex then
  begin
    FTopicListSortOrder := not FTopicListSortOrder;
  end else
  begin
    FTopicListSortOrder := true;
//  FTopicListSortIndex := Column.id;    // 2008.06.16
    FTopicListSortIndex := Column.Index  // 2008.06.16
  end;

  //\[gs
  FTopicList.Sort(TopicListSortCompare);

  if FSelectedBoard is TFavoriteBoard then
  begin
    (FSelectedBoard as TFavoriteBoard).Sort(TopicListSortCompare);
  end;

  DoubleBuffered := true;
  Repaint;
  DoubleBuffered := false;
end;

//ngthread.txt ̓e NGThreadszɋL
procedure TTopicListView.SetNGThreads();
var
  strNGThreadFile: String;
  Mode: Word;
  FileStream : TFileStream;
  i: integer;
begin
  strNGThreadFile := Apppath('ngthread.txt');

  //t@C݂ȂΐVK쐬
  if FileExists(strNGThreadFile) = false then
   begin
    Mode := fmCreate or fmShareDenyWrite;

    FileStream := TFileStream.Create(strNGThreadFile, Mode);
    FileStream.Free;
  end;

  //NGThreads := TStringList.Create;
  NGThreads.Clear;
  NGThreads.LoadFromFile(Apppath('ngthread.txt'));

  for i:=0 to NGThreads.Count-1 do
  begin
     NGThreads.Strings[i] := TrimRight(NGThreads.Strings[i]);
  end;

end;

constructor TTopicListView.Create;
begin
  inherited;

  FListItemToClear := TObjectList.Create;
  FTopicList       := TList.Create;
  CompleteEvent := TSimpleEvent.Create;
  OnColumnClick    := TopicListViewColumnClick;
  OnCustomDrawItem := TopicListViewCustomDrawItem;
  OnData           := TopicListViewData;

  //ŏ̋Nł̓\[gXԍɂ
  FTopicListSortIndex := 2;

  NGThreads := TStringList.Create;

  GetTimeZoneInformation(TimeZoneInfo);		// 2008.07.03
end;

function TTopicListView.IsNGThread(strWord: string): boolean;
var
  bl: boolean;
  i: integer;
begin
  bl := false;

  //NGXbhɌꂪ܂܂邩ǂ̔f
  for i:=0 to NGThreads.Count-1 do
  begin
     if (strWord = NGThreads.Strings[i]) then
     begin
      bl := true;
      Break;
     end;
  end;

  result := bl;
end;

destructor TTopicListView.Destroy;
begin
  CompleteEvent.Free;
  FTopicList.Free;
  FListItemToClear.Free;

  NGThreads.Free;

  inherited;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TTopicListView]);
end;

//procedure TTopicListView.OnActive(var Msg: TMessage);
//begin
//  MainForm.SetColumnOrderArray();
//end;

//
// XbhԍAXbh쐬ɕϊ
//
function TTopicListView.ThreadnumToStr(s: string): string;
var
  iTime: TDateTime;
  n: integer;

begin

	iTime:=0;
	// Xbhԍintɕϊ
	n := StrToIntDef(s,0);

	// XbhԍTDateTimeɕϊ
	if n >0 then
	begin
		iTime := (n - TimeZoneInfo.Bias*60)/(24*60*60) + UnixDateDelta;
	end;

	// TDateTime𕶎ɕϊ
	result:=DateTimeToStr(iTime);
end;

//procedure TTopicListView.InitTopicViewItem;
//begin
//
//  if ItemIndex <> -1 then
//  begin
//    TTopic(FTopicList[ItemIndex]).ScrollPosition:=0;
//    TTopic(FTopicList[ItemIndex]).PhysicalScrollPosition:=-1;
//  end;
//end;







end.
