unit untBBSCore;

interface

uses
  Classes, Contnrs,
  untTopic, untBoard;

type

  TTopicStateType = (stMessageReceived, stStatusText, stDownloadState, stWriteDone);
  TTopicStateChangeEvent = procedure(Topic : TTopic; EventType : TTopicStateType) of object;

  TBBSCore = class
  private
    FTopicCache             : TStringList;
    FTopicStateChangeEvents : array of TTopicStateChangeEvent;
    FWorkingThreads         : TList;
  public
    constructor Create;
    destructor  Destroy; override;
    function  GetTopic(TopicPath : string) : TTopic;
    procedure DownloadTopic(Topic : TTopic);
    procedure PostArticle(Topic : TTopic; PostName, PostEmail, PostBody : string );
    procedure MakeTopic(Board : TBoard; Title, PostName, PostEmail, PostBody : string);
    procedure AddTopicStateChangeEvent(Item : TTopicStateChangeEvent);
    procedure RaiseTopicStateChangeEvent(Topic : TTopic; EventType : TTopicStateType);
  end;

implementation

uses
  untTopicDownloadThread, untTopicPostThread;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBBSCore.Create;
begin
  FTopicCache := TStringList.Create;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBBSCore.Destroy;
begin
  FTopicCache.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: GetTopic
  pr  : gsbN̎擾
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.GetTopic(TopicPath: string): TTopic;
var
  I        : Integer;
  Index    : Integer;
  newtopic : TTopic;
begin

  // LbVǂݎ
  Index := FTopicCache.IndexOf(TopicPath);
  if Index > - 1 then
  begin
    result := TTopic(FTopicCache.Objects[Index]);
    exit;
  end;

  // VgsbN
  newtopic := TTopic.Create(TopicPath);
  //newtopic.OnUpdate := MainForm.UpdateTopic;
  Index := FTopicCache.Add(TopicPath);
  FTopicCache.Objects[Index] := newtopic;
  result := newtopic;
end;

{ --------------------------------------------------------
  ֐: DownloadTopic
  pr  : gsbÑ_E[h
    : Topic - _E[hΏۂ̃gsbN
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.DownloadTopic(Topic: TTopic);
var
  DownloadThread : TTopicDownloadThread;
begin

  if Topic.IsDownloadingTopic = false then
  begin

    // _E[hpXbh𗧂グ
    DownloadThread := TTopicDownloadThread.Create(Topic, false); 
    DownloadThread.Priority := tpIdle;
    DownloadThread.Resume;

  end;

end;

{ --------------------------------------------------------
  ֐: PostArticle
  pr  : bZ[W̓e
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.PostArticle(Topic: TTopic; PostName, PostEmail,
  PostBody: string);
var
  PostThread : TTopicPostThread;
begin

  if Topic.IsPosingArticle = false then
  begin

    // epXbh𗧂グ
    PostThread := TTopicPostThread.Create(Topic, PostName, PostEmail, PostBody);
    PostThread.Priority := tpIdle;
    PostThread.Resume;

  end;

end;

{ --------------------------------------------------------
  ֐: MakeTopic
  pr  : gsbN̍쐬
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.MakeTopic(Board: TBoard; Title, PostName, PostEmail,
  PostBody: string);
begin

end;

{ --------------------------------------------------------
  ֐: AddTopicStateChangeEvent
  pr  : gsbN̍쐬
    : Item - 
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.AddTopicStateChangeEvent(Item: TTopicStateChangeEvent);
var
  intLength : integer;
begin

  intLength := Length(FTopicStateChangeEvents);
  SetLength(FTopicStateChangeEvents, intLength + 1);
  FTopicStateChangeEvents[intLength] := Item;

  //FTopicStateChangeEvents.Add(Item);
end;

{ --------------------------------------------------------
  ֐: RaiseTopicStateChangeEvent
  pr  : Cxg̔s
    : Topic     - gsbN
  @@@: EventType - Cxg̎
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.RaiseTopicStateChangeEvent(Topic: TTopic;
  EventType: TTopicStateType);
var
  I : integer;
begin

  for I := 0 to Length(FTopicStateChangeEvents) - 1 do
    TTopicStateChangeEvent(FTopicStateChangeEvents[I])(Topic, EventType);

end;


end.
