unit untBoardList;

interface

uses
  Classes, SysUtils, Contnrs, Forms, 
  untOption, untTool, untBoard;

type
  TBoardList = class
  private
    FBoardListId: Integer;
    procedure SetBoardListId(const Value: Integer);
  public
    Boards        : TObjectList;
    FavoriteBoard : TOfflineBoard;
    property    BoardListId : Integer read FBoardListId write SetBoardListId;
    function    GetBoardByPath(BoardPath : string) : TBoard;
    constructor Create();
    destructor  Destroy; override;
  end;

implementation

{ TBoardList }

//  vpeB 

procedure TBoardList.SetBoardListId(const Value: Integer);
begin
  FBoardListId := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBoardList.Create;
var
  boardfile     : TStringList;
  boarditems    : TStringArray;
  I             : Integer;
  category      : string;
  newboard      : TOnlineBoard;
  favidxpath    : string;
  favoriteboard : TOfflineBoard;
begin
  FBoardListId := 1;

  // {[ht@Cǂݍ
  Boards    := TObjectList.Create();
  boardfile := TStringList.Create;
  if FileExists(AppPath('2channel.brd')) then
    boardfile.LoadFromFile(AppPath('2channel.brd'));

  for I := 0 to boardfile.Count - 1 do
  begin
    boarditems := Split(boardfile[I], #9);
    if boarditems[0] <> '' then
      category := boarditems[0]
    else
    begin

      // IuWFNg쐬
      newboard := TOnlineBoard.Create(boarditems[2],
                                      boarditems[3],
                                      category,
                                      StringReplace(boarditems[1], '/', '_', [rfReplaceAll]));
      // Xgɒǉ
      Boards.Add(newboard);
    end;
  end;
  boardfile.Free;

	// Cɓǂݍ
  favidxpath := AppPath('favorite.fav');
  favoriteboard := TOfflineBoard.Create(favidxpath, 'Cɓ');
  //favoriteboard.Category := '}CtH_';
	Boards.Insert(0, favoriteboard);
	self.FavoriteBoard := favoriteboard;
  
	// Xbhqɂǂݍ
  {
	string[] idxfiles = Directory.GetFiles(Application.StartupPath, "*.fav");
			foreach(string idxfile in idxfiles)
			{
				if(idxfile == Config.FavoriteIdxPath) continue;
				Match matchboard  = Regex.Match(idxfile, "\\\\([^\\\\]+)\\.fav");
				string boardname  = matchboard.Groups[1].Value;

				favorite = new OfflineBoard(idxfile, boardname);
				favorite.Category = "}CtH_";
				Boards.Insert(1, favorite);
			}

			// Cxgs
			//if(OnUpdateComplete != null) OnUpdateComplete(null);

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBoardList.Destroy;
begin
  //Boards.Free;

  inherited Destroy;
end;

{ --------------------------------------------------------
  ֐: GetBoardByPath
  pr  : {[h̎擾
    : BoardPath
  ߂l: TBoard
  l  : Ȃ
  ------------------------------------------------------ }
function TBoardList.GetBoardByPath(BoardPath: string): TBoard;
var
  I     : Integer;
  Board : TBoard;
begin

  for I := 0 to Boards.Count - 1 do
  begin
    Board := TBoard(Boards[I]);
    if Board.BoardPath = BoardPath then
    begin
      result := Board;
      exit;
    end;
  end;

  result := nil;
end;

end.
