unit untMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ToolWin, ExtCtrls, ImgList,
  Menus, Contnrs, untWriteForm, untTool, untToolTipForm, untBBSCore,
  untGlobal, untBoard, untTopicBrowser, untTopic, untOption,
  untSearchForm;

type
  TBoardListCategory = class
  public
    CategoryName : string;
    Color        : TColor;
    Opened       : Boolean;
    Boards       : TList;
  end;

  TMainForm = class(TForm)
    BoardListBox : TListBox;
    ToolBarImageList: TImageList;
    TopicImageList: TImageList;
    MainControlBar: TControlBar;
    MainToolBar: TToolBar;
    SearchToolButton: TToolButton;
    PatrolToolButton: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    StyleToolButton: TToolButton;
    StyleSub1ToolButton: TToolButton;
    StyleSub2ToolButton: TToolButton;
    StyleSub3ToolButton: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    Splitter1: TSplitter;
    RightPanel: TPanel;
    Splitter2: TSplitter;
    TopicListView: TListView;
    BrowserPanel: TPanel;
    TopicToolBar: TToolBar;
    ToolButton5: TToolButton;
    DownloadTopicToolButton: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton12: TToolButton;
    TopicWriteToolButton: TToolButton;
    FavoriteToolButton: TToolButton;
    ToolButton15: TToolButton;
    ToolButton17: TToolButton;
    CloseTabToolButton: TToolButton;
    MainStatusBar: TStatusBar;
    TopicPageControl: TPageControl;
    ToolPopupMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    TopicListViewPopupMenu: TPopupMenu;
    OpenNewTabMenuItem: TMenuItem;
    BoardNameLabel: TLabel;
    TopicNameLabel: TLabel;
    TopicPagePopupMenu: TPopupMenu;
    CloseMenuItem: TMenuItem;
    CloseAllMenuItem: TMenuItem;
    CloseWithoutMenuItem: TMenuItem;
    URL1: TMenuItem;
    URL2: TMenuItem;
    N6: TMenuItem;
    N01: TMenuItem;
    N7: TMenuItem;
    AutoReloadMenuItem: TMenuItem;
    procedure StyleChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BoardListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BoardListBoxData(Control: TWinControl; Index: Integer;
      var Data: String);
    function BoardListBoxDataFind(Control: TWinControl;
      FindString: String): Integer;
    procedure BoardListBoxClick(Sender: TObject);
    procedure TopicListViewData(Sender: TObject; Item: TListItem);
    procedure TopicListViewMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OpenNewTabMenuItemClick(Sender: TObject);
    procedure TopicPageControlChange(Sender: TObject);
    procedure TopicWriteToolButtonClick(Sender: TObject);
    procedure TopicPageControlDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure CloseTabToolButtonClick(Sender: TObject);
    procedure TopicPageControlMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DownloadTopicToolButtonClick(Sender: TObject);
    procedure FavoriteToolButtonClick(Sender: TObject);
    procedure PatrolToolButtonClick(Sender: TObject);
    procedure BoardNameLabelClick(Sender: TObject);
    procedure AutoReloadMenuItemClick(Sender: TObject);
    procedure SearchToolButtonClick(Sender: TObject);
  private
    FOldtab    : TTopicBrowser;
    FWriteForm : TWriteForm;
    FSelectedBoard : TBoard;
    FBoardList     : TList;
    FTopicList     : TList;
    procedure UpdateBoardList();
    procedure GetBoardFromListBox(Index : Integer; var Board : TBoard; var Category : TBoardListCategory);
    procedure OpenBoard(Board : TBoard);
    procedure OpenTab(Topic : TTopic; newtab : Boolean);
    procedure CloseTab(Tab : TTopicBrowser);
    procedure ChangeTab();
    procedure DownloadTopic();
    procedure TopicStateChange(Topic : TTopic; EventType : TTopicStateType);
    procedure Board_TopicReceived(Sender : TObject; Topic : TTopic);
  public
    { Public 錾 }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

{ TMainForm }

//  c[o[Cxg 

procedure TMainForm.FormCreate(Sender: TObject);
var
  browser : TTopicBrowser;
begin

  gBBSCore.AddTopicStateChangeEvent(TopicStateChange); 

  ToolTipForm := TToolTipForm.Create(self); 
  ToolTipForm.UnVisible;
  ToolTipForm.Show;

  // ݒ蔽f
  StyleChange(nil);
  OpenBoard(nil);

  // {[hXgXV
  UpdateBoardList();

  // uEUЂƂJĂ
  browser := TTopicBrowser.Create(self);
  browser.PageControl := TopicPageControl;

  // ݃tH[
  FWriteForm := TWriteForm.Create(self);

end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  I       : Integer;
  browser : TTopicBrowser;
begin

  FWriteForm.Free;

  // uEỦ
  {
  for I := 0 to TopicPageControl.PageCount - 1 do
  begin
    browser := TTopicBrowser(TopicPageControl.Pages[I]);
    browser.Free;
  end;
  }

  FBoardList.Free;
  FTopicList.Free;

end;

// \X^CύX
procedure TMainForm.StyleChange(Sender: TObject);
var
  NormalMode : Boolean;
begin

  // yCX^C̕ύX
  if Sender = StyleToolButton then
    if StyleToolButton.ImageIndex = 3 then
    begin
      StyleToolButton.ImageIndex     := 7;
      StyleSub1ToolButton.ImageIndex := 8;
      StyleSub2ToolButton.ImageIndex := 9;
      StyleSub3ToolButton.ImageIndex := 10;
    end else
    begin
      StyleToolButton.ImageIndex     := 3;
      StyleSub1ToolButton.ImageIndex := 4;
      StyleSub2ToolButton.ImageIndex := 5;
      StyleSub3ToolButton.ImageIndex := 6;
    end;
  NormalMode := (StyleToolButton.ImageIndex = 7);

  if (StyleSub2ToolButton.Down = true) and
     (StyleSub3ToolButton.Down = true) then
    if(Sender = StyleSub2ToolButton) then
      StyleSub3ToolButton.Down := false
    else
      StyleSub2ToolButton.Down := false;

  if StyleSub1ToolButton.Down = true then
    BoardListBox.Visible := false
  else
  begin
    BoardListBox.Visible := true;
    BoardListBox.Width := gBoardListBoxWidth;
    RightPanel.Align   := alNone;
    Splitter1.Align    := alNone;
    Splitter1.Width    := 3;
    Splitter1.Left     := BoardListBox.Width;
    Splitter1.Align    := alLeft;
    RightPanel.Left    := Splitter1.Left + Splitter1.Width;
    RightPanel.Align   := alClient;
  end;   

  if (StyleSub2ToolButton.Down = false) and
     (StyleSub3ToolButton.Down = false) then
  begin

    if NormalMode = true then
    begin
      TopicListView.Visible := true;
      TopicListView.Align   := alTop;
      TopicListView.Height  := gTopicListViewHeight;
      Splitter2.Align       := alNone;
      Splitter2.Height      := 3;
      Splitter2.Top         := TopicListView.Height;
      Splitter2.Align       := alTop;
      BrowserPanel.Visible  := true;
      BrowserPanel.Align    := alNone;
      BrowserPanel.Top      := Splitter2.Top + Splitter2.Height;
      BrowserPanel.Align    := alClient;
    end else
    begin
      TopicListView.Visible := true;
      TopicListView.Align   := alLeft;
      TopicListView.Width   := gTopicListViewWidth;
      Splitter2.Align       := alNone;
      Splitter2.Width       := 3;
      Splitter2.Left        := TopicListView.Width;
      Splitter2.Align       := alLeft;
      BrowserPanel.Visible  := true;
      BrowserPanel.Align    := alNone;
      BrowserPanel.Left     := Splitter2.Left + Splitter2.Width;
      BrowserPanel.Align    := alClient;
    end;

  end else
  if StyleSub2ToolButton.Down = true then
  begin
    BrowserPanel.Visible := false;
    TopicListView.Align  := alClient;
  end else
  begin
    TopicListView.Visible := false;
    BrowserPanel.Align  := alClient;
  end;


end;

// ꗗ`
procedure TMainForm.BoardListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  Category     : TBoardListCategory;
  Board        : TBoard;
  ColorRect    : TRect;
  ViewString   : string;
  DefaultBrush : TColor;
begin

  GetBoardFromListBox(Index, Board, Category);
  if Board = nil then
    ViewString := '' + Category.CategoryName
  else
    ViewString := '@' + Board.DisplayName;

  // FÂ
  ColorRect.Left   := Rect.Left;
  ColorRect.Top    := Rect.Top;
  ColorRect.Bottom := Rect.Bottom;
  ColorRect.Right  := Rect.Left + 5;
  DefaultBrush := TListBox(Control).Canvas.Brush.Color;
  TListBox(Control).Canvas.Brush.Color := Category.Color;
  TListBox(Control).Canvas.Brush.Style := bsSolid;
  TListBox(Control).Canvas.FillRect(ColorRect);
  TListBox(Control).Canvas.Brush.Color := DefaultBrush;

  Rect.Left := Rect.Left + 5;
  TListBox(Control).Canvas.TextRect(Rect, Rect.Left + 1, Rect.Top, ViewString);

end;

// ^u`
procedure TMainForm.TopicPageControlDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean);
var
  Browser  : TTopicBrowser;
  X, Y     : Integer;
  DrawRect  : TRect;
begin

  if (TabIndex >= 0) and (TabIndex < TopicPageControl.PageCount) then
  begin
    Browser := TTopicBrowser(TopicPageControl.Pages[TabIndex]);

    // 
    Control.Canvas.FillRect(Rect); 

    // ACR̕`
    if(Browser.ImageIndex > -1) and (Browser.ImageIndex < TopicPageControl.Images.Count) then
    begin
      TopicPageControl.Images.Draw(Control.Canvas, Rect.Left + 3, Rect.Top + 3, Browser.ImageIndex);

      X := Rect.Left + 20;
    end else
    begin
      X := Rect.Left + 5;
    end;

    if Active = false then
      Control.Canvas.Font.Color := clBtnShadow
    else
      Control.Canvas.Font.Color := clWindowText;

    DrawRect.Top    := Rect.Top + 2;
    DrawRect.Left   := X;
    DrawRect.Bottom := Rect.Bottom - 1;
    DrawRect.Right  := Rect.Right  - 1;
    Control.Canvas.TextRect(DrawRect, X, Rect.Top + 5, Browser.Caption);
  end;

end;

procedure TMainForm.BoardListBoxData(Control: TWinControl; Index: Integer;
  var Data: String);
var
  Category     : TBoardListCategory;
  Board        : TBoard;
begin

  GetBoardFromListBox(Index, Board, Category);
  if Board = nil then
    Data := '' + Category.CategoryName
  else
    Data := '@' + Board.DisplayName;

end;

function TMainForm.BoardListBoxDataFind(Control: TWinControl;
  FindString: String): Integer;
begin
  //
end;

// {[hXgClick
procedure TMainForm.BoardListBoxClick(Sender: TObject);
var
  Index    : Integer;
  Board    : TBoard;
  Category : TBoardListCategory;
begin

  Index := BoardListBox.ItemIndex;
  GetBoardFromListBox(Index, Board, Category);

  if Board <> nil then
    OpenBoard(Board);

end;

procedure TMainForm.TopicListViewData(Sender: TObject; Item: TListItem);
var
  Topic : TTopic;
  image : Integer;
begin

  if (Item.Index < 0) or (Item.Index >= FTopicList.Count) then exit; 

  Topic := TTopic(FTopicList[Item.Index]);
  Item.Caption  := '';
  Item.SubItems.Add('');
  Item.SubItems.Add(IntToStr(Topic.Index));
  Item.SubItems.Add(Topic.Title);
  Item.SubItems.Add(IntToStr(Topic.MessageCount));
  Item.SubItems.Add(IntToStr(Topic.GotMessageCount));
  Item.SubItems.Add(IntToStr(Topic.NewMessageCount));

  // ACR
  image := -1;
  if Topic.DownloadState <> dsNone  then image := 2
  else if Topic.IsFavorite          then image := 3
	else if Topic.IsError             then image := 7
  else if Topic.IsFreezed           then image := 8
  else if Topic.GotMessageCount >= Topic.MessageCount then image := 4
  else if Topic.GotMessageCount > 0 then image := 5;
  Item.ImageIndex := image;

end;

// gsbNACeIꂽ
procedure TMainForm.TopicListViewMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Topic : TTopic;
  Item  : TListItem;
begin

  Item := TopicListView.Selected;
  if Item <> nil then
  begin
    Topic := TTopic(FTopicList[Item.Index]);
    OpenTab(Topic, false);
  end;
end;

// ^uύX
procedure TMainForm.TopicPageControlChange(Sender: TObject);
begin
  ChangeTab();
end;

// ^u_uNbNꂽ
procedure TMainForm.TopicPageControlMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
//
  if ssDouble in Shift then
    DownloadTopic;
end;

// xNbN
procedure TMainForm.BoardNameLabelClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
  if ActiveTab.Topic <> nil then
    OpenBoard(TBoard(ActiveTab.Topic.Board));
  
end;

//  j[Cxg 

// open topic with newtab
procedure TMainForm.OpenNewTabMenuItemClick(Sender: TObject);
var
  Topic : TTopic;
  Item  : TListItem;
begin

  Item := TopicListView.Selected;
  if Item <> nil then
  begin
    Topic := TTopic(FTopicList[Item.Index]);
    OpenTab(Topic, true);
  end;
end;

// I[g[h
procedure TMainForm.AutoReloadMenuItemClick(Sender: TObject);
var
  Topic : TTopic;
  ActiveTab : TTopicBrowser;
begin

  AutoReloadMenuItem.Checked := not AutoReloadMenuItem.Checked;

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
  if ActiveTab.Topic <> nil then
    ActiveTab.AutoReload := AutoReloadMenuItem.Checked;
end;

//  c[j[Cxg 

// gsbN
procedure TMainForm.TopicWriteToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
  if ActiveTab.Topic <> nil then
    FWriteForm.SetTopic(ActiveTab.Topic); 

end;

// ^u
procedure TMainForm.CloseTabToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
  I         : Integer;
begin

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);

  if Sender = CloseAllMenuItem then
  begin

    // Sĕ
    for I := 0 to TopicPageControl.PageCount - 1 do
      CloseTab(TTopicBrowser(TopicPageControl.Pages[I]));

  end else
  if Sender = CloseWithoutMenuItem then
  begin

    // ANeBuȃ^uȊO
    for I := 0 to TopicPageControl.PageCount - 1 do
      if TopicPageControl.Pages[I] <> ActiveTab then
        CloseTab(TTopicBrowser(TopicPageControl.Pages[I]));

  end else

    // ANeBuȃ^u
    CloseTab(ActiveTab);

end;

// gsbN_E[h
procedure TMainForm.DownloadTopicToolButtonClick(Sender: TObject);
begin
  DownloadTopic;
end;

// Cɓɒǉ
procedure TMainForm.FavoriteToolButtonClick(Sender: TObject);
var
  Topic : TTopic;
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
  if ActiveTab.Topic <> nil then
  begin
    if ActiveTab.Topic.IsFavorite = false then
      gBoardList.FavoriteBoard.AppendTopic(ActiveTab.Topic)
    else
      gBoardList.FavoriteBoard.RemoveTopic(ActiveTab.Topic)
  end;

  TopicStateChange(ActiveTab.Topic, stDownloadState);

end;

// Jn
procedure TMainForm.PatrolToolButtonClick(Sender: TObject);
begin

  gBoardList.FavoriteBoard.Patrol();

end;

// 
procedure TMainForm.SearchToolButtonClick(Sender: TObject);
var
  SearchForm   : TSearchForm;
  I            : Integer;
  SearchText   : string;
  ActiveTab    : TTopicBrowser;
  NewTopicList : TList;
begin

  SearchForm := TSearchForm.Create(nil);
  SearchForm.ShowModal;
  SearchText := SearchForm.SearchEdit.Text;

  if SearchForm.SearchSelect = srFromTopic then
  begin

    // gsbN̓e猟

    ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
    ActiveTab.SearchText(SearchText);

  end else
  if SearchForm.SearchSelect = srFromTopicList then
  begin

    // gsbNXg猟
    NewTopicList := TList.Create;
    for I := 0 to FTopicList.Count - 1 do
      if Pos(SearchText, TTopic(FTopicList[I]).Title) > 0 then
        NewTopicList.Add(FTopicList[I]);

    FTopicList.Free;
    FTopicList := NewTopicList;
    TopicListView.Items.Count := FTopicList.Count;

  end else
  if SearchForm.SearchSelect = srFromBoardList then
  begin

    // {[hXg猟

    for I := 0 to BoardListBox.Count - 1 do
      if Pos(SearchText, BoardListBox.Items[I]) > 0 then
      begin
        BoardListBox.Selected[I] := true;
        //BoardListBox.ItemIndex := I;
        BoardListBoxClick(BoardListBox);
        break;
      end;

  end;

  SearchForm.Free;

  //
end;

//  ̑̃Cxg 

// {[hXg̍XV
procedure TMainForm.UpdateBoardList();
var
  I            : Integer;
  Board        : TBoard;
  CategoryName : string;
  Category     : TBoardListCategory;
  ColorCycle   : Integer;
  Color        : TColor;
begin

  BoardListBox.Clear();
  FBoardList.Free;
  FBoardList := TList.Create();

  // {[hXg\z
  Category   := nil;
  ColorCycle := 0;
  for I := 0 to gBoardList.Boards.Count - 1 do
  begin
    Board := TBoard(gBoardList.Boards[I]);
    if (Board.Category <> CategoryName) or (Category = nil) then
    begin
      Category := TBoardListCategory.Create();
      Category.Boards       := TList.Create();
      Category.CategoryName := Board.Category;
      CategoryName          := Board.Category;

      // F
      Inc(ColorCycle); if ColorCycle > 33 then ColorCycle := 1;
      case ColorCycle of
        1:  Color := Rgb( 255, 255, 255 );
        2:  Color := Rgb( 152,  90,  98 );
        3:  Color := Rgb( 221, 255, 221 );
        4:  Color := Rgb( 255, 215, 255 );
        5:  Color := Rgb(  81, 157, 176 );
        6:  Color := Rgb( 215, 215, 255 );
        7:  Color := Rgb(   0, 128, 128 );
        8:  Color := Rgb( 255,   0,   0 );
        9:  Color := Rgb( 186, 160,  71 );
        10: Color := Rgb( 255, 134, 134 );
        11: Color := Rgb( 194, 177, 186 );
        12: Color := Rgb( 139,  63, 120 );
        13: Color := Rgb( 169, 186,  50 );
        14: Color := Rgb( 160, 150, 222 );
        15: Color := Rgb( 211, 196, 141 );
        16: Color := Rgb( 255,   0, 255 );
        17: Color := Rgb( 255, 255,   0 );
        18: Color := Rgb( 143, 140, 145 );
        19: Color := Rgb( 255, 162, 255 );
        20: Color := Rgb(   0,   0, 255 );
        21: Color := Rgb( 208,  34, 196 );
        22: Color := Rgb( 179, 255, 179 );
        23: Color := Rgb(  55, 230, 217 );
        24: Color := Rgb( 149, 149, 255 );
        25: Color := Rgb(  91,  48, 194 );
        26: Color := Rgb( 200, 241, 255 );
        27: Color := Rgb(   0, 255,   0 );
        28: Color := Rgb( 40,  202, 255 );
        29: Color := Rgb( 255, 255, 210 );
        30: Color := Rgb( 255, 208, 208 );
        31: Color := Rgb(   0, 140, 187 );
        32: Color := Rgb( 234, 138, 172 );
        33: Color := Rgb(   0,   0,   0 );
      end;
      Category.Color := Color;
      FBoardList.Add(Category);
    end;

    Category.Boards.Add(Board);
  end;

  BoardListBox.Count := gBoardList.Boards.Count + FBoardList.Count;

end;

// gsbNM
procedure TMainForm.Board_TopicReceived(Sender: TObject; Topic: TTopic);
var
  TopIndex : Integer;
begin

  FTopicList.Add(Topic);
  TopicListView.Items.Add;
  //TopIndex := TopicListView.TopItem.Index;
  //TopicListView.Items.Count := Topic.Index;
  //if TopIndex < TopicListView.Items.Count then
  //  TopicListView.TopItem.Index  := TopIndex; 


  Application.ProcessMessages;

end;

procedure TMainForm.TopicStateChange(Topic: TTopic;
  EventType: TTopicStateType);
begin

  if EventType <> stDownloadState then exit;

  // gsbNXgXV
  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;

  ChangeTab();

  // ^uĕ`
  TopicPageControl.DoubleBuffered := true;
  TopicPageControl.Repaint;
  TopicPageControl.DoubleBuffered := false;

end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: GetBoardFromListBox
  pr  : {[hXgIndeẍʒuɂ{[h擾
    : Index
  @@@: Board
  @@@: Category
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.GetBoardFromListBox(Index : Integer;
                                    var Board : TBoard;
                                 var Category : TBoardListCategory);
var
  I            : Integer;
  C_Category   : TBoardListCategory;
  MaxIndex     : Integer;
  SubIndex     : Integer;
begin

  Board    := nil;
  Category := nil;

  MaxIndex := -1;
  for I := 0 to FBoardList.Count - 1 do
  begin
    C_Category := TBoardListCategory(FBoardList[I]);
    Inc(MaxIndex, C_Category.Boards.Count + 1);
    if Index <= MaxIndex then
    begin
      SubIndex := (C_Category.Boards.Count - 1) - (MaxIndex - Index);

      if SubIndex > -1 then
        Board := TBoard(C_Category.Boards[SubIndex]);
      Category := C_Category;
      exit;
    end;
  end;

end;

{ --------------------------------------------------------
  ֐: OpenBoard
  pr  : {[hJ
    : Index
  @@@: Board
  @@@: Category
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.OpenBoard(Board: TBoard);
var
  NoClear : Boolean;
begin

  NoClear := false;
  if FSelectedBoard <> nil then
    if FSelectedBoard = Board then
      if FSelectedBoard.IsDownloading then
        NoClear := true;

  if NoClear = false then
  begin
    TopicListView.Items.Clear();
    FTopicList.Free;
    FTopicList := TList.Create;
  end;

  if FSelectedBoard <> nil then
  begin
    FSelectedBoard.OnTopicReceived := nil;
    //FSelectedBoard.OnError := nil;
  end;

  // ^Cgo[ύX
  self.Caption := '`ᕜ Version ' +
                   GetVersionStr();

  if Board <> nil then
  begin
    FSelectedBoard := Board;
    FSelectedBoard.OnTopicReceived := Board_TopicReceived;
    //FSelectedBoard.OnError := Board_TopicReceived;

    // ^Cgo[ύX
    self.Caption := self.Caption + ' [ ' + Board.DisplayName + ' ]';

    // ǂݍ݊Jn
    FSelectedBoard.Download();
  end;

end;

{ --------------------------------------------------------
  ֐: CloseTab
  pr  : ^u
    : Tab - ^u
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.CloseTab(Tab : TTopicBrowser);
var
  Index : Integer;
begin

  Index := Tab.TabIndex;
  if Index > 0 then Index := Index -1;
  //TopicPageControl.ActivePage := TopicPageControl.Pages[Index];

  if TopicPageControl.PageCount = 1 then
    Tab.CloseTopic
  else
  begin
    Tab.Free;
  end;

  // ^uĕ`
  TopicPageControl.DoubleBuffered := true;
  TopicPageControl.Repaint;
  TopicPageControl.DoubleBuffered := false;
end;

{ --------------------------------------------------------
  ֐: OpenTab
  pr  : {[h^uŊJ
    : Index
  @@@: Board
  @@@: Category
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.OpenTab(Topic: TTopic; newtab: Boolean);
var
  Match     : Boolean;
  ActiveTab : TTopicBrowser;
  I         : Integer;
  Browser   : TTopicBrowser;
begin

  // ɃXbh\ς݂Ȃ炻ANeBuɂ
	Match := false;
	Activetab := nil;
  for I := 0 to TopicPageControl.PageCount - 1 do
  begin
    Browser := TTopicBrowser(TopicPageControl.Pages[I]);
    if Browser.Topic = Topic then
    begin
		  Activetab := Browser;
      Match := true;
			break;
    end;
  end;

  if Match = false then
    if (newtab = true) and ((TTopicBrowser(TopicPageControl.Pages[0]).Topic <> nil)) then
    begin

      // VJ
			ActiveTab := TTopicBrowser.Create(self);
      ActiveTab.PageControl := TopicPageControl;
      ActiveTab.OpenTopic(Topic);

    end else
    begin

		  // ANeBuȃ^uŊJ
			ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
			Activetab.OpenTopic(topic);
    end;

  TopicPageControl.ActivePage := ActiveTab;
  Application.ProcessMessages;

	// ǂݍ݊Jn
  ChangeTab();
	Activetab.Download();

end;

{ --------------------------------------------------------
  ֐: ChangeTab
  pr  : ^uύXꂽ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.ChangeTab;
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);

  if ActiveTab.Topic <> nil then
  begin
    BoardNameLabel.Caption   := '[' + ActiveTab.Topic.BoardName + ']';
    TopicNameLabel.Left      := BoardNameLabel.Left + BoardNameLabel.Width + 5;
    TopicNameLabel.Caption   := ActiveTab.Topic.Title;
    MainStatusBar.SimpleText := ActiveTab.Topic.StatusText;
    //AddressTextBox.Text  := activetab.Thread.BrowserUrl;

    if ActiveTab.Topic.IsFavorite then
      FavoriteToolButton.ImageIndex := 18
    else
      FavoriteToolButton.ImageIndex := 19;

    AutoReloadMenuItem.Checked := ActiveTab.AutoReload;

  end else
  begin
    BoardNameLabel.Caption := '';
    TopicNameLabel.Caption := '';
    MainStatusBar.SimpleText := '';
  end;

  if FOldtab <> nil then
    if FOldTab <> ActiveTab then FOldtab.ClearNewMsg;
  FOldTab := ActiveTab;

  // ^uĕ`
  TopicPageControl.DoubleBuffered := true;
  TopicPageControl.Repaint;
  TopicPageControl.DoubleBuffered := false;
end;

{ --------------------------------------------------------
  ֐: DownloadTopic
  pr  : ݊JĂ^uXV
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.DownloadTopic;
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := TTopicBrowser(TopicPageControl.ActivePage);
  ActiveTab.Download;

end;


end.
