unit untOption;

interface

uses
  IniFiles, SysUtils, Forms,
  untTool;

const
  APP_USERAGENT    = 'Mozilla/1.0 (hage/1.00)';
  DIR_LOG          = 'log\';

var

  // O[oIvV
  gBoardListUrl  : string;         // {[hXgURL
  gWriteProxyUse : Boolean;        // ݂ɃvLVg
  gWriteProxy    : string;         // ݗpvLV
  gReadProxyUse  : Boolean;        // ǂݍ݂ɃvLVg
  gReadProxy     : string;         // ǂݍݗpvLV
  gHeaderHtml    : string;         // uEUowb_HTML
  gResHtml       : string;         // uEUoXHTML
  gNewResHtml    : string;         // uEUoVXHTML
  gViewLimit     : Integer;        // \X

  gOffLineMode  : Boolean;         // ItC[h쒆

  // CAEg֘A
  gMainFormWindowState : Integer;  // MainForm WindowState
  gMainFormWidth       : Integer;  // MainForm Width
  gMainFormHeight      : Integer;  // MainForm Height
  gBoardListBoxWidth   : Integer;  // BoardListBox  Width  size
  gTopicListViewWidth  : Integer;  // TopicListView Width  size
  gTopicListViewHeight : Integer;  // TopicListView Height size

  procedure ReadOption();

implementation

const
  FILE_OPTIONINI     = 'katju88.ini';
  FILE_HEADERHTML    = 'Header.htm';
  FILE_RESHTML       = 'Res.htm';
  FILE_NEWRESHTML    = 'NewRes.htm';
  SEC_MAIN           = 'Main';
  SEC_PROXY          = 'Proxy';
  SEC_MAINFORM       = 'MainForm';
  SEC_BOARDLISTBOX   = 'BoardListBox';
  SEC_TOPICLISTVIEW  = 'TopicListView';
  KEY_USERAGENT      = 'UserAgent';
  KEY_BOARDLISTURL   = 'BoardListUrl';
  KEY_WRITEPROXYUSE  = 'WriteProxyUse';
  KEY_WRITEPROXY     = 'WriteProxy';
  KEY_READPROXYUSE   = 'ReadProxyUse';
  KEY_READPROXY      = 'ReadProxy';
  KEY_WINDOWSTATE    = 'WindowState';
  KEY_WIDTH          = 'Width';
  KEY_HEIGHT         = 'Height';
  KEY_VIEWLIMIT      = 'ViewLimit';

{  O[o֐  }

// -----------------------------------------------------
// ֐ : ReadOption
// @ : IvV̓ǂݍ
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure ReadOption();
var
  OptionIni : TIniFile;
  strPath   :string;
begin

  OptionIni      := TIniFile.Create(AppPath(FILE_OPTIONINI));

  // Main
  gBoardListUrl  := OptionIni.ReadString(SEC_MAIN, KEY_BOARDLISTURL, 'http://www6.ocn.ne.jp/~mirv/2chmenu.html');
  gViewLimit     := OptionIni.ReadInteger(SEC_MAIN, KEY_VIEWLIMIT, 50);

  // Proxy
  gWriteProxyUse := OptionIni.ReadBool(  SEC_PROXY, KEY_WRITEPROXYUSE, false);
  gWriteProxy    := OptionIni.ReadString(SEC_PROXY, KEY_WRITEPROXY,    '');
  gReadProxyUse  := OptionIni.ReadBool(  SEC_PROXY, KEY_READPROXYUSE,  false);
  gReadProxy     := OptionIni.ReadString(SEC_PROXY, KEY_READPROXY,     '');

  // MainForm Layout
  gMainFormWindowState := OptionIni.ReadInteger(SEC_MAINFORM,      KEY_WINDOWSTATE, Integer(wsNormal));
  gMainFormWidth       := OptionIni.ReadInteger(SEC_MAINFORM,      KEY_WIDTH,  600);
  gMainFormHeight      := OptionIni.ReadInteger(SEC_MAINFORM,      KEY_HEIGHT, 500);
  gBoardListBoxWidth   := OptionIni.ReadInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,  120);
  gTopicListViewWidth  := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,  300);
  gTopicListViewHeight := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT, 100);

  // wb_pHTML
  strPath := AppPath(FILE_HEADERHTML);
  if FileExists(strPath) = true then
    gHeaderHtml := GetFile(strPath)
  else
    gHeaderHtml := '<html><body><font face="lr oSVbN"><dl>';

  // X\pHTML
  strPath := AppPath(FILE_RESHTML);
  if FileExists(strPath) = true then
    gResHtml := GetFile(strPath)
  else
    gResHtml := '<dt>&NUMBER OF<font color="forestgreen">&MAILNAME</font> eF&DATE<dd>&MESSAGE<br><br>';

  // VX\pHTML
  strPath := AppPath(FILE_NEWRESHTML);
  if FileExists(strPath) = true then
    gNewResHtml := GetFile(strPath)
  else
    gNewResHtml := '<dt><b>&NUMBER</b> OF<font color="forestgreen">&MAILNAME</font> eF&DATE<dd>&MESSAGE<br><br>';

end;

// -----------------------------------------------------
// ֐ : WriteOption
// @ : IvV̕ۑ
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure WriteOption();
var
  OptionIni : TIniFile;
begin

  OptionIni := TIniFile.Create(AppPath(FILE_OPTIONINI));

  // Main
  OptionIni.WriteString(SEC_MAIN, KEY_USERAGENT, gBoardListUrl);
  OptionIni.WriteInteger(SEC_MAIN, KEY_VIEWLIMIT, gViewLimit);

  // Proxy
  OptionIni.WriteBool(  SEC_PROXY, KEY_WRITEPROXYUSE, gWriteProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_WRITEPROXY,    gWriteProxy);
  OptionIni.WriteBool(  SEC_PROXY, KEY_READPROXYUSE,  gReadProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_READPROXY,     gReadProxy);

  // MainForm Layout
  OptionIni.WriteInteger(SEC_MAINFORM,      KEY_WINDOWSTATE,  gMainFormWindowState);
  OptionIni.WriteInteger(SEC_MAINFORM,      KEY_WIDTH,        gMainFormWidth);
  OptionIni.WriteInteger(SEC_MAINFORM,      KEY_HEIGHT,       gMainFormHeight);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,        gBoardListBoxWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,        gTopicListViewWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT,       gTopicListViewHeight);


end;


end.
