unit untStreamTool;

interface

uses
  Classes;

type

  TStreamReader = class
  private
    FStream : TStream;
  public
    constructor Create(Target : TStream);
    function ReadLine(var BufferString : string): Boolean;
    function Read(var Buff : Char): Boolean;
    function ReadToEnd : string;
  end;

implementation

{ TStreamReader }

constructor TStreamReader.Create(Target: TStream);
begin
  FStream := Target;
end;

function TStreamReader.Read(var Buff: Char): Boolean;
var
  intSize : Integer;
begin

  intSize := FStream.Read(Buff, 1);
  if intSize = 1 then
    result := true
  else
    result := false;

end;

function TStreamReader.ReadLine(var BufferString : string): Boolean;
var
  Buffer     : Char;
  LastBuffer : Char;
  intSize    : Integer;
  line       : string;
begin

  LastBuffer := #0;

  // s܂œǂݍ
  while true do
  begin
    intSize := FStream.Read(Buffer, 1);
    if intSize = 0 then
      if line <> '' then
        break
      else
      begin
        result       := false;
        BufferString := '';
        exit;
      end;

    if Buffer = #10 then
    begin

      if LastBuffer = #13 then LastBuffer := #0;
      break;
    end else
    begin
      if LastBuffer <> #0 then Line := Line + LastBuffer;
      LastBuffer := Buffer;
    end;
  end;
  if LastBuffer <> #0 then Line := Line + LastBuffer;
  
  // lԂ
  result       := true;
  BufferString := line;

end;


function TStreamReader.ReadToEnd: string;
var
  Buffer  : Array[1..255] of Char;
  intSize : Integer;
  str     : string;
begin

  //str := TStringStream.Create('');
  while true do
  begin
    intSize := FStream.Read(Buffer, SizeOf(Buffer));
    if intSize = 0 then break;

    str := str + Copy(Buffer, 1, intSize);
  end;

  result := str;
  //str.Free;

end;

end.
