unit untToolTipForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TToolTipForm = class(TForm)
    ToolTipLabel: TLabel;
    TopShape: TShape;
    LeftShape: TShape;
    BottomShape: TShape;
    RightShape: TShape;
  private
    { Private 錾 }
    FHintText : string;
  public
    { Public 錾 }
    procedure SetHint(HintText : string);
    procedure UnVisible();
  end;

var
  ToolTipForm: TToolTipForm;

implementation

{$R *.dfm}

procedure TToolTipForm.SetHint(HintText: string);
var
  MousePos : TPoint;
begin
  FHintText := HintText;

  ToolTipLabel.Left := 3;
  ToolTipLabel.Top  := 3;
  ToolTipLabel.Caption := HintText;

  GetCursorPos(MousePos);
  self.Width  := ToolTipLabel.Width  + 6;
  self.Height := ToolTipLabel.Height + 6;
  self.Left   := MousePos.X;
  self.Top    := MousePos.Y - self.Height - 3;

  TopShape.Left      := 0;
  TopShape.Top       := 0;
  TopShape.Width     := self.Width;
  TopShape.Height    := 1;

  LeftShape.Left     := 0;
  LeftShape.Top      := 0;
  LeftShape.Width    := 1;
  LeftShape.Height   := self.Height;

  BottomShape.Left   := 0;
  BottomShape.Top    := self.Height - 1;
  BottomShape.Width  := self.Width;
  BottomShape.Height := 1;

  RightShape.Left    := self.Width - 1;
  RightShape.Top     := 0;
  RightShape.Width   := 1;
  RightShape.Height  := self.Height;

end;

procedure TToolTipForm.UnVisible;
begin

  self.Top    := - 500;
  self.Left   := - 500;
  self.Width  := 0;
  self.Height := 0;

end;

end.
