unit untTopic;

interface

uses
  SysUtils, Classes, Contnrs, Dialogs, Forms, DzURL,
  untTool, untHttpClient, untOption, SyncObjs, untStreamTool;

type

  TTopicMessage = class
  private
    FIsNewMessage: Boolean;
    FIndex: Integer;
    FBody: string;
    FRestStr: string;
    FPostemail: string;
    FPostName: string;
    procedure SetBody(const Value: string);
    procedure SetIndex(const Value: Integer);
    procedure SetIsNewMessage(const Value: Boolean);
    procedure SetPostemail(const Value: string);
    procedure SetPostName(const Value: string);
    procedure SetRestStr(const Value: string);
    function GetForPopup() : string; 
  public
    property Index        : Integer read FIndex write SetIndex;
    property Body         : string  read FBody write SetBody;
    property PostName     : string  read FPostName write SetPostName;
		property Postemail    : string  read FPostemail write SetPostemail;
    property RestStr      : string  read FRestStr write SetRestStr;
    property IsNewMessage : Boolean read FIsNewMessage write SetIsNewMessage;
    property ForPopup     : string  read GetForPopup;
  end;

	TMessageReceivedEvent = procedure(sender : TObject; msg : TTopicMessage) of object;
  TDownloadState = (dsNone, dsStarting, dsProcessing, dsDatLoaded, dsError, dsFreezed);
  TWriteDoneEvent = procedure(sender : TObject; ErrorMessage : string) of object;

  TTopic = class
  private
    FOnWriteDone: TWriteDoneEvent;
    FIsDownloadingTopic: Boolean;
    FCritSec        : TCriticalSection;
    FNoFirstLine    : Boolean;
    FBoardListId    : Integer;
    FDownloading    : Boolean;
    FTopicId: string;
    FIsNoNotice: Boolean;
    FNewMessageCount: Integer;
    FIndex: Integer;
    FDatSize: Integer;
    FMessageCount: Integer;
    FScrollPosition: Integer;
    FGotMessageCount: Integer;
    FBoardServerId: string;
    FBoardName: string;
    FTopicPath: string;
    FTitle: string;
    FBoardServer: string;
    FWroteName: string;
    FBoardPath: string;
    FBoardId: string;
    FWroteEmail: string;
    FBoard: TObject;
    FLocalDir: string;
    FIsFavorite: boolean;
    FIsGotLog: boolean;
    FIsFreezed: boolean;
    FPriority: Integer;
    FMemo: string;
    FOnMessageReceived: TMessageReceivedEvent;
    FOnUpdateState: TNotifyEvent;
    FNoNotice: Boolean;
    FMessageList : TObjectList;
    FIsError: Boolean;
    FStatusText: string;
    FOnUpdate: TNotifyEvent;
    FIsLoadedLocalDat: Boolean;
    FLastModified: string;
    FNewReceivedMessage: TTopicMessage;
    FDownloadState: TDownloadState;
    FWriteError: string;
    FIsPosingArticle: Boolean;
    procedure SetTopicId(const Value: string);
    procedure SetBoard(const Value: TObject);
    procedure SetBoardId(const Value: string);
    procedure SetBoardName(const Value: string);
    procedure SetBoardPath(const Value: string);
    procedure SetBoardServer(const Value: string);
    procedure SetBoardServerId(const Value: string);
    procedure SetDatSize(const Value: Integer);
    procedure SetGotMessageCount(const Value: Integer);
    procedure SetIndex(const Value: Integer);
    procedure SetIsNoNotice(const Value: Boolean);
    procedure SetMessageCount(const Value: Integer);
    procedure SetNewMessageCount(const Value: Integer);
    procedure SetScrollPosition(const Value: Integer);
    procedure SetTitle(const Value: string);
    procedure SetTopicPath(const Value: string);
    procedure SetWroteEmail(const Value: string);
    procedure SetWroteName(const Value: string);
    procedure UpdateBoardInfo();
    procedure SetLocalDir(const Value: string);
    procedure SetIsFavorite(const Value: boolean);
    procedure SetIsFreezed(const Value: boolean);
    procedure SetIsGotLog(const Value: boolean);
    procedure SetPriority(const Value: Integer);
    procedure SetMemo(const Value: string);
    procedure SetOnUpdateState(const Value: TNotifyEvent);
    procedure SetOnMessageReceived(const Value: TMessageReceivedEvent);
    procedure SetNoNotice(const Value: Boolean);
    procedure SetError(errortext : string);
    procedure SetIsError(const Value: Boolean);
    procedure SetStatusText(const Value: string);
    function GetDatUrl: string;
    function GetBrowserUrl: string;
    procedure SetOnUpdate(const Value: TNotifyEvent);
    procedure SetOnWriteDone(const Value: TWriteDoneEvent);
    procedure SetIsDownloadingTopic(const Value: Boolean);
    procedure SetIsLoadedLocalDat(const Value: Boolean);
    procedure SetLastModified(const Value: string);
    procedure SetNewReceivedMessage(const Value: TTopicMessage);
    procedure SetDownloadState(const Value: TDownloadState);
    procedure SetWriteError(const Value: string);
    procedure SetIsPosingArticle(const Value: Boolean);
  public
    property TopicId         : string       read FTopicId         write SetTopicId;
    property TopicPath       : string       read FTopicPath       write SetTopicPath;
    property Title           : string       read FTitle           write SetTitle;
    property MessageCount    : Integer      read FMessageCount    write SetMessageCount;
    property Index           : Integer      read FIndex           write SetIndex;
    property Board           : TObject      read FBoard           write SetBoard;
    property BoardPath       : string       read FBoardPath       write SetBoardPath;
    property BoardServerId   : string       read FBoardServerId   write SetBoardServerId;
    property BoardId         : string       read FBoardId         write SetBoardId;
    property BoardServer     : string       read FBoardServer     write SetBoardServer;
    property BoardName       : string       read FBoardName       write SetBoardName;
    property IsNoNotice      : Boolean      read FIsNoNotice      write SetIsNoNotice;
    property GotMessageCount : Integer      read FGotMessageCount write SetGotMessageCount;
    property NewMessageCount : Integer      read FNewMessageCount write SetNewMessageCount;
    property WroteName       : string       read FWroteName       write SetWroteName;
    property WroteEmail      : string       read FWroteEmail      write SetWroteEmail;
    property DatSize         : Integer      read FDatSize         write SetDatSize;
    property ScrollPosition  : Integer      read FScrollPosition  write SetScrollPosition;
    property LocalDir        : string       read FLocalDir        write SetLocalDir;
    property IsFreezed       : boolean      read FIsFreezed       write SetIsFreezed;
    property IsGotLog        : boolean      read FIsGotLog        write SetIsGotLog;
    property IsFavorite      : boolean      read FIsFavorite      write SetIsFavorite;
    property Priority        : Integer      read FPriority        write SetPriority;
    property Memo            : string       read FMemo            write SetMemo;
    property NoNotice        : Boolean read FNoNotice write SetNoNotice;
    property IsError         : Boolean read FIsError write SetIsError;
    property StatusText      : string read FStatusText write SetStatusText;
    property DatUrl          : string read GetDatUrl;
    property BrowserUrl      : string read GetBrowserUrl;
    property DownloadState   : TDownloadState read FDownloadState write SetDownloadState;
    property OnMessageReceived : TMessageReceivedEvent read FOnMessageReceived write SetOnMessageReceived;
    property OnUpdateState     : TNotifyEvent read FOnUpdateState write SetOnUpdateState;
    property OnUpdate         :  TNotifyEvent read FOnUpdate write SetOnUpdate;
    property OnWriteDone      : TWriteDoneEvent read FOnWriteDone write SetOnWriteDone;
    property MessageList     : TObjectList read FMessageList;
    property IsDownloadingTopic : Boolean read FIsDownloadingTopic write SetIsDownloadingTopic;
    property IsPosingArticle : Boolean read FIsPosingArticle write SetIsPosingArticle;
    property IsLoadedLocalDat : Boolean read FIsLoadedLocalDat write SetIsLoadedLocalDat;
    property LastModified : string read FLastModified write SetLastModified;
    property NewReceivedMessage : TTopicMessage read FNewReceivedMessage write SetNewReceivedMessage;
    property WriteError : string read FWriteError write SetWriteError;
    constructor Create(topicpath : string);
    destructor  Destroy(); override;
    procedure SaveIdx();
    procedure Lock;
    procedure Unlock;
  end;

implementation

uses
  untBoard, untGlobal;

{ TTopicMessage }

//  vpeB 

// |bvAbvp̃bZ[W
function TTopicMessage.GetForPopup: string;
var
  puretext : string;
begin

  puretext := IntToStr(FIndex)       + ' ' +
              'OF'   + FPostName + ' ' +
              'eF' + FRestStr  + #10 +
              FBody;

  // HTML^O
	puretext := StringReplace(puretext, '<br>', #10, [rfReplaceAll]);
  result := puretext;

end;

procedure TTopicMessage.SetBody(const Value: string);
begin
  FBody := Value;
end;

procedure TTopicMessage.SetIndex(const Value: Integer);
begin
  FIndex := Value;
end;

procedure TTopicMessage.SetIsNewMessage(const Value: Boolean);
begin
  FIsNewMessage := Value;
end;

procedure TTopicMessage.SetPostemail(const Value: string);
begin
  FPostemail := Value;
end;

procedure TTopicMessage.SetPostName(const Value: string);
begin
  FPostName := Value;
end;

procedure TTopicMessage.SetRestStr(const Value: string);
begin
  FRestStr := Value;
end;

{ TTopic }

//  vpeB 


procedure TTopic.SetOnWriteDone(const Value: TWriteDoneEvent);
begin
  FOnWriteDone := Value;
end;

procedure TTopic.SetBoard(const Value: TObject);
begin
  FBoard := Value;
end;

procedure TTopic.SetBoardId(const Value: string);
begin
  FBoardId := Value;
end;

procedure TTopic.SetBoardName(const Value: string);
begin
  FBoardName := Value;
end;

procedure TTopic.SetBoardPath(const Value: string);
begin
  FBoardPath := Value;
end;

procedure TTopic.SetBoardServer(const Value: string);
begin
  FBoardServer := Value;
end;

procedure TTopic.SetIsPosingArticle(const Value: Boolean);
begin
  FIsPosingArticle := Value;
end;

procedure TTopic.SetLastModified(const Value: string);
begin
  FLastModified := Value;
end;

procedure TTopic.SetNewReceivedMessage(const Value: TTopicMessage);
begin
  FNewReceivedMessage := Value;
end;

procedure TTopic.SetIsLoadedLocalDat(const Value: Boolean);
begin
  FIsLoadedLocalDat := Value;
end;

procedure TTopic.SetIsDownloadingTopic(const Value: Boolean);
begin
  FIsDownloadingTopic := Value;
end;

procedure TTopic.SetBoardServerId(const Value: string);
begin
  FBoardServerId := Value;
end;

procedure TTopic.SetDatSize(const Value: Integer);
begin
  FDatSize := Value;
end;

procedure TTopic.SetStatusText(const Value : string);
begin
  FStatusText := Value;
end;


procedure TTopic.SetDownloadState(const Value: TDownloadState);
begin
  FDownloadState := Value;
end;


procedure TTopic.SetGotMessageCount(const Value: Integer);
begin
  FGotMessageCount := Value;
end;

procedure TTopic.SetIndex(const Value: Integer);
begin
  FIndex := Value;
end;

procedure TTopic.SetIsNoNotice(const Value: Boolean);
begin
  FIsNoNotice := Value;
end;

procedure TTopic.SetMessageCount(const Value: Integer);
begin
  FMessageCount := Value;
end;

procedure TTopic.SetNewMessageCount(const Value: Integer);
begin
  FNewMessageCount := Value;
end;

procedure TTopic.SetScrollPosition(const Value: Integer);
begin
  FScrollPosition := Value;
end;

procedure TTopic.SetTitle(const Value: string);
begin
  FTitle := Value;
end;

procedure TTopic.SetTopicId(const Value: string);
begin
  FTopicId := Value;
end;

procedure TTopic.SetTopicPath(const Value: string);
begin
  FTopicPath := Value;
end;

procedure TTopic.SetWroteEmail(const Value: string);
begin
  FWroteEmail := Value;
end;

procedure TTopic.SetWroteName(const Value: string);
begin
  FWroteName := Value;
end;

procedure TTopic.SetLocalDir(const Value: string);
begin
  FLocalDir := Value;
end;

procedure TTopic.SetIsFavorite(const Value: boolean);
begin
  FIsFavorite := Value;
end;

procedure TTopic.SetIsFreezed(const Value: boolean);
begin
  FIsFreezed := Value;
end;

procedure TTopic.SetIsGotLog(const Value: boolean);
begin
  FIsGotLog := Value;
end;

procedure TTopic.SetPriority(const Value: Integer);
begin
  FPriority := Value;
end;

procedure TTopic.SetMemo(const Value: string);
begin
  FMemo := Value;
end;

procedure TTopic.SetOnUpdateState(const Value: TNotifyEvent);
begin
  FOnUpdateState := Value;
end;

procedure TTopic.SetOnMessageReceived(const Value: TMessageReceivedEvent);
begin
  FOnMessageReceived := Value;
end;

procedure TTopic.SetNoNotice(const Value: Boolean);
begin
  FNoNotice := Value;
end;

procedure TTopic.SetIsError(const Value: Boolean);
begin
  FIsError := Value;
end;

procedure TTopic.SetWriteError(const Value: string);
begin
  FWriteError := Value;
end;

function TTopic.GetDatUrl: string;
begin
  UpdateBoardInfo();
	result := 'http://' + FBoardServer + '/' +
            FBoardId  +	'/dat/' + FTopicId + '.dat';
end;

function TTopic.GetBrowserUrl : string;
begin
  UpdateBoardInfo();
	result := 'http://' + FBoardServer + '/test/read.cgi/'  +
            FBoardId  + '/' + FTopicId + '/';
end;

procedure TTopic.SetOnUpdate(const Value: TNotifyEvent);
begin
  FOnUpdate := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : topicpath
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopic.Create(topicpath : string);
var
  parse        : TStringArray;
  idxpath      : string;
  idxlines     : TStringList;
  idxitems     : TStringArray;
  state        : Integer;
  topictoppath : string;
begin

    FCritSec := TCriticalSection.Create;
    FCritSec.Enter;

    parse := Split(topicpath, '/');
    FTopicPath     := topicpath;
    FBoardServerId := parse[0];
    FBoardId       := parse[1];
    FTopicId       := parse[2];
    FBoardPath := FBoardServerId + '/' + FBoardId;

    if Length(FTopicId) > 5 then
      topictoppath := Copy(FTopicId, 1, 4)
    else
      topictoppath := FTopicId;
    FLocalDir  := AppPath('Log\' + FBoardServerId + '\' + FBoardId + '\' + topictoppath + '\');

		UpdateBoardInfo();

		// tH_Ȃ΍
    if DirectoryExists(FLocalDir) = false then
      CreateFullDir(localdir);

  	// IDX t@CΓǂݍ
		idxpath := localdir + FTopicId + '.idx';
  	if FileExists(idxpath) then
    begin
      idxlines := TStringList.Create();
      idxlines.LoadFromFile(idxpath);
      if idxlines.Count > 0 then
      begin
        idxitems := Split(idxlines[0], #9);
        if Length(idxitems) >= 18 then
        begin

          state := StrToInt(idxitems[1]);
          FIsFreezed       := Boolean(state and 16);
          FIsGotLog        := Boolean(state and 32);
          FIsFavorite      := Boolean(state and 64);

          FPriority        := StrToInt(idxitems[2]);
          FTitle           := idxitems[3];
          FMessageCount    := StrToInt(idxitems[7]);
          FGotMessageCount := StrToInt(idxitems[8]);
          FNewMessageCount := StrToInt(idxitems[9]);
          FBoardName       := idxitems[12];
          FDatSize         := StrToInt(idxitems[13]);
          FWroteName       := idxitems[14];
          FWroteEmail      := idxitems[15];
          FScrollPosition  := StrToInt(idxitems[16]);
          FMemo            := idxitems[17];
        end;

        if Length(idxitems) >= 21 then
        begin
          FLastModified    := idxitems[21];
        end;

      end;
      idxlines.Free;
    end;

    FMessageList := TObjectList.Create;

    FCritSec.Leave;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopic.Destroy;
var
  I       : Integer;
  MsgList : TList;
begin

  FMessageList.Free;
  FCritSec.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: Lock
  pr  : bN
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.Lock;
begin
  FCritSec.Enter;
end;

{ --------------------------------------------------------
  ֐: Unlock
  pr  : AbN
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.Unlock;
begin
  FCritSec.Leave;
end;

{ --------------------------------------------------------
  ֐: SaveIdx
  pr  : Idxt@C̋L^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.SaveIdx;
var
  line    : string;
  state   : Integer;
  idxpath : string;
begin

  state := 0;
  if(FIsFreezed)  then state := state or 16;
  if(FIsGotLog)   then state := state or 32;
	if(FIsFavorite) then state := state or 64;
			
  line := '88' + #9 +
          IntToStr(state) + #9 +
					IntToStr(FPriority) + #9 +
					FTitle + #9 +
          FBoardServer + #9 +
					FBoardId + #9 +
				  FTopicId + #9 +
					IntToStr(FMessageCount) + #9 +
					IntToStr(FGotMessageCount) + #9 +
					IntToStr(FNewMessageCount) + #9 +
					'' + #9 +
					'' + #9	+
					FBoardName + #9 +
					IntToStr(FDatsize) + #9 +
					FWroteName + #9 +
					FWroteEmail + #9 +
					IntToStr(FScrollPosition) + #9 +
					FMemo + #9 +
          #9 +
          #9 +
          #9 +
          FLastModified + #9;

  // ۑ
  idxpath := FLocalDir + FTopicId + '.idx';
  WriteFile(idxpath, line);

end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: UpdateBoardInfo
  pr  : {[h̍XV
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.UpdateBoardInfo;
var
  Board : TOnlineBoard;
begin

  if gBoardList.BoardListId <> FBoardListId then
  begin

    FBoardListId := gBoardList.BoardListId;
		board := TOnlineBoard(gBoardList.GetBoardByPath(FBoardPath));
  	if board <> nil then
    begin
      FBoardServer := board.Server;
			FBoardName   := board.DisplayName;		
			FBoard       := board;
    end else
    begin
			FBoardName   := '';
			FBoard       := nil;
    end;
  end;

end;


{ --------------------------------------------------------
  ֐: SetError
  pr  : G[
    : errortext - G[bZ[W
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.SetError(errortext: string);
begin
  FIsError       := true;
	FStatusText    := errortext;
  FDownloadState := dsError;
end;


end.
