unit untTopicBrowser;

interface

uses
  Classes, ComCtrls, Controls, OleCtrls, SHDocVw_TLB, MSHTML_TLB,
  untTopic, untHttp, SysUtils, untGlobal, untOption, Forms, untToolTipForm,
  untTool, ExtCtrls, windows, untBBSCore;

type

  TTopicBrowser = class(TTabSheet)
  private
    FViewLimit      : Integer;
    FReloadTimer    : TTimer;
    FLogLoadedCount : Integer;
    FBrowser        : TWebBrowser;
    FTopic          : TTopic;
    FLogLoaded      : Boolean;
    FNewMsg         : Boolean;
    FWaitInitialize : Boolean;
    FAutoReload: Boolean;
    FDownloading    : Boolean;
    procedure BrowserInitialize();
    procedure SaveScrollPosition();
    procedure SetTopic(const Value: TTopic);
    procedure Browser_NavigateComplete2(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant);
    procedure Browser_StatusTextChange(Sender: TObject; const Text: WideString);
    procedure Topic_MessageReceived(sender : TObject; msg : TTopicMessage);
    procedure Topic_UpdateState(sender : TObject);
    procedure BrowserOutput(output : string);
    procedure SetAutoReload(const Value: Boolean);
    procedure AutoReloadTimer(sender : TObject);
    procedure TopicStateChange(Topic : TTopic; EventType : TTopicStateType);
  public
    property Topic : TTopic read FTopic write SetTopic;
    property AutoReload : Boolean read FAutoReload write SetAutoReload;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure   OpenTopic(Topic : TTopic);
    procedure   CloseTopic();
    procedure   Download();
    procedure   ClearNewMsg();
    procedure   SearchText(str : string);
  end;

implementation

{ TopicBrowser }

//  vpeB 

procedure TTopicBrowser.SetTopic(const Value: TTopic);
begin
  FTopic := Value;
end;

// I[g[hݒ
procedure TTopicBrowser.SetAutoReload(const Value: Boolean);
begin
  FAutoReload := Value;
  FReloadTimer.Enabled := Value;
  Topic_UpdateState(FTopic);
end;


//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : AOwner
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopicBrowser.Create(AOwner: TComponent);
var
  proc : TTopicStateChangeEvent; 
begin
  inherited Create(AOwner);

  proc := TopicStateChange;
  gBBSCore.AddTopicStateChangeEvent(proc);

  ImageIndex := -1;
  FTopic := nil;
  FReloadTimer := TTimer.Create(self);
  FReloadTimer.Enabled  := false;
  FReloadTimer.Interval := 60000;
  FReloadTimer.OnTimer  := AutoReloadTimer;

  // uEU̐
  FBrowser := TWebBrowser.Create(self);
  TWinControl(FBrowser).Parent := self;
  FBrowser.Align   := alClient;
  FBrowser.Visible := true;
  FBrowser.OnNavigateComplete2 := Browser_NavigateComplete2;
  FBrowser.OnStatusTextChange  := Browser_StatusTextChange;

  // uEȔ
  BrowserInitialize();
end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopicBrowser.Destroy;
begin
  FBrowser.Free;
  FReloadTimer.Free;

  inherited Destroy;
end;

{ --------------------------------------------------------
  ֐: OpenTopic
  pr  : gsbNJ
    : Topic
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.OpenTopic(Topic: TTopic);
begin

  if FTopic <> nil then CloseTopic();

  FTopic := Topic;
  if FTopic <> nil then
  begin
    FTopic.OnMessageReceived := Topic_MessageReceived;
    FTopic.OnUpdateState     := Topic_UpdateState;
    self.Text := FTopic.Title;
  end else
    self.Text := '';

  FViewLimit := gViewLimit;

end;

{ --------------------------------------------------------
  ֐: CloseTopic
  pr  : gsbN
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.CloseTopic;
begin

  if FTopic <> nil then
  begin
    FTopic.OnMessageReceived := nil;
    FTopic.OnUpdateState     := nil;

    SaveScrollPosition();
  end;

  SetAutoReload(false);
  FTopic     := nil;
  self.Text  := '';
  ImageIndex := -1;
  FLogLoaded := false;
  BrowserInitialize();

end;

{ --------------------------------------------------------
  ֐: Download
  pr  : gsbN̎M
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.Download;
begin

  if FTopic <> nil then
  begin
    if FLogLoaded = false then FTopic.NoNotice := true;
    FNewMsg := false;
    gBBSCore.DownloadTopic(FTopic);
  end;

end;

{ --------------------------------------------------------
  ֐: ClearNewMsg
  pr  : V}[N̎O
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.ClearNewMsg;
begin
  FNewMsg := false;
  Topic_UpdateState(FTopic);
end;


//  Cxg 

// uEȔ
procedure TTopicBrowser.Browser_NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin

  if FWaitInitialize = true then
  begin
    BrowserOutput(gHeaderHtml);
		FWaitInitialize := false;
  end;

end;

// Xe[^Xo[̕ω
procedure TTopicBrowser.Browser_StatusTextChange(Sender: TObject;
  const Text: WideString);
var
  Text2    : string;
  intPos   : Integer;
  intPopup : Integer;
  msg      : TTopicMessage;
begin

  Text2 := Text;

  if Text2 = '' then
    ToolTipForm.UnVisible()
  else if Copy(Text2, 1, 7) = 'mailto:' then
  begin
    ToolTipForm.SetHint(CopyAfter(string(Text2), 8));
    exit;
  end else
  if Copy(Text2, 1, 11) = 'about:blank' then
  begin
    intPos   := LastDelimiter('/', Text2);
    intPopup := StrToIntNeo(CopyAfter(Text2, intPos + 1));
    intPopup := intPopup - 1;
    if (intPopup >= 0) and (intPopup < FTopic.MessageList.Count) then
    begin
      msg := TTopicMessage(FTopic.MessageList[intPopup]);
      ToolTipForm.SetHint(msg.ForPopup);
      exit;
    end;
  end;

  ToolTipForm.UnVisible();

end;

// bZ[WM
procedure TTopicBrowser.Topic_MessageReceived(sender: TObject;
  msg: TTopicMessage);
var
  outputhtml : string;
  mailname   : string;
  output     : string;
begin

  FDownloading:= true;

  FLogLoaded := true;
  
	if msg.IsNewMessage = false then
  begin
	  Inc(FLogLoadedCount);
    if msg.Index > 1 then
      if FViewLimit > 0 then
        if FTopic.GotMessageCount - FLogLoadedCount > FViewLimit then
          exit;

    outputhtml := gResHtml;
  end else
  begin
	  outputhtml := gNewResHtml;
		FNewMsg    := true;
  end;
  msg.IsNewMessage := false;

  if msg.PostEmail  <> '' then
  begin
    mailname := '<A HREF="mailto:' + msg.PostEmail+ '">' +
                msg.PostName + '</A>';
  end else
	  mailname := msg.PostName;

  outputhtml := StringReplace(outputhtml, '&MAILNAME', mailname, [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&NUMBER',   IntToStr(msg.Index), [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&DATE',     msg.RestStr, [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&MESSAGE',  msg.Body, [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&PLAINNUMBER',IntToStr(msg.Index), [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&MAIL', msg.Postemail, [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&NAME', msg.PostName, [rfReplaceAll]);

	//this.ImageIndex = 4;

  // 
  output := '<a name="a"' + IntToStr(msg.Index) + '"></a>' + outputhtml + #13#10;
  BrowserOutput(output);
end;

// ԕω
procedure TTopicBrowser.TopicStateChange(Topic: TTopic;
  EventType: TTopicStateType);
begin
  if Topic <> FTopic then exit;

  if EventType = stMessageReceived then
    Topic_MessageReceived(Topic, Topic.NewReceivedMessage)
  else if EventType = stDownloadState then
    Topic_UpdateState(Topic);
    
end;


procedure TTopicBrowser.Topic_UpdateState(sender: TObject);
var
  body : OleVariant;
  scrollheight : Integer;
  top          : Integer;
begin

  Case FTopic.DownloadState of
    dsNone:
    begin

      if FNewMsg = true then
        ImageIndex := 6
      else if FAutoReload = true then
        ImageIndex := 9
      else
        ImageIndex := -1;

      if FDownloading = true then
      begin
        FDownloading := false;

        // vOANeBułȂ
        // ^Cgo[_ł
        if Application.Active  = false then
        begin
          FlashWindow(Application.Handle, True);
        end;
      end;

    end;
    dsError:      ImageIndex := 7;
    dsFreezed:    ImageIndex := 8;
    dsStarting:   ImageIndex := 0;
    dsProcessing: ImageIndex := 1;
    dsDatLoaded:
    begin

      // XN[
      body := (FBrowser.Document as IHTMLDocument2).body;
      //if body <> nil then
      //begin
			  scrollheight := body.scrollHeight;
        top := scrollheight  -  FTopic.ScrollPosition;
        body.scrollTop := top;
      //end;

    end;
  end;

end;

// I[g[h
procedure TTopicBrowser.AutoReloadTimer(sender: TObject);
begin
  if FNewMsg = false then
    Download;
end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: BrowserInitialize
  pr  : uEȔ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.BrowserInitialize();
var
  I : Integer;
begin

  FWaitInitialize := true;
  FBrowser.Navigate('about:blank');

  // o܂ő҂
  for I := 0 to 100 do
    if FWaitInitialize = false then
      break
    else
      Application.ProcessMessages;

end;

{ --------------------------------------------------------
  ֐: SaveScrollPosition
  pr  : XN[ʒu̕ۑ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.SaveScrollPosition;
var
  body : Variant;
  top  : Integer;
  scrollheight : Integer;
  lastspace    : Integer;
begin

  body := (FBrowser.Document as IHTMLDocument2).body;
    top          := body.scrollTop;
    scrollheight := body.scrollHeight;
    //offsetheight := body.offsetHeight;
    lastspace    := scrollheight  -  top;
    FTopic.ScrollPosition := lastspace;
		FTopic.SaveIdx();

end;

{ --------------------------------------------------------
  ֐: BrowserOutput
  pr  : uEU֏o
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.BrowserOutput(output: string);
begin

  OleVariant(FBrowser.Document as IHTMLDocument2).write(output);

  Application.ProcessMessages;

end;

{ --------------------------------------------------------
  ֐: SearchText
  pr  : 
    : str - 
  ߂l: Ȃ
  l  : http://hogehoge2001.tripod.co.jp/note-delphi.htmlq؁B
  ------------------------------------------------------ }
procedure TTopicBrowser.SearchText(str: string);
var
  textRange: OleVariant;
  b        : Boolean;
  txt      : String;
  forwardP : boolean;
begin

  forwardP := true;

  (* ݂̃ZNVT *)
  textRange := OleVariant(fbrowser.Document as IHTMLDocument2).selection;
  textRange := textRange.createRange();
  textRange.select();
  if forwardP then
  begin  (* O *)
    textRange.moveStart('character');
    textRange.moveEnd('textedit');
    b := textRange.findText(str, 1);
  end
  else begin (* 납*)
    txt := textRange.text;
    if length(txt) <= 0 then
      textRange := OleVariant(FBrowser.Document as IHTMLDocument2).body.createTextRange;
    textRange.moveEnd('word', -1);
    b := textRange.findText(str, -1);
  end;
  (* [ጩĂ` *)
  if b then
  begin
    textRange.select();
    OleVariant(Fbrowser.Document as IHTMLDocument2).body.scrollTop
      := OleVariant(FBrowser.Document as IHTMLDocument2).body.scrollTop
       + textRange.offsetTop - FBrowser.Height div 2;
  end;
end;

end.
