unit untTopicDownloadThread;

interface

uses
  Classes, SysUtils, Dialogs,
  untHttpClient, untStreamTool, untTool,
  untBBSCore, untTopic, untGlobal, untOption;

type
  TTopicDownloadThread = class(TThread)
  private
    { Private 錾 }
    FParent         : TTopic;
    FNoDownload     : Boolean;
    FTopicStateType : TTopicStateType;
    FDatFile        : TextFile;
    procedure LoadLog;
    function ParseMsg(line: string; msgnumber: Integer;
      newmsg: Boolean): TTopicMessage;
  public
    procedure   Execute; override;
    constructor Create(Parent: TTopic; NoDownload : Boolean);
    procedure   RaiseTopicStateChangeEvent;
  end;

implementation

{ TTopicDownloadThread }

constructor TTopicDownloadThread.Create(Parent: TTopic; NoDownload : Boolean);
begin
  inherited Create(true);

  FParent     := Parent;
  FNoDownload := NoDownload;
end;

procedure TTopicDownloadThread.Execute;
var
  logpath     : string;
  range       : integer;
  sr          : TStreamReader;
  Response    : THttpResponse;
  line        : string;
  firstchar   : char;
  msgcount    : integer;
  parse       : TTopicMessage;
  contentsize : integer;
  blnError    : boolean;
  HttpRequest : THttpRequest;
begin
  inherited;

  FParent.Lock;
  FParent.IsDownloadingTopic := true;

  // Oǂݍ
  LoadLog();

  if FNoDownload = false then
  begin

    FParent.DownloadState := dsStarting;
    FTopicStateType := stDownloadState;
    Synchronize(RaiseTopicStateChangeEvent);

    FParent.StatusText :=  'ڑł';
    FTopicStateType := stStatusText;
    Synchronize(RaiseTopicStateChangeEvent);

    // C^[lbgǂݍ
    HttpRequest := THttpRequest.Create(FParent.DatUrl);
    HttpRequest.UserAgent := APP_USERAGENT;
    HttpRequest.IfModifiedSince := FParent.LastModified;
    if FParent.DatSize > 0 then
      range := FParent.DatSize - 1
    else
      range := 0;
    HttpRequest.StartRange := range;
    Response := HttpRequest.GetResponse;

    FParent.DownloadState := dsProcessing;
    FTopicStateType := stDownloadState;
    Synchronize(RaiseTopicStateChangeEvent);

    FParent.StatusText := 'ڑ܂';
    FTopicStateType := stStatusText;
    Synchronize(RaiseTopicStateChangeEvent);

    if (Response.StatusCode >= 200) and
       (Response.StatusCode < 300) then
    begin

      // ݏ
      logpath := FParent.LocalDir + FParent.TopicId + '.dat';
      AssignFile(FDatFile, logpath);
      if FileExists(logpath) = false then ReWrite(FDatFile);
      Append(FDatFile);

      sr := TStreamReader.Create(Response.GetResponseStream);

      // O܂o
      if FParent.DatSize > 0 then
        if (sr.Read(firstchar) = false) or (firstchar <> #10) then
        begin
          blnError := true;
          FParent.StatusText := '폜ځ[ŃOl܂悤ł';
          FParent.IsError    := true;
          FTopicStateType := stStatusText;
          Synchronize(RaiseTopicStateChangeEvent);
          HttpRequest.Close();
        end;

      // ǂݏo
      while (blnError = false) and (sr.ReadLine(line)) do
      begin

        // 
        msgcount := FParent.MessageList.Count + 1;
        parse    := ParseMsg(line, msgcount, true);
        if parse = nil then
        begin
          blnError := true;
          FParent.StatusText := 'G[';
          FTopicStateType := stStatusText;
          Synchronize(RaiseTopicStateChangeEvent);
          break;
        end;

        // [Jɕۑ
        Write(FDatFile, line + #10);
      end;

      // t@C
      CloseFile(FDatFile);

      // DATTCYL^
      contentsize := Response.ContentLength;
      if contentsize > 0 then
      if FParent.DatSize = 0 then
        FParent.DatSize := contentsize
      else
        FParent.DatSize := FParent.DatSize + contentsize - 1;

      // Last-ModifiedL^
      FParent.LastModified := Response.LastModified;
    end;

    FParent.NewMessageCount := FParent.MessageList.Count - FParent.GotMessageCount;
    FParent.GotMessageCount := FParent.MessageList.Count;

    if blnError = false then
    begin
      FParent.DownloadState := dsNone;
      FTopicStateType := stDownloadState;
      Synchronize(RaiseTopicStateChangeEvent);

      if FParent.NewMessageCount = 0 then
        FParent.StatusText := 'VȂ'
      else
        FParent.StatusText := IntToStr(FParent.NewMessageCount) + '̃XM';
      FTopicStateType := stStatusText;
      Synchronize(RaiseTopicStateChangeEvent);
    end;

  end;

  FParent.SaveIdx();

  FParent.DownloadState := dsNone;
  FTopicStateType := stDownloadState;
  Synchronize(RaiseTopicStateChangeEvent);

  FParent.IsDownloadingTopic := false;
  FParent.Unlock;

  Terminate;
  Free;

end;

{ --------------------------------------------------------
  ֐: LoadLog
  pr  : O̓ǂݍ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicDownloadThread.LoadLog;
var
  localloaded : boolean;
  I           : Integer;
  msg         : TTopicMessage;
  msgcount    : Integer;
  logpath     : string;
  logvalue    : string;
  lines       : TStringArray;
  parse       : TTopicMessage;
begin

  if FParent.NoNotice = true then
  begin

    // Cxgs
    for I := 0 to FParent.MessageList.Count - 1 do
    begin
      msg := TTopicMessage(FParent.MessageList[I]);
      FParent.NewReceivedMessage := msg;
      FTopicStateType := stMessageReceived;
      Synchronize(RaiseTopicStateChangeEvent)
    end;
    FParent.NoNotice := false;
  end;
  msgcount := FParent.MessageList.Count;

  if FParent.IsLoadedLocalDat = false then
  begin

 	  // [Jǂݍ
    logpath  := FParent.LocalDir + FParent.TopicId + '.dat';
    logvalue := GetFile(logpath);
    lines    := Split(logvalue, #10);
    for I := 0 to Length(lines) - 1 do
    begin
    
      // p[X
      Inc(msgcount);
      parse := ParseMsg(lines[I], msgcount, false);
      if parse = nil then
      begin
        FParent.IsError := true;
        FParent.StatusText := 'G[';
        FTopicStateType := stStatusText;
        Synchronize(RaiseTopicStateChangeEvent);
        exit;
      end;
      localloaded := true;
    end;
    FParent.IsLoadedLocalDat := true;
  end;
	FParent.Gotmessagecount := FParent.MessageList.Count;

  if localloaded = true then
  begin
    FParent.DownloadState := dsDatLoaded;
    FTopicStateType := stDownloadState;
    Synchronize(RaiseTopicStateChangeEvent)
  end;

end;

{ --------------------------------------------------------
  ֐: ParseMsg
  pr  : bZ[Ws͂TTopicMessage𐶐
    : line
  @@@: msgnumber - bZ[WNo
  @@@: newmsg    - VbZ[W
  ߂l: TTopicMessage
  l  : Ȃ
  ------------------------------------------------------ }
function TTopicDownloadThread.ParseMsg(line: string; msgnumber: Integer;
  newmsg: Boolean): TTopicMessage;
var
  msg   : TTopicMessage;
  Items : TStringArray;
begin

  // TTopic̃bN͂̊֐̊Oōs

  // ACeɕ
  msg   := nil;
  Items := Split(line, ('<>'));
	if Length(Items) > 3 then
  begin

	  // bZ[WNX
    msg := TTopicMessage.Create();
    msg.Index        := msgnumber;
    msg.PostName     := '<B>' + Items[0] +  '</B>';
    msg.PostEmail    := Items[1];
   	msg.RestStr      := Items[2];
    msg.Body         := Items[3] ;
		msg.IsNewMessage := newmsg;

		// bZ[Wzɒǉ
		FParent.MessageList.Add(msg);
    FParent.IsGotLog := true;

  end;

  if msg = nil then
  begin
    ShowMessage('ʹװ');
  end else
  begin
  	// Cxgs
    FParent.NewReceivedMessage := msg;
    FTopicStateType := stMessageReceived;
    Synchronize(RaiseTopicStateChangeEvent)
  end;

	result := msg;
end;

procedure TTopicDownloadThread.RaiseTopicStateChangeEvent;
begin
  gBBSCore.RaiseTopicStateChangeEvent(FParent, FTopicStateType); 
end;

end.
