unit untTopicPostThread;

interface

uses
  Classes, SysUtils, Dialogs, DzURL,
  untHttpClient, untStreamTool, untTool,
  untBBSCore, untTopic, untGlobal, untOption, untBoard;

type

  TTopicPostThread = class(TThread)
  private
    FParent       : TTopic;
    FPostName     : string;
    FPostEmail    : string;
    FPostBody     : string;
    FErrorMessage : string;
    FTopicStateType : TTopicStateType;
    procedure RaiseTopicStateChangeEvent;
  public
    procedure Execute; override;
    constructor Create(Parent: TTopic; PostName, PostEmail, PostBody : string);
  end;

implementation

{ TTopicPostThread }

constructor TTopicPostThread.Create(Parent: TTopic; PostName, PostEmail, PostBody : string);
begin
  inherited Create(true);

  FParent := Parent;
  FPostName  := PostName;
  FPostEmail := PostEmail;
  FPostBody  := PostBody;
end;

procedure TTopicPostThread.Execute;
var
  sr           : TStreamReader;
  Response     : THttpResponse;
  line         : string;
  pagestr      : string;
  currenttime  : TDateTime;
  ErrorMsg     : string;
  HttpRequest  : THttpRequest;
begin
  inherited;

  FParent.Lock;
  FParent.IsPosingArticle := true;

  // C^[lbgǂݍ
  HttpRequest := THttpRequest.Create(TOnlineBoard(FParent.Board).BbsCgiUrl);
  HttpRequest.Method  := 'POST';
  HttpRequest.Referer := FParent.BrowserUrl;
  HttpRequest.UserAgent := APP_USERAGENT;
  HttpRequest.AddArgument('FROM', FPostName);
  HttpRequest.AddArgument('mail', FPostEmail);
  HttpRequest.AddArgument('MESSAGE', FPostBody);
  HttpRequest.AddArgument('bbs', FParent.BoardId);
  HttpRequest.AddArgument('key', FParent.TopicId);
  HttpRequest.AddArgument('time', IntToStr(Round((Now() - EncodeDate(1970, 1, 1)) * 86400)));
  HttpRequest.Cookie := 'NAME=' + UrlEncode(FPostName, true) + '; MAIL=' + UrlEncode(FPostEmail, true);

  Response := HttpRequest.GetResponse;

  if (Response.StatusCode >= 200) and
     (Response.StatusCode < 300) then
  begin
    sr := TStreamReader.Create(Response.GetResponseStream);
    pagestr := sr.ReadToEnd;
    HttpRequest.Close;

    if Pos('݂܂', pagestr) = 0 then
    begin
      ErrorMsg := CopyMiddle(pagestr, '<b>', '</b>');
      FErrorMessage := Errormsg;
    end;
  end;
  HttpRequest.Free;

  FParent.WriteError := FErrorMessage;
  FTopicStateType := stWriteDone;
  Synchronize(RaiseTopicStateChangeEvent);

  FParent.IsPosingArticle := false;
  FParent.Unlock;
  
  Terminate;
  Free;

end;

procedure TTopicPostThread.RaiseTopicStateChangeEvent;
begin
  gBBSCore.RaiseTopicStateChangeEvent(FParent, FTopicStateType); 
end;


end.
