unit untWriteForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, OleCtrls, SHDocVw, StdCtrls, untTopic,
  untGlobal, SHDocVw_TLB, untBBSCore;

type
  TWriteForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    WebBrowser1: TWebBrowser;
    Label1: TLabel;
    TitleEdit: TEdit;
    Label2: TLabel;
    NameComboBox: TComboBox;
    Label3: TLabel;
    EmailComboBox: TComboBox;
    BodyMemo: TMemo;
    SageCheckBox: TCheckBox;
    WriteButton: TButton;
    CancelButton: TButton;
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WriteButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private 錾 }
    FFormHeight : Integer;
    FTopic      : TTopic;
    procedure TopicStateChange(Topic: TTopic; EventType: TTopicStateType);
  public
    { Public 錾 }
    procedure SetTopic(Topic : TTopic);
  end;

var
  WriteForm: TWriteForm;

implementation

{$R *.dfm}

procedure TWriteForm.FormDeactivate(Sender: TObject);
begin
  //
  FFormHeight := self.Height;
  self.Height := 0;
end;

procedure TWriteForm.FormActivate(Sender: TObject);
begin
  //
  self.Height := FFormHeight;
end;

procedure TWriteForm.FormCreate(Sender: TObject);
begin
  FFormHeight := self.Height;
  gBBSCore.AddTopicStateChangeEvent(TopicStateChange);
end;

procedure TWriteForm.WriteButtonClick(Sender: TObject);
begin

  gBBSCore.PostArticle(FTopic, NameComboBox.Text, EmailComboBox.Text, BodyMemo.Text);

end;

procedure TWriteForm.SetTopic(Topic: TTopic);
begin

  if FTopic <> nil then FTopic.OnWriteDone := nil;

  FTopic := Topic;
  self.Caption := 'u' + FTopic.Title + 'vɃX';
  TitleEdit.Text := FTopic.Title;
  TitleEdit.Enabled := false;
  NameComboBox.Text := '';
  EmailComboBox.Text := '';
  SageCheckBox.Checked := false;
  BodyMemo.Text := '';

  self.Show;

end;

procedure TWriteForm.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TWriteForm.TopicStateChange(Topic: TTopic;
  EventType: TTopicStateType);
begin

  if Topic <> FTopic then exit;
  if EventType <> stWriteDone then exit;
  
  if Topic.WriteError = '' then
  begin

    gBBSCore.DownloadTopic(FTopic);
    Close;
  end else
    ShowMessage(Topic.WriteError);

end;

end.
