unit untBBS2chDolib;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, gzip, 
  untStreamTool, untTool,
  untBBSFramework,
  untLoginForm;

type

  TBBS2chDolibGetTopic = class(TBBSGetTopic)
  private
    FURL          : string;
    FNoFirstLine  : boolean;
    FReadPosition : integer;
    FWriteEvent   : TMemoryStreamEx;
    FBuffer       : TMemoryStream;
    FBufferReader : TStreamReader;
    FGzipStream   : TGzipDecompressStream;
    FFreezed      : boolean;
    FGzipinitialized  : boolean;
    FServer           : string;
    FBoardId          : string;
    FTopicId          : string;
    FError            : boolean;
    FHeaderSize       : integer;
    procedure HttpReceived(const Buff; Count : int64);
    procedure SetFreezed(const Value: boolean);
  public
    property    Freezed : boolean read FFreezed write SetFreezed;
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

implementation

uses
  untOption;

{ TBBS2chDolibGetTopic }

constructor TBBS2chDolibGetTopic.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;

end;

destructor TBBS2chDolibGetTopic.Destroy;
begin

  inherited;
end;

procedure TBBS2chDolibGetTopic.Get;
var
  contentsize : integer;
begin
  inherited;

  FURL := 'http://' + FServer + '/test/offlaw.cgi/' +
           FBoardId + '/' + FTopicId + '/?raw=.' +
           IntToStr(FDatSize) + '&sid=' + UrlEncode(gSessionId);

  FBufferReader := nil;
  FBuffer       := nil;
  FWriteEvent   := nil;
  try
    FReadPosition := 0;
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    FNoFirstLine  := true;
    FGzipinitialized := false;
    FError           := false;
    FHeaderSize      := 0;

    FHttp.Request.AcceptEncoding := 'gzip';
    FHttp.Get(FURL, FWriteEvent);

    contentsize := FBuffer.Size - FHeaderSize;
    if contentsize > 0 then
    begin
      if FDatSize = 0 then
        FDatSize := contentsize
      else
        FDatSize := FDatSize + contentsize - 1;
    end;
    
  except
    on E : EIdHTTPProtocolException do
      RaiseError(etDatFreezed, 'DAT܂');
  end;

  FBufferReader.Free;
  FBuffer.Free;
  FWriteEvent.Free;

  if FGzipinitialized then
    FGzipStream.Free;

end;

procedure TBBS2chDolibGetTopic.HttpReceived(const Buff; Count: int64);
var
  line   : string;
  RegExp :TRegExpr;
begin

  if FError then exit;

  FBuffer.Seek(0, soFromEnd);
  if Pos('gzip', FHttp.Response.ContentEncoding) > 0 then
  begin
    if FGzipinitialized = false then
    begin
      FGzipinitialized := true;
      FGzipStream  := TGzipDecompressStream.Create(FBuffer);
    end;
    FGzipStream.write(buff, count);
  end else
    FBuffer.Write(Buff, Count);
  FBuffer.Seek(FReadPosition, soFromBeginning);

  RegExp := TRegExpr.Create;
  RegExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>';

  while FBufferReader.ReadLine(line) do
  begin
    FReadPosition := FBuffer.Position;

    // `FbN
    if FNoFirstLine then
    begin
      FHeaderSize  := Length(line) + 1;
      FNoFirstLine := false;
      if Copy(line, 1, 1) = '+' then
        continue
      else
      begin

        FError := true;

        if Copy(line, 1, 4) = '-ERR' then
        begin
          FArticleList.Add('<FONT COLOR="Gray">offlaw.cgi</FONT><>' +
                           '<>' +
                           '<>' +
                           '<FONT COLOR="Gray">' + line + '</FONT><>');

          if Assigned(OnReceived) then OnReceived(self);
        end;

        RaiseError(etAbone, 'xO폜ĂĎ擾ĂB');
        exit;
      end;
    end;

    // sǉ
    if RegExp.Exec(line) then
      FArticleList.Add(line)
    else begin
      RaiseError(etParse, '̓G[');
      FArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>');
    end;

  end;

  Regexp.Free;

  //Synchronize(RaiseMessageReceivedEvent);
  FBuffer.Seek(0, soFromEnd);

  if Assigned(OnReceived) then OnReceived(self);

end;

procedure TBBS2chDolibGetTopic.SetFreezed(const Value: boolean);
begin
  FFreezed := Value;
end;


end.
