unit untEditBoardButttonForm;

interface 

uses 
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls; 

type 
  TEditBoardButtonForm = class(TForm)
    BoardButtonListBox: TListBox; 
    MoveUpButton: TButton; 
    MoveDownButton: TButton; 
    RemoveButton: TButton; 
    AddButton: TButton; 
    RedoButton: TButton; 
    OKButton: TButton; 
    BoardButtonLabel: TLabel; 
    CancelButton: TButton; 
    DescriptionLabel: TLabel; 
    procedure FormCreate(Sender: TObject); 
    procedure FormDestroy(Sender: TObject); 
    procedure MoveUpButtonClick(Sender: TObject); 
    procedure MoveDownButtonClick(Sender: TObject); 
    procedure RemoveButtonClick(Sender: TObject); 
    procedure RedoButtonClick(Sender: TObject); 
    procedure OKButtonClick(Sender: TObject); 
    procedure CancelButtonClick(Sender: TObject); 
    procedure ButtonEnabler(Sender: TObject); 
    procedure FormKeyDown(Sender: TObject; var Key: Word; 
      Shift: TShiftState); 
  private 
    FCancel : Boolean; 
    FEditBoardButtonList : TStringList; 
    FBoardButtonList     : TStringList; 
    function  GetFBoardButtonList  : TStringList; 
    procedure SetBoardButtonList(const BoardButtonList : TStringList); 
    function  GetCancel : Boolean; 
    procedure Refresh; 
    function  IsModified : Boolean; 
  public 
    property BoardButtonList : TStringList read GetFBoardButtonList write SetBoardButtonList; 
    property Cancel : Boolean read GetCancel; 
  end; 

var 
  EditBoardButtonForm: TEditBoardButtonForm;

implementation 

{$R *.dfm} 

procedure TEditBoardButtonForm.FormDestroy(Sender: TObject);
begin 
  FEditBoardButtonList.Free; 
end; 

function TEditBoardButtonForm.GetFBoardButtonList  : TStringList;
begin 
  Result := FBoardButtonList; 
end; 

procedure TEditBoardButtonForm.SetBoardButtonList(const BoardButtonList : TStringList); 
begin 
  FBoardButtonList := boardButtonList; 

  FEditBoardButtonList.Clear; 
  FEditBoardButtonList.AddStrings(FBoardButtonList); 

  Refresh(); 
end;

function TEditBoardButtonForm.GetCancel : Boolean;
begin 
  Result := FCancel; 
end; 

procedure TEditBoardButtonForm.Refresh;
begin 
  BoardButtonListBox.Items.BeginUpdate; 
  BoardButtonListBox.Items.Clear; 
  BoardButtonListBox.Items.AddStrings(FEditBoardButtonList); 
  BoardButtonListBox.Items.EndUpdate; 
end; 

procedure TEditBoardButtonForm.MoveUpButtonClick(Sender: TObject);
var 
  index : Integer; 
begin 
  index := BoardButtonListBox.ItemIndex; 
  if index > 0 then 
  begin 
    FEditBoardButtonList.Move(index, index - 1); 
    Refresh(); 
    BoardButtonListBox.ItemIndex := index - 1; 
    ButtonEnabler(Sender); 
  end; 
end; 

procedure TEditBoardButtonForm.MoveDownButtonClick(Sender: TObject);
var 
  index : Integer; 
begin 
  index := BoardButtonListBox.ItemIndex; 
  if (index > -1) and (index < BoardButtonListBox.Count - 1) then 
  begin 
    FEditBoardButtonList.Move(index, index + 1); 
    Refresh(); 
    BoardButtonListBox.ItemIndex := index + 1; 
    ButtonEnabler(Sender); 
  end; 
end; 

procedure TEditBoardButtonForm.RemoveButtonClick(Sender: TObject);
var 
  index : Integer; 
begin 
  index := BoardButtonListBox.ItemIndex; 
  if (index > -1) and (BoardButtonListBox.Count > 0) then 
  begin 
    FEditBoardButtonList.Delete(index); 
    Refresh(); 
    if (index = FEditBoardButtonList.Count) then 
      BoardButtonListBox.ItemIndex := index - 1 
    else 
      BoardButtonListBox.ItemIndex := index; 
    ButtonEnabler(Sender); 
  end; 
end; 

procedure TEditBoardButtonForm.RedoButtonClick(Sender: TObject);
begin 
  FEditBoardButtonList.Clear; 
  FEditBoardButtonList.AddStrings(FBoardButtonList); 
  BoardButtonListBox.ItemIndex := -1; 
  ButtonEnabler(Sender); 
  Refresh(); 
end; 

procedure TEditBoardButtonForm.OKButtonClick(Sender: TObject);
begin 
  if IsModified() then 
  begin 
    FBoardButtonList.Clear; 
    FBoardButtonList.AddStrings(FEditBoardButtonList); 
    Close(); 
  end 
  else 
    CancelButtonClick(Sender); 
end; 

procedure TEditBoardButtonForm.CancelButtonClick(Sender: TObject);
begin 
  FCancel := True; 
  Close(); 
end; 

procedure TEditBoardButtonForm.FormCreate(Sender: TObject); 
begin 
  FEditBoardButtonList := TStringList.Create; 
  FCancel := False; 
end;

procedure TEditBoardButtonForm.ButtonEnabler(Sender: TObject); 
var 
  MoveUp, MoveDown, Remove, Redo : Boolean; 
begin 
  MoveUp   := True; 
  MoveDown := True; 
  Remove   := True; 
  Redo     := True; 

  if not IsModified then 
    Redo := False; 

  if BoardButtonListBox.ItemIndex = -1 then 
  begin 
    MoveUp   := False; 
    MoveDown := False; 
    Remove   := False; 
  end 
  else if BoardButtonListBox.ItemIndex = 0 then 
    MoveUp   := False; 

  if BoardButtonListBox.ItemIndex = BoardButtonListBox.Count - 1 then 
    MoveDown := False; 

  MoveUpButton.Enabled   := MoveUp; 
  MoveDownButton.Enabled := MoveDown; 
  RemoveButton.Enabled   := Remove; 
  RedoButton.Enabled     := Redo; 
end; 


procedure TEditBoardButtonForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState); 
begin 
  if Key = VK_ESCAPE then 
    CancelButtonClick(Sender); 
end; 

function  TEditBoardButtonForm.IsModified : Boolean; 
begin 
  if FBoardButtonList.Equals(FEditBoardButtonList) then 
    Result := False 
  else 
    Result := True; 
end;



end.
