unit untMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ToolWin, ExtCtrls, ImgList,
  Menus, Contnrs, untWriteForm, untTool, untBBSCore,
  untGlobal, untBoard, untTopicBrowser, untTopic, untOption,
  untSearchForm, untOptionForm, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  unt2chUrlParser, untTopicBrowserIE, untTopicBrowserDoe,
  untUpdateBoardForm, untBoardDownloadThread,
  ShellAPI, Clipbrd, untBoardList, IdAntiFreezeBase, IdAntiFreeze,
  IdCookieManager, Math, ActnList, untLoginForm, StrUtils,
  untCreateOfflineFolder, Commctrl, untHintWindow,
  untEditBoardButttonForm, untLogSweeperForm, ShDocVw;

type

  TBoardListBoxItem = class
  public
    Category      : TBoardCategory;
    Board         : TBoard;
    ViewString    : string;
  end;

  TMainForm = class(TForm)
    ToolBarImageList: TImageList;
    TopicImageList: TImageList;
    Splitter1: TSplitter;
    RightPanel: TPanel;
    Splitter2: TSplitter;
    BrowserPanel: TPanel;
    TopicToolBar: TToolBar;
    ViewLimitToolButton: TToolButton;
    DownloadTopicToolButton: TToolButton;
    StopToolButton: TToolButton;
    ToolButton8: TToolButton;
    ToolButton12: TToolButton;
    TopicWriteToolButton: TToolButton;
    FavoriteToolButton: TToolButton;
    ToolButton15: TToolButton;
    TrashToolButton: TToolButton;
    CloseTabToolButton: TToolButton;
    TopicListViewPopupMenu: TPopupMenu;
    OpenNewTabMenuItem: TMenuItem;
    BoardNameLabel: TLabel;
    TopicNameLabel: TLabel;
    TopicPagePopupMenu: TPopupMenu;
    CloseMenuItem: TMenuItem;
    CloseAllMenuItem: TMenuItem;
    CloseWithoutMenuItem: TMenuItem;
    CopyUrlMenuItem: TMenuItem;
    CopyTitleUrlMenuItem: TMenuItem;
    OpenByBrowserMenuItem: TMenuItem;
    N01: TMenuItem;
    N7: TMenuItem;
    AutoReloadMenuItem: TMenuItem;
    TopicTabControl: TTabControl;
    ToolPopupMenu: TPopupMenu;
    IE1: TMenuItem;
    OptionMenuItem: TMenuItem;
    N5: TMenuItem;
    UpdateBoardListMenuItem: TMenuItem;
    N9: TMenuItem;
    ViewLimitPopupMenu: TPopupMenu;
    ViewLimit50MenuItem: TMenuItem;
    ViewLimit100MenuItem: TMenuItem;
    ViewLimit250MenuItem: TMenuItem;
    ViewLimit500MenuItem: TMenuItem;
    ViewLimit1000MenuItem: TMenuItem;
    ViewLimitNothingMenuItem: TMenuItem;
    TopicListView: TListView;
    CoolBar: TCoolBar;
    MainToolBar: TToolBar;
    SearchToolButton: TToolButton;
    PatrolToolButton: TToolButton;
    MakeTopicToolButton: TToolButton;
    StyleToolButton: TToolButton;
    StyleSub1ToolButton: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    UrlEdit: TEdit;
    BoardButtonToolBar: TToolBar;
    BoardButton: TToolButton;
    AddressBarPopupMenu: TPopupMenu;
    N1: TMenuItem;
    URL3: TMenuItem;
    ToolButton4: TToolButton;
    ToolButton3: TToolButton;
    StyleSub2ToolButton: TToolButton;
    StyleSub3ToolButton: TToolButton;
    MainStatusBar: TStatusBar;
    RepaintTabTimer: TTimer;
    RepaintListViewTimer: TTimer;
    DownloadAllTopicToolButton: TToolButton;
    BoardListBoxPopupMenu: TPopupMenu;
    RegisterBoardButtonMenuItem: TMenuItem;
    N3: TMenuItem;
    CopyBoardUrlMenuButton: TMenuItem;
    OpenBoardByBrowserMenuItem: TMenuItem;
    IdAntiFreeze1: TIdAntiFreeze;
    LeftPanel: TPanel;
    BoardListBox: TListBox;
    ComboBox1: TComboBox;
    ArticlePopupMenu: TPopupMenu;
    N2: TMenuItem;
    LoginMenuItem: TMenuItem;
    N4: TMenuItem;
    SetPriorityMenuItem: TMenuItem;
    InputMemoMenuItem: TMenuItem;
    URL1: TMenuItem;
    URL2: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    ResAtMenuItem: TMenuItem;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    BoardButtonPopupMenu: TPopupMenu;
    BoardDeleteMenuItem: TMenuItem;
    ActionList1: TActionList;
    ReceiveActiveTabAction: TAction;
    CloseActiveTabAction: TAction;
    TabForwardAction: TAction;
    TabBeforeAction: TAction;
    ChangeLimitAllActiveTab: TAction;
    ChangeStyle1Action: TAction;
    ChangeStyle2Action: TAction;
    ChangeStyle3Action: TAction;
    CreateOfflineFolder: TMenuItem;
    FavoritePopupMenu: TPopupMenu;
    RemoveOfflineFolder: TMenuItem;
    SetPriorityPlus3ItemMenu: TMenuItem;
    SetPriorityPlus2ItemMenu: TMenuItem;
    SetPriorityPlus1ItemMenu: TMenuItem;
    SetPriorityZeroItemMenu: TMenuItem;
    SetPriorityMinus1ItemMenu: TMenuItem;
    SetPriorityMinus2ItemMenu: TMenuItem;
    SetPriorityMinus3ItemMenu: TMenuItem;
    BoardButtonToolBarPopupMenu: TPopupMenu;
    EditBoardButtonMenuItem: TMenuItem;
    N6: TMenuItem;
    N13: TMenuItem;
    N14: TMenuItem;
    OpenAllCategoryAction: TAction;
    CloseAllCategoryAction: TAction;
    LogSweeperAction: TAction;
    procedure StyleChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BoardListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BoardListBoxData(Control: TWinControl; Index: Integer;
      var Data: String);
    procedure BoardListBoxClick(Sender: TObject);
    procedure TopicListViewData(Sender: TObject; Item: TListItem);
    procedure TopicListViewMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OpenNewTabMenuItemClick(Sender: TObject);
    procedure TopicTabControlChange(Sender: TObject);
    procedure TopicWriteToolButtonClick(Sender: TObject);
    procedure TopicTabControlDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure CloseTabToolButtonClick(Sender: TObject);
    procedure TopicTabControlMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DownloadTopicToolButtonClick(Sender: TObject);
    procedure FavoriteToolButtonClick(Sender: TObject);
    procedure PatrolToolButtonClick(Sender: TObject);
    procedure BoardNameLabelClick(Sender: TObject);
    procedure AutoReloadMenuItemClick(Sender: TObject);
    procedure SearchToolButtonClick(Sender: TObject);
    procedure StopToolButtonClick(Sender: TObject);
    procedure TopicListViewColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure MakeTopicToolButtonClick(Sender: TObject);
    procedure TopicTabControlResize(Sender: TObject);
    procedure OptionMenuItemClick(Sender: TObject);
    procedure TopicListViewDrawSubItem(Control: TWinControl;
      var ACanvas: TCanvas; Index, SubItem: Integer; ARect: TRect;
      State: TOwnerDrawState; var DefaultDrawing: Boolean);
    procedure TopicListViewDrawItem(Control: TWinControl;
      var ACanvas: TCanvas; Index: Integer; ARect: TRect;
      State: TOwnerDrawState; var DefaultDrawing, FullRowSelect: Boolean);
    procedure TrashToolButtonClick(Sender: TObject);
    procedure ViewLimitChangeClick(Sender: TObject);
    procedure TopicListViewCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure UpdateBoardListMenuItemClick(Sender: TObject);
    procedure UrlEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CopyUrlMenuItemClick(Sender: TObject);
    procedure CopyTitleUrlMenuItemClick(Sender: TObject);
    procedure OpenByBrowserMenuItemClick(Sender: TObject);
    procedure RepaintTabTimerTimer(Sender: TObject);
    procedure RepaintListViewTimerTimer(Sender: TObject);
    procedure DownloadAllTopicToolButtonClick(Sender: TObject);
    procedure RegisterBoardButtonMenuItemClick(Sender: TObject);
    procedure CopyBoardUrlMenuButtonClick(Sender: TObject);
    procedure OpenBoardByBrowserMenuItemClick(Sender: TObject);
    procedure CoolBarResize(Sender: TObject);
    procedure TopicTabControlMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LoginMenuItemClick(Sender: TObject);
    procedure ResAtMenuItemClick(Sender: TObject);
    procedure BoardListBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoardButtonToolBarCustomized(Sender: TObject);
    procedure BoardDeleteMenuItemClick(Sender: TObject);
    procedure BoardButtonToolBarMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ReceiveActiveTabActionExecute(Sender: TObject);
    procedure CloseActiveTabActionExecute(Sender: TObject);
    procedure TabBeforeActionExecute(Sender: TObject);
    procedure TabForwardActionExecute(Sender: TObject);
    procedure ChangeLimitAllActiveTabExecute(Sender: TObject);
    procedure ChangeStyle2ActionExecute(Sender: TObject);
    procedure ChangeStyle1ActionExecute(Sender: TObject);
    procedure ChangeStyle3ActionExecute(Sender: TObject);
    procedure CreateOfflineFolderClick(Sender: TObject);
    procedure FavoritePopupMenuPopup(Sender: TObject);
    procedure FavoriteMenuItemClick(Sender: TObject);
    procedure RemoveOfflineFolderClick(Sender: TObject);
    procedure BoardListBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TopicTabControlMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure TopicTabControlDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure TopicTabControlDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure BoardListBoxDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure BoardListBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure SetPriorityMenuItemClick(Sender: TObject);
    procedure SetSelectedTopicPriority(Priority: Integer);
    procedure TopicListViewPopupMenuPopup(Sender: TObject);
    procedure TopicPagePopupMenuPopup(Sender: TObject);
    procedure SetPriorityPlusItemMenuClick(Sender: TObject);
    procedure EditBoardButtonMenuItemClick(Sender: TObject);
    procedure OpenAllCategoryActionExecute(Sender: TObject);
    procedure CloseAllCategoryActionExecute(Sender: TObject);
    procedure InputMemoMenuItemClick(Sender: TObject);
    procedure LogSweeperActionExecute(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    FActive          : boolean;
    FSelectButton    : string;
    FSelectMessageNo : integer;
    FOldtab        : TTopicBrowser;
    FWriteForm     : TWriteForm;
    FSelectedBoard : TBoard;
    //FBoardList     : TObjectList;
    FTopicList     : TList;
    FBrowserList   : TObjectList;
    FRefreshCount  : integer;
    FBoardListBoxItems : TObjectList;
    FBoardButtonList : TStringList;
    FBoardButtonMenuList : TObjectList;
    FRestoreCoolBands : Boolean;
    FTopicListSortOrder : boolean;
    FTopicListSortIndex : integer;
    FTopicListFilter    : string;
    FMouseControl: TControl;
    procedure OpenBoard(Board : TBoard);
    procedure OpenTab(Topic : TTopic; newtab : Boolean);
    procedure CloseTab(Index : integer);
    procedure ChangeTab();
    procedure DownloadTopic();
    procedure Board_TopicReceived(Sender : TObject; Topic : TTopic);
    function  GetActiveTab : TTopicBrowser;
    procedure OpenUrl(Url : string);
    function  CreateTopicBrowser() : TTopicBrowser;
    procedure RefreshBoardListBox;
    procedure TopicBrowser_NavigateUrl(Sender : TObject; URL : string);
    procedure OpenBrowser(URL : string);
    procedure TopicBrowser_ChangeDownloadState(Sender : TObject);
    procedure CreateBoardButton();
    procedure BoardButtonClick(Sender : TObject);
    procedure SaveBoardButton;
    function GetTabIndexAtPoint(Point : TPoint) : Integer;
    function GetTabAtPoint(Point : TPoint) : TTopicBrowser;
    procedure FormIdle(Sender: TObject; var Done: Boolean);
    //function  TopicListSortCompare(Item1, Item2: Pointer) : Integer;
  public
    { Public 錾 }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

{ TMainForm }

procedure TMainForm.FormCreate(Sender: TObject);
var
  I             : integer;
  ActiveTab     : TTopicBrowser;
  items         : TStringArray;
begin

  gBBSCore.DefaultTopicChangeDownloadStateFunction := TopicBrowser_ChangeDownloadState;

  FTopicList := TList.Create;
  FBoardListBoxItems := TObjectList.Create;

  // Style
  StyleToolButton.Down     := gMainFormStyleType3;
  StyleSub1ToolButton.Down := gMainFormStyleSub1;
  StyleSub2ToolButton.Down := gMainFormStyleSub2;
  StyleSub3ToolButton.Down := gMainFormStyleSub3;

  // BoardList
  BoardListBox.ItemHeight := BoardListBox.Canvas.TextHeight('') + 2;

  // ݒ蔽f
  StyleChange(nil);
  OpenBoard(nil);
  TopicTabControl.MultiLine := gMultiLineTab;

  // TopicListViewColumn
  items := Split(gTopicListViewColumnOrders, ',');
  if Length(items) >= 11 then
    for I := 0 to 10 do
      TopicListView.Columns.FindItemID(StrToIntNeo(items[i])).Index := I;

  items := Split(gTopicListViewColumnWidths, ',');
  if Length(items) >= 11 then
    for I := 0 to 10 do
      TopicListView.Column[I].Width := StrToIntNeo(items[I]);

  TopicListView.Font.Size := gTopicListViewColumnFontSize;
  //TopicListView.SmallImages.Height := TopicListView.Canvas.TextHeight('') + gTopicListViewColumnPadding;
  TopicListView.GridLines := gTopicListViewGridLines;

  // {[hXgXV
  RefreshBoardListBox();

  // uEUЂƂJĂ
  FBrowserList := TObjectList.Create;
  ActiveTab := CreateTopicBrowser();
  ActiveTab.Visible := true;

  // ݃tH[
  FWriteForm := TWriteForm.Create(self);

  // {^̍쐬
  FBoardButtonList := TStringList.Create;
  if FileExists(AppPath('favboard.idx')) then
    FBoardButtonList.LoadFromFile(AppPath('favboard.idx'));   

  FBoardButtonMenuList := TObjectList.Create;
  CreateBoardButton();

  FRestoreCoolBands := true;

  // Form size
  self.Height := gMainFormHeight;
  self.Width  := gMainFormWidth;
  self.Top    := gMainFormTop;
  self.Left   := gMainFormLeft;
  self.Show;
  self.WindowState := TWindowState(gMainFormWindowState);

  //FRestoreCoolBands := true;
  //CoolBarResize(CoolBar);

  Application.OnIdle := FormIdle;

end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  I       : Integer;
 column  : TListColumn;
  band    : TCoolBand;
begin

  FWriteForm.Free;
  FBrowserList.Free;
  FBoardListBoxItems.Free;

  // Style
  gMainFormStyleType3 := StyleToolButton.Down;
  gMainFormStyleSub1  := StyleSub1ToolButton.Down;
  gMainFormStyleSub2  := StyleSub2ToolButton.Down;
  gMainFormStyleSub3  := StyleSub3ToolButton.Down;
  if LeftPanel.Visible then gBoardListBoxWidth := LeftPanel.Width;
  if (StyleToolButton.ImageIndex = 7) then
    if BrowserPanel.Visible then gTopicListViewHeight := TopicListView.Height
  else
    if BrowserPanel.Visible then gTopicListViewWidth := TopicListView.Width;

  // Form size
  if self.WindowState = wsMinimized then
    gMainFormWindowState := Integer(wsNormal)
  else
    gMainFormWindowState := Integer(self.WindowState);
  if self.WindowState = wsNormal then
  begin
    gMainFormHeight  := self.Height;
    gMainFormWidth   := self.Width;
    gMainFormTop     := self.Top;
    gMainFormLeft    := self.Left;
  end;

  // TopicListView column position
  gTopicListViewColumnOrders := '';
  gTopicListViewColumnWidths := '';
  for I := 0 to TopicListView.Columns.Count - 1 do
  begin
    column := TopicListView.Columns[I];
    gTopicListViewColumnOrders := gTopicListViewColumnOrders
                    + IntToStr(column.Tag) + ',';
    gTopicListViewColumnWidths := gTopicListViewColumnWidths
                    + IntToStr(column.Width) + ',';
  end;

  gCoolBarBandId    := '';
  gCoolBarBandWidth := '';
  gCoolBarBandBreak := '';
  for i := 0 to CoolBar.Bands.Count -1 do
  begin
    band := CoolBar.Bands[I];
    gCoolBarBandId    := gCoolBarBandId    + IntToStr(band.ID) + ', ' ;
    gCoolBarBandWidth := gCoolBarBandWidth  + IntToStr(band.Width) + ', ';
    if band.Break = true then
      gCoolBarBandBreak := gCoolBarBandBreak + 'TRUE, '
    else
      gCoolBarBandBreak := gCoolBarBandBreak + 'FALSE, ';
  end;

  gBoardList.Save;

  //FBoardList.Free;
  FTopicList.Free;

  FBoardButtonMenuList.Free;
  FBoardButtonList.Free;

end;

// \X^CύX
procedure TMainForm.StyleChange(Sender: TObject);
var
  NormalMode : Boolean;
begin

  // eR|[lg̃TCYۑ
  if sender <> nil then
  begin
    NormalMode := (StyleToolButton.ImageIndex = 7);
    if LeftPanel.Visible then gBoardListBoxWidth := LeftPanel.Width;
    if NormalMode then
    begin
      if BrowserPanel.Visible then gTopicListViewHeight := TopicListView.Height;
    end else
    begin
      if BrowserPanel.Visible then gTopicListViewWidth := TopicListView.Width;
    end;
  end;

  // yCX^C̕ύX
  if Sender = StyleToolButton then
    if StyleToolButton.ImageIndex = 3 then
    begin
      StyleToolButton.ImageIndex     := 7;
      StyleToolButton.Hint           := 'ʏʍ\ɕύX';
      StyleSub1ToolButton.ImageIndex := 8;
      StyleSub2ToolButton.ImageIndex := 9;
      StyleSub3ToolButton.ImageIndex := 10;
    end else
    begin
      StyleToolButton.ImageIndex     := 3;
      StyleToolButton.Hint           := 'cRʍ\ɕύX';
      StyleSub1ToolButton.ImageIndex := 4;
      StyleSub2ToolButton.ImageIndex := 5;
      StyleSub3ToolButton.ImageIndex := 6;
    end;
  NormalMode := (StyleToolButton.ImageIndex = 7);


  if (StyleSub2ToolButton.Down = true) and
     (StyleSub3ToolButton.Down = true) then
    if(Sender = StyleSub2ToolButton) then
      StyleSub3ToolButton.Down := false
    else
      StyleSub2ToolButton.Down := false;

  if StyleSub1ToolButton.Down = true then
  begin
    LeftPanel.Visible := false;
    Splitter1.Visible    := false;
  end else
  begin
    LeftPanel.Visible := true;
    LeftPanel.Width := gBoardListBoxWidth;
    RightPanel.Align   := alNone;
    Splitter1.Visible  := true;
    Splitter1.Align    := alNone;
    Splitter1.Width    := 3;
    Splitter1.Left     := LeftPanel.Width;
    Splitter1.Align    := alLeft;
    RightPanel.Left    := Splitter1.Left + Splitter1.Width;
    RightPanel.Align   := alClient;
  end;   

  if (StyleSub2ToolButton.Down = false) and
     (StyleSub3ToolButton.Down = false) then
  begin

    if NormalMode = true then
    begin
      TopicListView.Visible := true;
      TopicListView.Align   := alTop;
      TopicListView.Height  := gTopicListViewHeight;
      Splitter2.Visible     := true;
      Splitter2.Align       := alNone;
      Splitter2.Height      := 3;
      Splitter2.Top         := TopicListView.Height;
      Splitter2.Align       := alTop;
      BrowserPanel.Visible  := true;
      BrowserPanel.Align    := alNone;
      BrowserPanel.Top      := Splitter2.Top + Splitter2.Height;
      BrowserPanel.Align    := alClient;
    end else
    begin
      TopicListView.Visible := true;
      TopicListView.Align   := alLeft;
      TopicListView.Width   := gTopicListViewWidth;
      Splitter2.Visible     := true;
      Splitter2.Align       := alNone;
      Splitter2.Width       := 3;
      Splitter2.Left        := TopicListView.Width;
      Splitter2.Align       := alLeft;
      BrowserPanel.Visible  := true;
      BrowserPanel.Align    := alNone;
      BrowserPanel.Left     := Splitter2.Left + Splitter2.Width;
      BrowserPanel.Align    := alClient;
    end;

  end else
  if StyleSub2ToolButton.Down = true then
  begin
    Splitter2.Visible    := false;
    BrowserPanel.Visible := false;
    TopicListView.Align  := alClient;
  end else
  begin
    Splitter2.Visible    := false;
    TopicListView.Visible := false;
    BrowserPanel.Align  := alClient;
  end;


end;

// ꗗ`
procedure TMainForm.BoardListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  ColorRect    : TRect;
  DefaultBrush : TColor;
  item         : TBoardListBoxItem;
begin

  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit;

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);

  // FÂ 
  if gBoardListNoColor = false then
  begin
    ColorRect.Left   := Rect.Left; 
    ColorRect.Top    := Rect.Top; 
    ColorRect.Bottom := Rect.Bottom; 
    ColorRect.Right  := Rect.Left + 4; 
    DefaultBrush := TListBox(Control).Canvas.Brush.Color; 
    TListBox(Control).Canvas.Brush.Color := item.Category.Color; 
    TListBox(Control).Canvas.Brush.Style := bsSolid; 
    TListBox(Control).Canvas.FillRect(ColorRect); 
    TListBox(Control).Canvas.Brush.Color := DefaultBrush; 
  end;

  Rect.Left := Rect.Left + 4;
  TListBox(Control).Canvas.TextRect(Rect, Rect.Left + 1, Rect.Top + 1, item.ViewString);

end;

// ^u`
procedure TMainForm.TopicTabControlDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean);
var
  Browser  : TTopicBrowser;
  X        : Integer;
  DrawRect  : TRect;
begin

  if (TabIndex >= 0) and (TabIndex < TopicTabControl.Tabs.Count) then
  begin
    Browser := TTopicBrowser(FBrowserList[TabIndex]);

    // 
    Control.Canvas.FillRect(Rect);

    // ACR̕`
    if(Browser.ImageIndex > -1) and (Browser.ImageIndex < TopicTabControl.Images.Count) then
    begin
      TopicTabControl.Images.Draw(Control.Canvas, Rect.Left + 3, Rect.Top + 3, Browser.ImageIndex);

      X := Rect.Left + 20;
    end else
    begin
      X := Rect.Left + 5;
    end;

    if Active = false then
      Control.Canvas.Font.Color := clBtnShadow
    else
      Control.Canvas.Font.Color := clWindowText;

    DrawRect.Top    := Rect.Top + 2;
    DrawRect.Left   := X;
    DrawRect.Bottom := Rect.Bottom - 1;
    DrawRect.Right  := Rect.Right  - 1;
    Control.Canvas.TextRect(DrawRect, X, Rect.Top + 5, Browser.Caption);
  end;

end;

procedure TMainForm.BoardListBoxData(Control: TWinControl; Index: Integer;
  var Data: String);
var
  item     : TBoardListBoxItem;
begin

  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit; 

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  Data := item.ViewString;


end;


// {[hXgClick
procedure TMainForm.BoardListBoxClick(Sender: TObject);
var
  Index    : Integer;
  item     : TBoardListBoxItem;
begin

  Index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit; 

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  if item.Board <> nil then
    OpenBoard(item.Board)
  else
  begin
    item.Category.Opened := not item.Category.Opened;
    RefreshBoardListBox;
  end;

end;

procedure TMainForm.TopicListViewData(Sender: TObject; Item: TListItem);
var
  Topic  : TTopic;
  image  : Integer;
  gotmsg : string;
  newmsg : string;
begin

  if (Item.Index < 0) or (Item.Index >= FTopicList.Count) then exit;

  Topic := TTopic(FTopicList[Item.Index]);

  gotmsg := IntToStr(Topic.GotMessageCount); 
  if Topic.GotMessageCount <= 0 then
    if Topic.IsLoadedLocalDat = false then
      gotmsg := '';

  newmsg := IntToStr(Topic.NewMessageCount);
  if Topic.NewMessageCount <= 0 then
    if Topic.IsLoadedLocalDat = false then
      newmsg := '';

  Item.Caption  := ''; 
  if Topic.Priority < 0 then 
    Item.SubItems.Add(IntToStr(Topic.Priority)) 
  else if Topic.Priority > 0 then 
    Item.SubItems.Add('+' + IntToStr(Topic.Priority)) 
  else 
    Item.SubItems.Add('');
  Item.SubItems.Add(IntToStr(Topic.Index));

  Item.SubItems.Add(Topic.Title);
  Item.SubItems.Add(IntToStr(Topic.MessageCount));
  Item.SubItems.Add(gotmsg);
  Item.SubItems.Add(newmsg);
  Item.SubItems.Add(Topic.LastReadDate);
  Item.SubItems.Add(Topic.LastWriteDate);

  if Topic.Board <> nil then
    Item.SubItems.Add(TBoard(Topic.Board).DisplayName)
  else
    Item.SubItems.Add('');

  Item.SubItems.Add(Topic.Memo);

  // ACR
  image := -1;
  if Topic.DownloadState <> dsNone  then image := 2
  else if Topic.IsFavorite          then image := 3
	else if Topic.IsError             then image := 7
  else if Topic.IsFreezed           then image := 8
  else if Topic.GotMessageCount >= Topic.MessageCount then image := 4
  else if Topic.GotMessageCount > 0 then image := 5;
  Item.ImageIndex := image;

end;

// gsbNACeIꂽ
procedure TMainForm.TopicListViewMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Topic : TTopic;
  Item  : TListItem;
begin

  Item := TopicListView.Selected;
  if Item <> nil then
  begin
    Topic := TTopic(FTopicList[Item.Index]);
    OpenTab(Topic, false);
  end;
end;

// ^uύX
procedure TMainForm.TopicTabControlChange(Sender: TObject);
begin
  ChangeTab();
end;

// ^u_uNbNꂽ
procedure TMainForm.TopicTabControlMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin

  if ssDouble in Shift then
    DownloadTopic;

  if Button = mbLeft then
    TopicTabControl.BeginDrag(false, 8);
  
end;

procedure TMainForm.TopicTabControlMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbMiddle then
    CloseTabToolButtonClick(nil);
end;

// xNbN
procedure TMainForm.BoardNameLabelClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      OpenBoard(TBoard(ActiveTab.Topic.Board));
  
end;

function TopicListSortCompare(Item1, Item2: Pointer): Integer;
var
  Compare        : integer;
  Topic1, Topic2 : TTopic;
  NoChange       : boolean;
begin

  Topic1 := Item1;
  Topic2 := Item2;
  nochange := false;
  Compare  := 0;

  case MainForm.FTopicListSortIndex  of
  1: Compare := CompareValue  (Topic1.Priority,        Topic2.Priority);  
  2: Compare := CompareValue  (Topic1.Index,           Topic2.Index);
  3: Compare := AnsiCompareStr(Topic1.Title,           Topic2.Title);
  4: Compare := CompareValue  (Topic1.MessageCount,    Topic2.MessageCount);
  5: Compare := CompareValue  (Topic1.GotMessageCount, Topic2.GotMessageCount);
  6: Compare := CompareValue  (Topic1.NewMessageCount, Topic2.NewMessageCount);
  7: Compare := AnsiCompareStr(Topic1.LastReadDate,    Topic2.LastReadDate);
  8: Compare := AnsiCompareStr(Topic1.LastWriteDate,   Topic2.LastWriteDate);
  9: Compare := AnsiCompareStr(TBoard(Topic1.Board).DisplayName, TBoard(Topic2.Board).DisplayName);
  else nochange := true;
  end;
  if MainForm.FTopicListSortOrder = true then Compare:=-Compare;
  if nochange then
    Compare := CompareValue(Topic1.Index, Topic2.Index);

  result := Compare;
end;

// Xgr[\[g
procedure TMainForm.TopicListViewColumnClick(Sender: TObject;
  Column: TListColumn);
begin

  if Column.Index = FTopicListSortIndex then
    FTopicListSortOrder := not FTopicListSortOrder
  else begin
    FTopicListSortOrder := true;
    FTopicListSortIndex := Column.id;
  end;
  FTopicList.Sort(TopicListSortCompare);

  TopicListView.Repaint;
end;

// OpenURL
procedure TMainForm.UrlEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

  if Key = $0d then
    OpenUrl(UrlEdit.Text);

end;

//  j[Cxg 

// ݒEBhEJ
procedure TMainForm.OptionMenuItemClick(Sender: TObject);
var
  OptionForm : TOptionForm;
begin

  OptionForm := TOptionForm.Create(self);
  OptionForm.ShowModal;
  OptionForm.Free;

end;

// {[hXg̍XV
procedure TMainForm.UpdateBoardListMenuItemClick(Sender: TObject);
var
  UpdateBoardForm : TUpdateBoardListForm;
begin

  UpdateBoardForm := TUpdateBoardListForm.Create(self);
  UpdateBoardForm.ShowModal;
  UpdateBoardForm.Free;

  RefreshBoardListBox;

end;

// OC
procedure TMainForm.LoginMenuItemClick(Sender: TObject);
var
  LoginForm : TLoginForm;
begin

  LoginForm := TLoginForm.Create(self);
  LoginForm.ShowModal;
  LoginForm.Release;
  LoginForm.Free;

end;

// open topic with newtab
procedure TMainForm.OpenNewTabMenuItemClick(Sender: TObject);
var
  Topic : TTopic;
  Item  : TListItem;
begin

  Item := TopicListView.Selected;
  if Item <> nil then
  begin
    Topic := TTopic(FTopicList[Item.Index]);
    OpenTab(Topic, true);
  end;
end;

// I[g[h
procedure TMainForm.AutoReloadMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  AutoReloadMenuItem.Checked := not AutoReloadMenuItem.Checked;

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      ActiveTab.AutoReload := AutoReloadMenuItem.Checked;
end;

procedure TMainForm.ViewLimitChangeClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab = nil then exit;

  if Sender = ViewLimit50MenuItem then
    ActiveTab.ChangeViewLimit(50)
  else if Sender = ViewLimit100MenuItem then
    ActiveTab.ChangeViewLimit(100)
  else if Sender = ViewLimit250MenuItem then
    ActiveTab.ChangeViewLimit(250)
  else if Sender = ViewLimit500MenuItem then
    ActiveTab.ChangeViewLimit(500)
  else if Sender = ViewLimit1000MenuItem then
    ActiveTab.ChangeViewLimit(1000)
  else if Sender = ViewLimitNothingMenuItem then
    ActiveTab.ChangeViewLimit(0);

end;

//  c[j[Cxg 

// Jn
procedure TMainForm.PatrolToolButtonClick(Sender: TObject);
begin

  gBoardList.FavoriteBoard.Patrol();
  RepaintListViewTimer.Enabled := true;

end;

// 
procedure TMainForm.SearchToolButtonClick(Sender: TObject);
var
  I            : Integer;
  SearchText   : string;
  ActiveTab    : TTopicBrowser;
  NewTopicList : TList;
begin

  SearchForm.ShowModal;
  SearchText := SearchForm.SearchEdit.Text;

  if SearchForm.SearchSelect = srFromTopic then
  begin

    // gsbN̓e猟

    ActiveTab := GetActiveTab();
    if ActiveTab <> nil then
      ActiveTab.SearchText(SearchText);

  end else
  if SearchForm.SearchSelect = srFromTopicList then
  begin

    // gsbNXg猟
    FTopicListFilter := SearchText;
    NewTopicList := TList.Create;
    for I := 0 to FTopicList.Count - 1 do
      if AnsiContainsText(TTopic(FTopicList[I]).Title, SearchText) then
        NewTopicList.Add(FTopicList[I])
      else
        TTopic(FTopicList[I]).CountDown;  

    FTopicList.Free;
    FTopicList := NewTopicList;
    TopicListView.Items.Count := FTopicList.Count;

    TopicListView.Repaint;

  end else
  if SearchForm.SearchSelect = srFromBoardList then
  begin

    // {[hXg猟

    for I := 0 to BoardListBox.Count - 1 do
      if AnsiContainsText(BoardListBox.Items[I], SearchText) then

      begin
        BoardListBox.Selected[I] := true;
        //BoardListBox.ItemIndex := I;
        BoardListBoxClick(BoardListBox);
        break;
      end;

  end;

end;

// gsbN
procedure TMainForm.TopicWriteToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      FWriteForm.SetTopic(ActiveTab.Topic); 

end;

// ɃX
procedure TMainForm.ResAtMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      FWriteForm.SetTopic(ActiveTab.Topic, FSelectMessageNo);
      
end;

// O̍폜
procedure TMainForm.TrashToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
  begin
    if Activetab.Topic <> nil then
      ActiveTab.Topic.EraseLog;
    ActiveTab.CloseTopic;
  end;
  ChangeTab();

end;

// ^u
procedure TMainForm.CloseTabToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
  I         : Integer;
  Found     : Boolean;
  Index     : Integer;
  PT : TPoint;
begin

  //TopicTabControl.DoubleBuffered := true;
  //TopicTabControl.SelectNextPage(false);
  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);

  //TopicTabControl.Pages.RemoveControl(TopicTabControl.ActivePage);

  if Sender = CloseMenuItem then 
  begin
  
    Index := GetTabIndexAtPoint(TopicPagePopupMenu.PopupPoint); 
    CloseTab(Index);

  end else
  if Sender = CloseAllMenuItem then
  begin

    // Sĕ
    for I := 0 to TopicTabControl.Tabs.Count - 1 do
      CloseTab(0);

  end else
  if Sender = CloseWithoutMenuItem then
  begin

    // ANeBuȃ^uȊO
    Found := false;
    for I := 0 to TopicTabControl.Tabs.Count - 1 do
      if Found = false then
        if FBrowserList[0] <> ActiveTab then
          CloseTab(0)
        else
          Found := true
      else
        CloseTab(1);

  end else
  if Sender = nil then
  begin

    // {^NbN^u
    GetCursorPos(PT);
    Index := GetTabIndexAtPoint(PT);
    CloseTab(Index);
  end else

    // ANeBuȃ^u
    CloseTab(TopicTabControl.TabIndex);


  //TopicTabControl.DoubleBuffered := false;

end;

// gsbN_E[h
procedure TMainForm.DownloadTopicToolButtonClick(Sender: TObject);
begin
  DownloadTopic;
end;

// SẴgsbN_E[h
procedure TMainForm.DownloadAllTopicToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
  I         : Integer;
begin

  for I := 0 to FBrowserList.Count - 1 do
  begin
    ActiveTab := TTopicBrowser(FBrowserList[I]);
    ActiveTab.Download;
  end;

  RepaintTabTimer.Enabled := true;
  
end;

// Cɓɒǉ
procedure TMainForm.FavoriteToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
  begin
    if ActiveTab.Topic <> nil then
    begin
      if ActiveTab.Topic.IsFavorite = false then
      begin
        ActiveTab.Topic.IsFavorite := true;
        gBoardList.FavoriteBoard.AppendTopic(ActiveTab.Topic);
      end else
      begin
        ActiveTab.Topic.IsFavorite := false;
        gBoardList.FavoriteBoard.RemoveTopic(ActiveTab.Topic);
      end;
    end;

    TopicBrowser_ChangeDownloadState(ActiveTab.Topic);
  end;

end;

// _E[h~
procedure TMainForm.StopToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      ActiveTab.Topic.StopDownload;

end;

// gsbN̍쐬
procedure TMainForm.MakeTopicToolButtonClick(Sender: TObject);
begin

  if FSelectedBoard <> nil then
    if FSelectedBoard is TOnlineBoard then
      FWRiteForm.SetBoard(TOnlineBoard(FSelectedBoard));

end;

// URL̃Rs[
procedure TMainForm.CopyUrlMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      Clipboard.AsText := ActiveTab.Topic.BrowserUrl;

end;

// ^CgURL̃Rs[
procedure TMainForm.CopyTitleUrlMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      Clipboard.AsText := ActiveTab.Topic.Title + #13#10 +
                          ActiveTab.Topic.BrowserUrl;

end;

// uEUŊJ
procedure TMainForm.OpenByBrowserMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      OpenBrowser(ActiveTab.Topic.BrowserUrl);

end;

procedure TMainForm.BoardListBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  index     : integer;
  pos       : TPoint;
  item      : TBoardListBoxItem;
  boardname : string;
begin

  if Button = mbRight then
  begin
    pos.X := x;
    pos.Y := y;
    index := BoardListBox.ItemAtPos(pos, true);
    if index < 0 then index := BoardListBox.Count - 1;
    BoardListBox.ItemIndex := index;

    // {^
    item := TBoardListBoxItem(FBoardListBoxItems[Index]);
    if item.Board <> nil then
      boardname := TBoard(item.Board).DisplayName
    else
      boardname := '' + item.Category.CategoryName;

    // o^Ă΃`FbN
    if FBoardButtonList.IndexOf(boardname) = -1 then
      RegisterBoardButtonMenuItem.Checked := false
    else
      RegisterBoardButtonMenuItem.Checked := true;

    // }CtH_ȂAXbhqɍ쐬j[\
    if boardname = '}CtH_' then
      CreateOfflineFolder.Visible := true
    else
      CreateOfflineFolder.Visible := false;

    // XbhqɂȂ폜j[\
    RemoveOfflineFolder.Visible := false;
    if item.Board <> nil then
      if item.Board is TOfflineBoard then
        if item.Board.DisplayName <> 'Cɓ' then
          RemoveOfflineFolder.Visible := true;
      
    BoardListBoxPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
  end;

end;

procedure TMainForm.RegisterBoardButtonMenuItemClick(Sender: TObject);
var
  Index     : Integer;
  item      : TBoardListBoxItem;
  itemind   : integer;
  boardname : string;
begin

  Index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit;

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  if item.Board <> nil then
    boardname := TBoard(item.Board).DisplayName
  else
    boardname := '' + item.Category.CategoryName;

  // o^ĂȂΓo^
  itemind := FBoardButtonList.IndexOf(boardname);
  if itemind = -1 then
    FBoardButtonList.Add(boardname) 
  else
    FBoardButtonList.Delete(itemind); 

  CreateBoardButton;
  SaveBoardButton;

end;

// {^̃JX^}CY
procedure TMainForm.BoardDeleteMenuItemClick(Sender: TObject);
var
  itemind : integer;
begin

  // o^Ă΍폜
  itemind := FBoardButtonList.IndexOf(FSelectButton);
  if itemind > -1 then
    FBoardButtonList.Delete(itemind); 

  CreateBoardButton;
  SaveBoardButton;
  
end;

procedure TMainForm.BoardButtonToolBarMouseUp(Sender: TObject; 
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer); 
begin 
  // 
  if (Sender is TToolButton) and (Button = mbRight) then 
  begin 
    FSelectButton := TToolButton(Sender).Caption; 
    BoardButtonPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y); 
  end; 
  if (Sender is TToolBar) and (Button = mbRight) then
    BoardButtonToolBarPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y); 
end;

procedure TMainForm.CopyBoardUrlMenuButtonClick(Sender: TObject);
var
  Index    : Integer;
  item     : TBoardListBoxItem;
begin

  Index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit;

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  if item.Board <> nil then
    if item.Board is TOnlineBoard then
      Clipboard.AsText := TOnlineBoard(item.Board).BoardUrl;

end;

procedure TMainForm.OpenBoardByBrowserMenuItemClick(Sender: TObject);
var
  Index    : Integer;
  item     : TBoardListBoxItem;
begin

  Index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit;

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  if item.Board <> nil then
    if item.Board is TOnlineBoard then
      OpenBrowser(TOnlineBoard(item.Board).BoardUrl);
      
end;

// {^
procedure TMainForm.BoardButtonClick(Sender: TObject);
var
  I, J     : integer;
  caption  : string;
  category : TBoardCategory;
begin

  if sender is TMenuItem then
    caption := TMenuItem(Sender).Caption
  else if sender is TToolButton then
    caption := TToolButton(sender).Caption;

  for I := 0 to gBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(gBoardList.Categorys[I]);
    for J := 0 to category.Boards.Count - 1 do
      if TBoard(category.Boards[J]).DisplayName = caption then
      begin
        OpenBoard(TBoard(category.Boards[J]));
        break;
      end;
  end;

end;

//  ̑̃Cxg 

// gsbNM
procedure TMainForm.Board_TopicReceived(Sender: TObject; Topic: TTopic);
begin

  if FTopicListFilter <> '' then
    if AnsiContainsText(Topic.Title, FTopicListFilter) = false then
      exit;

  try
    FTopicList.Add(Topic);
    Topic.CountUp;
    TopicListView.Items.Count := FTopicList.Count;
    //TopIndex := TopicListView.TopItem.Index;
    //TopicListView.Items.Count := Topic.Index;
    //if TopIndex < TopicListView.Items.Count then
    //  TopicListView.TopItem.Index  := TopIndex;

    // ܂ɍĕ`悵Ă݂
    Inc(FRefreshCount);
    if FRefreshCount = 20 then
    begin
      TopicListView.DoubleBuffered := true;
      TopicListView.Repaint;
      TopicListView.DoubleBuffered := false;
    end;
  except on Exception do ;
  end;

  Application.ProcessMessages;

end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: OpenBoard
  pr  : {[hJ
    : Index
  @@@: Board
  @@@: Category
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.OpenBoard(Board: TBoard);
var
  NoClear  : Boolean;
  I, J     : integer;
  category : TBoardCategory;
begin
  FRefreshCount := 0;
  FTopicListFilter := '';

  NoClear := false;
  if FSelectedBoard <> nil then
    if FSelectedBoard = Board then
      if FSelectedBoard.IsDownloading then
        NoClear := true;

  if NoClear = false then
  begin
    TopicListView.Items.Clear();

    if FTopicList <> nil then
      for i := 0 to FTopicList.Count - 1 do
        TTopic(FTopicList[I]).CountDown;
    FTopicList.Clear;
  end;

  if FSelectedBoard <> nil then
  begin
    FSelectedBoard.OnTopicReceived := nil;
    //FSelectedBoard.OnError := nil;
  end;

  // ^Cgo[ύX
  self.Caption := 'Version ' +
                   GetVersionStr();

  if Board <> nil then
  begin
    FSelectedBoard := Board;
    FSelectedBoard.OnTopicReceived := Board_TopicReceived;
    //FSelectedBoard.OnError := Board_TopicReceived;

    // ^Cgo[ύX
    self.Caption := self.Caption + ' [ ' + Board.DisplayName + ' ]';

    // {[hXg{bNX̑IύX

    for I := 0 to gBoardList.Categorys.Count - 1 do
    begin
      category := TBoardCategory(gBoardList.Categorys[I]);
      for J := 0 to category.Boards.Count - 1 do
        if category.Boards[J] = Board then
        begin
          if category.Opened = false then
          begin
            category.Opened := true;
            RefreshBoardListBox;
          end;
          break;
        end;
    end;

    for I := 0 to BoardListBox.Count - 1 do
      if TBoardListBoxItem(FBoardListBoxItems[I]).Board = Board then
      begin
        BoardListBox.Selected[I] := true;
        break;
      end;

    // ǂݍ݊Jn
    if FSelectedBoard is TOnlineBoard then
    begin

      //gBBSCore.DownloadBoard(TOnlineBoard(FSelectedBoard));
      UrlEdit.Text := TOnlineBoard(FSelectedBoard).BoardUrl;
    end;

    FSelectedBoard.Download();
  end;

end;

{ --------------------------------------------------------
  ֐: CloseTab
  pr  : ^u
    : Tab - ^u
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.CloseTab(Index : integer);
var
  Tab : TTopicBrowser;
  select : integer;
  ClosedTabIndex : Integer;
begin

  if (index >= 0) and (index < FBrowserList.Count) then
  begin
    Tab := TTopicBrowser(FBrowserList[index]);

    if TopicTabControl.Tabs.Count = 1 then
      Tab.CloseTopic
    else
    begin
      ClosedTabIndex := TopicTabControl.TabIndex;


      Tab.SaveScrollPosition;
      TopicTabControl.Tabs.Delete(index);
      TopicTabControl.RemoveControl(Tab);
      FBrowserList.Remove(Tab);

      if ClosedTabIndex = index then 
      begin 
        if index > 1 then select := index - 1 else select := 0; 
        TopicTabControl.TabIndex := select; 
      end;
      //Tab.Free;
    end;               

    FOldtab := nil;
    ChangeTab();
  end;

end;

{ --------------------------------------------------------
  ֐: OpenTab
  pr  : {[h^uŊJ
    : Index
  @@@: Board
  @@@: Category
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.OpenTab(Topic: TTopic; newtab: Boolean);
var
  Match       : Boolean;
  ActiveTab   : TTopicBrowser;
  I           : Integer;
  Browser     : TTopicBrowser;
  selectindex : integer;
begin
  selectindex := 0;

  // ɃXbh\ς݂Ȃ炻ANeBuɂ
	Match := false;
	Activetab := nil;
  for I := 0 to TopicTabControl.Tabs.Count - 1 do
  begin
    Browser := TTopicBrowser(FBrowserList[I]);
    if Browser.Topic = Topic then
    begin
		  Activetab := Browser;
      Match := true;
      selectindex := I;
			break;
    end;
  end;

  if Match = false then
    if ((TTopicBrowser(FBrowserList[0]).Topic <> nil) and
       (gAlwaysNewTab or (newtab = true))) then
    begin

      // VJ
			ActiveTab := CreateTopicBrowser();
      ActiveTab.OpenTopic(Topic);
      selectindex := FBrowserList.Count - 1;

    end else
    begin

		  // ANeBuȃ^uŊJ
			ActiveTab := GetActiveTab();
      if ActiveTab = nil then exit;
    	Activetab.OpenTopic(topic);
      selectindex := TopicTabControl.TabIndex;
    end;

  TopicTabControl.TabIndex := selectindex;
  Application.ProcessMessages;

	// ǂݍ݊Jn
  ChangeTab();
	Activetab.Download();

end;

{ --------------------------------------------------------
  ֐: ChangeTab
  pr  : ^uύXꂽ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.ChangeTab;
var
  ActiveTab : TTopicBrowser;
  I         : integer;
  board     : TOnlineBoard;
begin

  try
    ActiveTab := GetActiveTab();
    if ActiveTab = nil then exit;

    if FOldtab <> nil then
      if FOldTab <> ActiveTab then FOldtab.ClearNewMsg;
    FOldtab := ActiveTab;

    if ActiveTab.Topic <> nil then
    begin
      board := TOnlineBoard(ActiveTab.Topic.Board);
      BoardNameLabel.Caption   := '[' + board.DisplayName + ']';
      TopicNameLabel.Left      := BoardNameLabel.Left + BoardNameLabel.Width + 5;
      TopicNameLabel.Caption   := AnsiReplaceText(ActiveTab.Topic.Title, '&', '&&'); 
      MainStatusBar.SimpleText := ActiveTab.Topic.StatusText;
      //AddressTextBox.Text  := activetab.Thread.BrowserUrl;

      if ActiveTab.Topic.IsFavorite then
        FavoriteToolButton.ImageIndex := 18
      else
        FavoriteToolButton.ImageIndex := 19;

      AutoReloadMenuItem.Checked := ActiveTab.AutoReload;

      UrlEdit.Text := ActiveTab.Topic.BrowserUrl;

    end else
    begin
      BoardNameLabel.Caption := '';
      TopicNameLabel.Caption := '';
      MainStatusBar.SimpleText := '';
    end;

    ActiveTab.Visible := true;
    for I := 0 to FBrowserList.Count - 1 do
      if FBrowserList[I] <> ActiveTab then
        TTopicBrowser(FBrowserList[I]).Visible := false;

    // ^uĕ`
    RepaintTabTimer.Enabled := true;
    //Application.ProcessMessages;

  except on Exception do ;
  end;

end;

{ --------------------------------------------------------
  ֐: DownloadTopic
  pr  : ݊JĂ^uXV
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.DownloadTopic;
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
  begin
    ActiveTab.Download;
    RepaintTabTimer.Enabled := true;
  end;

end;

{ --------------------------------------------------------
  ֐: GetActiveTab
  pr  : ANeBuȃ^u擾
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TMainForm.GetActiveTab: TTopicBrowser;
var
  index : integer;
begin

  index := TopicTabControl.TabIndex;
  if (index >= 0) and (index < FBrowserList.Count) then
    result := TTopicBrowser(FBrowserList[index])
  else
    result := nil;

end;

procedure TMainForm.TopicTabControlResize(Sender: TObject);
var
  I : Integer;
  tab : TTopicBrowser;
begin

  if FBrowserList <> nil then
    for I := 0 to FBrowserList.Count - 1 do
    begin
      tab       := TTopicBrowser(FBrowserList[I]);
      tab.Left  := 3;
      tab.Top   := TopicTabControl.TabHeight * TopicTabControl.RowCount + 5;
      tab.Width := TopicTabControl.Width - 6;
      tab.Height:= TopicTabControl.Height - tab.Top - 3;
    end;

end;

{
virtual mode.
procedure TMainForm.TopicListViewCustomDrawSubItem(Sender: TCustomListView;
  Item: TListItem; SubItem: Integer; State: TCustomDrawState;
  var DefaultDraw: Boolean);
var
  R: TRect;
begin
  if Item = nil then Exit;
  if SubItem = 0 then Exit;

  //TopicListView.Canvas.Font.Color := clHighlight;

end;

procedure TMainForm.TopicListViewCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Item = nil then Exit;

  DefaultDraw := true;

end;
}

procedure TMainForm.TopicListViewDrawSubItem(Control: TWinControl;
  var ACanvas: TCanvas; Index, SubItem: Integer; ARect: TRect;
  State: TOwnerDrawState; var DefaultDrawing: Boolean);
begin

  //ACanvas.Font.Color := clHighlight;
  //ACanvas.TextRect(ARect, AREct.Top , Arect.Left , 'test');
  DefaultDrawing := true;
end;

procedure TMainForm.TopicListViewDrawItem(Control: TWinControl;
  var ACanvas: TCanvas; Index: Integer; ARect: TRect;
  State: TOwnerDrawState; var DefaultDrawing, FullRowSelect: Boolean);
begin
  DefaultDrawing := true;
end;

procedure TMainForm.TopicListViewCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  DefaultDraw := true;
  //TopicListView.Canvas.Font.Color := clHighlight;
end;

// URLJ
procedure TMainForm.OpenUrl(Url: string);
var
  parser : T2chUrlParser;
  topic  : TTopic;
  board  : TOnlineBoard;
  navigated     : boolean;
  msgno         : integer;
begin

  navigated := false;

  if AnsiStartsStr('menu://at/', URL) then
  begin
    msgno := StrToIntNeo(CopyAfter(URL, 11));
    FSelectMessageNo := msgno;
    ArticlePopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    exit;
  end;

  parser := T2chUrlParser.Create(Url);
  if parser.Is2chUrl then
  begin
    board := gBoardList.GetBoard(parser.Host, parser.BoardName, true);
    if board <> nil then
      if parser.TopicId <> '' then
      begin
        topic := gBBSCore.GetTopic(board, parser.TopicId);

        if topic.NoIndex = true then
        begin
          gBBSCore.DownloadBoard(board);
          Application.ProcessMessages;
        end;

        OpenTab(topic, (GetAsyncKeyState(VK_SHIFT) < 0));
        navigated := true;
      end else
      begin
        OpenBoard(board);
        navigated := true;
      end;
  end;
  parser.Free;

  // uEUŊJ
  if navigated = false then
    OpenBrowser(Url);

end;

function TMainForm.CreateTopicBrowser: TTopicBrowser;
begin

  if gBrowserType = ubDoe then
    result := TTopicBrowserDoe.Create(self)
  else
    result := TTopicBrowserIE.Create(self);

  result.OnChangeDownloadState := TopicBrowser_ChangeDownloadState;
  result.Visible := false;
  result.Parent  := TopicTabControl;
  result.OnNavigateUrl := TopicBrowser_NavigateUrl;
  FBrowserList.Add(result);
  TopicTabControl.Tabs.Add('');

end;

// {[hꗗ̍č\z 
procedure TMainForm.RefreshBoardListBox; 
var 
  I, J        : Integer; 
  C_Category  : TBoardCategory; 
  newitem     : TBoardListBoxItem; 
  selectindex : integer; 
  menuitem    : TMenuItem; 
  numOfShowItems    : Integer; 
  categoryName      : string; 
  numOfChildBoards  : Integer; 
  newTopIndex       : Integer;
  oldTopIndex       : Integer;
begin

  numOfShowItems    := BoardListBox.Height div BoardListBox.ItemHeight; 
  selectindex       := BoardListBox.ItemIndex; 
  categoryName      := BoardListBox.Items[BoardListBox.ItemIndex]; 
  categoryName      := Copy(categoryName, 3, Length(categoryName) - 1); 
  numOfChildBoards  := 0; 

  oldTopIndex := BoardListBox.TopIndex;
  FBoardListBoxItems.Clear;

  for I := 0 to gBoardList.Categorys.Count - 1 do 
  begin 
    C_Category := TBoardCategory(gBoardList.Categorys[I]); 

    newitem    := TBoardListBoxItem.Create; 
    newitem.ViewString := '' + C_Category.CategoryName; 
    newitem.Category   := C_Category; 
    newitem.Board      := nil; 
    FBoardListBoxItems.Add(newitem); 

    if C_Category.Opened = true then 
      for J := 0 to C_Category.Boards.Count - 1 do 
      begin 
        newitem := TBoardListBoxItem.Create; 
        newitem.ViewString := '@' + TBoard(C_Category.Boards[J]).DisplayName; 
        newitem.Category   := C_Category; 
        newitem.Board      := TBoard(C_Category.Boards[J]); 
        FBoardListBoxItems.Add(newitem); 
        if categoryName = C_Category.CategoryName then 
          Inc(numOfChildBoards); 
      end; 
  end; 

  BoardListBox.Count := FBoardListBoxItems.Count; 
  BoardListBox.ItemIndex := selectindex;
  newTopIndex := oldTopIndex; 

  // scroll to opened category
  if (numOfChildBoards > 0) then
  begin
    // if not enough space
    if numOfChildBoards > numOfShowItems then
    begin
      newTopIndex := selectIndex;
    end
    else if (((selectindex - newTopIndex) + numOfChildBoards + 3) > numOfShowItems) then
    begin
      newTopIndex := (selectindex + numOfChildBoards + 2) - numOfShowItems;
    end;
  end;

  BoardListBox.TopIndex := newTopIndex;

  FavoritePopupMenu.Items.Clear;
  for I := 1 to gBoardList.MyFolder.Boards.Count - 1 do 
  begin
    if not (TBoard(gBoardList.MyFolder.Boards[I]) is TOfflineBoard) then continue;  
    menuitem := TMenuItem.Create(FavoritePopupMenu); 
    menuitem.Caption := TBoard(gBoardList.MyFolder.Boards[I]).DisplayName; 
    menuitem.OnClick := FavoriteMenuItemClick; 
    menuitem.Tag     := I; 
    FavoritePopupMenu.Items.Add(menuitem); 
  end; 

end;


procedure TMainForm.TopicBrowser_NavigateUrl(Sender: TObject; URL: string);
begin
  OpenUrl(URL);
end;

procedure TMainForm.OpenBrowser(URL: string);
begin

  URL := AnsiReplaceText(URL, '[%23]', '#');

  if gUseDefaultBrowser or (gBrowserPath = '') then 
    ShellExecute(Handle, 'OPEN', pchar('URL:' + URL),'', '', SW_SHOWNORMAL) 
  else 
    ShellExecute(Handle, 'OPEN', PChar(gBrowserPath), pchar(URL), '', SW_SHOWNORMAL);
    
end;

procedure TMainForm.TopicBrowser_ChangeDownloadState(Sender: TObject);
begin

  // gsbNXgXV
  RepaintListViewTimer.Enabled := true;

  // ^uĕ`
  RepaintTabTimer.Enabled := true;

  ChangeTab();

end;

procedure TMainForm.RepaintTabTimerTimer(Sender: TObject);
begin
  RepaintTabTimer.Enabled := false;

  TopicTabControl.DoubleBuffered := true;
  TopicTabControl.Repaint;
  TopicTabControl.DoubleBuffered := false;

end;

procedure TMainForm.RepaintListViewTimerTimer(Sender: TObject);
begin
  RepaintListViewTimer.Enabled := false;

  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;

end;

// {^\z
procedure TMainForm.CreateBoardButton;
var
  I, J    : integer;
  button  : TToolButton;
  newmenu : TPopupMenu;
  newmenuitem  : TMenuItem;
  categorymenu : TMenuItem;
  category     : TBoardCategory;
begin

  FBoardButtonMenuList.Clear;

  //
  {
  eraseok := false;
  while eraseok = false do
  begin
    eraseok := true;
    for I := 1 to FBoardButtonList.Count - 1 do
      if FBoardButtonList[I] = 'Q˂' then
      begin
        FBoardButtonList.Delete(I);
        eraseok := false;
        break;
      end;
  end;
  }

  // remove
  for I := 0 to BoardButtonToolBar.ButtonCount - 1 do
  begin
    button := BoardButtonToolBar.Buttons[0];
    BoardButtonToolBar.RemoveControl(button);
    button.Free;
  end;

  //
  for I := FBoardButtonList.Count - 1 downto 0 do
  begin
    button := TToolButton.Create(BoardButtonToolBar);
    button.AutoSize  := true;
    button.Parent    := BoardButtonToolBar;
    button.Caption   := FBoardButtonList[I];
    button.Style     := tbsButton;
    button.OnMouseUp := BoardButtonToolBarMouseUp;

    newmenu := TPopupMenu.Create(BoardButtonToolBar);
    newmenu.AutoHotkeys := maManual;
    button.DropdownMenu := newmenu;
    FBoardButtonMenuList.Add(newmenu);

    if Copy(FBoardButtonList[I], 1, 2) = '' then
    begin

      category := nil;
      for J := 0 to  gBoardList.Categorys.Count - 1 do
      begin
        category := TBoardCategory(gBoardList.Categorys[J]);
        if CopyAfter(FBoardButtonList[I], 3) = category.CategoryName then
          break;
        category := nil;
      end;

      if category <> nil then
        for J := 0 to category.Boards.Count - 1 do
        begin

          newmenuitem := TMenuItem.Create(newmenu);
          newmenuitem.Caption := TBoard(category.Boards[J]).DisplayName;
          newmenuitem.AutoHotkeys := maManual;
          newmenuitem.OnClick := BoardButtonClick;
          newmenu.Items.Add(newmenuitem);
          FBoardButtonMenuList.Add(newmenuitem);
        end;
    end else
      button.OnClick := BoardButtonClick;

  end;

  // Q˂

  button := TToolButton.Create(BoardButtonToolBar);
  button.AutoSize := true;
  button.Parent   := BoardButtonToolBar;
  button.Caption  := 'Q˂';

  newmenu := TPopupMenu.Create(BoardButtonToolBar);
  newmenu.AutoHotkeys := maManual;
  button.DropdownMenu := newmenu;
  FBoardButtonMenuList.Add(newmenu);

  for I := 0 to  gBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(gBoardList.Categorys[I]);
    categorymenu := TMenuItem.Create(newmenu);
    categorymenu.Caption := category.CategoryName;
    newmenu.Items.Add(categorymenu); 
    FBoardButtonMenuList.Add(categorymenu);

    for J := 0 to category.Boards.Count - 1 do
    begin
      newmenuitem := TMenuItem.Create(categorymenu);
      newmenuitem.Caption := TBoard(category.Boards[J]).DisplayName;
      newmenuitem.OnClick := BoardButtonClick;
      categorymenu.Add(newmenuitem);
      FBoardButtonMenuList.Add(newmenuitem);
    end;
  end;

end;

procedure TMainForm.CoolBarResize(Sender: TObject);
var
  I             : integer;
  cl_iditems    : TStringArray;
  cl_breakitems : TStringArray;
  cl_widthitems : TStringArray;
  band          : TCoolBand;
begin

  if FRestoreCoolBands then
  begin
    FRestoreCoolBands := false;

    CoolBar.Bands.BeginUpdate;
    cl_iditems    := Split(gCoolBarBandId, ',');
    cl_breakitems := Split(gCoolBarBandBreak, ',');
    cl_widthitems := Split(gCoolBarBandWidth, ',');
    if (Length(cl_iditems)    >= 3) and
       (Length(cl_breakitems) >= 3) and
       (Length(cl_widthitems) >= 3) then
    begin
      for I := 2 downto 0 do
      begin
        band := TCoolBand(CoolBar.Bands.FindItemID(StrToIntNeo(cl_iditems[i])));
        band.Index := i;
        band.Break := (Trim(UpperCase(cl_breakitems[i])) <> 'FALSE');
        band.Width := StrToIntNeo(cl_widthitems[i]);
      end;
    end;
    CoolBar.Bands.EndUpdate;
  end;

end;

procedure TMainForm.SaveBoardButton;
begin

  FBoardButtonList.SaveToFile(AppPath('favboard.idx')); 

end;

procedure TMainForm.BoardButtonToolBarCustomized(Sender: TObject);
begin

{
  FBoardButtonList.Clear;
  for I := 1 to BoardButtonToolBar.ButtonCount - 1 do
    if BoardButtonToolBar.Buttons[I].Visible = true then
      FBoardButtonList.Add(BoardButtonToolBar.Buttons[I].Caption);

  //CreateBoardButton;
  SaveBoardButton;
  }
end;





procedure TMainForm.ReceiveActiveTabActionExecute(Sender: TObject);
begin
  DownloadTopic;
end;

procedure TMainForm.CloseActiveTabActionExecute(Sender: TObject);
begin
  CloseTabToolButtonClick(CloseTabToolButton);
end;

procedure TMainForm.TabBeforeActionExecute(Sender: TObject);
var
  index : integer;
begin
  index := TopicTabControl.TabIndex;
  if index > 0 then TopicTabControl.TabIndex := index - 1;
  ChangeTab();
end;

procedure TMainForm.TabForwardActionExecute(Sender: TObject);
var
  index : integer;
begin
  index := TopicTabControl.TabIndex;
  if index < TopicTabControl.Tabs.Count - 1 then TopicTabControl.TabIndex := index + 1;
  ChangeTab();
end;

procedure TMainForm.ChangeLimitAllActiveTabExecute(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab = nil then exit;

  ActiveTab.ChangeViewLimit(0);
end;

procedure TMainForm.ChangeStyle1ActionExecute(Sender: TObject);
begin
  StyleSub1ToolButton.Down := not StyleSub1ToolButton.Down;
  StyleChange(StyleSub1ToolButton);
end;

procedure TMainForm.ChangeStyle2ActionExecute(Sender: TObject);
begin
  StyleSub2ToolButton.Down := not StyleSub2ToolButton.Down;
  StyleChange(StyleSub2ToolButton);
end;

procedure TMainForm.ChangeStyle3ActionExecute(Sender: TObject);
begin
  StyleSub3ToolButton.Down := not StyleSub3ToolButton.Down;
  StyleChange(StyleSub3ToolButton);
end;

procedure TMainForm.CreateOfflineFolderClick(Sender: TObject);
var
  createform : TCreateOfflineFolderForm;
  cancel     : boolean;
  foldername : string;
  folderpath : string;
  board      : TStringList;
begin

  createform := TCreateOfflineFolderForm.Create(self);
  createform.ShowModal;
  cancel     := createform.Cancel;
  foldername := createform.FolderName;
  createform.Release;
  createform.Free;

  folderpath := AppPath(foldername + '.idx');

  if AnsiCompareStr(foldername, '') = 0 then 
  begin 
    exit; 
  end;

  if FileExists(folderpath) then
  begin
    ShowMessage('ɓ̑qɂ܂');
    exit;
  end;

  if LastDelimiter('\/:,;*"<>|', foldername) > 0 then
  begin
    ShowMessage('\/:,;*"<>| ͎̕g܂');
    exit;
  end;

  // {[ht@C̍쐬
  board := TStringList.Create;
  board.SaveToFile(folderpath);
  board.Free; 

  gBoardList.Free;
  gBoardList := TBoardList.Create;

  RefreshBoardListBox;

end;

procedure TMainForm.RemoveOfflineFolderClick(Sender: TObject);
var
  index     : Integer;
  item      : TBoardListBoxItem;
  board     : TOfflineBoard;
begin

  index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then exit;

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  if item.Board <> nil then
    if item.Board is TOfflineBoard then
    begin
      board := TOfflineBoard(item.Board);

      // TNƍ폜
      DeleteFile(AppPath(board.DisplayName + '.idx'));

      gBoardList.Free;
      gBoardList := TBoardList.Create;
      RefreshBoardListBox;
      BoardListBoxClick(BoardListBox);
    end;

end;

procedure TMainForm.FavoritePopupMenuPopup(Sender: TObject);
var
  I         : integer;
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  for I := 1 to gBoardList.MyFolder.Boards.Count - 1 do
  begin
    if not (TBoard(gBoardList.MyFolder.Boards[I]) is TOfflineBoard) then continue;
    FavoritePopupMenu.Items[I - 1].Checked := false;
    if ActiveTab <> nil then
      if ActiveTab.Topic <> nil then
        FavoritePopupMenu.Items[I - 1].Checked :=
          TOfflineBoard(gBoardList.MyFolder.Boards[I]).IsHave(ActiveTab.Topic);
  end;
  
end;

procedure TMainForm.FavoriteMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
  board     : TOfflineBoard;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
    begin
      board := TOfflineBoard(gBoardList.MyFolder.Boards[TMenuItem(Sender).Tag]);
      if board.IsHave(ActiveTab.Topic) then
        board.RemoveTopic(ActiveTab.Topic)
      else
        board.AppendTopic(ActiveTab.Topic);
    end;

end;

procedure TMainForm.BoardListBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  index     : integer;
  pos       : TPoint;
begin

    pos.X := x;
    pos.Y := y;
    index := BoardListBox.ItemAtPos(Pos, True);
    if index < 0 then Index := BoardListBox.Count - 1;
    BoardListBox.Selected[index] := True;
end;

procedure TMainForm.TopicTabControlMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var 
  ActiveTab : TTopicBrowser; 
  Index     : Integer;
begin

{

    ActiveTab := GetActiveTab();
    if (ActiveTab = nil) or (ActiveTab.Topic = nil) then
    begin
      ToolTip.UnVisible;
      Exit;
    end;
    Index := GetPointedTab();
    if Index < 0 then Exit;

    //if ToolTip.HintText <> TTopicBrowser(FBrowserList[index]).Topic.Title then
      ToolTip.SetHint(TTopicBrowser(FBrowserList[index]).Topic.Title);

}

end;

procedure TMainForm.TopicTabControlDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  if not (Source is TTabControl) then 
    Accept := False; 
end;

procedure TMainForm.TopicTabControlDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var 
  Index : Integer; 
  temp  : TTopicBrowser;
  PT : TPoint;
begin 
  if not (Sender is TTabControl) then Exit; 

  GetCursorPos(PT); 
  Index := GetTabIndexAtPoint(PT);

  if (Index < 0) or (Index = TopicTabControl.TabIndex) then Exit; 

  FBrowserList.Move(TopicTabControl.TabIndex, Index); 
  TopicTabControl.TabIndex := Index;
  ChangeTab(); 
end;

procedure TMainForm.BoardListBoxDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  if not (Source is TTabControl) then
    Accept := False;
end;

procedure TMainForm.BoardListBoxDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var 
  ActiveTab : TTopicBrowser; 
  TabIndex     : Integer; 
  Index        : Integer; 
  Pos          : TPoint; 
  Board        : TBoard; 
  OfflineBoard : TOfflineBoard; 
  Topic        : TTopic; 
begin 
  ActiveTab := GetActiveTab(); 
  if (ActiveTab = nil) or (ActiveTab.Topic = nil) then Exit;

  TabIndex := (Source as TTabControl).TabIndex; 
  Pos.X := X; 
  Pos.Y := Y; 
  Index := (Sender as TListBox).ItemAtPos(Pos, True); 

  if (Index < 1) or (Index > gBoardList.MyFolder.Boards.Count) then Exit; 

  Board := gBoardList.MyFolder.Boards[Index - 1]; 
  if Board is TOfflineBoard then 
  begin 
    OfflineBoard := TOfflineBoard(Board);
    Topic := TTopicBrowser(FBrowserList[TabIndex]).Topic; 
    if not OfflineBoard.IsHave(Topic) then 
    begin 
      OfflineBoard.AppendTopic(Topic); 
      if FSelectedBoard = OfflineBoard then 
        OpenBoard(OfflineBoard); 
    end; 
  end; 
  TopicTabControl.EndDrag(false); 
end;


{ Topic Priority Related }

procedure TMainForm.SetPriorityMenuItemClick(Sender: TObject); 
var 
  i : Integer; 
  MenuItem : TMenuItem; 
  Item     : TListItem; 
  Topic    : TTopic; 
begin 
  Item := TopicListView.Selected; 
  if Item <> nil then 
  begin 
    Topic    := TTopic(FTopicList[Item.Index]); 
    MenuItem := TMenuItem(Sender); 
    // do check selected priority 
    for i := 0 to MenuItem.Count - 1 do 
      if Topic.Priority = StrToInt(MenuItem[i].Caption) then 
        MenuItem.Items[i].Checked := True; 
  end; 
end; 

procedure TMainForm.SetPriorityPlusItemMenuClick(Sender: TObject);
var
  Priority : Integer; 
  MenuItem : TMenuItem; 
begin 
  MenuItem := TMenuItem(Sender); 
  Priority := StrToInt(MenuItem.Caption); 
  SetSelectedTopicPriority(Priority); 
end; 


// do enable if need
// vȂĂˁH(noname)
procedure TMainForm.TopicListViewPopupMenuPopup(Sender: TObject);
var
  i : Integer;
  Item  : TListItem;
begin

{

  Item := TopicListView.Selected;
  if Item <> nil then
  begin
    for i := 0 to TopicListViewPopupMenu.Items.Count - 1 do
      TopicListViewPopupMenu.Items[i].Enabled := True;

    // if not yet retrieved
    if TTopic(FTopicList[Item.Index]).GotMessageCount = 0 then
      SetPriorityMenuItem.Enabled := False;
  end
  else begin
    for i := 0 to TopicListViewPopupMenu.Items.Count - 1 do
      TopicListViewPopupMenu.Items[i].Enabled := False;
  end;

}

end;

procedure TMainForm.SetSelectedTopicPriority(Priority : Integer); 
var 
  Topic : TTopic; 
  Item  : TListItem; 
begin 
  Item := TopicListView.Selected; 
  if Item <> nil then 
  begin 
    Topic := TTopic(FTopicList[Item.Index]); 
    if Topic.Priority <> Priority then 
    begin 
      Topic.Priority := Priority; 
      Topic.SaveIdx(); 
      TopicListView.Repaint; 
    end; 
  end;
end; 
{ /Topic Priority Related }

procedure TMainForm.TopicPagePopupMenuPopup(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
  i : Integer;
begin
    ActiveTab := GetActiveTab();
    if (ActiveTab = nil) or (ActiveTab.Topic = nil) then
      for i := 0 to TopicPagePopupMenu.Items.Count - 1 do
        TopicPagePopupMenu.Items[i].Enabled := False
    else
      for i := 0 to TopicPagePopupMenu.Items.Count - 1 do
        TopicPagePopupMenu.Items[i].Enabled := True;

end;

// wʒũ^uCfbNX擾 
function TMainForm.GetTabIndexAtPoint(Point : TPoint) : Integer; 
var 
  Info  : TTCHitTestInfo; 
begin 
  Info.pt := TopicTabControl.ScreenToClient(Point); 
  Info.flags := TCHT_ONITEM; 
  result := TabCtrl_HitTest(TopicTabControl.Handle, @Info); 
end; 


// wʒũ^u擾 
function TMainForm.GetTabAtPoint(Point : TPoint) : TTopicBrowser; 
var 
  index : Integer; 
begin 
  index := GetTabIndexAtPoint(Point); 
  if (index >= 0) and (index < FBrowserList.Count) then 
    result := TTopicBrowser(FBrowserList[index]) 
  else 
    result := nil; 
end;

// {^ҏWtH[̕\ 
procedure TMainForm.EditBoardButtonMenuItemClick(Sender: TObject); 
var 
  Point : TPoint;
  EditBoardButtonForm : TEditBoardButtonForm;
begin 
  // FBoardButtonList ܂BfsłB 
  EditBoardButtonForm := TEditBoardButtonForm.Create(self); 
  GetCursorPos(point); 
  EditBoardButtonForm.Left := Point.X - EditBoardButtonForm.Width div 2; 
  EditBoardButtonForm.Top  := Point.Y - EditBoardButtonForm.Height div 3; 
  EditBoardButtonForm.BoardButtonList := FBoardButtonList;
  EditBoardButtonForm.ShowModal;
  if not EditBoardButtonForm.Cancel then 
  begin 
    CreateBoardButton(); 
    SaveBoardButton(); 
  end; 
  EditBoardButtonForm.Free; 
end;

procedure TMainForm.OpenAllCategoryActionExecute(Sender: TObject);
var
  I : integer;
begin

  for I := 0 to gBoardList.Categorys.Count - 1 do
    TBoardCategory(gBoardList.Categorys[I]).Opened := true;  

  RefreshBoardListBox;

end;

procedure TMainForm.CloseAllCategoryActionExecute(Sender: TObject);
var
  I : integer;
begin

  for I := 0 to gBoardList.Categorys.Count - 1 do
    TBoardCategory(gBoardList.Categorys[I]).Opened := false;  

  RefreshBoardListBox;

end;

procedure TMainForm.InputMemoMenuItemClick(Sender: TObject);
var 
  Item  : TListItem; 
  Topic : TTopic; 
  Memo  : string; 
begin 
  Item := TopicListView.Selected; 
  if Item <> nil then 
  begin 
    Topic := TTopic(FTopicList[Item.Index]); 
    Memo  := InputBox('', Topic.Title, Topic.Memo); 
    if Memo <> Topic.Memo then 
    begin 
      Topic.Memo := Memo; 
      Topic.SaveIdx(); 
      TopicListView.Repaint; 
    end; 
  end;
end;

procedure TMainForm.LogSweeperActionExecute(Sender: TObject);
var
  LogSweeperForm : TLogSweeperForm;
begin
  LogSweeperForm := TLogSweeperForm.Create(self);
  LogSweeperForm.ShowModal;
  LogSweeperForm.Free;
end;

procedure TMainForm.FormIdle(Sender: TObject; var Done: Boolean); 
var 
  P : TPoint; 
  Control, CaptureControl : TControl; 
  ActiveTab : TTopicBrowser; 
  i : Integer; 
begin

  if (gAutoFocus = false) or
     (FActive = false) then exit;

  GetCursorPos(P); 
  Control := FindDragTarget(P, True); 

  if FMouseControl <> Control then 
  begin 
    FMouseControl := Control; 
    if FMouseControl = BoardListBox then 
      BoardListBox.SetFocus 
    else if FMouseControl = TopicListView then
    begin
      BoardListBox.SetFocus; // ̂̍sȂƃuEUListViewœȂ
      TopicListView.SetFocus;
    end else
    if FMouseControl is TWebBrowser then
    begin
      ActiveTab := GetActiveTab(); 
      if ActiveTab <> nil then 
        for i := 0 to ActiveTab.ComponentCount - 1 do 
          if ActiveTab.Components[i] is TWebBrowser then 
            if TWebBrowser(ActiveTab.Components[i]).document <> nil then 
              olevariant(TWebBrowser(ActiveTab.Components[i]).document).parentWindow.focus; 
    end; 
  end; 
end;

procedure TMainForm.FormDeactivate(Sender: TObject);
begin
  FActive := false;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  FActive := true;
end;

end.

