unit untSearchForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type

  TSearchFormResult = (srFromTopic, srFromTopicList, srFromBoardList, srCancel);

  TSearchForm = class(TForm)
    Label1: TLabel;
    SearchEdit: TEdit;
    FromTopicListRadioButton: TRadioButton;
    FromBoardListRadioButton: TRadioButton;
    SearchButton: TButton;
    CancelButton: TButton;
    FromTopicRadioButton: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure SearchButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    SearchSelect : TSearchFormResult;
  end;

var
  SearchForm: TSearchForm;

implementation

{$R *.dfm}

procedure TSearchForm.FormCreate(Sender: TObject);
begin
  SearchEdit.Text := '';
  FromTopicListRadioButton.Checked := true;
end;

procedure TSearchForm.SearchButtonClick(Sender: TObject);
begin

  if SearchEdit.Text = '' then
  begin
    SearchSelect := srCancel;
  end else
  begin

    if FromTopicRadioButton.Checked then
      SearchSelect := srFromTopic
    else if FromTopicListRadioButton.Checked then
      SearchSelect := srFromTopicList
    else
      SearchSelect := srFromBoardList;
  end;

  Close();
end;

procedure TSearchForm.CancelButtonClick(Sender: TObject);
begin
  SearchSelect := srCancel;
  Close();
end;

end.
