unit untAllSubscribedTopicsLoadThread;

interface

uses
  Classes, SysUtils, StrUtils,
  RegExpr,
  untBoard, untTopic, untOption, untGlobal;

type

  TAllSubscribedTopicsLoadThread = class(TThread)
  private
    FBoard           : TAllSubscribedTopics;
    procedure LoadLog(const path: string); 
  public
    constructor Create(Board : TAllSubscribedTopics);
    destructor  Destroy; override;
    procedure   Execute; override;
  end;

implementation

{ TAllSubscribedTopicsLoadThread }

constructor TAllSubscribedTopicsLoadThread.Create(Board: TAllSubscribedTopics);
begin
  inherited Create(true);

  FBoard := Board;

end;

destructor TAllSubscribedTopicsLoadThread.Destroy;
begin
  inherited;
end;

procedure TAllSubscribedTopicsLoadThread.Execute;
var 
  path : string;
begin

  FBoard.IsDownloading := true;

  path := DIR_LOG;
  if AnsiEndsText('\', DIR_LOG) then
    path := Copy(path, 0, Length(path) - 1);
  LoadLog(path);

  FBoard.IsDownloading := false;

  Terminate;

end;

//  vCx[g֐  

{ -------------------------------------------------------- 
  ֐: LoadLog 
  pr  : O̓ǂݍ 
    : Ȃ 
  ߂l: Ȃ 
  l  : Ȃ 
  ------------------------------------------------------ } 
procedure TAllSubscribedTopicsLoadThread.LoadLog(const path: string); 
var 
  Regex      : TRegExpr; 
  searchRec  : TSearchRec; 
  foundPath  : string; 
  server     : string; 
  boardname  : string; 
  topicid    : string; 
  board      : TOnlineBoard; 
  Topic      : TTopic; 
begin 
  Regex := TRegExpr.Create; 
  Regex.Expression := '^' + DIR_LOG + '\' + '(.+?)\\(.+?)\\(.+?)\.i'; 

  if FindFirst(path +  '\*.*', faAnyFile, searchRec) = 0 then 
  begin 
    repeat 
      if (searchRec.Name <> '.') and (searchRec.Name <> '..') then 
      begin 

        foundPath := path + '\' + searchRec.Name; 

        if (searchRec.Attr and faDirectory) <> 0 then 
          LoadLog(foundPath); 

        if AnsiEndsText('.i', searchRec.Name) then 
        begin 
          // gsbN̓ǂݍ 
          if Regex.Exec(foundPath) then 
          begin 
            server    := Regex.Substitute('$1'); 
            boardname := Regex.Substitute('$2'); 
            topicid   := Regex.Substitute('$3'); 
            board := gBoardList.GetBoard(server, boardname); 

            Topic := gBBSCore.GetTopic(board, topicid); 
            //Topic.CountUp;
            FBoard.AddTopic(Topic); 
          end; 
        end; 

      end; 
    until FindNext(searchRec) <> 0; 
    FindClose(searchRec); 
  end; 

  Regex.Free; 
end;

end.

