unit untTaskThread;

interface

uses
  Classes, SysUtils, Dialogs, Contnrs,
  untTopic, untBoard;

type

  TTaskType = (tsDownloadTopic, tsDownloadBoard, tsLogLoadTopic, tsAllSubscribedTopics);
  TTaskItem = class
  public
    Topic    : TTopic;
    Board    : TBoard;
    TaskType : TTaskType;
  end;

  TTaskThread = class(TThread)
  private
    FTaskList : TThreadList;
  public
    procedure   Execute; override;
    constructor Create(TaskList : TThreadList);
    destructor  Destroy; override;
  end;

implementation

uses
  untTopicDownloadThread, untBoardDownloadThread,
  untAllSubscribedTopicsLoadThread;
{ TTaskThread }

constructor TTaskThread.Create(TaskList : TThreadList);
begin
  inherited Create(true);

  FTaskList := TaskList;

end;

destructor TTaskThread.Destroy;
begin

  inherited;
end;

procedure TTaskThread.Execute;
var
  Tasks : TList;
  Task  : TTaskItem;
  I     : integer;
  DownloadThread : TThread;
  NoTask : Boolean;
begin
  inherited;

  repeat

    NoTask := true;
    Tasks := FTaskList.LockList;

    for I := 0 to Tasks.Count - 1 do
    begin
      Task   := TTaskItem(Tasks[I]);
      NoTask := false;

      // ^XN
      case Task.TaskType of

        tsDownloadBoard :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TBoardDownloadThread.Create(TOnlineBoard(Task.Board));
          DownloadThread.Priority := tpNormal;
          DownloadThread.FreeOnTerminate := true;
          DownloadThread.Resume;

        end;

        tsDownloadTopic :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TTopicDownloadThread.Create(Task.Topic, false);
          DownloadThread.Priority := tpNormal;
          DownloadThread.FreeOnTerminate := true;
          DownloadThread.Resume;

        end;

        tsLogLoadTopic :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TTopicDownloadThread.Create(Task.Topic, true);
          DownloadThread.Priority := tpNormal;
          DownloadThread.FreeOnTerminate := true;
          DownloadThread.Resume;

        end;

        tsAllSubscribedTopics :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TAllSubscribedTopicsLoadThread.Create(TAllSubscribedTopics(Task.Board));
          DownloadThread.Priority := tpNormal;
          DownloadThread.FreeOnTerminate := true;
          DownloadThread.Resume;

        end;

      end;

    end;

    for I := 0 to Tasks.Count - 1 do 
        TTaskItem(Tasks.Items[I]).Free;

    Tasks.Clear;
    FTaskList.UnlockList;

    if Terminated then break;
    if NoTask then self.Suspend;

  until false;

  Terminate;

end;

end.
