unit untBrowserFrame;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, SHDocVw_TLB, ComCtrls,
  untTopic, untOption;

type

  TBrowserFrame = class(TFrame)
    Browser: TWebBrowser;
    procedure Browser1DocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
  private
    { Private 錾 }
    FTopic        : TTopic;
    FLogLoaded    : Boolean;
    FOutputBuffer : string;
    FNoScroll     : Boolean;
    FWaitAbout    : Boolean;
    procedure SetTopic(const Value: TTopic);
    procedure ReceiveArticle(Sender : TObject; Article : TTopic);
    procedure BrowserOutput(OutputText : string);
    procedure SaveScrollPos;
  public
    { Public 錾 }
    property  Topic : TTopic read FTopic write SetTopic;
    procedure Download();
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

implementation

{$R *.DFM}

{ vpeB }

procedure TBrowserFrame.SetTopic(const Value: TTopic);
var
  MyTabSheet : TTabSheet;
begin

  if FTopic <> nil then
  begin
    //FTopic.OnReceiveArticle := nil;
    //FTopic.View := false;
    SaveScrollPos;
  end;

  FTopic := Value;
  MyTabSheet := TTabSheet(self.Parent);
  if FTopic = nil then
  begin

    FWaitAbout := false;
    Browser.Navigate('about:blank');
    MyTabSheet.Caption := '';
  
  end else
  begin

    //FTopic.View := true;
    //FTopic.OnReceiveArticle := ReceiveArticle;
    //FLogLoaded   := false;

    //MyTabSheet.Caption := FTopic.Title;
  end;

end;

{ \bh }

// -----------------------------------------------------
// ֐ : Download
// @ : Xbh̃_E[hJn
// @ : Board - J
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure TBrowserFrame.Download;
begin

  FNoScroll := true;
  if FTopic = nil then exit;
  //if FTopic.Viewed = true then
  //  FTopic.DownloadStart
  //else
  //begin
  //  FWaitAbout := true;
  //  Browser1.Navigate('about:blank');
  //end;

end;

{ vCx[g֐ }

// -----------------------------------------------------
// ֐ : ReceiveArticle
// @ : ݂̎M
// @ : Article
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure TBrowserFrame.ReceiveArticle(Sender: TObject;
  Article: TTopic);
var
  strOut : string;
  doc    : Variant;
begin

  //if Article.NewArticle = true then
  //  strOut := gNewResHtml
  //else
  //  strOut := gResHtml;

  //doc := Browser1.Document;

  {
  strOut := StringReplace(strOut, '&NUMBER', IntToStr(Article.ArticleNumber), [rfReplaceAll]);
  strOut := StringReplace(strOut, '&MAILNAME', Article.Author, [rfReplaceAll]);
  strOut := StringReplace(strOut, '&DATE', Article.RestStr, [rfReplaceAll]);
  strOut := StringReplace(strOut, '&MESSAGE', Article.Body, [rfReplaceAll]);
  doc.Write(strOut + #13#10);
  }

  // XN[
  {
  if FNoScroll = true then
    if doc.body.scrollHeight > FTopic.BrowserScrollPosition then
    begin
      FNoScroll := false;
      doc.parentWindow.scroll(0, FTopic.BrowserScrollPosition);
    end;
  }

end;

// -----------------------------------------------------
// ֐ : BrowserOutput
// @ : uEUɕo͂
// @ : OutputText - o͂镶
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure TBrowserFrame.BrowserOutput(OutputText: string);
var
 sl: TStringList;
 ms: TMemoryStream;
 doc: Variant;
begin

  doc := Browser.Document;
  doc.Write(Outputtext);
  //Application.ProcessMessages;

end;

// -----------------------------------------------------
// ֐ : Create
// @ : RXgN^
// @ : AOwner
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
constructor TBrowserFrame.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

end;

// -----------------------------------------------------
// ֐ : Destroy
// @ : fXNgN^
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
destructor TBrowserFrame.Destroy;
begin
  SaveScrollPos;
  inherited;

end;

procedure TBrowserFrame.Browser1DocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin

  if FWaitAbout = true then
  begin
    BrowserOutput(gHeaderHtml);
    //FTopic.DownloadStart;
  end;
  FWaitAbout := false;

end;



procedure TBrowserFrame.SaveScrollPos;
var 
  doc: Variant;
begin

  // XN[ʒuoĂ
  {
  if Assigned(Browser1.Document)  then
  begin
    doc := Browser1.Document;
    FTopic.BrowserScrollPosition := doc.body.scrollTop;
  end;
  }

end;

end.
