unit untCrypt;

interface

uses
  Classes,
  UCrypt, UBase64;

function Crypt(PlainText : string) : string;
function Decrypt(Crypted : string) : string;

implementation

function Crypt(PlainText : string) : string;
var
  Crypt : THogeCrypt;
  inputStream, outputStream: TStringStream;
begin

  if PlainText <> '' then
  begin
    inputStream  := TStringStream.Create(PlainText);
    outputStream := TStringStream.Create('');
    Crypt := THogeCrypt.Create;

    Crypt.Encrypt(inputStream, '', outputStream);
    result := HogeBase64Encode(outputStream.DataString);
  end else
    result := '';

end;

function Decrypt(Crypted : string) : string;
var
  Crypt : THogeCrypt;
  inputStream, outputStream: TStringStream;
begin

  if Crypted <> '' then
  begin
    inputStream  := TStringStream.Create(HogeBase64Decode(Crypted));
    outputStream := TStringStream.Create('');
    Crypt := THogeCrypt.Create;

    Crypt.Decrypt(inputStream, '', outputStream);
    result := outputStream.DataString;
  end else
    result := '';

end;


end.
