unit untDolibLogin;

// O[oϐ܂B

interface

uses
  Dialogs,
  Dolib,
  untLoginForm,
  untOption;

type
  TDolibLogin = class
  private
    FSessionId : string;
    FUserAgent: string;
    procedure SetSessionId(const Value: string);
    procedure SetUserAgent(const Value: string);
  public
    property    SessionId : string read FSessionId write SetSessionId;
    property    UserAgent : string read FUserAgent write SetUserAgent;
    function    Login() : boolean;
    constructor Create;
    destructor  Destroy; override;
  end;

implementation

{ TDolibLogin }

constructor TDolibLogin.Create;
begin
end;

destructor TDolibLogin.Destroy;
begin

  inherited;
end;

// OC
function TDolibLogin.Login : boolean;
var
  Login     : TDolib;
  SessionId : string;
  UserAgent : string;
  ErrorMsg  : string;
  ErrorCode : integer;
begin

  result := false;

  Login := TDolib.Create;
  Login.UserName := gUserId;
  Login.Password := gPassword;
  Login.ClientUA := APP_2chUA;
  if  (not Login.Connect) then  begin
    ShowMessage(Login.ErrorMsg);
  end else begin
    SessionId := Login.SessionID;
    UserAgent := Login.UserAgent;
    ErrorMsg  := Login.ErrorMsg;
    ErrorCode := Login.ErrorCode;
    if ErrorCode <> 0 then
      ShowMessage(Login.ErrorMsg)
    else
      result := true;

    Login.Disconnect;
  end;
  Login.Free;

  if SessionId <> '' then
    gSessionId := SessionId;

  if UserAgent <> '' then
    gUserAgent := UserAgent; 

end;

procedure TDolibLogin.SetSessionId(const Value: string);
begin
  FSessionId := Value;
end;

procedure TDolibLogin.SetUserAgent(const Value: string);
begin
  FUserAgent := Value;
end;

end.
