#include "main.h"
#include <kapp.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include <qfile.h>
#include <qdir.h>
#include <qurl.h>
#include <qpushbutton.h>
#include <qptrlist.h>

static KCmdLineOptions options[] =
{
    {"s",0,0},
    {"iconsize <iconsize>",I18N_NOOP("iconsize"),"90"},
    {"w",0,0},
    {"iconwidth <iconwidth>",I18N_NOOP("iconwidth"),0},
    {"r",0,0},
    {"remove",I18N_NOOP("remove"),0},
    {"R",0,0},
    {"recursive <recursive>",I18N_NOOP("recursive"),"0"},
    {"a",0,0},
    {"auto",I18N_NOOP("autosize"),0},
    {"d",0,0},
    {"default",I18N_NOOP("defaultsize"),0},
    {"+[Files]",I18N_NOOP("files"),0 },
    {0,0,0 }
};

static bool autoMode = false;


void addfilelist(ThumbnailManager *list,KURL url,
        unsigned int iconsize,unsigned int iconwidth,int recursive)
{
//    QUrl i = url.url();
    kdDebug() << url.url() << endl;
    if (url.isLocalFile()) {
        if (recursive != 0) {
            QDir d(QDir::cleanDirPath(url.path()));
            kdDebug() << "RECURSIVE :" << url.path()  << endl;
            QStringList dfile = d.entryList("*");
            if (dfile.count() != 0) {
                for (unsigned int j = 0;j != dfile.count();j ++) {
                    if (dfile[j][0] != '.')
                        addfilelist(list,url.path() + "/" + dfile[j],iconsize,iconwidth,recursive - 1);
                }
            }
        }
    }
    if (autoMode && url.isLocalFile()) {
        KSimpleConfig * config = new KSimpleConfig(QDir::cleanDirPath(url.directory()) + "/.directory",true);
        kdDebug() << QDir::cleanDirPath(url.directory()) << "/.directory" << endl;
        config->setGroup("URL properties");
        unsigned int s = config->readNumEntry("IconSize",iconsize);
        if (s >= 48) iconsize = ICON_LARGE;
        else if (s >= 32) iconsize = ICON_MED;
        else iconsize = ICON_SMALL;
        kdDebug() << "AutoIconSize: " << s << ":" << iconsize << endl;
        delete config;
    }
        
    list->addFile(url.url(),iconsize,iconwidth);
};
    


int main(int argc,char **argv) {
    KAboutData about("kthumbnailmanager",I18N_NOOP("KThumbnailManager"),
        "0.1",I18N_NOOP("kthumbnailmanager"),KAboutData::License_GPL,
        "(c) 2003, TAM");
    ThumbnailManager *preview;

    KCmdLineArgs::init(argc,argv,&about);
    KCmdLineArgs::addCmdLineOptions(options);

    
    KApplication app;

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    unsigned int iconsize = args->getOption("iconsize").toUInt();
    unsigned int iconwidth = args->getOption("iconwidth").toUInt();
    int recursive = args->getOption("recursive").toInt();
    if ((args->isSet("default")) || (autoMode = args->isSet("auto"))) {
        KConfig * config = new KConfig("konqiconviewrc",true,true);
        config->setGroup("Settings");
        unsigned int s = config->readNumEntry("IconSize",64);
        if (s >= 48) iconsize = ICON_LARGE;
        else if (s >= 32) iconsize = ICON_MED;
        else iconsize = ICON_SMALL;
        kdDebug() << "DefaultIconSize: " << iconsize << endl;
        delete config;
    }
    
    KThumbnailManagerDialog *dialog = new KThumbnailManagerDialog();
    
    dialog->show();

    preview = dialog->thumbnailmanager;

    if (args->count()) {
        for (int i = 0;i != args->count();i ++) {
            addfilelist(preview,args->url(i),iconsize,iconwidth,recursive);
            //QListViewItem * item = new QListViewItem(dialog->widget->Filelist,args->url(i).url());
        }
    } else {
//        exit(0);
    }
    if (args->isSet("remove")) {
        preview->remove();
        exit(0);
    }
        QObject::connect(dialog,SIGNAL(complete()),&app,SLOT(quit()));
    
        args->clear();
        emit preview->start();
        app.exec();


}
