# -*-perl-*-
# Keitairc::ClientInfo
# $Id: ClientInfo.pm,v 1.2 2008/01/19 12:39:44 morimoto Exp $
# $Source: /cvsroot/keitairc/lib/Keitairc/ClientInfo.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::ClientInfo;
use strict;

################################################################
sub new{
	my $proto = shift;
	my $arg = shift;
	my $me = {};

	for my $key (keys %{$arg->{_headers}}){
		my $ukey = $key;
		$ukey =~ s/-/_/g;
		$me->{header}->{$ukey} = $arg->{_headers}->{$key};
	}

	for my $set (split(/; */, $me->{header}->{Cookie})){
		my ($name, $value) = split(/=/, $set);
		$value =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('C', hex($1))/eg;
		$me->{cookie}->{$name} = $value;
	}

        bless $me;
	$me->{serial_key} = $me->serial_key();
	$me;
}

################################################################
sub user_agent{
	my $me = shift;
	$me->{header}->{user_agent};
}

################################################################
sub is_ezweb{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^KDDI-/;
}

################################################################
sub is_docomo{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^DoCoMo/;
}

################################################################
sub is_ipod{
	my $me = shift;
	$me->{header}->{user_agent} =~ /(iPod|iPhone)/;
}

################################################################
sub is_softbank{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^(SoftBank|Vodafone|J-PHONE|MOT-)/;
}

################################################################
sub softbank_serial{
	my $me = shift;
	if($me->is_softbank()){
		if($me->{header}->{user_agent} =~ m|/(SN[0-9A-Z]+)|){
			return $1;
		}
	}
}

################################################################
sub docomo_foma_icc{
	my $me = shift;
	if($me->is_docomo()){
		# NTT DoCoMoFOMAü¤ֹ (15Υˡʱѿ) 
		# FOMA¤ֹ (20Υˡʱѿ)
		# http://www.nttdocomo.co.jp/service/imode/make/content/html/tag/utn.html
		# ºݤˤlower caseȤƤ褦ʤΤ
		# DoCoMo/2.0 P703imyu(c100;TB;W30H15)
		# DoCoMo/2.0 P703imyu(c100;TB;W30H15;ser12345ABCDE12345;icc12345ABCDE12345abcde)
		if($me->{header}->{user_agent} =~ /;(icc[0-9a-zA-Z]{20})/){
			return $1;
		}
	}
}

################################################################
sub subscribe_id{
	my $me = shift;
	$me->{header}->{x_up_subno};
}

################################################################
sub serial_key{
	my $me = shift;
	if($me->is_softbank()){
		return $me->softbank_serial();
	}
	if($me->is_ezweb()){
		return $me->subscribe_id();
	}
}

################################################################
# Cookie򰷤뤫ɤ
# Ȥꤢ Cookie μ¤˰ʤ DoCoMo ȽꤷƤ
sub cookie_available{
	my $me = shift;
	unless($me->is_docomo()){
		return 1;
	}
}

1;
