/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import java.io.IOException;
import java.io.InputStream;

public class VorbisFile2 {
    private static final int CHUNKSIZE = 8500;
    private static final int OV_FALSE = -1;
    private static final int OV_EOF = -2;
    private static final int OV_EREAD = -128;
    private static final int OV_EFAULT = -129;
    private static final int OV_ENOTVORBIS = -132;
    SeekableInputStream datasource;
    long offset;
    long end;
    SyncState oy = new SyncState();
    int links;
    long[] offsets;
    long[] dataoffsets;
    int[] serialnos;
    long[] pcmlengths;
    Info[] vi;
    Comment[] vc;
    long pcm_offset;
    boolean decode_ready;
    int current_serialno;
    int current_link;
    float bittrack;
    float samptrack;
    StreamState os = new StreamState();
    DspState vd = new DspState();
    Block vb = new Block(this.vd);

    public VorbisFile2(InputStream is, byte[] initial, int ibytes) throws JOrbisException, IOException {
        try {
            SeekableInputStream sis = new SeekableInputStream(is);
            int ret = this.open(sis, initial, ibytes);
            if (ret == -1) {
                throw new JOrbisException("VorbisFile: open return -1");
            }
        }
        catch (Exception e) {
            throw new JOrbisException("VorbisFile: " + e.toString());
        }
    }

    private final int get_data() {
        int index = this.oy.buffer(8500);
        byte[] buffer = this.oy.data;
        int bytes = 0;
        try {
            bytes = this.datasource.read(buffer, index, 8500);
        }
        catch (Exception e) {
            return -128;
        }
        this.oy.wrote(bytes);
        if (bytes == -1) {
            bytes = 0;
        }
        return bytes;
    }

    private final void seek_helper(long offst) {
        try {
            this.datasource.seek(offst);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.offset = offst;
        this.oy.reset();
    }

    private final int get_next_page(Page page, long boundary) {
        int ret;
        int more;
        block6: {
            if (boundary > 0L) {
                boundary += this.offset;
            }
            while (true) {
                if (boundary > 0L && this.offset >= boundary) {
                    return -1;
                }
                more = this.oy.pageseek(page);
                if (more < 0) {
                    this.offset -= (long)more;
                    continue;
                }
                if (more != 0) break block6;
                if (boundary == 0L) {
                    return -1;
                }
                ret = this.get_data();
                if (ret == 0) {
                    return -2;
                }
                if (ret < 0) break;
            }
            return -128;
        }
        ret = (int)this.offset;
        this.offset += (long)more;
        return ret;
    }

    private final int get_prev_page(Page page) throws JOrbisException {
        int ret;
        long begin = this.offset;
        int offst = -1;
        block0: while (offst == -1) {
            if ((begin -= 8500L) < 0L) {
                begin = 0L;
            }
            this.seek_helper(begin);
            while (this.offset < begin + 8500L) {
                ret = this.get_next_page(page, begin + 8500L - this.offset);
                if (ret == -128) {
                    return -128;
                }
                if (ret < 0) {
                    if (offst != -1) continue block0;
                    throw new JOrbisException();
                }
                offst = ret;
            }
        }
        this.seek_helper(offst);
        ret = this.get_next_page(page, 8500L);
        if (ret < 0) {
            return -129;
        }
        return offst;
    }

    private final int bisect_forward_serialno(long begin, long searched, long end, int currentno, int m) {
        int ret;
        long endsearched = end;
        long next = end;
        Page page = new Page();
        while (searched < endsearched) {
            long bisect = endsearched - searched < 8500L ? searched : (searched + endsearched) / 2L;
            this.seek_helper(bisect);
            ret = this.get_next_page(page, -1L);
            if (ret == -128) {
                return -128;
            }
            if (ret < 0 || page.serialno() != currentno) {
                endsearched = bisect;
                if (ret < 0) continue;
                next = ret;
                continue;
            }
            searched = ret + page.header_len + page.body_len;
        }
        this.seek_helper(next);
        ret = this.get_next_page(page, -1L);
        if (ret == -128) {
            return -128;
        }
        if (searched >= end || ret == -1) {
            this.links = m + 1;
            this.offsets = new long[m + 2];
            this.offsets[m + 1] = searched;
        } else {
            ret = this.bisect_forward_serialno(next, this.offset, end, page.serialno(), m + 1);
            if (ret == -128) {
                return -128;
            }
        }
        this.offsets[m] = begin;
        return 0;
    }

    private final int fetch_headers(Info vi, Comment vc, int[] serialno, Page og_ptr) {
        Page og = new Page();
        Packet op = new Packet();
        if (og_ptr == null) {
            int ret = this.get_next_page(og, 8500L);
            if (ret == -128) {
                return -128;
            }
            if (ret < 0) {
                return -132;
            }
            og_ptr = og;
        }
        if (serialno != null) {
            serialno[0] = og_ptr.serialno();
        }
        this.os.init(og_ptr.serialno());
        vi.init();
        vc.init();
        int i = 0;
        while (i < 3) {
            this.os.pagein(og_ptr);
            while (i < 3) {
                int result = this.os.packetout(op);
                if (result == 0) break;
                if (result == -1) {
                    vi.clear();
                    vc.clear();
                    this.os.clear();
                    return -1;
                }
                if (vi.synthesis_headerin(vc, op) != 0) {
                    vi.clear();
                    vc.clear();
                    this.os.clear();
                    return -1;
                }
                ++i;
            }
            if (i >= 3 || this.get_next_page(og_ptr, 1L) >= 0) continue;
            vi.clear();
            vc.clear();
            this.os.clear();
            return -1;
        }
        return 0;
    }

    private final void prefetch_all_headers(Info first_i, Comment first_c, int dataoffset) throws JOrbisException {
        Page og = new Page();
        this.vi = new Info[this.links];
        this.vc = new Comment[this.links];
        this.dataoffsets = new long[this.links];
        this.pcmlengths = new long[this.links];
        this.serialnos = new int[this.links];
        int i = 0;
        while (i < this.links) {
            block6: {
                if (first_i != null && first_c != null && i == 0) {
                    this.vi[i] = first_i;
                    this.vc[i] = first_c;
                    this.dataoffsets[i] = dataoffset;
                } else {
                    this.seek_helper(this.offsets[i]);
                    this.vi[i] = new Info();
                    this.vc[i] = new Comment();
                    if (this.fetch_headers(this.vi[i], this.vc[i], null, null) == -1) {
                        this.dataoffsets[i] = -1L;
                    } else {
                        this.dataoffsets[i] = this.offset;
                        this.os.clear();
                    }
                }
                long end = this.offsets[i + 1];
                this.seek_helper(end);
                do {
                    int ret;
                    if ((ret = this.get_prev_page(og)) != -1) continue;
                    this.vi[i].clear();
                    this.vc[i].clear();
                    break block6;
                } while (og.granulepos() == -1L);
                this.serialnos[i] = og.serialno();
                this.pcmlengths[i] = og.granulepos();
            }
            ++i;
        }
    }

    private final int make_decode_ready() {
        if (this.decode_ready) {
            System.exit(1);
        }
        this.vd.synthesis_init(this.vi[0]);
        this.vb.init(this.vd);
        this.decode_ready = true;
        return 0;
    }

    private final int open_seekable() throws JOrbisException {
        Info initial_i = new Info();
        Comment initial_c = new Comment();
        Page og = new Page();
        int[] foo = new int[1];
        int ret = this.fetch_headers(initial_i, initial_c, foo, null);
        int serialno = foo[0];
        int dataoffset = (int)this.offset;
        this.os.clear();
        if (ret == -1) {
            return -1;
        }
        if (ret < 0) {
            return ret;
        }
        long end = this.datasource.getLength();
        end = this.get_prev_page(og);
        if (og.serialno() != serialno) {
            if (this.bisect_forward_serialno(0L, 0L, end + 1L, serialno, 0) < 0) {
                this.clear();
                return -128;
            }
        } else if (this.bisect_forward_serialno(0L, end, end + 1L, serialno, 0) < 0) {
            this.clear();
            return -128;
        }
        this.prefetch_all_headers(initial_i, initial_c, dataoffset);
        return 0;
    }

    private final void decode_clear() {
        this.os.clear();
        this.vd.clear();
        this.vb.clear();
        this.decode_ready = false;
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
    }

    private final int process_packet(int readp) {
        Page og = new Page();
        while (true) {
            Packet op;
            int result;
            if (this.decode_ready && (result = this.os.packetout(op = new Packet())) > 0) {
                long granulepos = op.granulepos;
                if (this.vb.synthesis(op) == 0) {
                    int oldsamples = this.vd.synthesis_pcmout(null, null);
                    this.vd.synthesis_blockin(this.vb);
                    this.samptrack += (float)(this.vd.synthesis_pcmout(null, null) - oldsamples);
                    this.bittrack += (float)(op.bytes * 8);
                    if (granulepos != -1L && op.e_o_s == 0) {
                        int link = this.current_link;
                        int samples = this.vd.synthesis_pcmout(null, null);
                        granulepos -= (long)samples;
                        int i = 0;
                        while (i < link) {
                            granulepos += this.pcmlengths[i];
                            ++i;
                        }
                        this.pcm_offset = granulepos;
                    }
                    return 1;
                }
            }
            if (readp == 0) {
                return 0;
            }
            if (this.get_next_page(og, -1L) < 0) {
                return 0;
            }
            this.bittrack += (float)(og.header_len * 8);
            if (this.decode_ready && this.current_serialno != og.serialno()) {
                this.decode_clear();
            }
            if (!this.decode_ready) {
                this.current_serialno = og.serialno();
                int i = 0;
                while (i < this.links) {
                    if (this.serialnos[i] == this.current_serialno) break;
                    ++i;
                }
                if (i == this.links) {
                    return -1;
                }
                this.current_link = i;
                this.os.init(this.current_serialno);
                this.os.reset();
                this.make_decode_ready();
            }
            this.os.pagein(og);
        }
    }

    private final int clear() {
        this.vb.clear();
        this.vd.clear();
        this.os.clear();
        if (this.vi != null && this.links != 0) {
            int i = 0;
            while (i < this.links) {
                this.vi[i].clear();
                this.vc[i].clear();
                ++i;
            }
            this.vi = null;
            this.vc = null;
        }
        if (this.dataoffsets != null) {
            this.dataoffsets = null;
        }
        if (this.pcmlengths != null) {
            this.pcmlengths = null;
        }
        if (this.serialnos != null) {
            this.serialnos = null;
        }
        if (this.offsets != null) {
            this.offsets = null;
        }
        this.oy.clear();
        return 0;
    }

    private final int open(SeekableInputStream is, byte[] initial, int ibytes) throws JOrbisException {
        int ret;
        this.datasource = is;
        this.oy.init();
        if (initial != null) {
            int index = this.oy.buffer(ibytes);
            System.arraycopy(initial, 0, this.oy.data, index, ibytes);
            this.oy.wrote(ibytes);
        }
        if ((ret = this.open_seekable()) != 0) {
            this.datasource = null;
            this.clear();
        }
        return ret;
    }

    public final int streams() {
        return this.links;
    }

    public final int bitrate(int i) {
        if (i >= this.links) {
            return -1;
        }
        if (i < 0) {
            long bits = 0L;
            int j = 0;
            while (j < this.links) {
                bits += (this.offsets[j + 1] - this.dataoffsets[j]) * 8L;
                ++j;
            }
            return (int)Math.rint((float)bits / this.time_total(-1));
        }
        return (int)Math.rint((float)((this.offsets[i + 1] - this.dataoffsets[i]) * 8L) / this.time_total(i));
    }

    public final int bitrate_instant() {
        int _link = this.current_link;
        if (this.samptrack == 0.0f) {
            return -1;
        }
        int ret = (int)((double)(this.bittrack / this.samptrack * (float)this.vi[_link].rate) + 0.5);
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
        return ret;
    }

    public final int serialnumber(int i) {
        if (i >= this.links) {
            return -1;
        }
        if (i < 0) {
            return this.current_serialno;
        }
        return this.serialnos[i];
    }

    public final long raw_total(int i) {
        if (i < 0) {
            long acc = 0L;
            int j = 0;
            while (j < this.links) {
                acc += this.raw_total(j);
                ++j;
            }
            return acc;
        }
        return this.offsets[i + 1] - this.offsets[i];
    }

    public final long pcm_total(int i) {
        if (i < 0) {
            long acc = 0L;
            int j = 0;
            while (j < this.links) {
                acc += this.pcm_total(j);
                ++j;
            }
            return acc;
        }
        return this.pcmlengths[i];
    }

    public final float time_total(int i) {
        if (i < 0) {
            float acc = 0.0f;
            int j = 0;
            while (j < this.links) {
                acc += this.time_total(j);
                ++j;
            }
            return acc;
        }
        return (float)this.pcmlengths[i] / (float)this.vi[i].rate;
    }

    public final int raw_seek(int pos) {
        if (pos < 0 || (long)pos > this.offsets[this.links]) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        this.pcm_offset = -1L;
        this.decode_clear();
        this.seek_helper(pos);
        switch (this.process_packet(1)) {
            case 0: {
                this.pcm_offset = this.pcm_total(-1);
                return 0;
            }
            case -1: {
                this.pcm_offset = -1L;
                this.decode_clear();
                return -1;
            }
        }
        while (true) {
            switch (this.process_packet(0)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    this.pcm_offset = -1L;
                    this.decode_clear();
                    return -1;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final int pcm_seek(long pos) {
        link = -1;
        total = this.pcm_total(-1);
        if (pos < 0L || pos > total) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        link = this.links - 1;
        while (link >= 0) {
            if (pos >= (total -= this.pcmlengths[link])) break;
            --link;
        }
        target = pos - total;
        end = this.offsets[link + 1];
        begin = this.offsets[link];
        best = (int)begin;
        og = new Page();
        while (begin < end) {
            bisect = end - begin < 8500L ? begin : (end + begin) / 2L;
            this.seek_helper(bisect);
            ret = this.get_next_page(og, end - bisect);
            if (ret == -1) {
                end = bisect;
                continue;
            }
            granulepos = og.granulepos();
            if (granulepos < target) {
                best = ret;
                begin = this.offset;
                continue;
            }
            end = bisect;
        }
        if (this.raw_seek(best) != 0) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (this.pcm_offset > pos) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (pos <= this.pcm_total(-1)) ** GOTO lbl54
        this.pcm_offset = -1L;
        this.decode_clear();
        return -1;
lbl-1000:
        // 1 sources

        {
            target = (int)(pos - this.pcm_offset);
            _pcm = new float[1][][];
            _index = new int[this.getInfo((int)-1).channels];
            samples = this.vd.synthesis_pcmout(_pcm, _index);
            if (samples > target) {
                samples = target;
            }
            this.vd.synthesis_read(samples);
            this.pcm_offset += (long)samples;
            if (samples >= target || this.process_packet(1) != 0) continue;
            this.pcm_offset = this.pcm_total(-1);
lbl54:
            // 3 sources

            ** while (this.pcm_offset < pos)
        }
lbl55:
        // 1 sources

        return 0;
    }

    public final int time_seek(float seconds) {
        int link = -1;
        long pcm_total = this.pcm_total(-1);
        float time_total = this.time_total(-1);
        if (seconds < 0.0f || seconds > time_total) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        link = this.links - 1;
        while (link >= 0) {
            pcm_total -= this.pcmlengths[link];
            if (seconds >= (time_total -= this.time_total(link))) break;
            --link;
        }
        long target = (long)((float)pcm_total + (seconds - time_total) * (float)this.vi[link].rate);
        return this.pcm_seek(target);
    }

    public final long raw_tell() {
        return this.offset;
    }

    public final long pcm_tell() {
        return this.pcm_offset;
    }

    public final float time_tell() {
        int link = -1;
        long pcm_total = 0L;
        float time_total = 0.0f;
        pcm_total = this.pcm_total(-1);
        time_total = this.time_total(-1);
        link = this.links - 1;
        while (link >= 0) {
            time_total -= this.time_total(link);
            if (this.pcm_offset >= (pcm_total -= this.pcmlengths[link])) break;
            --link;
        }
        return time_total + (float)(this.pcm_offset - pcm_total) / (float)this.vi[link].rate;
    }

    public final Info getInfo(int link) {
        if (link < 0) {
            if (this.decode_ready) {
                return this.vi[this.current_link];
            }
            return null;
        }
        if (link >= this.links) {
            return null;
        }
        return this.vi[link];
    }

    public final Comment getComment(int link) {
        if (link < 0) {
            if (this.decode_ready) {
                return this.vc[this.current_link];
            }
            return null;
        }
        if (link >= this.links) {
            return null;
        }
        return this.vc[link];
    }

    public final int read(byte[] buffer, int length) {
        while (true) {
            if (this.decode_ready) {
                float[][][] _pcm = new float[1][][];
                int[] _index = new int[this.getInfo((int)-1).channels];
                int samples = this.vd.synthesis_pcmout(_pcm, _index);
                float[][] pcm = _pcm[0];
                if (samples != 0) {
                    int channels = this.getInfo((int)-1).channels;
                    int bytespersample = 2 * channels;
                    if (samples > length / bytespersample) {
                        samples = length / bytespersample;
                    }
                    int stride = channels * 2;
                    int i = 0;
                    while (i < channels) {
                        int src = _index[i];
                        int dest = i * 2;
                        int j = 0;
                        while (j < samples) {
                            int val = (int)(pcm[i][src + j] * 32768.0f + 0.5f);
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            } else if (val < Short.MIN_VALUE) {
                                val = Short.MIN_VALUE;
                            }
                            buffer[dest] = (byte)val;
                            buffer[dest + 1] = (byte)(val >>> 8);
                            dest += stride;
                            ++j;
                        }
                        ++i;
                    }
                    this.vd.synthesis_read(samples);
                    this.pcm_offset += (long)samples;
                    return samples * bytespersample;
                }
            }
            switch (this.process_packet(1)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    return -1;
                }
            }
        }
    }

    public final Info[] getInfo() {
        return this.vi;
    }

    public final Comment[] getComment() {
        return this.vc;
    }

    public final void close() throws IOException {
        this.datasource.close();
    }

    static class SeekableInputStream
    extends InputStream {
        private InputStream mStream;
        private long mLength;
        private long mOffset;

        SeekableInputStream(InputStream is) throws IOException {
            this.mStream = is;
            this.mLength = is.available();
            this.mStream.mark(0);
        }

        @Override
        public int read() throws IOException {
            int ret = this.mStream.read();
            if (ret >= 0) {
                ++this.mOffset;
            }
            return ret;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            int ret = this.mStream.read(buf);
            if (ret > 0) {
                this.mOffset += (long)ret;
            }
            return ret;
        }

        @Override
        public int read(byte[] buf, int s, int len) throws IOException {
            int ret = this.mStream.read(buf, s, len);
            if (ret > 0) {
                this.mOffset += (long)ret;
            }
            return ret;
        }

        @Override
        public long skip(long n) throws IOException {
            long ret = this.mStream.skip(n);
            if (ret > 0L) {
                this.mOffset += ret;
            }
            return ret;
        }

        public long getLength() {
            return this.mLength;
        }

        public long tell() {
            return this.mOffset;
        }

        @Override
        public int available() {
            return (int)this.mLength;
        }

        @Override
        public void close() throws IOException {
            this.mStream.close();
        }

        @Override
        public synchronized void mark(int m) {
        }

        @Override
        public synchronized void reset() throws IOException {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        public void seek(long pos) throws IOException {
            this.mStream.reset();
            this.mStream.skip(pos);
            this.mOffset = pos;
        }
    }
}

