/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.kag3;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.CustomObject;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.IntWrapper;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.ObjectProxy;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class DexCodeObject
extends CustomObject {
    private static boolean mStrFuncInit = false;
    private static final int STRFUNC_MAX = 13;
    private static int[] mStrFuncHash = new int[13];
    private static final String[] mStrFuncs = new String[]{"charAt", "indexOf", "toUpperCase", "toLowerCase", "substring", "substr", "sprintf", "replace", "escape", "split", "trim", "reverse", "repeat"};
    private static final int StrMethod_charAt = 0;
    private static final int StrMethod_indexOf = 1;
    private static final int StrMethod_toUpperCase = 2;
    private static final int StrMethod_toLowerCase = 3;
    private static final int StrMethod_substring = 4;
    private static final int StrMethod_substr = 5;
    private static final int StrMethod_sprintf = 6;
    private static final int StrMethod_replace = 7;
    private static final int StrMethod_escape = 8;
    private static final int StrMethod_split = 9;
    private static final int StrMethod_trim = 10;
    private static final int StrMethod_reverse = 11;
    private static final int StrMethod_repeat = 12;
    private ScriptBlock mBlock;
    DexCodeObject mParent;
    private String mName;
    private int mContextType;
    private int mMaxVariableCount;
    private int mVariableReserveCount;
    private int mMaxFrameCount;
    private int mFuncDeclArgCount;
    private int mFuncDeclUnnamedArgArrayBase;
    private int mFuncDeclCollapseBase;
    private DexCodeObject mPropSetter;
    private DexCodeObject mPropGetter;
    private DexCodeObject mSuperClassGetter;
    private int[] mSuperClassGetterPointer;
    protected TJS mTJS;
    private static final int NAMESPACE_DEFAULT_HASH_BITS = 3;

    private static int getContextHashSize(int type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 0;
            }
        }
        return 3;
    }

    public DexCodeObject(ScriptBlock block, String name, int type, short[] code, Variant[] da, int varcount, int verrescount, int maxframe, int argcount, int arraybase, int colbase, boolean srcsorted, LongBuffer srcpos, int[] superpointer) {
        super(DexCodeObject.getContextHashSize(type));
        this.mCallFinalize = false;
        this.mBlock = block;
        this.mName = name;
        this.mContextType = type;
        this.mMaxVariableCount = varcount;
        this.mVariableReserveCount = verrescount;
        this.mMaxFrameCount = maxframe;
        this.mFuncDeclArgCount = argcount;
        this.mFuncDeclUnnamedArgArrayBase = arraybase;
        this.mFuncDeclCollapseBase = colbase;
        this.mSuperClassGetterPointer = superpointer;
    }

    public void setCodeObject(DexCodeObject parent, DexCodeObject setter, DexCodeObject getter, DexCodeObject superclass) {
        this.mParent = parent;
        this.mPropSetter = setter;
        this.mPropGetter = getter;
        this.mSuperClassGetter = superclass;
    }

    @Override
    protected void finalizeObject() throws VariantException, TJSException {
        if (this.mPropSetter != null) {
            this.mPropSetter = null;
        }
        if (this.mPropGetter != null) {
            this.mPropGetter = null;
        }
        if (this.mSuperClassGetter != null) {
            this.mSuperClassGetter = null;
        }
        if (this.mContextType != 0 && this.mBlock != null) {
            this.mBlock = null;
        }
        super.finalizeObject();
    }

    private void executeAsFunction(Dispatch2 objthis, Variant[] args, Variant result, int start_ip) throws VariantException, TJSException {
        int num_alloc = this.mMaxVariableCount + this.mVariableReserveCount + 1 + this.mMaxFrameCount;
        Variant[] regs = null;
        try {
            regs = new Variant[num_alloc];
            int i = 0;
            while (i < num_alloc) {
                regs[i] = new Variant();
                ++i;
            }
            int arrayOffset = this.mMaxVariableCount + this.mVariableReserveCount;
            if (objthis != null) {
                ObjectProxy proxy = new ObjectProxy();
                proxy.setObjects(objthis, this.mBlock.getTJS().getGlobal());
                regs[arrayOffset - 2].set(proxy);
            } else {
                Dispatch2 global = this.mBlock.getTJS().getGlobal();
                regs[arrayOffset - 2].set(global, global);
            }
            try {
                int r;
                int numargs;
                regs[arrayOffset - 1].set(objthis, objthis);
                int n = numargs = args != null ? args.length : 0;
                if (numargs >= this.mFuncDeclArgCount) {
                    if (this.mFuncDeclArgCount != 0) {
                        r = arrayOffset - 3;
                        int n2 = this.mFuncDeclArgCount;
                        int argOffset = 0;
                        while (true) {
                            regs[r].set(args[argOffset]);
                            ++argOffset;
                            if (--n2 != 0) {
                                --r;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    r = arrayOffset - 3;
                    int argOffset = 0;
                    int i2 = 0;
                    while (i2 < numargs) {
                        regs[r].set(args[argOffset]);
                        ++argOffset;
                        --r;
                        ++i2;
                    }
                    while (i2 < this.mFuncDeclArgCount) {
                        regs[r].clear();
                        --r;
                        ++i2;
                    }
                }
                if (this.mFuncDeclCollapseBase >= 0) {
                    r = arrayOffset - 3 - this.mFuncDeclCollapseBase;
                    Dispatch2 dsp = TJS.createArrayObject();
                    regs[r].set(dsp, dsp);
                    if (numargs > this.mFuncDeclCollapseBase) {
                        int c = 0;
                        int i3 = this.mFuncDeclCollapseBase;
                        while (i3 < numargs) {
                            dsp.propSetByNum(0, c, args[i3], dsp);
                            ++i3;
                            ++c;
                        }
                    }
                }
            }
            finally {
                regs = null;
            }
        }
        finally {
            regs = null;
        }
    }

    protected final void operateProperty(VariantClosure clo, Variant result, Variant param, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        Dispatch2 objThis = clo.mObjThis != null ? clo.mObjThis : objthis;
        int hr = clo.operation(ope, null, result, param, objThis);
        if (hr < 0) {
            DexCodeObject.throwFrom_tjs_error(hr, null);
        }
    }

    protected final void operatePropertyIndirect(VariantClosure clo, Variant name, Variant result, Variant param, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        Dispatch2 objThis;
        Dispatch2 dispatch2 = objThis = clo.mObjThis != null ? clo.mObjThis : objthis;
        if (!name.isInteger()) {
            String str = name.asString();
            int hr = clo.operation(ope, str, result, param, objThis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, str);
            }
        } else {
            int num = name.asInteger();
            int hr = clo.operationByNum(ope, num, result, param, objThis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error_num(hr, num);
            }
        }
    }

    protected final void operatePropertyDirect(VariantClosure clo, String name, Variant result, Variant param, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        Dispatch2 objThis = clo.mObjThis != null ? clo.mObjThis : objthis;
        int hr = clo.operation(ope, name, result, param, objThis);
        if (hr < 0) {
            DexCodeObject.throwFrom_tjs_error(hr, name);
        }
    }

    protected final void displayExceptionGeneratedCode(int codepos, Variant[] ra, int ra_offset) throws VariantException {
        StringBuilder builder = new StringBuilder(128);
        builder.append("==== An exception occured");
        builder.append(", VM ip = ");
        builder.append(codepos);
        builder.append(" ====");
        TJS.outputToConsole(builder.toString());
    }

    protected static void throwInvalidVMCode() throws TJSException {
        throw new TJSException("\u4e0d\u6b63\u306a VM \u30b3\u30fc\u30c9\u3067\u3059");
    }

    protected void addClassInstanceInfo(Dispatch2 dsp, String className) throws VariantException {
        if (dsp != null) {
            dsp.addClassInstanveInfo(className);
        }
    }

    protected void throwScriptException(Variant val, ScriptBlock block, int srcpos) throws TJSException, VariantException {
        String msg = null;
        if (val.isObject()) {
            Variant v2;
            String message_name;
            int hr;
            VariantClosure clo = val.asObjectClosure();
            if (clo.mObject != null && (hr = clo.propGet(0, message_name = "message", v2 = new Variant(), null)) >= 0) {
                msg = "script exception : " + v2.asString();
            }
        }
        if (msg == null || msg.length() == 0) {
            msg = "script exception";
        }
        throw new TJSScriptException(msg, block, srcpos, val);
    }

    public static void throwFrom_tjs_error_num(int hr, int num) throws TJSException {
        DexCodeObject.throwFrom_tjs_error(hr, String.valueOf(num));
    }

    public static void throwFrom_tjs_error(int hr, String name) throws TJSException {
        switch (hr) {
            case -1001: {
                if (name != null) {
                    String str = "\u30e1\u30f3\u30d0 \"%1\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093".replace("%1", name);
                    throw new TJSException(str);
                }
                throw new TJSException("\u30e1\u30f3\u30d0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            }
            case -1002: {
                throw new TJSException("\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u305f\u6a5f\u80fd\u306f\u672a\u5b9f\u88c5\u3067\u3059");
            }
            case -1003: {
                throw new TJSException("\u4e0d\u6b63\u306a\u5f15\u6570\u3067\u3059");
            }
            case -1004: {
                throw new TJSException("\u5f15\u6570\u306e\u6570\u304c\u4e0d\u6b63\u3067\u3059");
            }
            case -1005: {
                throw new TJSException("\u95a2\u6570\u3067\u306f\u306a\u3044\u304b\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u7a2e\u985e\u304c\u9055\u3044\u307e\u3059");
            }
            case -1007: {
                throw new TJSException("\u8aad\u307f\u8fbc\u307f\u5c02\u7528\u3042\u308b\u3044\u306f\u66f8\u304d\u8fbc\u307f\u5c02\u7528\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u5bfe\u3057\u3066\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            case -1006: {
                throw new TJSException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3059\u3067\u306b\u7121\u52b9\u5316\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            case -1008: {
                throw new TJSException("\u5b9f\u884c\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u304c\u9055\u3044\u307e\u3059");
            }
        }
        if (hr < 0) {
            String buf = String.format("Unknown failure : %08X", hr);
            throw new TJSException(buf);
        }
    }

    protected void setPropertyIndirect(Variant target, Variant member, Variant param, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            if (!member.isInteger()) {
                String str = member.asString();
                int hr = clo.propSet(flags, str, param, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    DexCodeObject.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propSetByNum(flags, member.asInteger(), param, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    DexCodeObject.throwFrom_tjs_error_num(hr, member.asInteger());
                }
            }
        } else if (target.isString()) {
            this.setStringProperty(param, target, member);
        } else if (target.isOctet()) {
            this.setOctetProperty(param, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    private void getOctetProperty(Variant result, Variant octet, Variant member) throws TJSException, VariantException {
        String name;
        if (!member.isNumber()) {
            name = member.getString();
            if (name == null) {
                DexCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                ByteBuffer o = octet.asOctet();
                if (o != null) {
                    result.set(o.capacity());
                } else {
                    result.set(0);
                }
                return;
            }
            if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                int len;
                ByteBuffer o = octet.asOctet();
                int n = Integer.valueOf(name);
                int n2 = len = o != null ? o.capacity() : 0;
                if (n < 0 || n >= len) {
                    throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                result.set(o.get(n));
                return;
            }
        } else {
            int len;
            ByteBuffer o = octet.asOctet();
            int n = member.asInteger();
            int n3 = len = o != null ? o.capacity() : 0;
            if (n < 0 || n >= len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(o.get(n));
            return;
        }
        DexCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void getOctetProperty(Variant result, Variant octet, String name) throws TJSException, VariantException {
        if (name == null) {
            DexCodeObject.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            ByteBuffer o = octet.asOctet();
            if (o != null) {
                result.set(o.capacity());
            } else {
                result.set(0);
            }
            return;
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            int len;
            ByteBuffer o = octet.asOctet();
            int n = Integer.valueOf(name);
            int n2 = len = o != null ? o.capacity() : 0;
            if (n < 0 || n >= len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(o.get(n));
            return;
        }
        DexCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void getOctetProperty(Variant result, Variant octet, int n) throws TJSException, VariantException {
        int len;
        ByteBuffer o = octet.asOctet();
        int n2 = len = o != null ? o.capacity() : 0;
        if (n < 0 || n >= len) {
            throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
        }
        result.set(o.get(n));
    }

    private void setOctetProperty(Variant param, Variant octet, Variant member) throws TJSException, VariantException {
        if (!member.isNumber()) {
            String name = member.getString();
            if (name == null) {
                DexCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                DexCodeObject.throwFrom_tjs_error(-1007, "");
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                DexCodeObject.throwFrom_tjs_error(-1007, "");
            }
            DexCodeObject.throwFrom_tjs_error(-1001, name);
        } else {
            DexCodeObject.throwFrom_tjs_error(-1007, "");
        }
    }

    private void setOctetProperty(Variant param, Variant octet, String name) throws TJSException, VariantException {
        if (name == null) {
            DexCodeObject.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            DexCodeObject.throwFrom_tjs_error(-1007, "");
        } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            DexCodeObject.throwFrom_tjs_error(-1007, "");
        }
        DexCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void setOctetProperty(Variant param, Variant octet, int member) throws TJSException, VariantException {
        DexCodeObject.throwFrom_tjs_error(-1007, "");
    }

    private void getStringProperty(Variant result, Variant str, Variant member) throws TJSException, VariantException {
        String name;
        if (!member.isNumber()) {
            name = member.getString();
            if (name == null) {
                DexCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                String s = str.asString();
                if (s == null) {
                    result.set(0);
                } else {
                    result.set(s.length());
                }
                return;
            }
            if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                int len;
                String s = str.asString();
                int n = Integer.valueOf(name);
                if (n == (len = s.length())) {
                    result.set(new String());
                    return;
                }
                if (n < 0 || n > len) {
                    throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                result.set(s.substring(n, n + 1));
                return;
            }
        } else {
            int len;
            String s = str.asString();
            int n = member.asInteger();
            if (n == (len = s.length())) {
                result.set(new String());
                return;
            }
            if (n < 0 || n > len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(s.substring(n, n + 1));
            return;
        }
        DexCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void getStringProperty(Variant result, Variant str, String name) throws TJSException, VariantException {
        if (name == null) {
            DexCodeObject.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            String s = str.asString();
            if (s == null) {
                result.set(0);
            } else {
                result.set(s.length());
            }
            return;
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            int len;
            String s = str.asString();
            int n = Integer.valueOf(name);
            if (n == (len = s.length())) {
                result.set(new String());
                return;
            }
            if (n < 0 || n > len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(s.substring(n, n + 1));
            return;
        }
        DexCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void getStringProperty(Variant result, Variant str, int n) throws TJSException, VariantException {
        String s = str.asString();
        int len = s.length();
        if (n == len) {
            result.set(new String());
            return;
        }
        if (n < 0 || n > len) {
            throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
        }
        result.set(s.substring(n, n + 1));
    }

    private void setStringProperty(Variant param, Variant str, Variant member) throws TJSException, VariantException {
        if (!member.isNumber()) {
            String name = member.getString();
            if (name == null) {
                DexCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                DexCodeObject.throwFrom_tjs_error(-1007, "");
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                DexCodeObject.throwFrom_tjs_error(-1007, "");
            }
            DexCodeObject.throwFrom_tjs_error(-1001, name);
        } else {
            DexCodeObject.throwFrom_tjs_error(-1007, "");
        }
    }

    private void setStringProperty(Variant param, Variant str, String name) throws TJSException, VariantException {
        if (name == null) {
            DexCodeObject.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            DexCodeObject.throwFrom_tjs_error(-1007, "");
        } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            DexCodeObject.throwFrom_tjs_error(-1007, "");
        }
        DexCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void setStringProperty(Variant param, Variant str, int member) throws TJSException, VariantException {
        DexCodeObject.throwFrom_tjs_error(-1007, "");
    }

    protected void getPropertyIndirect(Variant result, Variant target, Variant member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            if (!member.isInteger()) {
                String str = member.asString();
                int hr = clo.propGet(flags, str, result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    DexCodeObject.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propGetByNum(flags, member.asInteger(), result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    DexCodeObject.throwFrom_tjs_error_num(hr, member.asInteger());
                }
            }
        } else if (target.isString()) {
            this.getStringProperty(result, target, member);
        } else if (target.isOctet()) {
            this.getOctetProperty(result, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void setPropertyDirect(Variant target, String member, Variant param, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propSet(flags, member, param, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, member);
            }
        } else if (target.isString()) {
            this.setStringProperty(param, target, member);
        } else if (target.isOctet()) {
            this.setOctetProperty(param, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void setPropertyDirect(Variant target, int member, Variant param, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            String name;
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propSet(flags, name = Integer.toString(member), param, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, name);
            }
        } else if (target.isString()) {
            this.setStringProperty(param, target, member);
        } else if (target.isOctet()) {
            this.setOctetProperty(param, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void getPropertyDirect(Variant result, Variant target, String member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, member, result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, member);
            }
        } else if (target.isString()) {
            this.getStringProperty(result, target, member);
        } else if (target.isOctet()) {
            this.getOctetProperty(result, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void getPropertyDirect(Variant result, Variant target, int member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            String name;
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, name = Integer.toString(member), result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, name);
            }
        } else if (target.isString()) {
            this.getStringProperty(result, target, member);
        } else if (target.isOctet()) {
            this.getOctetProperty(result, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void processOctetFunction(String member, String target, Variant[] args, Variant result) throws TJSException {
        DexCodeObject.throwFrom_tjs_error(-1001, member);
    }

    protected void processStringFunction(String member, String target, Variant[] args, Variant result) throws TJSException, VariantException {
        if (!mStrFuncInit) {
            DexCodeObject.initTJSStrFunc();
        }
        if (member == null) {
            DexCodeObject.throwFrom_tjs_error(-1001, "");
        }
        int hash = member.hashCode();
        String s = new String(target);
        int s_len = target.length();
        if (hash == mStrFuncHash[0] && mStrFuncs[0].equals(member)) {
            if (args.length != 1) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (s_len == 0) {
                if (result != null) {
                    result.set("");
                }
                return;
            }
            int i = args[0].asInteger();
            if (i < 0 || i >= s_len) {
                if (result != null) {
                    result.set("");
                }
                return;
            }
            if (result != null) {
                result.set(s.substring(i, i + 1));
            }
            return;
        }
        if (hash == mStrFuncHash[1] && mStrFuncs[1].equals(member)) {
            if (args.length != 1 && args.length != 2) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            String pstr = args[0].asString();
            if (s == null || pstr == null) {
                if (result != null) {
                    result.set(-1);
                }
                return;
            }
            int start = args.length == 1 ? 0 : args[1].asInteger();
            if (start >= s_len) {
                if (result != null) {
                    result.set(-1);
                }
                return;
            }
            int found = s.indexOf(pstr, start);
            if (result != null) {
                result.set(found);
            }
            return;
        }
        if (hash == mStrFuncHash[2] && mStrFuncs[2].equals(member)) {
            if (args.length != 0) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result != null) {
                result.set(s.toUpperCase());
            }
            return;
        }
        if (hash == mStrFuncHash[3] && mStrFuncs[3].equals(member)) {
            if (args.length != 0) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result != null) {
                result.set(s.toLowerCase());
            }
            return;
        }
        if (hash == mStrFuncHash[4] && mStrFuncs[4].equals(member) || hash == mStrFuncHash[5] && mStrFuncs[5].equals(member)) {
            int start;
            if (args.length != 1 && args.length != 2) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if ((start = args[0].asInteger()) < 0 || start >= s_len) {
                if (result != null) {
                    result.set("");
                }
                return;
            }
            if (args.length == 2) {
                int count = args[1].asInteger();
                if (count < 0) {
                    if (result != null) {
                        result.set("");
                    }
                    return;
                }
                if (start + count > s_len) {
                    count = s_len - start;
                }
                if (result != null) {
                    result.set(s.substring(start, start + count));
                }
                return;
            }
            if (result != null) {
                result.set(s.substring(start));
            }
            return;
        }
        if (hash == mStrFuncHash[6] && mStrFuncs[6].equals(member)) {
            if (result != null) {
                String res = Utils.formatString(s, args);
                result.set(res);
            }
            return;
        }
        if (hash == mStrFuncHash[7] && mStrFuncs[7].equals(member)) {
            if (args.length < 2) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            VariantClosure clo = args[0].asObjectClosure();
            Variant str = new Variant(target);
            Variant[] params = new Variant[]{str, args[1]};
            String replace_name = "replace";
            clo.funcCall(0, "replace", result, params, null);
            return;
        }
        if (hash == mStrFuncHash[8] && mStrFuncs[8].equals(member)) {
            if (result != null) {
                result.set(LexBase.escapeC(target));
            }
            return;
        }
        if (hash == mStrFuncHash[9] && mStrFuncs[9].equals(member)) {
            if (args.length < 1) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            Dispatch2 array = TJS.createArrayObject();
            try {
                Variant str = new Variant(target);
                Variant[] params = args.length >= 3 ? new Variant[]{args[0], str, args[1], args[2]} : (args.length >= 2 ? new Variant[]{args[0], str, args[1]} : new Variant[]{args[0], str});
                String split_name = "split";
                array.funcCall(0, "split", null, params, array);
                if (result != null) {
                    result.set(new Variant(array, array));
                }
            }
            finally {
                array = null;
            }
            return;
        }
        if (hash == mStrFuncHash[10] && mStrFuncs[10].equals(member)) {
            if (args.length != 0) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result == null) {
                return;
            }
            result.set(s.trim());
            return;
        }
        if (hash == mStrFuncHash[11] && mStrFuncs[11].equals(member)) {
            if (args.length != 0) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result == null) {
                return;
            }
            StringBuilder builder = new StringBuilder(s_len);
            int i = 0;
            while (i < s_len) {
                builder.append(s.charAt(s_len - i - 1));
                ++i;
            }
            result.set(builder.toString());
            return;
        }
        if (hash == mStrFuncHash[12] && mStrFuncs[12].equals(member)) {
            if (args.length != 1) {
                DexCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result == null) {
                return;
            }
            int count = args[0].asInteger();
            if (count <= 0 || s_len <= 0) {
                result.set("");
                return;
            }
            int destLength = s_len * count;
            StringBuilder builder = new StringBuilder(destLength);
            while (count > 0) {
                builder.append(s);
                --count;
            }
            result.set(builder.toString());
            return;
        }
        DexCodeObject.throwFrom_tjs_error(-1001, member);
    }

    private static void initTJSStrFunc() {
        mStrFuncInit = true;
        int i = 0;
        while (i < 13) {
            DexCodeObject.mStrFuncHash[i] = mStrFuncs[i].hashCode();
            ++i;
        }
    }

    protected void instanceOf(Variant name, Variant targ) throws VariantException, TJSException {
        String str = name.asString();
        if (str != null) {
            int hr = CustomObject.defaultIsInstanceOf(0, targ, str, null);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, null);
            }
            targ.set(hr == 1 ? 1 : 0);
            return;
        }
        targ.set(0);
    }

    protected void eval(Variant val, Dispatch2 objthis, boolean resneed) throws VariantException, TJSException, CompileException {
        Variant res = new Variant();
        String str = val.asString();
        if (str.length() > 0) {
            if (resneed) {
                this.mBlock.getTJS().evalExpression(str, res, objthis, null, 0);
            } else {
                this.mBlock.getTJS().evalExpression(str, null, objthis, null, 0);
            }
        }
        if (resneed) {
            val.set(res);
        }
    }

    protected final void typeOfMemberIndirect(Variant result, Variant target, Variant member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            if (!member.isInteger()) {
                String str = member.asString();
                int hr = clo.propGet(flags, str, result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr == 0) {
                    this.typeOf(result);
                } else if (hr == -1001) {
                    result.set("undefined");
                } else if (hr < 0) {
                    DexCodeObject.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propGetByNum(flags, member.asInteger(), result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr == 0) {
                    this.typeOf(result);
                } else if (hr == -1001) {
                    result.set("undefined");
                } else if (hr < 0) {
                    DexCodeObject.throwFrom_tjs_error_num(hr, member.asInteger());
                }
            }
        } else if (target.isString()) {
            this.getStringProperty(result, target, member);
            this.typeOf(result);
        } else if (target.isOctet()) {
            this.getOctetProperty(result, target, member);
            this.typeOf(result);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void typeOfMemberDirect(Variant result, Variant target, String member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, member, result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr == 0) {
                this.typeOf(result);
            } else if (hr == -1001) {
                result.set("undefined");
            } else if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, member);
            }
        } else if (target.isString()) {
            this.getStringProperty(result, target, member);
            this.typeOf(result);
        } else if (target.isOctet()) {
            this.getOctetProperty(result, target, member);
            this.typeOf(result);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void typeOfMemberDirect(Variant result, Variant target, int member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            String name;
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, name = Integer.toString(member), result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr == 0) {
                this.typeOf(result);
            } else if (hr == -1001) {
                result.set("undefined");
            } else if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, name);
            }
        } else if (target.isString()) {
            this.getStringProperty(result, target, member);
            this.typeOf(result);
        } else if (target.isOctet()) {
            this.getOctetProperty(result, target, member);
            this.typeOf(result);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected void typeOf(Variant val) {
        String name = val.getTypeName();
        if (name != null) {
            val.set(name);
        }
    }

    protected void operateProperty0(VariantClosure clo, Variant result, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        int hr = clo.operation(ope, null, result, null, clo.mObjThis != null ? clo.mObjThis : objthis);
        if (hr < 0) {
            DexCodeObject.throwFrom_tjs_error(hr, null);
        }
    }

    protected void operatePropertyIndirect0(VariantClosure clo, Variant name, Variant result, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        if (!name.isInteger()) {
            String str = name.asString();
            int hr = clo.operation(ope, str, result, null, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error(hr, str);
            }
        } else {
            int hr = clo.operationByNum(ope, name.asInteger(), result, null, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                DexCodeObject.throwFrom_tjs_error_num(hr, name.asInteger());
            }
        }
    }

    protected void operatePropertyDirect0(VariantClosure clo, String name, Variant result, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        int hr = clo.operation(ope, name, result, null, objthis);
        if (hr < 0) {
            DexCodeObject.throwFrom_tjs_error(hr, name);
        }
    }

    @Override
    public int funcCall(int flag, String membername, Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            switch (this.mContextType) {
                case 0: {
                    this.executeAsFunction(objthis != null ? objthis : this.mBlock.getTJS().getGlobal(), null, result, 0);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    this.executeAsFunction(objthis, param, result, 0);
                    break;
                }
                case 6: {
                    this.executeAsFunction(objthis, param, result, 0);
                    break;
                }
                case 3: {
                    return -1005;
                }
            }
            return 0;
        }
        int hr = super.funcCall(flag, membername, result, param, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) > 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                int v = pointer[i];
                this.mSuperClassGetter.executeAsFunction(null, null, res, v);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.funcCall(flag, membername, result, param, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int propGet(int flag, String membername, Variant result, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null && this.mContextType == 3) {
            if (this.mPropGetter != null) {
                return this.mPropGetter.funcCall(0, null, result, null, objthis);
            }
            return -1007;
        }
        int hr = super.propGet(flag, membername, result, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.propGet(flag, membername, result, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int propSet(int flag, String membername, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        int hr;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null && this.mContextType == 3) {
            if (this.mPropSetter != null) {
                Variant[] params = new Variant[]{param};
                return this.mPropSetter.funcCall(0, null, null, params, objthis);
            }
            return -1007;
        }
        if (membername != null && this.mContextType == 6 && this.mSuperClassGetter != null) {
            int[] pointer;
            int count;
            int pseudo_flag = (flag & 0x800) != 0 ? flag : flag & 0xFFFFFDFF;
            hr = super.propSet(pseudo_flag, membername, param, objthis);
            if (hr == -1001 && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
                Variant res = new Variant();
                int i = count - 1;
                while (i >= 0) {
                    this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                    VariantClosure clo = res.asObjectClosure();
                    hr = clo.propSet(pseudo_flag, membername, param, objthis);
                    if (hr != -1001) break;
                    --i;
                }
            }
            if (hr == -1001 && (flag & 0x200) != 0) {
                hr = super.propSet(flag, membername, param, objthis);
            }
        } else {
            hr = super.propSet(flag, membername, param, objthis);
        }
        return hr;
    }

    @Override
    public int createNew(int flag, String membername, Holder<Dispatch2> result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            if (this.mContextType != 6) {
                return -1005;
            }
            CustomObject dsp = new CustomObject();
            this.executeAsFunction(dsp, null, null, 0);
            this.funcCall(0, this.mName, null, param, dsp);
            result.set(dsp);
            return 0;
        }
        int hr = super.createNew(flag, membername, result, param, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.createNew(flag, membername, result, param, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int isInstanceOf(int flag, String membername, String classname, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            switch (this.mContextType) {
                case 0: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 1: 
                case 2: {
                    if (!"Function".equals(classname)) break;
                    return 1;
                }
                case 3: {
                    if (!"Property".equals(classname)) break;
                    return 1;
                }
                case 6: {
                    if (!"Class".equals(classname)) break;
                    return 1;
                }
            }
        }
        int hr = super.isInstanceOf(flag, membername, classname, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.isInstanceOf(flag, membername, classname, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int getCount(IntWrapper result, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.getCount(result, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.getCount(result, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int deleteMember(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.deleteMember(flag, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.deleteMember(flag, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int invalidate(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.invalidate(flag, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.invalidate(flag, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int isValid(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.isValid(flag, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.isValid(flag, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int operation(int flag, String membername, Variant result, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        if (membername == null) {
            if (this.mContextType == 3) {
                return super.dispatchOperation(flag, membername, result, param, objthis);
            }
            return super.operation(flag, membername, result, param, objthis);
        }
        if (membername != null && this.mContextType == 6 && this.mSuperClassGetter != null) {
            int[] pointer;
            int count;
            int pseudo_flag = (flag & 0x800) != 0 ? flag : flag & 0xFFFFFDFF;
            int hr = super.operation(pseudo_flag, membername, result, param, objthis);
            if (hr == -1001 && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
                Variant res = new Variant();
                int i = count - 1;
                while (i >= 0) {
                    this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                    VariantClosure clo = res.asObjectClosure();
                    hr = clo.operation(pseudo_flag, membername, result, param, objthis);
                    if (hr != -1001) break;
                    --i;
                }
            }
            if (hr == -1001) {
                hr = super.operation(flag, membername, result, param, objthis);
            }
            return hr;
        }
        return super.operation(flag, membername, result, param, objthis);
    }

    public static void characterCodeFrom(Variant val) throws VariantException {
        char[] ch = new char[]{(char)val.asInteger()};
        val.set(new String(ch));
    }

    public static void characterCodeOf(Variant val) throws VariantException {
        String str = val.asString();
        if (str != null) {
            int v = str.codePointAt(0);
            val.set(v);
        } else {
            val.set(0);
        }
    }

    public final String getName() {
        return this.mName;
    }
}

