/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.kirikiri.tjs2.ArrayNI;
import jp.kirikiri.tjs2.ArrayObject;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.RegExpClass;
import jp.kirikiri.tjs2.RegExpNI;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class ArrayClass
extends NativeClass {
    public static int ClassID = -1;
    private static final String CLASS_NAME = "Array";

    @Override
    protected NativeInstance createNativeInstance() {
        return new ArrayNI();
    }

    @Override
    protected Dispatch2 createBaseTJSObject() {
        return new ArrayObject();
    }

    public static int getArrayElementCount(Dispatch2 dsp) throws TJSException {
        ArrayNI ni = (ArrayNI)dsp.getNativeInstance(ClassID);
        if (ni == null) {
            throw new TJSException("Array \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        return ni.mItems.size();
    }

    public static int copyArrayElementTo(Dispatch2 dsp, Variant[] dest, int dest_offset, int start, int count) throws TJSException {
        ArrayNI ni = (ArrayNI)dsp.getNativeInstance(ClassID);
        if (ni == null) {
            throw new TJSException("Array \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if (count < 0) {
            count = ni.mItems.size();
        }
        if (start >= ni.mItems.size()) {
            return 0;
        }
        int limit = start + count;
        int d = dest_offset;
        int i = start;
        while (i < limit) {
            dest[d] = ni.mItems.get(i);
            ++d;
            ++i;
        }
        return limit - start;
    }

    public ArrayClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        ClassID = NCM_CLASSID;
        this.registerNCM(CLASS_NAME, new NativeClassConstructor(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                ArrayNI _this = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (_this == null) {
                    return -1008;
                }
                int hr = _this.construct(param, objthis);
                if (hr < 0) {
                    return hr;
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("load", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (objthis == null) {
                    return -1008;
                }
                if (TJS.mStorage == null) {
                    return -1008;
                }
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String name = param[0].asString();
                String mode = null;
                if (param.length >= 2 && !param[1].isVoid()) {
                    mode = param[1].asString();
                }
                ni.mItems.clear();
                String content = TJS.mStorage.readText(name, mode);
                int count = content.length();
                int lines = 0;
                int reamain = 0;
                int i = 0;
                while (i < count) {
                    ++reamain;
                    int ch = content.codePointAt(i);
                    if (ch == 13 || ch == 10) {
                        if (i + 1 < count && content.codePointAt(i + 1) == 10 && ch == 13) {
                            ++lines;
                            ++i;
                        }
                        reamain = 0;
                    }
                    ++i;
                }
                if (reamain > 0) {
                    ++lines;
                }
                ni.mItems.clear();
                ni.mItems.ensureCapacity(lines);
                lines = 0;
                int start = 0;
                int i2 = 0;
                while (i2 < count) {
                    int ch = content.codePointAt(i2);
                    if (ch == 13 || ch == 10) {
                        ni.mItems.add(new Variant(content.substring(start, i2)));
                        if (i2 + 1 < count && content.codePointAt(i2 + 1) == 10 && ch == 13) {
                            ++i2;
                        }
                        start = i2 + 1;
                    }
                    ++i2;
                }
                if (start < count) {
                    ni.mItems.add(new Variant(content.substring(start, count)));
                }
                if (result != null) {
                    result.set(new Variant(objthis, objthis));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("save", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String name = param[0].asString();
                String mode = null;
                if (param.length >= 2 && !param[1].isVoid()) {
                    mode = param[1].asString();
                }
                TextWriteStreamInterface stream = TJS.mStorage.createTextWriteStream(name, mode);
                try {
                    for (Variant o : ni.mItems) {
                        if (o != null && (o.isString() || o.isNumber())) {
                            stream.write(o.asString());
                        }
                        stream.write("\n");
                    }
                }
                finally {
                    stream.destruct();
                }
                if (result != null) {
                    result.set(new Variant(objthis, objthis));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("saveStruct", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String name = param[0].asString();
                String mode = null;
                if (param.length >= 2 && !param[1].isVoid()) {
                    mode = param[1].asString();
                }
                TextWriteStreamInterface stream = TJS.mStorage.createTextWriteStream(name, mode);
                try {
                    ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
                    stack.add(objthis);
                    ni.saveStructuredData(stack, stream, "");
                }
                finally {
                    stream.destruct();
                }
                if (result != null) {
                    result.set(new Variant(objthis, objthis));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("split", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 2) {
                    return -1004;
                }
                ni.mItems.clear();
                String string = param[1].asString();
                boolean purgeempty = false;
                if (param.length >= 4 && !param[3].isVoid()) {
                    purgeempty = param[3].asBoolean();
                }
                if (param[0].isObject()) {
                    RegExpNI re;
                    VariantClosure clo = param[0].asObjectClosure();
                    if (clo.mObject != null && (re = (RegExpNI)clo.mObject.getNativeInstance(RegExpClass.mClassID)) != null) {
                        Holder<Dispatch2> array = new Holder<Dispatch2>(objthis);
                        re.split(array, string, purgeempty);
                        if (result != null) {
                            result.set(new Variant(objthis, objthis));
                        }
                        return 0;
                    }
                }
                String pattern = param[0].asString();
                int count = string.length();
                int start = 0;
                int i = 0;
                while (i < count) {
                    int ch = string.codePointAt(i);
                    if (pattern.indexOf(ch) != -1) {
                        if (!purgeempty || purgeempty && i - start != 0) {
                            ni.mItems.add(new Variant(string.substring(start, i)));
                        }
                        start = i + 1;
                    }
                    ++i;
                }
                if (!purgeempty || purgeempty && count - start >= 0) {
                    ni.mItems.add(new Variant(string.substring(start, count)));
                }
                if (result != null) {
                    result.set(new Variant(objthis, objthis));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("join", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String delimiter = param[0].asString();
                boolean purgeempty = false;
                if (param.length >= 3 && !param[2].isVoid()) {
                    purgeempty = param[2].asBoolean();
                }
                boolean first = true;
                StringBuilder builer = new StringBuilder(1024);
                int count = ni.mItems.size();
                int i = 0;
                while (i < count) {
                    Variant v = ni.mItems.get(i);
                    if (!purgeempty || !v.isVoid()) {
                        if (!first) {
                            builer.append(delimiter);
                        }
                        first = false;
                        builer.append(v.asString());
                    }
                    ++i;
                }
                if (result != null) {
                    result.set(builer.toString());
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("sort", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                int method = 43;
                VariantClosure closure = null;
                if (param.length >= 1 && !param[0].isVoid()) {
                    if (param[0].isObject()) {
                        closure = param[0].asObjectClosure();
                        method = 0;
                    } else {
                        String me = param[0].asString();
                        method = me.charAt(0);
                        switch (method) {
                            case 43: 
                            case 45: 
                            case 48: 
                            case 57: 
                            case 97: 
                            case 122: {
                                break;
                            }
                            default: {
                                method = 43;
                            }
                        }
                    }
                }
                switch (method) {
                    case 43: {
                        Collections.sort(ni.mItems, new ArraySortCompare_NormalAscending());
                        break;
                    }
                    case 45: {
                        Collections.sort(ni.mItems, new ArraySortCompare_NormalDescending());
                        break;
                    }
                    case 48: {
                        Collections.sort(ni.mItems, new ArraySortCompare_NumericAscending());
                        break;
                    }
                    case 57: {
                        Collections.sort(ni.mItems, new ArraySortCompare_NumericDescending());
                        break;
                    }
                    case 97: {
                        Collections.sort(ni.mItems, new ArraySortCompare_StringAscending());
                        break;
                    }
                    case 122: {
                        Collections.sort(ni.mItems, new ArraySortCompare_StringDescending());
                        break;
                    }
                    case 0: {
                        Collections.sort(ni.mItems, new ArraySortCompare_Functional(closure));
                    }
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("reverse", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                Collections.reverse(ni.mItems);
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("assign", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                ((ArrayObject)objthis).clear(ni);
                VariantClosure clo = param[0].asObjectClosure();
                if (clo.mObjThis != null) {
                    ni.assign(clo.mObjThis);
                } else if (clo.mObject != null) {
                    ni.assign(clo.mObject);
                } else {
                    throw new TJSException("null \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("assignStruct", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                ((ArrayObject)objthis).clear(ni);
                ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
                VariantClosure clo = param[0].asObjectClosure();
                if (clo.mObjThis != null) {
                    ni.assignStructure(clo.mObjThis, stack);
                } else if (clo.mObject != null) {
                    ni.assignStructure(clo.mObject, stack);
                } else {
                    throw new TJSException("null \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("clear", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                ((ArrayObject)objthis).clear(ni);
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("erase", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                int num = param[0].asInteger();
                ((ArrayObject)objthis).erase(ni, num);
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("remove", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                boolean eraseall = param.length >= 2 ? param[1].asBoolean() : true;
                Variant val = param[0];
                int count = ((ArrayObject)objthis).remove(ni, val, eraseall);
                if (result != null) {
                    result.set(count);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("insert", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 2) {
                    return -1004;
                }
                int num = param[0].asInteger();
                ((ArrayObject)objthis).insert(ni, param[1], num);
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("add", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                ((ArrayObject)objthis).add(ni, param[0]);
                if (result != null) {
                    result.set(ni.mItems.size() - 1);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("push", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                ((ArrayObject)objthis).insert(ni, param, ni.mItems.size());
                if (result != null) {
                    result.set(ni.mItems.size());
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("pop", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (ni.mItems.isEmpty()) {
                    if (result != null) {
                        result.clear();
                    }
                } else {
                    if (result != null) {
                        result.set(ni.mItems.get(ni.mItems.size() - 1));
                    }
                    ((ArrayObject)objthis).erase(ni, ni.mItems.size() - 1);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("shift", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (ni.mItems.isEmpty()) {
                    if (result != null) {
                        result.clear();
                    }
                } else {
                    if (result != null) {
                        result.set(ni.mItems.get(0));
                    }
                    ((ArrayObject)objthis).erase(ni, 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("unshift", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                ((ArrayObject)objthis).insert(ni, param, 0);
                if (result != null) {
                    result.set(ni.mItems.size());
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("find", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    Variant val = param[0];
                    int start = 0;
                    if (param.length >= 2) {
                        start = param[1].asInteger();
                    }
                    if (start < 0) {
                        start += ni.mItems.size();
                    }
                    if (start < 0) {
                        start = 0;
                    }
                    if (start >= ni.mItems.size()) {
                        result.set(-1);
                        return 0;
                    }
                    int count = ni.mItems.size();
                    int i = start;
                    while (i < count) {
                        Variant v = ni.mItems.get(i);
                        if (val.discernCompareInternal(v)) break;
                        ++i;
                    }
                    if (i == count) {
                        result.set(-1);
                    } else {
                        result.set(i);
                    }
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("count", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(ni.mItems.size());
                }
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) throws VariantException {
                block4: {
                    int count;
                    int resize;
                    ArrayNI ni;
                    block3: {
                        ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                        if (ni == null) {
                            return -1008;
                        }
                        resize = param.asInteger();
                        count = ni.mItems.size();
                        if (count >= resize) break block3;
                        int addcount = resize - count;
                        ni.mItems.ensureCapacity(count);
                        int i = 0;
                        while (i < addcount) {
                            ni.mItems.add(new Variant());
                            ++i;
                        }
                        break block4;
                    }
                    if (count <= resize) break block4;
                    int i = count - 1;
                    while (i >= resize) {
                        ni.mItems.remove(i);
                        --i;
                    }
                }
                return 0;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("length", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                ArrayNI ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(ni.mItems.size());
                }
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) throws VariantException {
                block4: {
                    int count;
                    int resize;
                    ArrayNI ni;
                    block3: {
                        ni = (ArrayNI)objthis.getNativeInstance(ClassID);
                        if (ni == null) {
                            return -1008;
                        }
                        resize = param.asInteger();
                        count = ni.mItems.size();
                        if (count >= resize) break block3;
                        int addcount = resize - count;
                        ni.mItems.ensureCapacity(count);
                        int i = 0;
                        while (i < addcount) {
                            ni.mItems.add(new Variant());
                            ++i;
                        }
                        break block4;
                    }
                    if (count <= resize) break block4;
                    int i = count - 1;
                    while (i >= resize) {
                        ni.mItems.remove(i);
                        --i;
                    }
                }
                return 0;
            }
        }, CLASS_NAME, 2, 0);
    }

    public static class ArraySortCompare_Functional
    implements Comparator<Variant> {
        private VariantClosure mClosure;

        public ArraySortCompare_Functional(VariantClosure clo) {
            this.mClosure = clo;
        }

        @Override
        public int compare(Variant lhs, Variant rhs) {
            try {
                boolean ret;
                Variant result = new Variant();
                Variant[] params = new Variant[]{lhs, rhs};
                int hr = this.mClosure.funcCall(0, null, result, params, null);
                if (hr < 0) {
                    Error.throwFrom_tjs_error(hr, null);
                }
                return (ret = result.asBoolean()) ? -1 : 1;
            }
            catch (VariantException e) {
                return 0;
            }
            catch (TJSException e) {
                return 0;
            }
        }
    }

    public static class ArraySortCompare_NormalAscending
    implements Comparator<Variant> {
        @Override
        public int compare(Variant lhs, Variant rhs) {
            try {
                return lhs.greaterThanForSort(rhs);
            }
            catch (VariantException e) {
                return 0;
            }
        }
    }

    public static class ArraySortCompare_NormalDescending
    implements Comparator<Variant> {
        @Override
        public int compare(Variant lhs, Variant rhs) {
            try {
                return lhs.littlerThanForSort(rhs);
            }
            catch (VariantException e) {
                return 0;
            }
        }
    }

    public static class ArraySortCompare_NumericAscending
    implements Comparator<Variant> {
        @Override
        public int compare(Variant lhs, Variant rhs) {
            block5: {
                double ret;
                block6: {
                    try {
                        if (!lhs.isString() || !rhs.isString()) break block5;
                        Number l = lhs.asNumber();
                        Number r = rhs.asNumber();
                        ret = l.doubleValue() - r.doubleValue();
                        if (ret != 0.0) break block6;
                        return 0;
                    }
                    catch (VariantException e) {
                        return 0;
                    }
                }
                if (ret < 0.0) {
                    return -1;
                }
                return 1;
            }
            return lhs.greaterThanForSort(rhs);
        }
    }

    public static class ArraySortCompare_NumericDescending
    implements Comparator<Variant> {
        @Override
        public int compare(Variant lhs, Variant rhs) {
            block5: {
                double ret;
                block6: {
                    try {
                        if (!lhs.isString() || !rhs.isString()) break block5;
                        Number l = lhs.asNumber();
                        Number r = rhs.asNumber();
                        ret = r.doubleValue() - l.doubleValue();
                        if (ret != 0.0) break block6;
                        return 0;
                    }
                    catch (VariantException e) {
                        return 0;
                    }
                }
                if (ret < 0.0) {
                    return -1;
                }
                return 1;
            }
            return lhs.littlerThanForSort(rhs);
        }
    }

    public static class ArraySortCompare_StringAscending
    implements Comparator<Variant> {
        @Override
        public int compare(Variant lhs, Variant rhs) {
            try {
                if (lhs.isString() && rhs.isString()) {
                    String l = lhs.getString();
                    String r = rhs.getString();
                    return l.compareTo(r);
                }
                String l = lhs.asString();
                String r = rhs.asString();
                return l.compareTo(r);
            }
            catch (VariantException e) {
                return 0;
            }
        }
    }

    public static class ArraySortCompare_StringDescending
    implements Comparator<Variant> {
        @Override
        public int compare(Variant lhs, Variant rhs) {
            try {
                if (lhs.isString() && rhs.isString()) {
                    String l = lhs.getString();
                    String r = rhs.getString();
                    return r.compareTo(l);
                }
                String l = lhs.asString();
                String r = rhs.asString();
                return r.compareTo(l);
            }
            catch (VariantException e) {
                return 0;
            }
        }
    }
}

