/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import jp.kirikiri.tjs2.ArrayClass;
import jp.kirikiri.tjs2.DictionaryClass;
import jp.kirikiri.tjs2.DictionaryNI;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.EnumMembersCallback;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

class ArrayNI
extends NativeInstanceObject {
    public ArrayList<Variant> mItems = new ArrayList();

    @Override
    public int construct(Variant[] param, Dispatch2 tjsObj) {
        if (param != null && param.length != 0) {
            return -1004;
        }
        return 0;
    }

    public void assign(Dispatch2 dsp) throws VariantException, TJSException {
        ArrayNI array = (ArrayNI)dsp.getNativeInstance(ArrayClass.ClassID);
        if (array != null) {
            this.mItems.clear();
            int count = array.mItems.size();
            int i = 0;
            while (i < count) {
                this.mItems.add(new Variant(array.mItems.get(i)));
                ++i;
            }
        } else {
            this.mItems.clear();
            DictionaryEnumCallback callback = new DictionaryEnumCallback(this.mItems);
            dsp.enumMembers(2048, callback, dsp);
        }
    }

    public void saveStructuredData(ArrayList<Dispatch2> stack, TextWriteStreamInterface stream, String indentstr) throws VariantException, TJSException {
        stream.write("(const) [\n");
        String indentstr2 = String.valueOf(indentstr) + " ";
        int count = this.mItems.size();
        int i = 0;
        while (i < count) {
            Variant v = this.mItems.get(i);
            stream.write(indentstr2);
            if (v.isObject()) {
                VariantClosure clo = v.asObjectClosure();
                ArrayNI.saveStructuredDataForObject(clo.selectObject(), stack, stream, indentstr2);
            } else {
                stream.write(Utils.variantToExpressionString(v));
            }
            if (i != this.mItems.size() - 1) {
                stream.write(",\n");
            } else {
                stream.write("\n");
            }
            ++i;
        }
        stream.write(indentstr);
        stream.write("]");
    }

    public static void saveStructuredDataForObject(Dispatch2 dsp, ArrayList<Dispatch2> stack, TextWriteStreamInterface stream, String indentstr) throws VariantException, TJSException {
        int count = stack.size();
        int i = 0;
        while (i < count) {
            Dispatch2 d = stack.get(i);
            if (d == dsp) {
                stream.write("null /* object recursion detected */");
                return;
            }
            ++i;
        }
        if (dsp != null) {
            DictionaryNI dicni = (DictionaryNI)dsp.getNativeInstance(DictionaryClass.ClassID);
            if (dicni != null) {
                stack.add(dsp);
                dicni.saveStructuredData(stack, stream, indentstr);
                stack.remove(stack.size() - 1);
                return;
            }
            ArrayNI arrayni = (ArrayNI)dsp.getNativeInstance(ArrayClass.ClassID);
            if (arrayni != null) {
                stack.add(dsp);
                arrayni.saveStructuredData(stack, stream, indentstr);
                stack.remove(stack.size() - 1);
                return;
            }
            stream.write("null /* (object) \"");
            Variant val = new Variant(dsp, dsp);
            stream.write(LexBase.escapeC(val.asString()));
            stream.write("\" */");
            return;
        }
        stream.write("null");
    }

    public void assignStructure(Dispatch2 dsp, ArrayList<Dispatch2> stack) throws TJSException, VariantException {
        ArrayNI arrayni = (ArrayNI)dsp.getNativeInstance(ArrayClass.ClassID);
        if (arrayni != null) {
            stack.add(dsp);
            try {
                this.mItems.clear();
                int count = arrayni.mItems.size();
                int i = 0;
                while (i < count) {
                    Variant v = arrayni.mItems.get(i);
                    if (v.isObject()) {
                        NativeInstanceObject newni;
                        Dispatch2 d;
                        int scount;
                        boolean objrec;
                        Dispatch2 dsp1 = v.asObject();
                        if (dsp1 != null && dsp1.getNativeInstance(DictionaryClass.ClassID) != null) {
                            objrec = false;
                            scount = stack.size();
                            int j = 0;
                            while (j < scount) {
                                d = stack.get(j);
                                if (d == dsp1) {
                                    objrec = true;
                                    break;
                                }
                                ++j;
                            }
                            if (objrec) {
                                this.mItems.add(new Variant());
                            } else {
                                Dispatch2 newobj = TJS.createDictionaryObject();
                                this.mItems.add(new Variant(newobj, newobj));
                                newni = (DictionaryNI)newobj.getNativeInstance(DictionaryClass.ClassID);
                                if (newni != null) {
                                    ((DictionaryNI)newni).assignStructure(dsp1, stack);
                                }
                            }
                        } else if (dsp1 != null && dsp1.getNativeInstance(ArrayClass.ClassID) != null) {
                            objrec = false;
                            scount = stack.size();
                            int j = 0;
                            while (j < scount) {
                                d = stack.get(j);
                                if (d == dsp1) {
                                    objrec = true;
                                    break;
                                }
                                ++j;
                            }
                            if (objrec) {
                                this.mItems.add(new Variant());
                            } else {
                                Dispatch2 newobj = TJS.createArrayObject();
                                this.mItems.add(new Variant(newobj, newobj));
                                newni = (ArrayNI)newobj.getNativeInstance(ArrayClass.ClassID);
                                if (newni != null) {
                                    ((ArrayNI)newni).assignStructure(dsp1, stack);
                                }
                            }
                        } else {
                            this.mItems.add(v);
                        }
                    } else {
                        this.mItems.add(v);
                    }
                    ++i;
                }
            }
            finally {
                stack.remove(stack.size() - 1);
            }
        } else {
            throw new TJSException("Dictionary \u307e\u305f\u306f Array \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
    }

    static class DictionaryEnumCallback
    implements EnumMembersCallback {
        public ArrayList<Variant> mItems;

        public DictionaryEnumCallback(ArrayList<Variant> items) {
            this.mItems = items;
        }

        @Override
        public boolean callback(String name, int flags, Variant value) {
            if ((flags & 0x1000) != 0) {
                return true;
            }
            this.mItems.add(new Variant(name));
            this.mItems.add(new Variant(value));
            return true;
        }
    }
}

