/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jp.kirikiri.tjs2.TJSException;

public abstract class BinaryStream {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int APPEND = 2;
    public static final int UPDATE = 3;
    public static final int ACCESS_MASK = 15;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;

    public abstract long seek(long var1, int var3) throws TJSException;

    public abstract int read(ByteBuffer var1) throws TJSException;

    public abstract int read(byte[] var1) throws TJSException;

    public abstract int read(byte[] var1, int var2, int var3) throws TJSException;

    public abstract int write(ByteBuffer var1);

    public abstract int write(byte[] var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public abstract void write(int var1);

    public abstract void close();

    public void setEndOfStorage() throws TJSException {
        throw new TJSException("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
    }

    public long getSize() throws TJSException {
        long orgpos = this.getPosition();
        long size = this.seek(0L, 2);
        this.seek(orgpos, 0);
        return size;
    }

    public long getPosition() throws TJSException {
        return this.seek(0L, 1);
    }

    public void setPosition(long pos) throws TJSException {
        if (pos != this.seek(pos, 0)) {
            throw new TJSException("\u30b7\u30fc\u30af\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
    }

    public void readBuffer(ByteBuffer buffer) throws TJSException {
        if (this.read(buffer) != -1) {
            throw new TJSException("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
        buffer.flip();
    }

    public void writeBuffer(ByteBuffer buffer) throws TJSException {
        if (this.write(buffer) != -1) {
            throw new TJSException("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    public boolean isArchive() {
        return false;
    }

    public abstract String getFilePath();

    public FileDescriptor getFileDescriptor() {
        return null;
    }

    public long getFileOffset() {
        return 0L;
    }
}

