/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;

public class ByteCodeLoader {
    private static final boolean LOAD_SRC_POS = false;
    public static final int FILE_TAG_LE = 844319316;
    public static final int VER_TAG_LE = 0x303031;
    private static final int OBJ_TAG_LE = 1397375567;
    private static final int DATA_TAG_LE = 0x41544144;
    private static final int TYPE_VOID = 0;
    private static final int TYPE_OBJECT = 1;
    private static final int TYPE_INTER_OBJECT = 2;
    private static final int TYPE_STRING = 3;
    private static final int TYPE_OCTET = 4;
    private static final int TYPE_REAL = 5;
    private static final int TYPE_BYTE = 6;
    private static final int TYPE_SHORT = 7;
    private static final int TYPE_INTEGER = 8;
    private static final int TYPE_LONG = 9;
    private static final int TYPE_INTER_GENERATOR = 10;
    private static final int TYPE_UNKNOWN = -1;
    private static byte[] mByteArray;
    private static short[] mShortArray;
    private static int[] mIntArray;
    private static long[] mLongArray;
    private static double[] mDoubleArray;
    private static long[] mDoubleTmpArray;
    private static String[] mStringArray;
    private static ByteBuffer[] mByteBufferArray;
    private static short[] mVariantTypeData;
    private static final int MIN_BYTE_COUNT = 64;
    private static final int MIN_SHORT_COUNT = 64;
    private static final int MIN_INT_COUNT = 64;
    private static final int MIN_DOUBLE_COUNT = 8;
    private static final int MIN_LONG_COUNT = 8;
    private static final int MIN_STRING_COUNT = 1024;
    private static boolean mDeleteBuffer;
    private static byte[] mReadBuffer;
    private static final int MIN_READ_BUFFER_SIZE = 163840;
    private static ObjectsCache mObjectsCache;

    public static void initialize() {
        mDeleteBuffer = false;
        mReadBuffer = null;
        mByteArray = null;
        mShortArray = null;
        mIntArray = null;
        mLongArray = null;
        mDoubleArray = null;
        mDoubleTmpArray = null;
        mStringArray = null;
        mByteBufferArray = null;
        mObjectsCache = new ObjectsCache();
        mVariantTypeData = null;
    }

    public static void finalizeApplication() {
        mDeleteBuffer = true;
        mReadBuffer = null;
        mByteArray = null;
        mShortArray = null;
        mIntArray = null;
        mLongArray = null;
        mDoubleArray = null;
        mDoubleTmpArray = null;
        mStringArray = null;
        mByteBufferArray = null;
        mObjectsCache = null;
        mVariantTypeData = null;
    }

    public static void allwaysFreeReadBuffer() {
        mDeleteBuffer = true;
        mReadBuffer = null;
        mByteArray = null;
        mShortArray = null;
        mIntArray = null;
        mLongArray = null;
        mDoubleArray = null;
        mDoubleTmpArray = null;
        mStringArray = null;
        mByteBufferArray = null;
        mObjectsCache.release();
        mVariantTypeData = null;
    }

    public ScriptBlock readByteCode(TJS owner, String name, BinaryStream input) throws TJSException {
        try {
            int size = (int)input.getSize();
            if (mReadBuffer == null || mReadBuffer.length < size) {
                int buflen = size < 163840 ? 163840 : size;
                mReadBuffer = new byte[buflen];
            }
            byte[] databuff = mReadBuffer;
            input.read(databuff);
            input.close();
            input = null;
            int tag = databuff[0] & 0xFF | (databuff[1] & 0xFF) << 8 | (databuff[2] & 0xFF) << 16 | (databuff[3] & 0xFF) << 24;
            if (tag != 844319316) {
                return null;
            }
            int ver = databuff[4] & 0xFF | (databuff[5] & 0xFF) << 8 | (databuff[6] & 0xFF) << 16 | (databuff[7] & 0xFF) << 24;
            if (ver != 0x303031) {
                return null;
            }
            int filesize = databuff[8] & 0xFF | (databuff[9] & 0xFF) << 8 | (databuff[10] & 0xFF) << 16 | (databuff[11] & 0xFF) << 24;
            if (filesize != size) {
                return null;
            }
            tag = databuff[12] & 0xFF | (databuff[13] & 0xFF) << 8 | (databuff[14] & 0xFF) << 16 | (databuff[15] & 0xFF) << 24;
            if (tag != 0x41544144) {
                return null;
            }
            size = databuff[16] & 0xFF | (databuff[17] & 0xFF) << 8 | (databuff[18] & 0xFF) << 16 | (databuff[19] & 0xFF) << 24;
            this.readDataArea(databuff, 20, size);
            int offset = 12 + size;
            tag = databuff[offset] & 0xFF | (databuff[offset + 1] & 0xFF) << 8 | (databuff[offset + 2] & 0xFF) << 16 | (databuff[offset + 3] & 0xFF) << 24;
            offset += 4;
            if (tag != 1397375567) {
                return null;
            }
            int objsize = databuff[offset] & 0xFF | (databuff[offset + 1] & 0xFF) << 8 | (databuff[offset + 2] & 0xFF) << 16 | (databuff[offset + 3] & 0xFF) << 24;
            ScriptBlock block = new ScriptBlock(owner, name, 0, null, null);
            this.readObjects(block, databuff, offset += 4, objsize);
            ScriptBlock scriptBlock = block;
            return scriptBlock;
        }
        finally {
            if (mDeleteBuffer) {
                mReadBuffer = null;
                mByteArray = null;
                mShortArray = null;
                mIntArray = null;
                mLongArray = null;
                mDoubleArray = null;
                mDoubleTmpArray = null;
                mStringArray = null;
                mByteBufferArray = null;
                mObjectsCache.release();
                mVariantTypeData = null;
            }
        }
    }

    private void readObjects(ScriptBlock block, byte[] buff, int offset, int size) throws TJSException {
        String[] strarray = mStringArray;
        ByteBuffer[] bbarray = mByteBufferArray;
        double[] dblarray = mDoubleArray;
        byte[] barray = mByteArray;
        short[] sarray = mShortArray;
        int[] iarray = mIntArray;
        long[] larray = mLongArray;
        int toplevel = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        int objcount = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        mObjectsCache.create(objcount);
        InterCodeObject[] objs = ByteCodeLoader.mObjectsCache.mObjs;
        ArrayList<VariantRepalace> work = ByteCodeLoader.mObjectsCache.mWork;
        int[] parent = ByteCodeLoader.mObjectsCache.mParent;
        int[] propSetter = ByteCodeLoader.mObjectsCache.mPropSetter;
        int[] propGetter = ByteCodeLoader.mObjectsCache.mPropGetter;
        int[] superClassGetter = ByteCodeLoader.mObjectsCache.mSuperClassGetter;
        int[][] properties = ByteCodeLoader.mObjectsCache.mProperties;
        int o = 0;
        while (o < objcount) {
            InterCodeObject obj;
            int tag = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            offset += 4;
            if (tag != 844319316) {
                throw new TJSException("\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u58ca\u308c\u3066\u3044\u308b\u304b\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u3068\u306f\u7570\u306a\u308b\u30d5\u30a1\u30a4\u30eb\u3067\u3059");
            }
            parent[o] = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int name = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int contextType = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int maxVariableCount = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int variableReserveCount = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int maxFrameCount = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int funcDeclArgCount = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int funcDeclUnnamedArgArrayBase = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int funcDeclCollapseBase = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            propSetter[o] = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            propGetter[o] = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            superClassGetter[o] = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            int count = buff[offset += 4] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            offset += 4;
            offset += count << 3;
            LongBuffer srcpos = null;
            count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            offset += 4;
            short[] code = new short[count];
            int i = 0;
            while (i < count) {
                code[i] = (short)(buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8);
                offset += 2;
                ++i;
            }
            offset += (count & 1) << 1;
            count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            offset += 4;
            int vcount = count << 1;
            if (mVariantTypeData == null || mVariantTypeData.length < vcount) {
                mVariantTypeData = new short[vcount];
            }
            short[] data = mVariantTypeData;
            int i2 = 0;
            while (i2 < vcount) {
                data[i2] = (short)(buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8);
                offset += 2;
                ++i2;
            }
            Variant[] vdata = new Variant[count];
            int datacount = count;
            int i3 = 0;
            while (i3 < datacount) {
                int pos = i3 << 1;
                short type = data[pos];
                short index = data[pos + 1];
                switch (type) {
                    case 0: {
                        vdata[i3] = new Variant();
                        break;
                    }
                    case 1: {
                        vdata[i3] = new Variant(null, null);
                        break;
                    }
                    case 2: {
                        Variant tmp = new Variant();
                        work.add(new VariantRepalace(tmp, index));
                        vdata[i3] = tmp;
                        break;
                    }
                    case 10: {
                        Variant tmp = new Variant();
                        work.add(new VariantRepalace(tmp, index));
                        vdata[i3] = tmp;
                        break;
                    }
                    case 3: {
                        vdata[i3] = new Variant(strarray[index]);
                        break;
                    }
                    case 4: {
                        vdata[i3] = new Variant(bbarray[index]);
                        break;
                    }
                    case 5: {
                        vdata[i3] = new Variant(dblarray[index]);
                        break;
                    }
                    case 6: {
                        vdata[i3] = new Variant(barray[index]);
                        break;
                    }
                    case 7: {
                        vdata[i3] = new Variant(sarray[index]);
                        break;
                    }
                    case 8: {
                        vdata[i3] = new Variant(iarray[index]);
                        break;
                    }
                    case 9: {
                        vdata[i3] = new Variant(larray[index]);
                        break;
                    }
                    default: {
                        vdata[i3] = new Variant();
                    }
                }
                ++i3;
            }
            count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            offset += 4;
            int[] scgetterps = new int[count];
            int i4 = 0;
            while (i4 < count) {
                scgetterps[i4] = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
                offset += 4;
                ++i4;
            }
            count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
            offset += 4;
            if (count > 0) {
                int pcount = count << 1;
                int[] props = new int[pcount];
                int i5 = 0;
                while (i5 < pcount) {
                    props[i5] = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
                    offset += 4;
                    ++i5;
                }
                properties[o] = props;
            }
            objs[o] = obj = new InterCodeObject(block, mStringArray[name], contextType, code, vdata, maxVariableCount, variableReserveCount, maxFrameCount, funcDeclArgCount, funcDeclUnnamedArgArrayBase, funcDeclCollapseBase, true, srcpos, scgetterps);
            ++o;
        }
        Variant val = new Variant();
        int o2 = 0;
        while (o2 < objcount) {
            InterCodeObject parentObj = null;
            InterCodeObject propSetterObj = null;
            InterCodeObject propGetterObj = null;
            InterCodeObject superClassGetterObj = null;
            if (parent[o2] >= 0) {
                parentObj = objs[parent[o2]];
            }
            if (propSetter[o2] >= 0) {
                propSetterObj = objs[propSetter[o2]];
            }
            if (propGetter[o2] >= 0) {
                propGetterObj = objs[propGetter[o2]];
            }
            if (superClassGetter[o2] >= 0) {
                superClassGetterObj = objs[superClassGetter[o2]];
            }
            objs[o2].setCodeObject(parentObj, propSetterObj, propGetterObj, superClassGetterObj);
            if (properties[o2] != null) {
                InterCodeObject obj = parentObj;
                int[] prop = properties[o2];
                int length = prop.length >>> 1;
                int i = 0;
                while (i < length) {
                    int pos = i << 1;
                    int pname = prop[pos];
                    int pobj = prop[pos + 1];
                    val.set(objs[pobj]);
                    obj.propSet(2560, mStringArray[pname], val, obj);
                    ++i;
                }
                properties[o2] = null;
            }
            ++o2;
        }
        int count = work.size();
        int i = 0;
        while (i < count) {
            VariantRepalace w = work.get(i);
            w.Work.set(objs[w.Index]);
            ++i;
        }
        work.clear();
        InterCodeObject top = null;
        if (toplevel >= 0) {
            top = objs[toplevel];
        }
        block.setObjects(top, objs, objcount);
    }

    private void readDataArea(byte[] buff, int offset, int size) {
        int len;
        int i;
        int c;
        int count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mByteArray == null || mByteArray.length < count) {
                c = count < 64 ? 64 : count;
                mByteArray = new byte[c];
            }
            System.arraycopy(buff, offset, mByteArray, 0, count);
            int stride = count + 3 >>> 2;
            offset += stride << 2;
        }
        count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mShortArray == null || mShortArray.length < count) {
                c = count < 64 ? 64 : count;
                mShortArray = new short[c];
            }
            short[] tmp = mShortArray;
            i = 0;
            while (i < count) {
                tmp[i] = (short)(buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8);
                offset += 2;
                ++i;
            }
            offset += (count & 1) << 1;
        }
        count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mIntArray == null || mIntArray.length < count) {
                int c2 = count < 64 ? 64 : count;
                mIntArray = new int[c2];
            }
            int[] tmp = mIntArray;
            i = 0;
            while (i < count) {
                tmp[i] = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
                offset += 4;
                ++i;
            }
        }
        count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mLongArray == null || mLongArray.length < count) {
                int c3 = count < 8 ? 8 : count;
                mLongArray = new long[c3];
            }
            long[] tmp = mLongArray;
            i = 0;
            while (i < count) {
                tmp[i] = (long)(buff[offset] & 0xFF) | (long)(buff[offset + 1] & 0xFF) << 8 | (long)(buff[offset + 2] & 0xFF) << 16 | (long)(buff[offset + 3] & 0xFF) << 24 | (long)(buff[offset + 4] & 0xFF) << 32 | (long)(buff[offset + 5] & 0xFF) << 40 | (long)(buff[offset + 6] & 0xFF) << 48 | (long)(buff[offset + 7] & 0xFF) << 56;
                offset += 8;
                ++i;
            }
        }
        count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mDoubleArray == null || mDoubleArray.length < count) {
                int c4 = count < 8 ? 8 : count;
                mDoubleArray = new double[c4];
            }
            if (mDoubleTmpArray == null || mDoubleTmpArray.length < count) {
                int c5 = count < 8 ? 8 : count;
                mDoubleTmpArray = new long[c5];
            }
            long[] tmp = mDoubleTmpArray;
            i = 0;
            while (i < count) {
                tmp[i] = (long)(buff[offset] & 0xFF) | (long)(buff[offset + 1] & 0xFF) << 8 | (long)(buff[offset + 2] & 0xFF) << 16 | (long)(buff[offset + 3] & 0xFF) << 24 | (long)(buff[offset + 4] & 0xFF) << 32 | (long)(buff[offset + 5] & 0xFF) << 40 | (long)(buff[offset + 6] & 0xFF) << 48 | (long)(buff[offset + 7] & 0xFF) << 56;
                offset += 8;
                ++i;
            }
            i = 0;
            while (i < count) {
                ByteCodeLoader.mDoubleArray[i] = Double.longBitsToDouble(tmp[i]);
                ++i;
            }
        }
        count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mStringArray == null || mStringArray.length < count) {
                int c6 = count < 1024 ? 1024 : count;
                mStringArray = new String[c6];
            }
            int i2 = 0;
            while (i2 < count) {
                len = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
                offset += 4;
                char[] ch = new char[len];
                int j = 0;
                while (j < len) {
                    ch[j] = (char)(buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8);
                    offset += 2;
                    ++j;
                }
                ByteCodeLoader.mStringArray[i2] = TJS.mapGlobalStringMap(new String(ch));
                offset += (len & 1) << 1;
                ++i2;
            }
        }
        count = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
        offset += 4;
        if (count > 0) {
            if (mByteBufferArray == null || mByteBufferArray.length < count) {
                mByteBufferArray = new ByteBuffer[count];
            }
            int i3 = 0;
            while (i3 < count) {
                len = buff[offset] & 0xFF | (buff[offset + 1] & 0xFF) << 8 | (buff[offset + 2] & 0xFF) << 16 | (buff[offset + 3] & 0xFF) << 24;
                byte[] tmp = new byte[len];
                System.arraycopy(buff, offset += 4, tmp, 0, len);
                ByteCodeLoader.mByteBufferArray[i3] = ByteBuffer.wrap(tmp);
                mByteBufferArray[i3].position(len);
                offset += len + 3 >>> 2 << 2;
                ++i3;
            }
        }
    }

    static class ObjectsCache {
        public InterCodeObject[] mObjs;
        public ArrayList<VariantRepalace> mWork;
        public int[] mParent;
        public int[] mPropSetter;
        public int[] mPropGetter;
        public int[] mSuperClassGetter;
        public int[][] mProperties;
        private static final int MIN_COUNT = 500;

        ObjectsCache() {
        }

        public void create(int count) {
            if (count < 500) {
                count = 500;
            }
            if (this.mWork == null) {
                this.mWork = new ArrayList();
            }
            this.mWork.clear();
            if (this.mObjs == null || this.mObjs.length < count) {
                this.mObjs = new InterCodeObject[count];
                this.mParent = new int[count];
                this.mPropSetter = new int[count];
                this.mPropGetter = new int[count];
                this.mSuperClassGetter = new int[count];
                this.mProperties = new int[count][];
            }
        }

        public void release() {
            this.mWork = null;
            this.mObjs = null;
            this.mParent = null;
            this.mPropSetter = null;
            this.mPropGetter = null;
            this.mSuperClassGetter = null;
            this.mProperties = null;
        }
    }

    static class VariantRepalace {
        public Variant Work;
        public int Index;

        public VariantRepalace(Variant w, int i) {
            this.Work = w;
            this.Index = i;
        }
    }
}

