/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.InterCodeGenerator;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;

public class ConstArrayData {
    private ArrayList<Byte> mByte = new ArrayList();
    private ArrayList<Short> mShort = new ArrayList();
    private ArrayList<Integer> mInteger = new ArrayList();
    private ArrayList<Long> mLong = new ArrayList();
    private ArrayList<Double> mDouble = new ArrayList();
    private ArrayList<String> mString = new ArrayList();
    private ArrayList<ByteBuffer> mByteBuffer = new ArrayList();
    private HashMap<Byte, Integer> mByteHash = new HashMap();
    private HashMap<Short, Integer> mShortHash = new HashMap();
    private HashMap<Integer, Integer> mIntegerHash = new HashMap();
    private HashMap<Long, Integer> mLongHash = new HashMap();
    private HashMap<Double, Integer> mDoubleHash = new HashMap();
    private HashMap<String, Integer> mStringHash = new HashMap();
    private HashMap<ByteBuffer, Integer> mByteBufferHash = new HashMap();
    private static final byte TYPE_VOID = 0;
    private static final byte TYPE_OBJECT = 1;
    private static final byte TYPE_INTER_OBJECT = 2;
    private static final byte TYPE_STRING = 3;
    private static final byte TYPE_OCTET = 4;
    private static final byte TYPE_REAL = 5;
    private static final byte TYPE_BYTE = 6;
    private static final byte TYPE_SHORT = 7;
    private static final byte TYPE_INTEGER = 8;
    private static final byte TYPE_LONG = 9;
    private static final byte TYPE_INTER_GENERATOR = 10;
    private static final byte TYPE_UNKNOWN = -1;

    private final int putByteBuffer(ByteBuffer val) {
        Integer index = this.mByteBufferHash.get(val);
        if (index == null) {
            index = this.mByteBuffer.size();
            this.mByteBuffer.add(val);
            this.mByteBufferHash.put(val, index);
            return index;
        }
        return index;
    }

    public final int putString(String val) {
        Integer index = this.mStringHash.get(val);
        if (index == null) {
            index = this.mString.size();
            this.mString.add(val);
            this.mStringHash.put(val, index);
            return index;
        }
        return index;
    }

    private final int putByte(byte b) {
        Byte val = b;
        Integer index = this.mByteHash.get(val);
        if (index == null) {
            index = this.mByte.size();
            this.mByte.add(val);
            this.mByteHash.put(val, index);
            return index;
        }
        return index;
    }

    private final int putShort(short b) {
        Short val = b;
        Integer index = this.mShortHash.get(val);
        if (index == null) {
            index = this.mShort.size();
            this.mShort.add(val);
            this.mShortHash.put(val, index);
            return index;
        }
        return index;
    }

    private final int putInteger(int b) {
        Integer val = b;
        Integer index = this.mIntegerHash.get(val);
        if (index == null) {
            index = this.mInteger.size();
            this.mInteger.add(val);
            this.mIntegerHash.put(val, index);
            return index;
        }
        return index;
    }

    private final int putLong(long b) {
        Long val = b;
        Integer index = this.mLongHash.get(val);
        if (index == null) {
            index = this.mLong.size();
            this.mLong.add(val);
            this.mLongHash.put(val, index);
            return index;
        }
        return index;
    }

    private final int putDouble(double b) {
        Double val = b;
        Integer index = this.mDoubleHash.get(val);
        if (index == null) {
            index = this.mDouble.size();
            this.mDouble.add(val);
            this.mDoubleHash.put(val, index);
            return index;
        }
        return index;
    }

    public final byte getType(Variant v) {
        Object o = v.toJavaObject();
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return 3;
        }
        if (o instanceof Integer) {
            int val = (Integer)o;
            if (val >= -128 && val <= 127) {
                return 6;
            }
            if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
                return 7;
            }
            return 8;
        }
        if (o instanceof Double) {
            return 5;
        }
        if (o instanceof VariantClosure) {
            VariantClosure clo = (VariantClosure)o;
            Dispatch2 dsp = clo.mObject;
            if (dsp instanceof InterCodeObject) {
                return 2;
            }
            return 1;
        }
        if (o instanceof InterCodeGenerator) {
            return 10;
        }
        if (o instanceof ByteBuffer) {
            return 4;
        }
        if (o instanceof Long) {
            long val = (Long)o;
            if (val >= -128L && val <= 127L) {
                return 6;
            }
            if (val >= -32768L && val <= 32767L) {
                return 7;
            }
            if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                return 8;
            }
            return 9;
        }
        return -1;
    }

    public final int putVariant(Variant v, ScriptBlock block) {
        Object o = v.toJavaObject();
        byte type = this.getType(v);
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                VariantClosure clo = (VariantClosure)o;
                if (clo.mObject == null && clo.mObjThis == null) {
                    return 0;
                }
                return -1;
            }
            case 2: {
                VariantClosure clo = (VariantClosure)o;
                Dispatch2 dsp = clo.mObject;
                return block.getObjectIndex((InterCodeObject)dsp);
            }
            case 3: {
                return this.putString((String)o);
            }
            case 4: {
                return this.putByteBuffer((ByteBuffer)o);
            }
            case 5: {
                return this.putDouble(((Number)o).doubleValue());
            }
            case 6: {
                return this.putByte(((Number)o).byteValue());
            }
            case 7: {
                return this.putShort(((Number)o).shortValue());
            }
            case 8: {
                return this.putInteger(((Number)o).intValue());
            }
            case 9: {
                return this.putLong(((Number)o).longValue());
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }

    public final int putVariant(Variant v, Compiler block) {
        Object o = v.toJavaObject();
        byte type = this.getType(v);
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                VariantClosure clo = (VariantClosure)o;
                if (clo.mObject == null && clo.mObjThis == null) {
                    return 0;
                }
                return -1;
            }
            case 2: {
                VariantClosure clo = (VariantClosure)o;
                Dispatch2 dsp = clo.mObject;
                return block.getObjectIndex((InterCodeObject)dsp);
            }
            case 3: {
                return this.putString((String)o);
            }
            case 4: {
                return this.putByteBuffer((ByteBuffer)o);
            }
            case 5: {
                return this.putDouble(((Number)o).doubleValue());
            }
            case 6: {
                return this.putByte(((Number)o).byteValue());
            }
            case 7: {
                return this.putShort(((Number)o).shortValue());
            }
            case 8: {
                return this.putInteger(((Number)o).intValue());
            }
            case 9: {
                return this.putLong(((Number)o).longValue());
            }
            case 10: {
                return block.getCodeIndex((InterCodeGenerator)o);
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }

    public final ByteBuffer exportBuffer() {
        int size = 0;
        int stralllen = 0;
        int count = this.mString.size();
        int i = 0;
        while (i < count) {
            int len = this.mString.get(i).length();
            len = (len + 1) / 2 * 2;
            stralllen += len * 2;
            ++i;
        }
        stralllen = (stralllen + 3) / 4 * 4;
        size += stralllen + count * 4 + 4;
        int bytealllen = 0;
        count = this.mByteBuffer.size();
        int i2 = 0;
        while (i2 < count) {
            int len = this.mByteBuffer.get(i2).capacity();
            len = (len + 3) / 4 * 4;
            bytealllen += len;
            ++i2;
        }
        bytealllen = (bytealllen + 3) / 4 * 4;
        size += bytealllen + count * 4 + 4;
        count = this.mByte.size();
        count = (count + 3) / 4 * 4;
        size += count + 4;
        count = this.mShort.size() * 2;
        count = (count + 3) / 4 * 4;
        size += count + 4;
        size += this.mInteger.size() * 4 + 4;
        size += this.mLong.size() * 8 + 4;
        ByteBuffer buf = ByteBuffer.allocate(size += this.mDouble.size() * 8 + 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.clear();
        count = this.mByte.size();
        buf.putInt(count);
        int i3 = 0;
        while (i3 < count) {
            buf.put(this.mByte.get(i3));
            ++i3;
        }
        count = (count + 3) / 4 * 4 - count;
        i3 = 0;
        while (i3 < count) {
            buf.put((byte)0);
            ++i3;
        }
        count = this.mShort.size();
        buf.putInt(count);
        i3 = 0;
        while (i3 < count) {
            buf.putShort(this.mShort.get(i3));
            ++i3;
        }
        count *= 2;
        count = (count + 3) / 4 * 4 - count;
        i3 = 0;
        while (i3 < count) {
            buf.put((byte)0);
            ++i3;
        }
        count = this.mInteger.size();
        buf.putInt(count);
        i3 = 0;
        while (i3 < count) {
            buf.putInt(this.mInteger.get(i3));
            ++i3;
        }
        count = this.mLong.size();
        buf.putInt(count);
        i3 = 0;
        while (i3 < count) {
            buf.putLong(this.mLong.get(i3));
            ++i3;
        }
        count = this.mDouble.size();
        buf.putInt(count);
        i3 = 0;
        while (i3 < count) {
            buf.putLong(Double.doubleToRawLongBits(this.mDouble.get(i3)));
            ++i3;
        }
        count = this.mString.size();
        buf.putInt(count);
        i3 = 0;
        while (i3 < count) {
            String str = this.mString.get(i3);
            int len = str.length();
            buf.putInt(len);
            int s = 0;
            while (s < len) {
                buf.putChar(str.charAt(s));
                ++s;
            }
            if (len % 2 == 1) {
                buf.putChar('\u0000');
            }
            ++i3;
        }
        count = this.mByteBuffer.size();
        buf.putInt(count);
        i3 = 0;
        while (i3 < count) {
            ByteBuffer by = this.mByteBuffer.get(i3);
            int cap = by.capacity();
            buf.putInt(cap);
            int b = 0;
            while (b < cap) {
                buf.put(by.get(b));
                ++b;
            }
            cap = (cap + 3) / 4 * 4 - cap;
            b = 0;
            while (b < cap) {
                buf.put((byte)0);
                ++b;
            }
            ++i3;
        }
        buf.flip();
        return buf;
    }
}

