/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.EnumMembersCallback;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.IntWrapper;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.SimpleGetSetProperty;
import jp.kirikiri.tjs2.SymbolData;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class CustomObject
extends Dispatch {
    private static final boolean AUTO_REBUILD_HASH = false;
    private static final int AUTO_REBUILD_HASH_THRESHOLD = 2;
    private static final int MAX_NATIVE_CLASS = 4;
    private static final int OBJECT_HASH__BITS_LIMITS = 32;
    private static final int NAMESPACE_DEFAULT_HASH_BITS = 3;
    private static final int SYMBOL_USING = 1;
    private static final int SYMBOL_INIT = 2;
    private static final int SYMBOL_HIDDEN = 8;
    private static final int SYMBOL_STATIC = 16;
    private static final int OP_BAND = 1;
    private static final int OP_BOR = 2;
    private static final int OP_BXOR = 3;
    private static final int OP_SUB = 4;
    private static final int OP_ADD = 5;
    private static final int OP_MOD = 6;
    private static final int OP_DIV = 7;
    private static final int OP_IDIV = 8;
    private static final int OP_MUL = 9;
    private static final int OP_LOR = 10;
    private static final int OP_LAND = 11;
    private static final int OP_SAR = 12;
    private static final int OP_SAL = 13;
    private static final int OP_SR = 14;
    private static final int OP_INC = 15;
    private static final int OP_DEC = 16;
    private static final int OP_MASK = 31;
    private static final int OP_MIN = 1;
    private static final int OP_MAX = 16;
    private static String mFinalizeName;
    private static String mMissingName;
    private static int mGlobalRebuildHashMagic;
    public int mCount;
    public int mHashMask;
    public int mHashSize;
    public SymbolData[] mSymbols;
    public int mRebuildHashMagic = mGlobalRebuildHashMagic;
    public boolean mIsInvalidated;
    public boolean mIsInvalidating;
    public NativeInstance[] mClassInstances;
    public int[] mClassIDs;
    private NativeInstance mPrimaryClassInstances;
    private int mPrimaryClassID;
    protected boolean mCallFinalize;
    protected String mfinalize_name;
    protected boolean mCallMissing;
    protected boolean mProsessingMissing;
    protected String mmissing_name;
    protected ArrayList<String> mClassNames;

    static {
        mGlobalRebuildHashMagic = 0;
    }

    public static void doRehash() {
        ++mGlobalRebuildHashMagic;
    }

    public static void initialize() {
        mFinalizeName = null;
        mMissingName = null;
        mGlobalRebuildHashMagic = 0;
    }

    public static void finalizeApplication() {
        mFinalizeName = null;
        mMissingName = null;
    }

    protected final boolean getValidity() {
        return !this.mIsInvalidated;
    }

    protected void finalizeObject() throws VariantException, TJSException {
        if (this.mCallFinalize && !TJS.IsTarminating) {
            this.funcCall(0, this.mfinalize_name, null, TJS.NULL_ARG, this);
        }
        int i = 3;
        while (i >= 0) {
            if (this.mClassIDs[i] != -1 && this.mClassInstances[i] != null) {
                this.mClassInstances[i].invalidate();
            }
            --i;
        }
        this.mPrimaryClassInstances = null;
        this.deleteAllMembers();
    }

    private void finalizeInternal() throws VariantException, TJSException {
        if (this.mIsInvalidating) {
            return;
        }
        this.mIsInvalidating = true;
        try {
            if (!this.mIsInvalidated) {
                this.finalizeObject();
                this.mIsInvalidated = true;
            }
        }
        finally {
            this.mIsInvalidating = false;
        }
    }

    public CustomObject() {
        this(3);
    }

    public CustomObject(int hashbits) {
        if (hashbits > 32) {
            hashbits = 32;
        }
        this.mHashSize = 1 << hashbits;
        this.mHashMask = this.mHashSize - 1;
        this.mSymbols = new SymbolData[this.mHashSize];
        int i = 0;
        while (i < this.mHashSize) {
            this.mSymbols[i] = new SymbolData();
            ++i;
        }
        this.mCallFinalize = true;
        if (mFinalizeName == null) {
            mFinalizeName = TJS.mapGlobalStringMap("finalize");
            mMissingName = TJS.mapGlobalStringMap("missing");
        }
        this.mfinalize_name = mFinalizeName;
        this.mmissing_name = mMissingName;
        this.mClassInstances = new NativeInstance[4];
        this.mClassIDs = new int[4];
        i = 0;
        while (i < 4) {
            this.mClassIDs[i] = -1;
            ++i;
        }
        this.mClassNames = new ArrayList();
        this.mPrimaryClassID = -1;
    }

    @Override
    protected void beforeDestruction() throws VariantException, TJSException {
        this.finalizeInternal();
    }

    private boolean callGetMissing(String name, Variant result) throws VariantException, TJSException {
        if (this.mProsessingMissing) {
            return false;
        }
        this.mProsessingMissing = true;
        boolean res = false;
        try {
            Variant val = new Variant();
            SimpleGetSetProperty prop = new SimpleGetSetProperty(val);
            Variant[] args = new Variant[]{new Variant(0), new Variant(new String(name)), new Variant(prop)};
            Variant funcresult = new Variant();
            int er = this.funcCall(0, this.mmissing_name, funcresult, args, this);
            if (er < 0) {
                res = false;
            } else {
                res = funcresult.asInteger() != 0;
                result.set(val);
            }
        }
        finally {
            this.mProsessingMissing = false;
        }
        return res;
    }

    private boolean callSetMissing(String name, Variant value) throws VariantException, TJSException {
        if (this.mProsessingMissing) {
            return false;
        }
        this.mProsessingMissing = true;
        boolean res = false;
        try {
            Variant val = new Variant(value);
            SimpleGetSetProperty prop = new SimpleGetSetProperty(val);
            Variant[] args = new Variant[]{new Variant(1), new Variant(new String(name)), new Variant(prop)};
            Variant funcresult = new Variant();
            int er = this.funcCall(0, this.mmissing_name, funcresult, args, this);
            res = er < 0 ? false : funcresult.asInteger() != 0;
        }
        finally {
            this.mProsessingMissing = false;
        }
        return res;
    }

    private SymbolData add(String name) throws TJSException {
        if (name == null) {
            return null;
        }
        SymbolData data = this.find(name);
        if (data != null) {
            return data;
        }
        int hash = name.hashCode();
        int pos = hash & this.mHashMask;
        SymbolData lv1 = this.mSymbols[pos];
        if ((lv1.mSymFlags & 1) != 0) {
            data = new SymbolData();
            data.selfClear();
            data.mNext = lv1.mNext;
            lv1.mNext = data;
            data.setName(name, hash);
            data.mSymFlags |= 1;
        } else {
            if ((lv1.mSymFlags & 2) == 0) {
                lv1.selfClear();
            }
            lv1.setName(name, hash);
            lv1.mSymFlags |= 1;
            data = lv1;
        }
        ++this.mCount;
        return data;
    }

    private SymbolData addTo(String name, SymbolData[] newdata, int newhashmask) throws TJSException {
        SymbolData data;
        if (name == null) {
            return null;
        }
        int hash = name.hashCode();
        SymbolData lv1 = newdata[hash & newhashmask];
        if ((lv1.mSymFlags & 1) != 0) {
            data = new SymbolData();
            data.selfClear();
            data.mNext = lv1.mNext;
            lv1.mNext = data;
            data.setName(name, hash);
            data.mSymFlags |= 1;
        } else {
            if ((lv1.mSymFlags & 2) == 0) {
                lv1.selfClear();
            }
            lv1.setName(name, hash);
            lv1.mSymFlags |= 1;
            data = lv1;
        }
        return data;
    }

    private void rebuildHash() throws TJSException {
        int newhashsize;
        int newhashbits;
        int r;
        this.mRebuildHashMagic = mGlobalRebuildHashMagic;
        int v = this.mCount;
        if ((v & 0xFFFF0000) != 0) {
            r = 16;
            v >>= 16;
        } else {
            r = 0;
        }
        if ((v & 0xFF00) != 0) {
            r += 8;
            v >>= 8;
        }
        if ((v & 0xF0) != 0) {
            r += 4;
            v >>= 4;
        }
        if ((newhashbits = r + (-21936 >> (v <<= 1) & 3) + 2) > 32) {
            newhashbits = 32;
        }
        if ((newhashsize = 1 << newhashbits) == this.mHashSize) {
            return;
        }
        int newhashmask = newhashsize - 1;
        int orgcount = this.mCount;
        SymbolData[] newsymbols = new SymbolData[newhashsize];
        int i = 0;
        while (i < newhashsize) {
            newsymbols[i] = new SymbolData();
            ++i;
        }
        try {
            i = 0;
            while (i < this.mHashSize) {
                SymbolData data;
                SymbolData lv1 = this.mSymbols[i];
                SymbolData d = lv1.mNext;
                while (d != null) {
                    SymbolData data2;
                    SymbolData nextd = d.mNext;
                    if ((d.mSymFlags & 1) != 0 && (data2 = this.addTo(d.mName, newsymbols, newhashmask)) != null) {
                        data2.mValue.copyRef(d.mValue);
                        data2.mSymFlags &= 0xFFFFFFE7;
                        data2.mSymFlags |= d.mSymFlags & 0x18;
                    }
                    d = nextd;
                }
                if ((lv1.mSymFlags & 1) != 0 && (data = this.addTo(lv1.mName, newsymbols, newhashmask)) != null) {
                    data.mValue.copyRef(lv1.mValue);
                    data.mSymFlags &= 0xFFFFFFE7;
                    data.mSymFlags |= lv1.mSymFlags & 0x18;
                }
                ++i;
            }
        }
        catch (TJSException e) {
            int _HashMask = this.mHashMask;
            int _HashSize = this.mHashSize;
            SymbolData[] _Symbols = this.mSymbols;
            this.mSymbols = newsymbols;
            this.mHashSize = newhashsize;
            this.mHashMask = newhashmask;
            this.deleteAllMembers();
            this.mSymbols = null;
            this.mHashMask = _HashMask;
            this.mHashSize = _HashSize;
            this.mSymbols = _Symbols;
            this.mCount = orgcount;
            throw e;
        }
        this.deleteAllMembers();
        this.mSymbols = null;
        this.mSymbols = newsymbols;
        this.mHashSize = newhashsize;
        this.mHashMask = newhashmask;
        this.mCount = orgcount;
    }

    private boolean deleteByName(String name) {
        int hash = name.hashCode();
        SymbolData lv1 = this.mSymbols[hash & this.mHashMask];
        if ((lv1.mSymFlags & 1) == 0 && lv1.mNext == null) {
            return false;
        }
        if ((lv1.mSymFlags & 1) != 0 && lv1.nameMatch(name)) {
            lv1.postClear();
            --this.mCount;
            return true;
        }
        SymbolData d = lv1.mNext;
        SymbolData prevd = lv1;
        while (d != null) {
            if ((d.mSymFlags & 1) != 0 && d.mHash == hash && d.nameMatch(name)) {
                prevd.mNext = d.mNext;
                d.destory();
                d = null;
                --this.mCount;
                return true;
            }
            prevd = d;
            d = d.mNext;
        }
        return false;
    }

    private void deleteAllMembers() {
        SymbolData nextd;
        SymbolData d;
        SymbolData lv1;
        int i = 0;
        while (i < this.mHashSize) {
            Variant val;
            lv1 = this.mSymbols[i];
            d = lv1.mNext;
            while (d != null) {
                Variant val2;
                nextd = d.mNext;
                if ((d.mSymFlags & 1) != 0 && (val2 = d.mValue).isObject()) {
                    val2.clear();
                }
                d = nextd;
            }
            if ((lv1.mSymFlags & 1) != 0 && (val = lv1.mValue).isObject()) {
                val.clear();
            }
            ++i;
        }
        i = 0;
        while (i < this.mHashSize) {
            lv1 = this.mSymbols[i];
            d = lv1.mNext;
            while (d != null) {
                nextd = d.mNext;
                if ((d.mSymFlags & 1) != 0) {
                    d.destory();
                }
                d = null;
                d = nextd;
            }
            if ((lv1.mSymFlags & 1) != 0) {
                lv1.postClear();
            }
            lv1.mNext = null;
            ++i;
        }
        this.mCount = 0;
    }

    private SymbolData find(String name) {
        if (name == null) {
            return null;
        }
        int hash = name.hashCode();
        int pos = hash & this.mHashMask;
        SymbolData lv1 = this.mSymbols[pos];
        if ((lv1.mSymFlags & 1) == 0 && lv1.mNext == null) {
            return null;
        }
        int cnt = 0;
        SymbolData prevd = lv1;
        SymbolData d = lv1.mNext;
        while (d != null) {
            if (d.mHash == hash && (d.mSymFlags & 1) != 0 && d.nameMatch(name)) {
                if (cnt > 2) {
                    prevd.mNext = d.mNext;
                    d.mNext = lv1.mNext;
                    lv1.mNext = d;
                }
                return d;
            }
            prevd = d;
            d = d.mNext;
            ++cnt;
        }
        if (lv1.mHash == hash && (lv1.mSymFlags & 1) != 0 && lv1.nameMatch(name)) {
            return lv1;
        }
        return null;
    }

    private static boolean enumCallback(int flags, EnumMembersCallback callback, Variant value, Dispatch2 objthis, SymbolData data) throws TJSException {
        int newflags = 0;
        if ((data.mSymFlags & 8) != 0) {
            newflags |= 0x1000;
        }
        if ((data.mSymFlags & 0x10) != 0) {
            newflags |= 0x10000;
        }
        value.clear();
        if ((flags & 0x100000) == 0) {
            Variant targ;
            boolean getvalues = false;
            if ((flags & 0x800) == 0 && (targ = data.mValue).isObject()) {
                VariantClosure tvclosure = targ.asObjectClosure();
                int hr = -1002;
                if (tvclosure.mObject != null) {
                    Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                    hr = tvclosure.mObject.propGet(0, null, value, disp);
                }
                if (hr >= 0) {
                    getvalues = true;
                } else if (hr != -1002 && hr != -1005 && hr != -1006) {
                    return false;
                }
            }
            if (!getvalues) {
                value.copyRef(data.mValue);
            }
        }
        return callback.callback(data.mName, newflags, value);
    }

    @Override
    public int enumMembers(int flags, EnumMembersCallback callback, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (callback == null) {
            return 0;
        }
        Variant value = new Variant();
        int i = 0;
        while (i < this.mHashSize) {
            SymbolData lv1 = this.mSymbols[i];
            SymbolData d = lv1.mNext;
            while (d != null) {
                SymbolData nextd = d.mNext;
                if ((d.mSymFlags & 1) != 0 && !CustomObject.enumCallback(flags, callback, value, objthis, d)) {
                    return 0;
                }
                d = nextd;
            }
            if ((lv1.mSymFlags & 1) != 0 && !CustomObject.enumCallback(flags, callback, value, objthis, lv1)) {
                return 0;
            }
            ++i;
        }
        return 0;
    }

    protected static int defaultPropGet(int flag, Variant targ, Variant result, Dispatch2 objthis) throws VariantException, TJSException {
        if ((flag & 0x800) == 0 && targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            int hr = -1002;
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                hr = tvclosure.mObject.propGet(0, null, result, disp);
            }
            if (hr >= 0) {
                return hr;
            }
            if (hr != -1002 && hr != -1005 && hr != -1006) {
                return hr;
            }
        }
        if (result == null) {
            return -1003;
        }
        result.copyRef(targ);
        return 0;
    }

    protected int copyAllMembers(CustomObject dest) throws TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (!dest.getValidity()) {
            return -1006;
        }
        Variant result = new Variant();
        int i = 0;
        while (i < this.mHashSize) {
            SymbolData lv1 = this.mSymbols[i];
            SymbolData d = lv1.mNext;
            while (d != null) {
                SymbolData nextd = d.mNext;
                if ((d.mSymFlags & 1) != 0 && (d.mSymFlags & 0x10) == 0) {
                    result.set(d.mValue);
                    if (result.isObject()) {
                        result.changeClosureObjThis(dest);
                    }
                    SymbolData data = dest.add(d.mName);
                    data.mSymFlags = (d.mSymFlags & 8) != 0 ? (data.mSymFlags |= 8) : (data.mSymFlags &= 0xFFFFFFF7);
                    data.mValue.copyRef(result);
                }
                d = nextd;
            }
            if ((lv1.mSymFlags & 1) != 0 && (lv1.mSymFlags & 0x10) == 0) {
                result.set(lv1.mValue);
                if (result.isObject()) {
                    result.changeClosureObjThis(dest);
                }
                SymbolData data = dest.add(lv1.mName);
                data.mSymFlags = (lv1.mSymFlags & 8) != 0 ? (data.mSymFlags |= 8) : (data.mSymFlags &= 0xFFFFFFF7);
                data.mValue.copyRef(result);
            }
            ++i;
        }
        return 0;
    }

    public void clear() {
        this.deleteAllMembers();
    }

    public int getValueInteger(String name) throws VariantException {
        SymbolData data = this.find(name);
        if (data == null) {
            return -1;
        }
        Variant val = data.mValue;
        return val.asInteger();
    }

    private static int tryFuncCallViaPropGet(VariantClosure tvclosure, int flag, Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        Variant tmp = new Variant();
        Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
        int er = tvclosure.mObject.propGet(0, null, tmp, disp);
        if (er >= 0) {
            tvclosure = tmp.asObjectClosure();
            disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
            er = tvclosure.mObject.funcCall(flag, null, result, param, disp);
        }
        return er;
    }

    protected static int defaultFuncCall(int flag, Variant targ, Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        if (targ.isObject()) {
            Dispatch2 disp;
            int er = -1005;
            VariantClosure tvclosure = targ.asObjectClosure();
            if (tvclosure.mObject != null && (er = tvclosure.mObject.funcCall(flag, null, result, param, disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis)) == -1005) {
                er = CustomObject.tryFuncCallViaPropGet(tvclosure, flag, result, param, objthis);
            }
            return er;
        }
        return -1005;
    }

    @Override
    public int funcCall(int flag, String membername, Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            return -1005;
        }
        SymbolData data = this.find(membername);
        if (data == null) {
            Variant value_func;
            if (this.mCallMissing && this.callGetMissing(membername, value_func = new Variant())) {
                return CustomObject.defaultFuncCall(flag, value_func, result, param, objthis);
            }
            return -1001;
        }
        return CustomObject.defaultFuncCall(flag, data.mValue, result, param, objthis);
    }

    @Override
    public int propGet(int flag, String membername, Variant result, Dispatch2 objthis) throws VariantException, TJSException {
        Variant value;
        if (this.mRebuildHashMagic != mGlobalRebuildHashMagic) {
            this.rebuildHash();
        }
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            return -1005;
        }
        SymbolData data = this.find(membername);
        if (data == null && this.mCallMissing && this.callGetMissing(membername, value = new Variant())) {
            return CustomObject.defaultPropGet(flag, value, result, objthis);
        }
        if (data == null && (flag & 0x200) != 0) {
            data = this.add(membername);
        }
        if (data == null) {
            return -1001;
        }
        return CustomObject.defaultPropGet(flag, data.mValue, result, objthis);
    }

    protected static int defaultPropSet(int flag, Variant targ, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        if ((flag & 0x800) == 0 && targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            int hr = -1002;
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                hr = tvclosure.mObject.propSet(0, null, param, disp);
            }
            if (hr >= 0) {
                return hr;
            }
            if (hr != -1002 && hr != -1005 && hr != -1006) {
                return hr;
            }
        }
        if (param == null) {
            return -1003;
        }
        targ.copyRef(param);
        return 0;
    }

    @Override
    public int propSet(int flag, String membername, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            return -1005;
        }
        SymbolData data = null;
        if (this.mCallMissing && (data = this.find(membername)) != null && this.callSetMissing(membername, param)) {
            return 0;
        }
        data = (flag & 0x200) != 0 ? this.add(membername) : this.find(membername);
        if (data == null) {
            return -1001;
        }
        data.mSymFlags = (flag & 0x1000) != 0 ? (data.mSymFlags |= 8) : (data.mSymFlags &= 0xFFFFFFF7);
        data.mSymFlags = (flag & 0x10000) != 0 ? (data.mSymFlags |= 0x10) : (data.mSymFlags &= 0xFFFFFFEF);
        if ((flag & 0x800) == 0 && data.mValue.isObject()) {
            VariantClosure tvclosure = data.mValue.asObjectClosure();
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                int hr = tvclosure.mObject.propSet(0, null, param, disp);
                if (hr >= 0) {
                    return hr;
                }
                if (hr != -1002 && hr != -1005 && hr != -1006) {
                    return hr;
                }
            }
            data = this.find(membername);
        }
        if (param == null) {
            return -1003;
        }
        data.mValue.copyRef(param);
        return 0;
    }

    @Override
    public int getCount(IntWrapper result, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (result == null) {
            return -1003;
        }
        result.value = this.mCount;
        return 0;
    }

    @Override
    public int deleteMember(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            return -1001;
        }
        if (!this.deleteByName(membername)) {
            return -1001;
        }
        return 0;
    }

    protected static int defaultInvalidate(int flag, Variant targ, Dispatch2 objthis) throws VariantException, TJSException {
        if (targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                return tvclosure.mObject.invalidate(flag, null, disp);
            }
        }
        return 2;
    }

    @Override
    public int invalidate(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        Variant value;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            if (this.mIsInvalidated) {
                return 2;
            }
            this.finalizeInternal();
            return 1;
        }
        SymbolData data = this.find(membername);
        if (data == null && this.mCallMissing && this.callGetMissing(membername, value = new Variant())) {
            return CustomObject.defaultInvalidate(flag, value, objthis);
        }
        if (data == null) {
            return -1001;
        }
        return CustomObject.defaultInvalidate(flag, data.mValue, objthis);
    }

    protected static int defaultIsValid(int flag, Variant targ, Dispatch2 objthis) throws VariantException, TJSException {
        if (targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                return tvclosure.mObject.isValid(flag, null, disp);
            }
        }
        return 1;
    }

    @Override
    public int isValid(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        Variant value;
        if (membername == null) {
            if (this.mIsInvalidated) {
                return 2;
            }
            return 1;
        }
        SymbolData data = this.find(membername);
        if (data == null && this.mCallMissing && this.callGetMissing(membername, value = new Variant())) {
            return CustomObject.defaultIsValid(flag, value, objthis);
        }
        if (data == null) {
            return -1001;
        }
        return CustomObject.defaultIsValid(flag, data.mValue, objthis);
    }

    protected static int defaultCreateNew(int flag, Variant targ, Holder<Dispatch2> result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        if (targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                return tvclosure.mObject.createNew(flag, null, result, param, disp);
            }
        }
        return -1005;
    }

    @Override
    public int createNew(int flag, String membername, Holder<Dispatch2> result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        Variant value;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            return -1005;
        }
        SymbolData data = this.find(membername);
        if (data == null && this.mCallMissing && this.callGetMissing(membername, value = new Variant())) {
            return CustomObject.defaultCreateNew(flag, value, result, param, objthis);
        }
        if (data == null) {
            return -1001;
        }
        return CustomObject.defaultCreateNew(flag, data.mValue, result, param, objthis);
    }

    public static int defaultIsInstanceOf(int flag, Variant targ, String name, Dispatch2 objthis) throws VariantException, TJSException {
        if (targ.isVoid()) {
            return 2;
        }
        if ("Object".equals(name)) {
            return 1;
        }
        if (targ.isNumber()) {
            if ("Number".equals(name)) {
                return 1;
            }
            return 2;
        }
        if (targ.isString()) {
            if ("String".equals(name)) {
                return 1;
            }
            return 2;
        }
        if (targ.isOctet()) {
            if ("Octet".equals(name)) {
                return 1;
            }
            return 2;
        }
        if (targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            if (tvclosure.mObject != null) {
                Dispatch2 disp = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                return tvclosure.mObject.isInstanceOf(flag, null, name, disp);
            }
            return 2;
        }
        return 2;
    }

    @Override
    public int isInstanceOf(int flag, String membername, String classname, Dispatch2 objthis) throws VariantException, TJSException {
        Variant value;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            if ("Object".equals(classname)) {
                return 1;
            }
            int count = this.mClassNames.size();
            int i = 0;
            while (i < count) {
                if (this.mClassNames.get(i).equals(classname)) {
                    return 1;
                }
                ++i;
            }
            return 2;
        }
        SymbolData data = this.find(membername);
        if (data == null && this.mCallMissing && this.callGetMissing(membername, value = new Variant())) {
            return CustomObject.defaultIsInstanceOf(flag, value, classname, objthis);
        }
        if (data == null) {
            return -1001;
        }
        return CustomObject.defaultIsInstanceOf(flag, data.mValue, classname, objthis);
    }

    protected static int defaultOperation(int flag, Variant targ, Variant result, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        int op = flag & 0x1F;
        if (op != 15 && op != 16 && param == null) {
            return -1003;
        }
        if (op < 1 || op > 16) {
            return -1003;
        }
        if (targ.isObject()) {
            VariantClosure tvclosure = targ.asObjectClosure();
            if (tvclosure.mObject != null) {
                Variant tmp = new Variant();
                Dispatch2 ot = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                int hr = tvclosure.mObject.propGet(0, null, tmp, ot);
                if (hr >= 0) {
                    CustomObject.doVariantOperation(op, tmp, param);
                    hr = tvclosure.mObject.propSet(0, null, tmp, ot);
                    if (hr < 0) {
                        return hr;
                    }
                    if (result != null) {
                        result.copyRef(tmp);
                    }
                    return 0;
                }
                if (hr != -1002 && hr != -1005 && hr != -1006) {
                    return hr;
                }
            }
        }
        CustomObject.doVariantOperation(op, targ, param);
        if (result != null) {
            result.copyRef(targ);
        }
        return 0;
    }

    @Override
    public int operation(int flag, String membername, Variant result, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            return -1005;
        }
        int op = flag & 0x1F;
        if (op != 15 && op != 16 && param == null) {
            return -1003;
        }
        if (op < 1 || op > 16) {
            return -1003;
        }
        SymbolData data = this.find(membername);
        if (data == null && this.mCallMissing) {
            return super.operation(flag, membername, result, param, objthis);
        }
        if (data == null) {
            return -1001;
        }
        if (data.mValue.isObject()) {
            VariantClosure tvclosure = data.mValue.asObjectClosure();
            if (tvclosure.mObject != null) {
                Variant tmp = new Variant();
                Dispatch2 ot = tvclosure.mObjThis != null ? tvclosure.mObjThis : objthis;
                int hr = tvclosure.mObject.propGet(0, null, tmp, ot);
                if (hr >= 0) {
                    CustomObject.doVariantOperation(op, tmp, param);
                    hr = tvclosure.mObject.propSet(0, null, tmp, ot);
                    if (hr < 0) {
                        return hr;
                    }
                    if (result != null) {
                        result.copyRef(tmp);
                    }
                    return 0;
                }
                if (hr != -1002 && hr != -1005 && hr != -1006) {
                    return hr;
                }
            }
        }
        Variant tmp = data.mValue;
        CustomObject.doVariantOperation(op, tmp, param);
        if (result != null) {
            result.copyRef(tmp);
        }
        return 0;
    }

    public int dispatchOperation(int flag, String membername, Variant result, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        return super.operation(flag, membername, result, param, objthis);
    }

    @Override
    public int nativeInstanceSupport(int flag, int classid, Holder<NativeInstance> pointer) {
        if (flag == 2) {
            int i = 0;
            while (i < 4) {
                if (this.mClassIDs[i] == classid) {
                    pointer.mValue = this.mClassInstances[i];
                    return 0;
                }
                ++i;
            }
            return -1;
        }
        if (flag == 1) {
            if (this.mPrimaryClassID == -1) {
                this.mPrimaryClassID = classid;
                this.mPrimaryClassInstances = (NativeInstance)pointer.mValue;
            }
            int i = 0;
            while (i < 4) {
                if (this.mClassIDs[i] == -1) {
                    this.mClassIDs[i] = classid;
                    this.mClassInstances[i] = (NativeInstance)pointer.mValue;
                    return 0;
                }
                ++i;
            }
            return -1;
        }
        return -1002;
    }

    @Override
    public int addClassInstanveInfo(String name) {
        this.mClassNames.add(name);
        return 0;
    }

    @Override
    public int classInstanceInfo(int flag, int num, Variant value) throws VariantException {
        switch (flag) {
            case 1: {
                String name = value.asString();
                this.mClassNames.add(name);
                return 0;
            }
            case 0: {
                if (num >= this.mClassNames.size()) {
                    return -1;
                }
                value.set(this.mClassNames.get(num));
                return 0;
            }
            case 2: {
                this.mfinalize_name = value.asString();
                this.mCallFinalize = this.mfinalize_name.length() > 0;
                return 0;
            }
            case 3: {
                this.mmissing_name = value.asString();
                this.mCallMissing = this.mmissing_name.length() > 0;
                return 0;
            }
        }
        return -1002;
    }

    @Override
    public NativeInstance getNativeInstance(int classid) {
        if (this.mPrimaryClassID == classid) {
            return this.mPrimaryClassInstances;
        }
        int i = 0;
        while (i < 4) {
            if (this.mClassIDs[i] == classid) {
                return this.mClassInstances[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public int setNativeInstance(int classid, NativeInstance ni) {
        if (this.mPrimaryClassID == -1) {
            this.mPrimaryClassID = classid;
            this.mPrimaryClassInstances = ni;
        }
        int i = 0;
        while (i < 4) {
            if (this.mClassIDs[i] == -1) {
                this.mClassIDs[i] = classid;
                this.mClassInstances[i] = ni;
                return 0;
            }
            ++i;
        }
        return -1;
    }

    public final String getClassNames() {
        if (this.mClassNames != null && this.mClassNames.size() > 0) {
            StringBuilder builder = new StringBuilder(512);
            int count = this.mClassNames.size();
            int i = 0;
            while (i < count) {
                if (i != 0) {
                    builder.append(',');
                }
                builder.append(this.mClassNames.get(i));
                ++i;
            }
            return builder.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(1024);
        int i = 0;
        while (i < this.mHashSize) {
            SymbolData lv1 = this.mSymbols[i];
            SymbolData d = lv1.mNext;
            while (d != null) {
                SymbolData nextd = d.mNext;
                if ((d.mSymFlags & 1) != 0) {
                    builder.append(d.mName);
                    builder.append(" : ");
                    builder.append(d.mValue.toString());
                    builder.append(", ");
                }
                d = nextd;
            }
            if ((lv1.mSymFlags & 1) != 0) {
                builder.append(lv1.mName);
                builder.append(" : ");
                builder.append(lv1.mValue.toString());
                builder.append(", ");
            }
            ++i;
        }
        if (builder.length() == 0) {
            return "empty";
        }
        return builder.toString();
    }

    public int propSetConstArray(String[] membername, int[] param, Dispatch2 objthis) throws VariantException, TJSException {
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername.length != param.length) {
            throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        int count = membername.length;
        int i = 0;
        while (i < count) {
            if (membername[i] == null) {
                throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            String name = TJS.mapGlobalStringMap(membername[i]);
            SymbolData data = this.add(name);
            data.mSymFlags &= 0xFFFFFFF7;
            data.mSymFlags &= 0xFFFFFFEF;
            if (data.mValue.isObject()) {
                throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            data.mValue.set(param[i]);
            ++i;
        }
        return 0;
    }
}

