/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.kirikiri.tjs2.DateNI;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class DateClass
extends NativeClass {
    public static int mClassID;
    private static final String CLASS_NAME = "Date";

    @Override
    protected NativeInstance createNativeInstance() {
        return new DateNI();
    }

    public DateClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        mClassID = NCM_CLASSID;
        this.registerNCM(CLASS_NAME, new NativeClassConstructor(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                int hr = _this.construct(param, objthis);
                if (hr < 0) {
                    return hr;
                }
                if (param.length == 0) {
                    _this.mDateTime = Calendar.getInstance();
                } else if (param.length >= 1) {
                    if (param[0].isString()) {
                        _this.mDateTime = DateClass.parseDateString(param[0].getString());
                    } else {
                        int mon = 0;
                        int day = 1;
                        int h = 0;
                        int m = 0;
                        int s = 0;
                        int y = param[0].asInteger();
                        if (param.length > 1 && !param[1].isVoid()) {
                            mon = param[1].asInteger();
                        }
                        if (param.length > 2 && !param[2].isVoid()) {
                            day = param[2].asInteger();
                        }
                        if (param.length > 3 && !param[3].isVoid()) {
                            h = param[3].asInteger();
                        }
                        if (param.length > 4 && !param[4].isVoid()) {
                            m = param[4].asInteger();
                        }
                        if (param.length > 5 && !param[5].isVoid()) {
                            s = param[5].asInteger();
                        }
                        Calendar cal = Calendar.getInstance();
                        cal.set(y, mon, day, h, m, s);
                        _this.mDateTime = cal;
                    }
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("finalize", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setYear", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                _this.mDateTime.set(1, param[0].asInteger());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setMonth", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                _this.mDateTime.set(2, param[0].asInteger());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setDate", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                _this.mDateTime.set(5, param[0].asInteger());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setHours", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                _this.mDateTime.set(11, param[0].asInteger());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setMinutes", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                _this.mDateTime.set(12, param[0].asInteger());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setSeconds", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                _this.mDateTime.set(13, param[0].asInteger());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("setTime", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                double num = param[0].asDouble();
                _this.mDateTime.setTimeInMillis((long)num);
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getDate", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(5));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getDay", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(7));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getHours", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(11));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getMinutes", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(12));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getMonth", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(2));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getSeconds", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(13));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getTime", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    long num = _this.mDateTime.getTimeInMillis();
                    result.set(num);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getTimezoneOffset", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (result != null) {
                    result.set(TimeZone.getDefault().getRawOffset() / 60000);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("getYear", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (result != null) {
                    result.set(_this.mDateTime.get(1));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("parse", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                DateNI _this = (DateNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                _this.mDateTime = DateClass.parseDateString(param[0].getString());
                return 0;
            }
        }, CLASS_NAME, 1, 0);
    }

    public static Calendar parseDateString(String str) throws TJSException {
        DateFormat format = DateFormat.getInstance();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(format.parse(str));
            return cal;
        }
        catch (ParseException e) {
            Pattern regex = Pattern.compile("([0-9]+)\\/([0-9]+)\\/([0-9]+)[ \t]+([0-9]+):([0-9]+):([0-9]+)");
            Matcher m = regex.matcher(str);
            if (m.groupCount() > 6) {
                int y = Integer.valueOf(m.group(1));
                int mon = Integer.valueOf(m.group(2));
                int day = Integer.valueOf(m.group(3));
                int h = Integer.valueOf(m.group(4));
                int min = Integer.valueOf(m.group(5));
                int s = Integer.valueOf(m.group(6));
                Calendar cal = Calendar.getInstance();
                cal.set(y, mon, day, h, min, s);
                return cal;
            }
            throw new TJSException("\u4e0d\u6b63\u306a\u65e5\u4ed8\u6587\u5b57\u5217\u306e\u5f62\u5f0f\u3067\u3059");
        }
    }
}

