/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import jp.kirikiri.tjs2.DictionaryNI;
import jp.kirikiri.tjs2.DictionaryObject;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class DictionaryClass
extends NativeClass {
    public static int ClassID = -1;
    private static final String CLASS_NAME = "Dictionary";

    @Override
    protected NativeInstance createNativeInstance() {
        return new DictionaryNI();
    }

    @Override
    protected Dispatch2 createBaseTJSObject() {
        return new DictionaryObject();
    }

    public DictionaryClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        ClassID = NCM_CLASSID;
        this.registerNCM(CLASS_NAME, new NativeClassConstructor(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                DictionaryNI _this = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (_this == null) {
                    return -1008;
                }
                int hr = _this.construct(param, objthis);
                if (hr < 0) {
                    return hr;
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("load", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (!ni.isValid()) {
                    return -1006;
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("save", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (!ni.isValid()) {
                    return -1006;
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("saveStruct", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (!ni.isValid()) {
                    return -1006;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String name = param[0].asString();
                String mode = null;
                if (param.length >= 2 && !param[1].isVoid()) {
                    mode = param[1].asString();
                }
                TextWriteStreamInterface stream = TJS.mStorage.createTextWriteStream(name, mode);
                try {
                    ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
                    stack.add(objthis);
                    ni.saveStructuredData(stack, stream, "");
                }
                finally {
                    stream.destruct();
                }
                if (result != null) {
                    result.set(new Variant(objthis, objthis));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("assign", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (!ni.isValid()) {
                    return -1006;
                }
                if (param.length < 1) {
                    return -1004;
                }
                boolean clear = true;
                if (param.length >= 2 && !param[1].isVoid()) {
                    clear = param[1].asBoolean();
                }
                VariantClosure clo = param[0].asObjectClosure();
                if (clo.mObjThis != null) {
                    ni.assign(clo.mObjThis, clear);
                } else if (clo.mObject != null) {
                    ni.assign(clo.mObject, clear);
                } else {
                    throw new TJSException("null \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("assignStruct", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (!ni.isValid()) {
                    return -1006;
                }
                if (param.length < 1) {
                    return -1004;
                }
                ArrayList<Dispatch2> stack = new ArrayList<Dispatch2>();
                VariantClosure clo = param[0].asObjectClosure();
                if (clo.mObjThis != null) {
                    ni.assignStructure(clo.mObjThis, stack);
                } else if (clo.mObject != null) {
                    ni.assignStructure(clo.mObject, stack);
                } else {
                    throw new TJSException("null \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("clear", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                DictionaryNI ni = (DictionaryNI)objthis.getNativeInstance(ClassID);
                if (ni == null) {
                    return -1008;
                }
                if (!ni.isValid()) {
                    return -1006;
                }
                ni.clear();
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
    }
}

