/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jp.kirikiri.tjs2.ArrayClass;
import jp.kirikiri.tjs2.ArrayNI;
import jp.kirikiri.tjs2.CustomObject;
import jp.kirikiri.tjs2.DictionaryClass;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.EnumMembersCallback;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class DictionaryNI
extends NativeInstanceObject {
    private WeakReference<CustomObject> mOwner;

    @Override
    public int construct(Variant[] param, Dispatch2 tjsobj) {
        if (param != null && param.length != 0) {
            return -1004;
        }
        this.mOwner = new WeakReference<CustomObject>((CustomObject)tjsobj);
        return 0;
    }

    @Override
    public void invalidate() throws VariantException, TJSException {
        this.mOwner.clear();
        super.invalidate();
    }

    public boolean isValid() {
        return this.mOwner.get() != null;
    }

    public void assign(Dispatch2 dsp) throws VariantException, TJSException {
        this.assign(dsp, true);
    }

    public void assign(Dispatch2 dsp, boolean clear) throws VariantException, TJSException {
        ArrayNI arrayni = null;
        CustomObject owner = (CustomObject)this.mOwner.get();
        if (dsp != null && (arrayni = (ArrayNI)dsp.getNativeInstance(ArrayClass.ClassID)) != null) {
            if (clear) {
                owner.clear();
            }
            int count = arrayni.mItems.size();
            int i = 0;
            while (i < count) {
                Variant v = arrayni.mItems.get(i);
                String name = v.asString();
                if (++i < count) {
                    Variant v2 = arrayni.mItems.get(i);
                    owner.propSet(2560, name, v2, owner);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            if (clear) {
                owner.clear();
            }
            AssignCallback callback = new AssignCallback(owner);
            dsp.enumMembers(2048, callback, dsp);
        }
    }

    public void clear() {
        CustomObject owner = (CustomObject)this.mOwner.get();
        if (owner != null) {
            owner.clear();
        }
    }

    public void saveStructuredData(ArrayList<Dispatch2> stack, TextWriteStreamInterface stream, String indentstr) throws VariantException, TJSException {
        stream.write("(const) %[\n");
        String indentstr2 = String.valueOf(indentstr) + " ";
        SaveStructCallback callback = new SaveStructCallback(stack, stream, indentstr2);
        CustomObject owner = (CustomObject)this.mOwner.get();
        owner.enumMembers(2048, callback, owner);
        if (callback.mCalled) {
            stream.write("\n");
        }
        stream.write(indentstr);
        stream.write("]");
    }

    public void assignStructure(Dispatch2 dsp, ArrayList<Dispatch2> stack) throws VariantException, TJSException {
        if (dsp.getNativeInstance(DictionaryClass.ClassID) != null) {
            stack.add(dsp);
            try {
                CustomObject owner = (CustomObject)this.mOwner.get();
                owner.clear();
                AssignStructCallback callback = new AssignStructCallback(stack, owner);
                dsp.enumMembers(2048, callback, dsp);
            }
            finally {
                stack.remove(stack.size() - 1);
            }
        } else {
            throw new TJSException("Dictionary \u307e\u305f\u306f Array \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
    }

    public String toString() {
        CustomObject owner = (CustomObject)this.mOwner.get();
        if (owner != null) {
            return owner.toString();
        }
        return super.toString();
    }

    static class AssignCallback
    implements EnumMembersCallback {
        private CustomObject mOwner;

        public AssignCallback(CustomObject owner) {
            this.mOwner = owner;
        }

        @Override
        public boolean callback(String name, int flags, Variant value) throws VariantException, TJSException {
            if ((flags & 0x1000) != 0) {
                return true;
            }
            this.mOwner.propSet(0xA00 | flags, name, value, this.mOwner);
            return true;
        }
    }

    static class AssignStructCallback
    implements EnumMembersCallback {
        private ArrayList<Dispatch2> mStack;
        private Dispatch2 mDest;

        public AssignStructCallback(ArrayList<Dispatch2> stack, Dispatch2 dest) {
            this.mStack = stack;
            this.mDest = dest;
        }

        @Override
        public boolean callback(String name, int flags, Variant value) throws VariantException, TJSException {
            if ((flags & 0x1000) != 0) {
                return true;
            }
            if (value.isObject()) {
                Variant val;
                Dispatch2 dsp = value.asObject();
                if (dsp != null) {
                    if (dsp.getNativeInstance(DictionaryClass.ClassID) != null) {
                        boolean objrec = false;
                        int count = this.mStack.size();
                        int i = 0;
                        while (i < count) {
                            Dispatch2 v = this.mStack.get(i);
                            if (v == dsp) {
                                objrec = true;
                                break;
                            }
                            ++i;
                        }
                        val = new Variant();
                        if (objrec) {
                            val.setObject(null);
                        } else {
                            Dispatch2 newobj = TJS.createDictionaryObject();
                            val.setObject(newobj, newobj);
                            DictionaryNI newni = (DictionaryNI)newobj.getNativeInstance(DictionaryClass.ClassID);
                            if (newni != null) {
                                newni.assignStructure(dsp, this.mStack);
                            }
                        }
                    } else if (dsp.getNativeInstance(ArrayClass.ClassID) != null) {
                        boolean objrec = false;
                        int count = this.mStack.size();
                        int i = 0;
                        while (i < count) {
                            Dispatch2 v = this.mStack.get(i);
                            if (v == dsp) {
                                objrec = true;
                                break;
                            }
                            ++i;
                        }
                        val = new Variant();
                        if (objrec) {
                            val.setObject(null);
                        } else {
                            Dispatch2 newobj = TJS.createArrayObject();
                            val.setObject(newobj, newobj);
                            ArrayNI newni = (ArrayNI)newobj.getNativeInstance(ArrayClass.ClassID);
                            if (newni != null) {
                                newni.assignStructure(dsp, this.mStack);
                            }
                        }
                    } else {
                        val = value;
                    }
                } else {
                    val = value;
                }
                this.mDest.propSet(2560, name, val, this.mDest);
            } else {
                this.mDest.propSet(2560, name, value, this.mDest);
            }
            return true;
        }
    }

    static class SaveStructCallback
    implements EnumMembersCallback {
        private ArrayList<Dispatch2> mStack;
        private TextWriteStreamInterface mStream;
        private String mIndentStr;
        public boolean mCalled;

        public SaveStructCallback(ArrayList<Dispatch2> stack, TextWriteStreamInterface stream, String indent) {
            this.mStack = stack;
            this.mStream = stream;
            this.mIndentStr = indent;
        }

        @Override
        public boolean callback(String name, int flags, Variant value) throws VariantException, TJSException {
            if ((flags & 0x1000) != 0) {
                return true;
            }
            if (this.mCalled) {
                this.mStream.write(",\n");
            }
            this.mCalled = true;
            this.mStream.write(this.mIndentStr);
            this.mStream.write("\"");
            this.mStream.write(LexBase.escapeC(name));
            this.mStream.write("\" => ");
            if (value.isObject()) {
                VariantClosure clo = value.asObjectClosure();
                ArrayNI.saveStructuredDataForObject(clo.selectObject(), this.mStack, this.mStream, this.mIndentStr);
            } else {
                this.mStream.write(Utils.variantToExpressionString(value));
            }
            return true;
        }
    }
}

