/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class Disassembler {
    private short[] mCode;
    private Variant[] mData;
    private SourceCodeAccessor mAccessor;
    private static final int VM_NOP = 0;
    private static final int VM_CONST = 1;
    private static final int VM_CP = 2;
    private static final int VM_CL = 3;
    private static final int VM_CCL = 4;
    private static final int VM_TT = 5;
    private static final int VM_TF = 6;
    private static final int VM_CEQ = 7;
    private static final int VM_CDEQ = 8;
    private static final int VM_CLT = 9;
    private static final int VM_CGT = 10;
    private static final int VM_SETF = 11;
    private static final int VM_SETNF = 12;
    private static final int VM_LNOT = 13;
    private static final int VM_NF = 14;
    private static final int VM_JF = 15;
    private static final int VM_JNF = 16;
    private static final int VM_JMP = 17;
    private static final int VM_INC = 18;
    private static final int VM_INCPD = 19;
    private static final int VM_INCPI = 20;
    private static final int VM_INCP = 21;
    private static final int VM_DEC = 22;
    private static final int VM_DECPD = 23;
    private static final int VM_DECPI = 24;
    private static final int VM_DECP = 25;
    private static final int VM_LOR = 26;
    private static final int VM_LORPD = 27;
    private static final int VM_LORPI = 28;
    private static final int VM_LORP = 29;
    private static final int VM_LAND = 30;
    private static final int VM_LANDPD = 31;
    private static final int VM_LANDPI = 32;
    private static final int VM_LANDP = 33;
    private static final int VM_BOR = 34;
    private static final int VM_BORPD = 35;
    private static final int VM_BORPI = 36;
    private static final int VM_BORP = 37;
    private static final int VM_BXOR = 38;
    private static final int VM_BXORPD = 39;
    private static final int VM_BXORPI = 40;
    private static final int VM_BXORP = 41;
    private static final int VM_BAND = 42;
    private static final int VM_BANDPD = 43;
    private static final int VM_BANDPI = 44;
    private static final int VM_BANDP = 45;
    private static final int VM_SAR = 46;
    private static final int VM_SARPD = 47;
    private static final int VM_SARPI = 48;
    private static final int VM_SARP = 49;
    private static final int VM_SAL = 50;
    private static final int VM_SALPD = 51;
    private static final int VM_SALPI = 52;
    private static final int VM_SALP = 53;
    private static final int VM_SR = 54;
    private static final int VM_SRPD = 55;
    private static final int VM_SRPI = 56;
    private static final int VM_SRP = 57;
    private static final int VM_ADD = 58;
    private static final int VM_ADDPD = 59;
    private static final int VM_ADDPI = 60;
    private static final int VM_ADDP = 61;
    private static final int VM_SUB = 62;
    private static final int VM_SUBPD = 63;
    private static final int VM_SUBPI = 64;
    private static final int VM_SUBP = 65;
    private static final int VM_MOD = 66;
    private static final int VM_MODPD = 67;
    private static final int VM_MODPI = 68;
    private static final int VM_MODP = 69;
    private static final int VM_DIV = 70;
    private static final int VM_DIVPD = 71;
    private static final int VM_DIVPI = 72;
    private static final int VM_DIVP = 73;
    private static final int VM_IDIV = 74;
    private static final int VM_IDIVPD = 75;
    private static final int VM_IDIVPI = 76;
    private static final int VM_IDIVP = 77;
    private static final int VM_MUL = 78;
    private static final int VM_MULPD = 79;
    private static final int VM_MULPI = 80;
    private static final int VM_MULP = 81;
    private static final int VM_BNOT = 82;
    private static final int VM_TYPEOF = 83;
    private static final int VM_TYPEOFD = 84;
    private static final int VM_TYPEOFI = 85;
    private static final int VM_EVAL = 86;
    private static final int VM_EEXP = 87;
    private static final int VM_CHKINS = 88;
    private static final int VM_ASC = 89;
    private static final int VM_CHR = 90;
    private static final int VM_NUM = 91;
    private static final int VM_CHS = 92;
    private static final int VM_INV = 93;
    private static final int VM_CHKINV = 94;
    private static final int VM_INT = 95;
    private static final int VM_REAL = 96;
    private static final int VM_STR = 97;
    private static final int VM_OCTET = 98;
    private static final int VM_CALL = 99;
    private static final int VM_CALLD = 100;
    private static final int VM_CALLI = 101;
    private static final int VM_NEW = 102;
    private static final int VM_GPD = 103;
    private static final int VM_SPD = 104;
    private static final int VM_SPDE = 105;
    private static final int VM_SPDEH = 106;
    private static final int VM_GPI = 107;
    private static final int VM_SPI = 108;
    private static final int VM_SPIE = 109;
    private static final int VM_GPDS = 110;
    private static final int VM_SPDS = 111;
    private static final int VM_GPIS = 112;
    private static final int VM_SPIS = 113;
    private static final int VM_SETP = 114;
    private static final int VM_GETP = 115;
    private static final int VM_DELD = 116;
    private static final int VM_DELI = 117;
    private static final int VM_SRV = 118;
    private static final int VM_RET = 119;
    private static final int VM_ENTRY = 120;
    private static final int VM_EXTRY = 121;
    private static final int VM_THROW = 122;
    private static final int VM_CHGTHIS = 123;
    private static final int VM_GLOBAL = 124;
    private static final int VM_ADDCI = 125;
    private static final int VM_REGMEMBER = 126;
    private static final int VM_DEBUGGER = 127;
    private static final int __VM_LAST = 128;
    private static final int fatNormal = 0;
    private static final int fatExpand = 1;
    private static final int fatUnnamedExpand = 2;

    public Disassembler(short[] ca, Variant[] da, SourceCodeAccessor a) {
        this.mCode = ca;
        this.mData = da;
        this.mAccessor = a;
    }

    public void set(short[] ca, Variant[] da, SourceCodeAccessor a) {
        this.mCode = ca;
        this.mData = da;
        this.mAccessor = a;
    }

    public void clear() {
        this.mCode = null;
        this.mData = null;
        this.mAccessor = null;
    }

    private void outputFuncSrc(String msg, String name, int line, ScriptBlock data) {
        String buf = line >= 0 ? String.format("#%s(%d) %s", name, line + 1, msg) : String.format("#%s %s", name, msg);
        TJS.outputToConsole(buf);
    }

    private void outputFunc(String msg, String comment, int addr, int codestart, int size, ScriptBlock data) {
        String buf = String.format("%08d %s", addr, msg);
        if (comment != null) {
            buf = String.valueOf(buf) + "\t// " + comment;
        }
        TJS.outputToConsole(buf);
    }

    public void disassemble(ScriptBlock data, int start, int end) throws VariantException {
        int prevline = -1;
        int curline = -1;
        if (end <= 0) {
            end = this.mCode.length;
        }
        if (end > this.mCode.length) {
            end = this.mCode.length;
        }
        int i = start;
        while (i < end) {
            int size;
            String msg = null;
            String com = null;
            int srcpos = this.mAccessor.codePosToSrcPos(i);
            int line = this.mAccessor.srcPosToLine(srcpos);
            if (curline == -1 || curline <= line) {
                if (curline == -1) {
                    curline = line;
                }
                int nl = line - curline;
                while (curline <= line) {
                    if (nl < 3 || nl >= 3 && line - curline <= 2) {
                        String src = this.mAccessor.getLine(curline);
                        this.outputFuncSrc(src, "", curline, data);
                        ++curline;
                        continue;
                    }
                    curline = line - 2;
                }
            } else if (prevline != line) {
                String src = this.mAccessor.getLine(line);
                this.outputFuncSrc(src, "", line, data);
            }
            prevline = line;
            switch (this.mCode[i]) {
                case 0: {
                    msg = "nop";
                    size = 1;
                    break;
                }
                case 14: {
                    msg = "nf";
                    size = 1;
                    break;
                }
                case 1: {
                    msg = String.format("const %%%d, *%d", this.mCode[i + 1], this.mCode[i + 2]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 2], Utils.VariantToReadableString(this.mData[this.mCode[i + 2]]));
                    }
                    size = 3;
                    break;
                }
                case 2: {
                    msg = String.format("cp %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 7: {
                    msg = String.format("ceq %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 8: {
                    msg = String.format("cdeq %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 9: {
                    msg = String.format("clt %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 10: {
                    msg = String.format("cgt %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 88: {
                    msg = String.format("chkins %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 26: {
                    msg = String.format("lor %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 27: {
                    msg = String.format("lorpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 28: {
                    msg = String.format("lorpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 29: {
                    msg = String.format("lorp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 30: {
                    msg = String.format("land %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 31: {
                    msg = String.format("landpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 32: {
                    msg = String.format("landpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 33: {
                    msg = String.format("landp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 34: {
                    msg = String.format("bor %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 35: {
                    msg = String.format("borpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 36: {
                    msg = String.format("borpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 37: {
                    msg = String.format("borp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 38: {
                    msg = String.format("bxor %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 39: {
                    msg = String.format("bxorpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 40: {
                    msg = String.format("bxorpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 41: {
                    msg = String.format("bxorp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 42: {
                    msg = String.format("band %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 43: {
                    msg = String.format("bandpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 44: {
                    msg = String.format("bandpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 45: {
                    msg = String.format("bandp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 46: {
                    msg = String.format("sar %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 47: {
                    msg = String.format("sarpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 48: {
                    msg = String.format("sarpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 49: {
                    msg = String.format("sarp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 50: {
                    msg = String.format("sal %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 51: {
                    msg = String.format("salpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 52: {
                    msg = String.format("salpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 53: {
                    msg = String.format("salp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 54: {
                    msg = String.format("sr %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 55: {
                    msg = String.format("srpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 56: {
                    msg = String.format("srpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 57: {
                    msg = String.format("srp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 58: {
                    msg = String.format("add %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 59: {
                    msg = String.format("addpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 60: {
                    msg = String.format("addpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 61: {
                    msg = String.format("addp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 62: {
                    msg = String.format("sub %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 63: {
                    msg = String.format("subpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 64: {
                    msg = String.format("subpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 65: {
                    msg = String.format("subp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 66: {
                    msg = String.format("mod %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 67: {
                    msg = String.format("modpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 68: {
                    msg = String.format("modpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 69: {
                    msg = String.format("modp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 70: {
                    msg = String.format("div %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 71: {
                    msg = String.format("divpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 72: {
                    msg = String.format("divpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 73: {
                    msg = String.format("divp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 74: {
                    msg = String.format("idiv %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 75: {
                    msg = String.format("idivpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 76: {
                    msg = String.format("idivpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 77: {
                    msg = String.format("idivp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 78: {
                    msg = String.format("mul %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 79: {
                    msg = String.format("mulpd %%%d, %%%d.*%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 5;
                    break;
                }
                case 80: {
                    msg = String.format("mulpi %%%d, %%%d.%%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3], this.mCode[i + 4]);
                    size = 5;
                    break;
                }
                case 81: {
                    msg = String.format("mulp %%%d, %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 5: {
                    msg = String.format("tt %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 6: {
                    msg = String.format("tf %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 11: {
                    msg = String.format("setf %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 12: {
                    msg = String.format("setnf %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 13: {
                    msg = String.format("lnot %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 82: {
                    msg = String.format("bnot %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 89: {
                    msg = String.format("asc %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 90: {
                    msg = String.format("chr %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 91: {
                    msg = String.format("num %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 92: {
                    msg = String.format("chs %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 3: {
                    msg = String.format("cl %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 93: {
                    msg = String.format("inv %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 94: {
                    msg = String.format("chkinv %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 83: {
                    msg = String.format("typeof %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 86: {
                    msg = String.format("eval %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 87: {
                    msg = String.format("eexp %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 95: {
                    msg = String.format("int %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 96: {
                    msg = String.format("real %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 97: {
                    msg = String.format("str %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 98: {
                    msg = String.format("octet %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 4: {
                    msg = String.format("ccl %%%d-%%%d", this.mCode[i + 1], this.mCode[i + 1] + this.mCode[i + 2] - 1);
                    size = 3;
                    break;
                }
                case 18: {
                    msg = String.format("inc %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 19: {
                    msg = String.format("incpd %%%d, %%%d.*%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 4;
                    break;
                }
                case 20: {
                    msg = String.format("incpi %%%d, %%%d.%%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 21: {
                    msg = String.format("incp %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 22: {
                    msg = String.format("dec %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 23: {
                    msg = String.format("decpd %%%d, %%%d.*%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 4;
                    break;
                }
                case 24: {
                    msg = String.format("decpi %%%d, %%%d.%%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 25: {
                    msg = String.format("decp %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 15: {
                    msg = String.format("jf %09d", this.mCode[i + 1] + i);
                    size = 2;
                    break;
                }
                case 16: {
                    msg = String.format("jnf %09d", this.mCode[i + 1] + i);
                    size = 2;
                    break;
                }
                case 17: {
                    msg = String.format("jmp %09d", this.mCode[i + 1] + i);
                    size = 2;
                    break;
                }
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    msg = String.format(this.mCode[i] == 99 ? "call %%%d, %%%d(" : (this.mCode[i] == 100 ? "calld %%%d, %%%d.*%d(" : (this.mCode[i] == 101 ? "calli %%%d, %%%d.%%%d(" : "new %%%d, %%%d(")), this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    int st = this.mCode[i] == 100 || this.mCode[i] == 101 ? 5 : 4;
                    int num = this.mCode[i + st - 1];
                    boolean first = true;
                    String buf = null;
                    int c = 0;
                    if (num == -1) {
                        size = st;
                        msg = String.valueOf(msg) + "...";
                    } else if (num == -2) {
                        num = this.mCode[i + ++st - 1];
                        size = st + num * 2;
                        int j = 0;
                        while (j < num) {
                            if (!first) {
                                msg = String.valueOf(msg) + ", ";
                            }
                            first = false;
                            switch (this.mCode[i + st + j * 2]) {
                                case 0: {
                                    buf = String.format("%%%d", this.mCode[i + st + j * 2 + 1]);
                                    break;
                                }
                                case 1: {
                                    buf = String.format("%%%d*", this.mCode[i + st + j * 2 + 1]);
                                    break;
                                }
                                case 2: {
                                    buf = "*";
                                }
                            }
                            msg = String.valueOf(msg) + buf;
                            ++j;
                        }
                    } else {
                        size = st + num;
                        while (num > 0) {
                            if (!first) {
                                msg = String.valueOf(msg) + ", ";
                            }
                            first = false;
                            buf = String.format("%%%d", this.mCode[i + c + st]);
                            ++c;
                            msg = String.valueOf(msg) + buf;
                            --num;
                        }
                    }
                    msg = String.valueOf(msg) + ")";
                    if (this.mData == null || this.mCode[i] != 100) break;
                    com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    break;
                }
                case 103: 
                case 110: {
                    msg = String.format(this.mCode[i] == 103 ? "gpd %%%d, %%%d.*%d" : "gpds %%%d, %%%d.*%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 4;
                    break;
                }
                case 104: 
                case 105: 
                case 106: 
                case 111: {
                    msg = String.format(this.mCode[i] == 104 ? "spd %%%d.*%d, %%%d" : (this.mCode[i] == 105 ? "spde %%%d.*%d, %%%d" : (this.mCode[i] == 106 ? "spdeh %%%d.*%d, %%%d" : "spds %%%d.*%d, %%%d")), this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 2], Utils.VariantToReadableString(this.mData[this.mCode[i + 2]]));
                    }
                    size = 4;
                    break;
                }
                case 107: 
                case 112: {
                    msg = String.format(this.mCode[i] == 107 ? "gpi %%%d, %%%d.%%%d" : "gpis %%%d, %%%d.%%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 108: 
                case 109: 
                case 113: {
                    msg = String.format(this.mCode[i] == 108 ? "spi %%%d.%%%d, %%%d" : (this.mCode[i] == 109 ? "spie %%%d.%%%d, %%%d" : "spis %%%d.%%%d, %%%d"), this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 114: {
                    msg = String.format("setp %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 115: {
                    msg = String.format("getp %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 84: 
                case 116: {
                    msg = String.format(this.mCode[i] == 116 ? "deld %%%d, %%%d.*%d" : "typeofd %%%d, %%%d.*%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    if (this.mData != null) {
                        com = String.format("*%d = %s", this.mCode[i + 3], Utils.VariantToReadableString(this.mData[this.mCode[i + 3]]));
                    }
                    size = 4;
                    break;
                }
                case 85: 
                case 117: {
                    msg = String.format(this.mCode[i] == 117 ? "deli %%%d, %%%d.%%%d" : "typeofi %%%d, %%%d.%%%d", this.mCode[i + 1], this.mCode[i + 2], this.mCode[i + 3]);
                    size = 4;
                    break;
                }
                case 118: {
                    msg = String.format("srv %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 119: {
                    msg = "ret";
                    size = 1;
                    break;
                }
                case 120: {
                    msg = String.format("entry %09d, %%%d", this.mCode[i + 1] + i, this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 121: {
                    msg = "extry";
                    size = 1;
                    break;
                }
                case 122: {
                    msg = String.format("throw %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 123: {
                    msg = String.format("chgthis %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 124: {
                    msg = String.format("global %%%d", this.mCode[i + 1]);
                    size = 2;
                    break;
                }
                case 125: {
                    msg = String.format("addci %%%d, %%%d", this.mCode[i + 1], this.mCode[i + 2]);
                    size = 3;
                    break;
                }
                case 126: {
                    msg = "regmember";
                    size = 1;
                    break;
                }
                case 127: {
                    msg = "debugger";
                    size = 1;
                    break;
                }
                default: {
                    msg = String.format("unknown instruction %d", this.mCode[i]);
                    size = 1;
                }
            }
            this.outputFunc(msg, com, i, i, size, data);
            i += size;
        }
    }
}

