/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class ExprNode {
    private int mOp;
    private int mPosition = -1;
    private ArrayList<ExprNode> mNodes;
    private Variant mVal;

    protected void finalize() {
        if (this.mNodes != null) {
            int count = this.mNodes.size();
            int i = 0;
            while (i < count) {
                ExprNode node = this.mNodes.get(i);
                if (node != null) {
                    node.clear();
                }
                ++i;
            }
            this.mNodes.clear();
            this.mNodes = null;
        }
        if (this.mVal != null) {
            this.mVal.clear();
            this.mVal = null;
        }
    }

    public final void setOpecode(int op) {
        this.mOp = op;
    }

    public final void setPosition(int pos) {
        this.mPosition = pos;
    }

    public final void setValue(Variant val) {
        if (this.mVal == null) {
            this.mVal = new Variant(val);
        } else {
            this.mVal.copyRef(val);
        }
    }

    public final void add(ExprNode node) {
        if (this.mNodes == null) {
            this.mNodes = new ArrayList();
        }
        this.mNodes.add(node);
    }

    public final int getOpecode() {
        return this.mOp;
    }

    public final int getPosition() {
        return this.mPosition;
    }

    public final Variant getValue() {
        return this.mVal;
    }

    public final ExprNode getNode(int index) {
        if (this.mNodes == null) {
            return null;
        }
        if (index < this.mNodes.size()) {
            return this.mNodes.get(index);
        }
        return null;
    }

    public final int getSize() {
        if (this.mNodes == null) {
            return 0;
        }
        return this.mNodes.size();
    }

    public final void addArrayElement(Variant val) throws TJSException, VariantException {
        String ss_add = "add";
        Variant[] args = new Variant[]{val};
        this.mVal.asObjectClosure().funcCall(0, "add", null, args, null);
    }

    public final void addDictionaryElement(String name, Variant val) throws TJSException, VariantException {
        this.mVal.asObjectClosure().propSet(512, name, val, null);
    }

    public final void clear() {
        if (this.mNodes != null) {
            int count = this.mNodes.size();
            int i = 0;
            while (i < count) {
                ExprNode node = this.mNodes.get(i);
                if (node != null) {
                    node.clear();
                }
                ++i;
            }
            this.mNodes.clear();
            this.mNodes = null;
        }
        if (this.mVal != null) {
            this.mVal.clear();
            this.mVal = null;
        }
    }
}

