/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

public class HashTable<Key, Value> {
    private static final int DEFAULT_HASH_SIZE = 64;
    private static final int HASH_USING = 1;
    private static final int HASH_LV1 = 2;
    private Element<Key, Value>[] mElms;
    private int mCount;
    private Element<Key, Value> mNFirst;
    private Element<Key, Value> mNLast;

    public HashTable() {
        this(64);
    }

    public HashTable(int initCapacity) {
        int capacity = 1;
        while (capacity < initCapacity) {
            capacity <<= 1;
        }
        this.mElms = new Element[capacity];
    }

    public void clear() {
        this.internalClear();
    }

    public Value get(Key key) {
        if (key == null) {
            return null;
        }
        Element<Key, Value> e = this.internalFindWithHash(key, key.hashCode());
        if (e == null) {
            return null;
        }
        return e.mValue;
    }

    public Value getAndTouch(Key key) {
        if (key == null) {
            return null;
        }
        Element<Key, Value> e = this.internalFindWithHash(key, key.hashCode());
        if (e == null) {
            return null;
        }
        this.checkUpdateElementOrder(e);
        return e.mValue;
    }

    private final Element<Key, Value> internalFindWithHash(Key key, int hash) {
        int mask = this.mElms.length - 1;
        Element<Key, Value> lv1 = this.mElms[hash & mask];
        if (lv1 == null) {
            return null;
        }
        if (hash == lv1.mHash && (lv1.mFlags & 1) != 0 && key.equals(lv1.mKey)) {
            return lv1;
        }
        Element elm = lv1.mNext;
        while (elm != null) {
            if (hash == elm.mHash && key.equals(elm.mKey)) {
                return elm;
            }
            elm = elm.mNext;
        }
        return null;
    }

    public void put(Key key, Value value) {
        if (key == null) {
            return;
        }
        this.addWithHash(key, key.hashCode(), value);
    }

    private void addWithHash(Key key, int hash, Value value) {
        int mask = this.mElms.length - 1;
        int index = hash & mask;
        Element<Key, Value> lv1 = this.mElms[index];
        if (lv1 == null) {
            this.mElms[index] = lv1 = new Element();
            lv1.mFlags = 2;
        }
        Element elm = lv1.mNext;
        while (elm != null) {
            if (hash == elm.mHash && key.equals(elm.mKey)) {
                this.checkUpdateElementOrder(elm);
                elm.mValue = value;
                return;
            }
            elm = elm.mNext;
        }
        if ((lv1.mFlags & 1) == 0) {
            lv1.mKey = key;
            lv1.mValue = value;
            lv1.mFlags |= 1;
            lv1.mHash = hash;
            lv1.mPrev = null;
            this.checkAddingElementOrder(lv1);
            return;
        }
        if (hash == lv1.mHash && key.equals(lv1.mHash)) {
            this.checkUpdateElementOrder(lv1);
            lv1.mValue = value;
            return;
        }
        Element newelm = new Element();
        newelm.mKey = key;
        newelm.mValue = value;
        newelm.mFlags |= 1;
        newelm.mHash = hash;
        if (lv1.mNext != null) {
            lv1.mNext.mPrev = newelm;
        }
        newelm.mNext = lv1.mNext;
        newelm.mPrev = lv1;
        lv1.mNext = newelm;
        this.checkAddingElementOrder(newelm);
    }

    boolean remove(Key key) {
        if (key == null) {
            return false;
        }
        return this.deleteWithHash(key, key.hashCode());
    }

    private boolean deleteWithHash(Key key, int hash) {
        int mask = this.mElms.length - 1;
        Element<Key, Value> lv1 = this.mElms[hash & mask];
        if (lv1 == null) {
            return false;
        }
        if ((lv1.mFlags & 1) != 0 && hash == lv1.mHash && key.equals(lv1.mKey)) {
            this.checkDeletingElementOrder(lv1);
            lv1.mKey = null;
            lv1.mValue = null;
            lv1.mFlags &= 0xFFFFFFFE;
            return true;
        }
        Element<Key, Value> prev = lv1;
        Element elm = lv1.mNext;
        while (elm != null) {
            if (hash == elm.mHash && key.equals(elm.mKey)) {
                this.checkDeletingElementOrder(elm);
                elm.mKey = null;
                elm.mValue = null;
                elm.mFlags &= 0xFFFFFFFE;
                prev.mNext = elm.mNext;
                if (elm.mNext != null) {
                    elm.mNext.mPrev = prev;
                }
                elm.mNext = null;
                elm.mPrev = null;
                return true;
            }
            prev = elm;
            elm = elm.mNext;
        }
        return false;
    }

    public int getCount() {
        return this.mCount;
    }

    public int chopLast(int count) {
        int ret = 0;
        while (count > 0) {
            --count;
            if (this.mNLast == null) break;
            this.deleteBytElement(this.mNLast);
            ++ret;
        }
        return ret;
    }

    private boolean deleteBytElement(Element<Key, Value> elm) {
        this.checkDeletingElementOrder(elm);
        elm.mKey = null;
        elm.mValue = null;
        elm.mFlags &= 0xFFFFFFFE;
        if ((elm.mFlags & 2) != 0) {
            return false;
        }
        if (elm.mPrev != null) {
            elm.mPrev.mNext = elm.mNext;
        }
        if (elm.mNext != null) {
            elm.mNext.mPrev = elm.mPrev;
        }
        return true;
    }

    private void checkDeletingElementOrder(Element<Key, Value> elm) {
        --this.mCount;
        if (this.mCount > 0) {
            if (elm == this.mNFirst) {
                this.mNFirst = elm.mNNext;
                this.mNFirst.mNPrev = null;
            } else if (elm == this.mNLast) {
                this.mNLast = elm.mNPrev;
                this.mNLast.mNNext = null;
            } else {
                elm.mNPrev.mNNext = elm.mNNext;
                elm.mNNext.mNPrev = elm.mNPrev;
            }
        } else {
            this.mNLast = null;
            this.mNFirst = null;
        }
    }

    private void checkUpdateElementOrder(Element<Key, Value> elm) {
        if (elm != this.mNFirst) {
            if (this.mNLast == elm) {
                this.mNLast = elm.mNPrev;
            }
            elm.mNPrev.mNNext = elm.mNNext;
            if (elm.mNNext != null) {
                elm.mNNext.mNPrev = elm.mNPrev;
            }
            elm.mNNext = this.mNFirst;
            elm.mNPrev = null;
            this.mNFirst.mNPrev = elm;
            this.mNFirst = elm;
        }
    }

    private void checkAddingElementOrder(Element<Key, Value> elm) {
        if (this.mCount == 0) {
            this.mNLast = elm;
            elm.mNNext = null;
        } else {
            this.mNFirst.mNPrev = elm;
            elm.mNNext = this.mNFirst;
        }
        this.mNFirst = elm;
        elm.mNPrev = null;
        ++this.mCount;
    }

    private void internalInit() {
        this.mCount = 0;
        this.mNFirst = null;
        this.mNLast = null;
    }

    private void internalClear() {
        int count = this.mElms.length;
        int i = 0;
        while (i < count) {
            if (this.mElms[i] != null) {
                Element e = this.mElms[i].mNext;
                while (e != null) {
                    e.mKey = null;
                    e.mValue = null;
                    e.mFlags &= 0xFFFFFFFE;
                    Element next = e.mNext;
                    e.mPrev = null;
                    e.mNext = null;
                    e.mNPrev = null;
                    e.mNNext = null;
                    e = next;
                }
                e = this.mElms[i];
                if ((e.mFlags & 1) != 0) {
                    e.mKey = null;
                    e.mValue = null;
                    e.mFlags &= 0xFFFFFFFE;
                    e.mPrev = null;
                    e.mNext = null;
                    e.mNPrev = null;
                    e.mNNext = null;
                }
            }
            ++i;
        }
        this.internalInit();
    }

    public Value getLastValue() {
        if (this.mNLast != null) {
            return this.mNLast.mValue;
        }
        return null;
    }

    static class Element<Key, Value> {
        int mHash;
        int mFlags;
        Key mKey;
        Value mValue;
        Element<Key, Value> mPrev;
        Element<Key, Value> mNext;
        Element<Key, Value> mNPrev;
        Element<Key, Value> mNNext;

        Element() {
        }
    }
}

