/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

public class IntVector {
    private static final int DEFAULT_SIZE = 16;
    private int[] mItems;
    private int mIndex;

    public IntVector() {
        this(16);
    }

    public IntVector(int initialCapacity) {
        this.mItems = new int[initialCapacity];
    }

    public IntVector(int[] datasrc, int index) {
        this.mItems = new int[index];
        this.mIndex = index;
        int i = 0;
        while (i < index) {
            this.mItems[i] = datasrc[i];
            ++i;
        }
    }

    private IntVector(int[] src) {
        this.mItems = src;
        this.mIndex = src.length;
    }

    public static IntVector wrap(int[] src) {
        return new IntVector(src);
    }

    private final void resize() {
        int count = this.mItems.length * 2;
        int[] newArray = new int[count];
        System.arraycopy(this.mItems, 0, newArray, 0, this.mItems.length);
        this.mItems = null;
        this.mItems = newArray;
    }

    public final void clear() {
        this.mIndex = 0;
    }

    public final void push_back(int val) {
        if (this.mIndex < this.mItems.length) {
            this.mItems[this.mIndex] = val;
            ++this.mIndex;
        } else {
            this.resize();
            if (this.mIndex < this.mItems.length) {
                this.mItems[this.mIndex] = val;
                ++this.mIndex;
            } else {
                throw new OutOfMemoryError("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
        }
    }

    public final void add(int val) {
        if (this.mIndex < this.mItems.length) {
            this.mItems[this.mIndex] = val;
            ++this.mIndex;
        } else {
            this.resize();
            if (this.mIndex < this.mItems.length) {
                this.mItems[this.mIndex] = val;
                ++this.mIndex;
            } else {
                throw new OutOfMemoryError("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
        }
    }

    public final int size() {
        return this.mIndex;
    }

    public final int lastElement() throws IndexOutOfBoundsException {
        if (this.mIndex == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.mItems[this.mIndex - 1];
    }

    public final int back() throws IndexOutOfBoundsException {
        if (this.mIndex == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.mItems[this.mIndex - 1];
    }

    public final int top() throws IndexOutOfBoundsException {
        if (this.mIndex == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.mItems[0];
    }

    public final void pop_back() {
        if (this.mIndex > 0) {
            --this.mIndex;
        }
    }

    public final void set(int index, int element) {
        if (index >= 0 && index < this.mIndex) {
            this.mItems[index] = element;
        }
    }

    public final int get(int index) throws IndexOutOfBoundsException {
        if (index < 0 && index >= this.mIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.mItems[index];
    }

    public final void remove(int index) throws IndexOutOfBoundsException {
        if (index < 0 && index >= this.mIndex) {
            throw new IndexOutOfBoundsException();
        }
        int count = this.mIndex - 1;
        int i = index;
        while (i < count) {
            this.mItems[i] = this.mItems[i + 1];
            ++i;
        }
        --this.mIndex;
    }

    public IntVector clone() {
        return new IntVector(this.mItems, this.mIndex);
    }

    public boolean isEmpty() {
        return this.mIndex == 0;
    }

    public int[] toArray() {
        int[] ret = new int[this.mIndex];
        System.arraycopy(this.mItems, 0, ret, 0, this.mIndex);
        return ret;
    }

    public int[] getRowArray() {
        return this.mItems;
    }
}

