/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.CompileState;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.ConstArrayData;
import jp.kirikiri.tjs2.ExprNode;
import jp.kirikiri.tjs2.IntVector;
import jp.kirikiri.tjs2.IntWrapper;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.LocalNamespace;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tjs2.VectorWrap;
import jp.kirikiri.tjs2.translate.JavaCodeGenerator;

public class InterCodeGenerator
implements SourceCodeAccessor {
    private static final int INC_ARRAY_COUNT = 256;
    private static final int SEARCH_CONST_VAL_SIZE = 20;
    private VectorWrap<ExprNode> mNodeToDeleteVector = new VectorWrap();
    private VectorWrap<ExprNode> mCurrentNodeVector = new VectorWrap();
    private Compiler mBlock;
    private InterCodeGenerator mParent;
    private String mName;
    private int mContextType;
    private short[] mCodeArea;
    private int mCodeAreaPos;
    private short[] mCode;
    private int mPrevSourcePos;
    private boolean mSourcePosArraySorted;
    private long[] mSourcePosArray;
    private int mSrcPosArrayPos;
    private ArrayList<Variant> mDataArea;
    private ArrayList<Variant> mInterCodeDataArea;
    private Variant[] mDataArray;
    private LocalNamespace mNamespace;
    private int mVariableReserveCount;
    private int mFrameBase;
    private int mMaxFrameCount;
    private IntVector mJumpList = new IntVector();
    private boolean mAsGlobalContextMode;
    private ExprNode mSuperClassExpr;
    private VectorWrap<NestData> mNestVector = new VectorWrap();
    private Stack<ArrayArg> mArrayArgStack = new Stack();
    private Stack<FuncArg> mFuncArgStack = new Stack();
    private InterCodeGenerator mPropSetter;
    private InterCodeGenerator mPropGetter;
    private InterCodeGenerator mSuperClassGetter;
    private int mMaxVariableCount;
    private ArrayList<FixData> mFixList;
    private VectorWrap<NonLocalFunctionDecl> mNonLocalFunctionDeclVector;
    private int mFunctionRegisterCodePoint;
    private int mPrevIfExitPatch;
    private IntVector mSuperClassGetterPointer;
    private int mFuncDeclArgCount;
    private int mFuncDeclUnnamedArgArrayBase;
    private int mFuncDeclCollapseBase;
    public static int ntBlock = 0;
    public static int ntWhile = 1;
    public static int ntDoWhile = 2;
    public static int ntFor = 3;
    public static int ntSwitch = 4;
    public static int ntIf = 5;
    public static int ntElse = 6;
    public static int ntTry = 7;
    public static int ntCatch = 8;
    public static int ntWith = 9;
    private ArrayList<Property> mProperties;
    private static final short VM_NOP = 0;
    private static final short VM_CONST = 1;
    private static final short VM_CP = 2;
    private static final short VM_CL = 3;
    private static final short VM_CCL = 4;
    private static final short VM_TT = 5;
    private static final short VM_TF = 6;
    private static final short VM_CEQ = 7;
    private static final short VM_CDEQ = 8;
    private static final short VM_CLT = 9;
    private static final short VM_CGT = 10;
    private static final short VM_SETF = 11;
    private static final short VM_SETNF = 12;
    private static final short VM_LNOT = 13;
    private static final short VM_NF = 14;
    private static final short VM_JF = 15;
    private static final short VM_JNF = 16;
    private static final short VM_JMP = 17;
    private static final short VM_INC = 18;
    private static final short VM_INCPD = 19;
    private static final short VM_INCPI = 20;
    private static final short VM_INCP = 21;
    private static final short VM_DEC = 22;
    private static final short VM_DECPD = 23;
    private static final short VM_DECPI = 24;
    private static final short VM_DECP = 25;
    private static final short VM_LOR = 26;
    private static final short VM_LORPD = 27;
    private static final short VM_LORPI = 28;
    private static final short VM_LORP = 29;
    private static final short VM_LAND = 30;
    private static final short VM_LANDPD = 31;
    private static final short VM_LANDPI = 32;
    private static final short VM_LANDP = 33;
    private static final short VM_BOR = 34;
    private static final short VM_BORPD = 35;
    private static final short VM_BORPI = 36;
    private static final short VM_BORP = 37;
    private static final short VM_BXOR = 38;
    private static final short VM_BXORPD = 39;
    private static final short VM_BXORPI = 40;
    private static final short VM_BXORP = 41;
    private static final short VM_BAND = 42;
    private static final short VM_BANDPD = 43;
    private static final short VM_BANDPI = 44;
    private static final short VM_BANDP = 45;
    private static final short VM_SAR = 46;
    private static final short VM_SARPD = 47;
    private static final short VM_SARPI = 48;
    private static final short VM_SARP = 49;
    private static final short VM_SAL = 50;
    private static final short VM_SALPD = 51;
    private static final short VM_SALPI = 52;
    private static final short VM_SALP = 53;
    private static final short VM_SR = 54;
    private static final short VM_SRPD = 55;
    private static final short VM_SRPI = 56;
    private static final short VM_SRP = 57;
    private static final short VM_ADD = 58;
    private static final short VM_ADDPD = 59;
    private static final short VM_ADDPI = 60;
    private static final short VM_ADDP = 61;
    private static final short VM_SUB = 62;
    private static final short VM_SUBPD = 63;
    private static final short VM_SUBPI = 64;
    private static final short VM_SUBP = 65;
    private static final short VM_MOD = 66;
    private static final short VM_MODPD = 67;
    private static final short VM_MODPI = 68;
    private static final short VM_MODP = 69;
    private static final short VM_DIV = 70;
    private static final short VM_DIVPD = 71;
    private static final short VM_DIVPI = 72;
    private static final short VM_DIVP = 73;
    private static final short VM_IDIV = 74;
    private static final short VM_IDIVPD = 75;
    private static final short VM_IDIVPI = 76;
    private static final short VM_IDIVP = 77;
    private static final short VM_MUL = 78;
    private static final short VM_MULPD = 79;
    private static final short VM_MULPI = 80;
    private static final short VM_MULP = 81;
    private static final short VM_BNOT = 82;
    private static final short VM_TYPEOF = 83;
    private static final short VM_TYPEOFD = 84;
    private static final short VM_TYPEOFI = 85;
    private static final short VM_EVAL = 86;
    private static final short VM_EEXP = 87;
    private static final short VM_CHKINS = 88;
    private static final short VM_ASC = 89;
    private static final short VM_CHR = 90;
    private static final short VM_NUM = 91;
    private static final short VM_CHS = 92;
    private static final short VM_INV = 93;
    private static final short VM_CHKINV = 94;
    private static final short VM_INT = 95;
    private static final short VM_REAL = 96;
    private static final short VM_STR = 97;
    private static final short VM_OCTET = 98;
    private static final short VM_CALL = 99;
    private static final short VM_CALLD = 100;
    private static final short VM_CALLI = 101;
    private static final short VM_NEW = 102;
    private static final short VM_GPD = 103;
    private static final short VM_SPD = 104;
    private static final short VM_SPDE = 105;
    private static final short VM_SPDEH = 106;
    private static final short VM_GPI = 107;
    private static final short VM_SPI = 108;
    private static final short VM_SPIE = 109;
    private static final short VM_GPDS = 110;
    private static final short VM_SPDS = 111;
    private static final short VM_GPIS = 112;
    private static final short VM_SPIS = 113;
    private static final short VM_SETP = 114;
    private static final short VM_GETP = 115;
    private static final short VM_DELD = 116;
    private static final short VM_DELI = 117;
    private static final short VM_SRV = 118;
    private static final short VM_RET = 119;
    private static final short VM_ENTRY = 120;
    private static final short VM_EXTRY = 121;
    private static final short VM_THROW = 122;
    private static final short VM_CHGTHIS = 123;
    private static final short VM_GLOBAL = 124;
    private static final short VM_ADDCI = 125;
    private static final short VM_REGMEMBER = 126;
    private static final short VM_DEBUGGER = 127;
    private static final short __VM_LAST = 128;
    private static final short stNone = 0;
    private static final short stEqual = 2;
    private static final short stBitAND = 42;
    private static final short stBitOR = 34;
    private static final short stBitXOR = 38;
    private static final short stSub = 62;
    private static final short stAdd = 58;
    private static final short stMod = 66;
    private static final short stDiv = 70;
    private static final short stIDiv = 74;
    private static final short stMul = 78;
    private static final short stLogOR = 26;
    private static final short stLogAND = 30;
    private static final short stSAR = 46;
    private static final short stSAL = 50;
    private static final short stSR = 54;
    private static final short stPreInc = 128;
    private static final short stPreDec = 129;
    private static final short stPostInc = 130;
    private static final short stPostDec = 131;
    private static final short stDelete = 132;
    private static final short stFuncCall = 133;
    private static final short stIgnorePropGet = 134;
    private static final short stIgnorePropSet = 135;
    private static final short stTypeOf = 136;
    private static final byte fatNormal = 0;
    private static final byte fatExpand = 1;
    private static final byte fatUnnamedExpand = 2;
    private static final int RT_NEEDED = 1;
    private static final int RT_CFLAG = 2;
    private static final int GNC_CFLAG = Integer.MIN_VALUE;
    private static final int GNC_CFLAG_I = -2147483647;

    public InterCodeGenerator(InterCodeGenerator parent, String name, Compiler block, int type) throws VariantException {
        this.mNamespace = new LocalNamespace();
        this.mFixList = new ArrayList();
        this.mNonLocalFunctionDeclVector = new VectorWrap();
        this.mSuperClassGetterPointer = new IntVector();
        this.mParent = parent;
        this.mSuperClassGetter = null;
        this.mPropSetter = null;
        this.mPropGetter = null;
        this.mCodeArea = new short[256];
        this.mDataArea = new ArrayList();
        this.mInterCodeDataArea = new ArrayList();
        this.mFrameBase = 1;
        this.mFuncDeclCollapseBase = -1;
        this.mPrevSourcePos = -1;
        if (name != null && name.length() > 0) {
            this.mName = name;
        }
        this.mContextType = type;
        switch (this.mContextType) {
            case 0: {
                this.mVariableReserveCount = 2;
                break;
            }
            case 1: {
                this.mVariableReserveCount = 2;
                break;
            }
            case 2: {
                this.mVariableReserveCount = 2;
                break;
            }
            case 3: {
                this.mVariableReserveCount = 0;
                break;
            }
            case 4: {
                this.mVariableReserveCount = 2;
                break;
            }
            case 5: {
                this.mVariableReserveCount = 2;
                break;
            }
            case 6: {
                this.mVariableReserveCount = 2;
                break;
            }
            case 7: {
                this.mVariableReserveCount = 2;
            }
        }
        this.mBlock = block;
        this.mBlock.add(this);
        if (this.mContextType == 6) {
            if (this.mMaxFrameCount < 1) {
                this.mMaxFrameCount = 1;
            }
            int dp = this.putData(new Variant(this.mName));
            int lexPos = this.getLexPos();
            if (this.mCodeAreaPos + 7 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexPos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 1;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 1;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)dp;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 125;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = -1;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 1;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 3;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 1;
            ++this.mCodeAreaPos;
            this.mFunctionRegisterCodePoint = this.mCodeAreaPos;
        }
    }

    protected void finalizeObject() throws VariantException, TJSException {
        if (this.mPropSetter != null) {
            this.mPropSetter = null;
        }
        if (this.mPropGetter != null) {
            this.mPropGetter = null;
        }
        if (this.mSuperClassGetter != null) {
            this.mSuperClassGetter = null;
        }
        if (this.mCodeArea != null) {
            this.mCodeArea = null;
        }
        if (this.mDataArea != null) {
            this.mDataArea.clear();
            this.mDataArea = null;
        }
        this.mBlock.remove(this);
        if (this.mContextType != 0 && this.mBlock != null) {
            this.mBlock = null;
        }
        this.mNamespace.clear();
        this.clearNodesToDelete();
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    private final void error(String msg) throws CompileException {
        this.mBlock.error(msg);
    }

    private int getLexPos() {
        return this.mBlock.getLexicalAnalyzer().getCurrentPosition();
    }

    public int getNodeToDeleteVectorCount() {
        return this.mNodeToDeleteVector.size();
    }

    public void pushCurrentNode(ExprNode node) {
        this.mCurrentNodeVector.add(node);
    }

    public ExprNode getCurrentNode() {
        if (this.mCurrentNodeVector.size() == 0) {
            return null;
        }
        return (ExprNode)this.mCurrentNodeVector.get(this.mCurrentNodeVector.size() - 1);
    }

    public void popCurrentNode() {
        int count = this.mCurrentNodeVector.size();
        if (count > 0) {
            this.mCurrentNodeVector.remove(count - 1);
        }
    }

    private void expandCodeArea() {
        int capacity = this.mCodeArea.length;
        int newcount = capacity + 256;
        short[] narray = new short[newcount];
        System.arraycopy(this.mCodeArea, 0, narray, 0, capacity);
        this.mCodeArea = null;
        this.mCodeArea = narray;
    }

    private void putSrcPos(int pos) {
        if (pos == -1) {
            return;
        }
        if (this.mPrevSourcePos != pos) {
            this.mPrevSourcePos = pos;
            this.mSourcePosArraySorted = false;
            if (this.mSourcePosArray == null) {
                this.mSourcePosArray = new long[256];
            } else if (this.mSrcPosArrayPos >= this.mSourcePosArray.length) {
                int newcount = this.mSourcePosArray.length + 256;
                long[] narray = new long[newcount];
                System.arraycopy(this.mSourcePosArray, 0, narray, 0, this.mSrcPosArrayPos);
                this.mSourcePosArray = narray;
            }
            this.mSourcePosArray[this.mSrcPosArrayPos] = (long)this.mCodeAreaPos << 32 | (long)pos;
            ++this.mSrcPosArrayPos;
        }
    }

    private int putData(Variant val) throws VariantException {
        Variant v;
        int size = this.mDataArea.size();
        int count = size > 20 ? 20 : size;
        int offset = size - 1;
        int i = 0;
        while (i < count) {
            int pos = offset - i;
            if (this.mDataArea.get(pos).discernCompareStrictReal(val)) {
                return pos;
            }
            ++i;
        }
        if (val.isString()) {
            v = new Variant(TJS.mapGlobalStringMap(val.asString()));
        } else {
            v = new Variant(val);
            Object o = v.toJavaObject();
            if (o instanceof InterCodeGenerator) {
                this.mInterCodeDataArea.add(v);
            }
        }
        this.mDataArea.add(v);
        return this.mDataArea.size() - 1;
    }

    public void dateReplace(Compiler compiler) {
        int count = this.mInterCodeDataArea.size();
        int i = 0;
        while (i < count) {
            Variant d = this.mInterCodeDataArea.get(i);
            Object o = d.toJavaObject();
            if (o instanceof InterCodeGenerator) {
                int idx = compiler.getCodeIndex((InterCodeGenerator)o);
                if (idx < 0) {
                    TJS.outputToConsole("not found");
                }
                d.set(compiler.getCodeObject(idx));
            }
            ++i;
        }
    }

    public void addLocalVariable(String name) throws VariantException {
        this.addLocalVariable(name, 0);
    }

    public void addLocalVariable(String name, int init) throws VariantException {
        int base = this.mContextType == 6 ? 2 : 1;
        int lexPos = this.getLexPos();
        if (this.mNamespace.getLevel() >= base) {
            this.mNamespace.add(name);
            if (init != 0) {
                int n = this.mNamespace.find(name);
                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(lexPos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 2;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)init;
                ++this.mCodeAreaPos;
            } else {
                int n = this.mNamespace.find(name);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(lexPos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 3;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                ++this.mCodeAreaPos;
            }
        } else {
            int dp = this.putData(new Variant(name));
            if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexPos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 111;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = -1;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)dp;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)init;
            ++this.mCodeAreaPos;
        }
    }

    public void initLocalVariable(String name, ExprNode node) throws VariantException, CompileException {
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
        this.addLocalVariable(name, resaddr);
        this.clearFrame(fr);
    }

    public void initLocalFunction(String name, int data) throws VariantException {
        int fr = this.mFrameBase;
        int pos = this.getLexPos();
        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(pos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 1;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)fr;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)data;
        ++this.mCodeAreaPos;
        this.addLocalVariable(name, ++fr - 1);
        this.clearFrame(fr);
    }

    public void createExprCode(ExprNode node) throws VariantException, CompileException {
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        this.genNodeCode(fr, node, 0, 0, new SubParam());
        this.clearFrame(fr);
    }

    public void enterWhileCode(boolean doWhile) {
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = doWhile ? ntDoWhile : ntWhile;
        this.mNestVector.lastElement().LoopStartIP = this.mCodeAreaPos;
    }

    public void createWhileExprCode(ExprNode node, boolean doWhile) throws VariantException, CompileException {
        if (doWhile) {
            this.doContinuePatch(this.mNestVector.lastElement());
        }
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 3, 0, new SubParam());
        int nodepos = node != null ? node.getPosition() : -1;
        boolean inv = false;
        if (resaddr != Integer.MIN_VALUE && resaddr != -2147483647) {
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 5;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
        } else if (resaddr == -2147483647) {
            inv = true;
        }
        this.clearFrame(fr);
        if (!doWhile) {
            this.mNestVector.lastElement().ExitPatchVector.add(this.mCodeAreaPos);
            this.mJumpList.add(this.mCodeAreaPos);
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = inv ? 15 : 16;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
        } else {
            int jmp_ip = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = inv ? 16 : 15;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)(this.mNestVector.lastElement().LoopStartIP - jmp_ip);
            ++this.mCodeAreaPos;
        }
    }

    public void exitWhileCode(boolean doWhile) throws CompileException {
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (doWhile) {
            if (this.mNestVector.lastElement().Type != ntDoWhile) {
                this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
                return;
            }
        } else if (this.mNestVector.lastElement().Type != ntWhile) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (!doWhile) {
            int jmp_ip = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            int pos = this.getLexPos();
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(pos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 17;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)(this.mNestVector.lastElement().LoopStartIP - jmp_ip);
            ++this.mCodeAreaPos;
        }
        this.doNestTopExitPatch();
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void enterIfCode() {
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntIf;
    }

    public void crateIfExprCode(ExprNode node) throws VariantException, CompileException {
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 3, 0, new SubParam());
        int nodepos = node != null ? node.getPosition() : -1;
        boolean inv = false;
        if (resaddr != Integer.MIN_VALUE && resaddr != -2147483647) {
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 5;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
        } else if (resaddr == -2147483647) {
            inv = true;
        }
        this.clearFrame(fr);
        this.mNestVector.lastElement().Patch1 = this.mCodeAreaPos;
        this.mJumpList.add(this.mCodeAreaPos);
        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(nodepos);
        }
        this.mCodeArea[this.mCodeAreaPos] = inv ? 15 : 16;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
    }

    public void exitIfCode() throws CompileException {
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntIf) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        this.mCodeArea[this.mNestVector.lastElement().Patch1 + 1] = (short)(this.mCodeAreaPos - this.mNestVector.lastElement().Patch1);
        this.mPrevIfExitPatch = this.mNestVector.lastElement().Patch1;
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void enterElseCode() {
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntElse;
        this.mNestVector.lastElement().Patch2 = this.mCodeAreaPos;
        this.mJumpList.add(this.mCodeAreaPos);
        int pos = this.getLexPos();
        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(pos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 17;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mPrevIfExitPatch + 1] = (short)(this.mCodeAreaPos - this.mPrevIfExitPatch);
    }

    public void exitElseCode() throws CompileException {
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntElse) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        this.mCodeArea[this.mNestVector.lastElement().Patch2 + 1] = (short)(this.mCodeAreaPos - this.mNestVector.lastElement().Patch2);
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void enterForCode(boolean varcreate) {
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntFor;
        if (varcreate) {
            this.enterBlock();
        }
        this.mNestVector.lastElement().VariableCreated = varcreate;
    }

    public void createForExprCode(ExprNode node) throws VariantException, CompileException {
        this.mNestVector.lastElement().LoopStartIP = this.mCodeAreaPos;
        if (node != null) {
            int nodepos = node.getPosition();
            IntWrapper fr = new IntWrapper(this.mFrameBase);
            int resaddr = this.genNodeCode(fr, node, 3, 0, new SubParam());
            boolean inv = false;
            if (resaddr != Integer.MIN_VALUE && resaddr != -2147483647) {
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(nodepos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 5;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                ++this.mCodeAreaPos;
            } else if (resaddr == -2147483647) {
                inv = true;
            }
            this.clearFrame(fr);
            this.mNestVector.lastElement().ExitPatchVector.add(this.mCodeAreaPos);
            this.mJumpList.add(this.mCodeAreaPos);
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = inv ? 15 : 16;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
        }
    }

    public void setForThirdExprCode(ExprNode node) {
        this.mNestVector.lastElement().PostLoopExpr = node;
    }

    public void exitForCode() throws CompileException, VariantException {
        int nestsize = this.mNestVector.size();
        if (nestsize == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntFor && this.mNestVector.lastElement().Type != ntBlock) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type == ntFor) {
            this.doContinuePatch(this.mNestVector.lastElement());
        }
        if (nestsize >= 2 && ((NestData)this.mNestVector.get((int)(nestsize - 2))).Type == ntFor) {
            this.doContinuePatch((NestData)this.mNestVector.get(nestsize - 2));
        }
        if (this.mNestVector.lastElement().PostLoopExpr != null) {
            IntWrapper fr = new IntWrapper(this.mFrameBase);
            this.genNodeCode(fr, this.mNestVector.lastElement().PostLoopExpr, 0, 0, new SubParam());
            this.clearFrame(fr);
        }
        int jmp_ip = this.mCodeAreaPos;
        this.mJumpList.add(this.mCodeAreaPos);
        int lexpos = this.getLexPos();
        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(lexpos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 17;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)(this.mNestVector.lastElement().LoopStartIP - jmp_ip);
        ++this.mCodeAreaPos;
        this.doNestTopExitPatch();
        if (this.mNestVector.lastElement().VariableCreated) {
            this.exitBlock();
        }
        this.doNestTopExitPatch();
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void enterSwitchCode(ExprNode node) throws VariantException, CompileException {
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntSwitch;
        this.mNestVector.lastElement().Patch1 = -1;
        this.mNestVector.lastElement().Patch2 = -1;
        this.mNestVector.lastElement().VariableCreated = true;
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
        if (this.mFrameBase != resaddr) {
            int nodepos;
            int n = nodepos = node != null ? node.getPosition() : -1;
            if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 2;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)this.mFrameBase;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
        }
        this.mNestVector.lastElement().RefRegister = this.mFrameBase;
        if (fr.value - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = fr.value - 1;
        }
        ++this.mFrameBase;
        if (this.mFrameBase - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = this.mFrameBase - 1;
        }
        this.clearFrame(fr);
        this.enterBlock();
    }

    public void exitSwitchCode() throws CompileException {
        this.exitBlock();
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntSwitch) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        int lexpos = this.getLexPos();
        int patch3 = 0;
        if (!this.mNestVector.lastElement().VariableCreated) {
            patch3 = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexpos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 17;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
        }
        if (this.mNestVector.lastElement().Patch1 != -1) {
            this.mCodeArea[this.mNestVector.lastElement().Patch1 + 1] = (short)(this.mCodeAreaPos - this.mNestVector.lastElement().Patch1);
        }
        if (this.mNestVector.lastElement().Patch2 != -1) {
            this.mJumpList.add(this.mCodeAreaPos);
            int jmp_start = this.mCodeAreaPos;
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexpos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 17;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)(this.mNestVector.lastElement().Patch2 - jmp_start);
            ++this.mCodeAreaPos;
        }
        if (!this.mNestVector.lastElement().VariableCreated) {
            this.mCodeArea[patch3 + 1] = (short)(this.mCodeAreaPos - patch3);
        }
        this.doNestTopExitPatch();
        --this.mFrameBase;
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void processCaseCode(ExprNode node) throws VariantException, CompileException {
        int nodepos;
        int nestsize = this.mNestVector.size();
        if (nestsize < 3) {
            this.error("\"case\" \u306f\u3053\u3053\u306b\u66f8\u304f\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
            return;
        }
        if (((NestData)this.mNestVector.get((int)(nestsize - 1))).Type != ntBlock || ((NestData)this.mNestVector.get((int)(nestsize - 2))).Type != ntBlock || ((NestData)this.mNestVector.get((int)(nestsize - 3))).Type != ntSwitch) {
            this.error("\"case\" \u306f\u3053\u3053\u306b\u66f8\u304f\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
            return;
        }
        NestData data = (NestData)this.mNestVector.get(this.mNestVector.size() - 3);
        int patch3 = 0;
        if (!data.VariableCreated) {
            patch3 = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            int n = nodepos = node != null ? node.getPosition() : -1;
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 17;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
        }
        this.exitBlock();
        if (data.Patch1 != -1) {
            this.mCodeArea[data.Patch1 + 1] = (short)(this.mCodeAreaPos - data.Patch1);
        }
        if (node != null) {
            int nodepos2;
            IntWrapper fr = new IntWrapper(this.mFrameBase);
            int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
            int n = nodepos2 = node != null ? node.getPosition() : -1;
            if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos2);
            }
            this.mCodeArea[this.mCodeAreaPos] = 7;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)data.RefRegister;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
            this.clearFrame(fr);
            data.Patch1 = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos2);
            }
            this.mCodeArea[this.mCodeAreaPos] = 16;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
        } else {
            data.Patch1 = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            int n = nodepos = node != null ? node.getPosition() : -1;
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 17;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
            data.Patch2 = this.mCodeAreaPos;
        }
        if (!data.VariableCreated) {
            this.mCodeArea[patch3 + 1] = (short)(this.mCodeAreaPos - patch3);
        }
        data.VariableCreated = false;
        this.enterBlock();
    }

    public void enterWithCode(ExprNode node) throws VariantException, CompileException {
        int nodepos;
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
        int n = nodepos = node != null ? node.getPosition() : -1;
        if (this.mFrameBase != resaddr) {
            if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 2;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)this.mFrameBase;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
        }
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntWith;
        this.mNestVector.lastElement().RefRegister = this.mFrameBase;
        if (fr.value - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = fr.value - 1;
        }
        ++this.mFrameBase;
        if (this.mFrameBase - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = this.mFrameBase - 1;
        }
        this.clearFrame(fr);
        this.enterBlock();
    }

    public void exitWidthCode() throws CompileException {
        this.exitBlock();
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntWith) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        --this.mFrameBase;
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void doBreak() throws CompileException {
        int lexpos = this.getLexPos();
        int i = this.mNestVector.size() - 1;
        while (i >= 0) {
            NestData data = (NestData)this.mNestVector.get(i);
            if (data.Type == ntSwitch || data.Type == ntWhile || data.Type == ntDoWhile || data.Type == ntFor) {
                data.ExitPatchVector.add(this.mCodeAreaPos);
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(lexpos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 17;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                return;
            }
            if (data.Type != ntBlock) {
                if (data.Type == ntTry) {
                    if (this.mCodeAreaPos >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 121;
                    ++this.mCodeAreaPos;
                } else if (data.Type != ntSwitch) {
                    int cfr_ignored_0 = data.Type;
                }
            }
            --i;
        }
        this.error("\"break\" \u307e\u305f\u306f \"continue\" \u306f\u3053\u3053\u306b\u66f8\u304f\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
    }

    public void doContinue() throws CompileException {
        int i = this.mNestVector.size() - 1;
        int lexpos = this.getLexPos();
        while (i >= 0) {
            NestData data = (NestData)this.mNestVector.get(i);
            if (data.Type == ntWhile) {
                int jmpstart = this.mCodeAreaPos;
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(lexpos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 17;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(data.LoopStartIP - jmpstart);
                ++this.mCodeAreaPos;
                return;
            }
            if (data.Type == ntDoWhile || data.Type == ntFor) {
                data.ContinuePatchVector.add(this.mCodeAreaPos);
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(lexpos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 17;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                return;
            }
            if (data.Type != ntBlock) {
                if (data.Type == ntTry) {
                    if (this.mCodeAreaPos >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(lexpos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 121;
                    ++this.mCodeAreaPos;
                } else if (data.Type != ntSwitch) {
                    int cfr_ignored_0 = data.Type;
                }
            }
            --i;
        }
        this.error("\"break\" \u307e\u305f\u306f \"continue\" \u306f\u3053\u3053\u306b\u66f8\u304f\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
    }

    public void doDebugger() {
        if (this.mCodeAreaPos >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(this.getLexPos());
        }
        this.mCodeArea[this.mCodeAreaPos] = 127;
        ++this.mCodeAreaPos;
    }

    public void returnFromFunc(ExprNode node) throws VariantException, CompileException {
        int nodepos;
        int n = nodepos = node != null ? node.getPosition() : -1;
        if (node == null) {
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 118;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
        } else {
            IntWrapper fr = new IntWrapper(this.mFrameBase);
            int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
            if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 118;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
            this.clearFrame(fr);
        }
        int org_framebase = this.mFrameBase;
        this.clearFrame(this.mFrameBase, 1);
        this.mFrameBase = org_framebase;
        int lexpos = this.getLexPos();
        int i = this.mNestVector.size() - 1;
        while (i >= 0) {
            NestData data = (NestData)this.mNestVector.get(i);
            if (data.Type == ntTry) {
                if (this.mCodeAreaPos >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(lexpos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 121;
                ++this.mCodeAreaPos;
            }
            --i;
        }
        if (this.mCodeAreaPos >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(lexpos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 119;
        ++this.mCodeAreaPos;
    }

    public void enterTryCode() {
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntTry;
        this.mNestVector.lastElement().VariableCreated = false;
        int lexpos = this.getLexPos();
        this.mNestVector.lastElement().Patch1 = this.mCodeAreaPos;
        this.mJumpList.add(this.mCodeAreaPos);
        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(lexpos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 120;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)this.mFrameBase;
        ++this.mCodeAreaPos;
        if (this.mFrameBase > this.mMaxFrameCount) {
            this.mMaxFrameCount = this.mFrameBase;
        }
    }

    public void enterCatchCode(String name) throws VariantException {
        int lexpos = this.getLexPos();
        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(lexpos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 121;
        ++this.mCodeAreaPos;
        this.mNestVector.lastElement().Patch2 = this.mCodeAreaPos;
        this.mJumpList.add(this.mCodeAreaPos);
        this.mCodeArea[this.mCodeAreaPos] = 17;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mNestVector.lastElement().Patch1 + 1] = (short)(this.mCodeAreaPos - this.mNestVector.lastElement().Patch1);
        int fr = this.mMaxFrameCount + 1;
        int base = name != null ? this.mFrameBase + 1 : this.mFrameBase;
        this.clearFrame(fr, base);
        this.mNestVector.lastElement().Type = ntCatch;
        if (name != null) {
            this.mNestVector.lastElement().VariableCreated = true;
            this.enterBlock();
            this.addLocalVariable(name, this.mFrameBase);
        }
    }

    public void exitTryCode() throws CompileException {
        if (this.mNestVector.size() >= 2 && ((NestData)this.mNestVector.get((int)(this.mNestVector.size() - 2))).Type == ntCatch && ((NestData)this.mNestVector.get((int)(this.mNestVector.size() - 2))).VariableCreated) {
            this.exitBlock();
        }
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntCatch) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        int p2addr = this.mNestVector.lastElement().Patch2;
        this.mCodeArea[p2addr + 1] = (short)(this.mCodeAreaPos - p2addr);
        this.mNestVector.remove(this.mNestVector.size() - 1);
    }

    public void processThrowCode(ExprNode node) throws VariantException, CompileException {
        int nodepos;
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
        int n = nodepos = node != null ? node.getPosition() : -1;
        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(nodepos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 122;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
        ++this.mCodeAreaPos;
        if (fr.value - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = fr.value - 1;
        }
    }

    public void createExtendsExprCode(ExprNode node, boolean hold) throws VariantException, CompileException {
        int nodepos;
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
        int n = nodepos = node != null ? node.getPosition() : -1;
        if (this.mCodeAreaPos + 6 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(nodepos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 123;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = -1;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 99;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
        if (hold) {
            this.mSuperClassExpr = node;
        }
        this.mFunctionRegisterCodePoint = this.mCodeAreaPos;
        if (this.mSuperClassGetter == null) {
            this.mSuperClassGetter = new InterCodeGenerator(this, this.mName, this.mBlock, 7);
        }
        this.mSuperClassGetter.createExtendsExprProxyCode(node);
    }

    public void createExtendsExprProxyCode(ExprNode node) throws VariantException, CompileException {
        int nodepos;
        this.mSuperClassGetterPointer.add(this.mCodeAreaPos);
        IntWrapper fr = new IntWrapper(this.mFrameBase);
        int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
            this.expandCodeArea();
        }
        this.mCodeArea[this.mCodeAreaPos] = 118;
        ++this.mCodeAreaPos;
        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
        ++this.mCodeAreaPos;
        this.clearFrame(fr);
        this.mCodeArea[this.mCodeAreaPos] = 119;
        ++this.mCodeAreaPos;
        int n = nodepos = node != null ? node.getPosition() : -1;
        if (CompileState.mEnableDebugCode) {
            this.putSrcPos(nodepos);
        }
        this.mCodeArea[this.mCodeAreaPos] = 0;
        ++this.mCodeAreaPos;
    }

    public void enterBlock() {
        this.mNamespace.push();
        int varcount = this.mNamespace.getCount();
        this.mNestVector.add(new NestData());
        this.mNestVector.lastElement().Type = ntBlock;
        this.mNestVector.lastElement().VariableCount = varcount;
    }

    public void exitBlock() throws CompileException {
        if (this.mNestVector.size() == 0) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        if (this.mNestVector.lastElement().Type != ntBlock) {
            this.error("\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)");
            return;
        }
        this.mNestVector.remove(this.mNestVector.size() - 1);
        this.mNamespace.pop();
    }

    public void generateFuncCallArgCode() {
        int lexpos = this.getLexPos();
        if (this.mFuncArgStack.peek().IsOmit) {
            if (this.mCodeAreaPos >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexpos);
            }
            this.mCodeArea[this.mCodeAreaPos] = -1;
            ++this.mCodeAreaPos;
        } else if (this.mFuncArgStack.peek().HasExpand) {
            ArrayList<FuncArgItem> vec = this.mFuncArgStack.peek().ArgVector;
            if (this.mCodeAreaPos + vec.size() * 2 + 1 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexpos);
            }
            this.mCodeArea[this.mCodeAreaPos] = -2;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)vec.size();
            ++this.mCodeAreaPos;
            int i = 0;
            while (i < vec.size()) {
                FuncArgItem arg = vec.get(i);
                this.mCodeArea[this.mCodeAreaPos] = (short)arg.Type;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)arg.Register;
                ++this.mCodeAreaPos;
                ++i;
            }
        } else {
            ArrayList<FuncArgItem> vec = this.mFuncArgStack.peek().ArgVector;
            if (this.mCodeAreaPos + vec.size() >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexpos);
            }
            this.mCodeArea[this.mCodeAreaPos] = (short)vec.size();
            ++this.mCodeAreaPos;
            int i = 0;
            while (i < vec.size()) {
                this.mCodeArea[this.mCodeAreaPos] = (short)vec.get((int)i).Register;
                ++this.mCodeAreaPos;
                ++i;
            }
        }
    }

    public void addFunctionDeclArg(String varname, ExprNode node) throws VariantException, CompileException {
        this.mNamespace.add(varname);
        if (node != null) {
            int nodepos;
            int n = nodepos = node != null ? node.getPosition() : -1;
            if (this.mCodeAreaPos + 4 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 8;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)(-3 - this.mFuncDeclArgCount);
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
            int jmp_ip = this.mCodeAreaPos;
            this.mJumpList.add(this.mCodeAreaPos);
            this.mCodeArea[this.mCodeAreaPos] = 16;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
            IntWrapper fr = new IntWrapper(this.mFrameBase);
            int resaddr = this.genNodeCode(fr, node, 1, 0, new SubParam());
            if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(nodepos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 2;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)(-3 - this.mFuncDeclArgCount);
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
            ++this.mCodeAreaPos;
            this.clearFrame(fr);
            this.mCodeArea[jmp_ip + 1] = (short)(this.mCodeAreaPos - jmp_ip);
        }
        ++this.mFuncDeclArgCount;
    }

    public void addFunctionDeclArgCollapse(String varname) {
        if (varname == null) {
            this.mFuncDeclUnnamedArgArrayBase = this.mFuncDeclArgCount;
        } else {
            this.mFuncDeclCollapseBase = this.mFuncDeclArgCount;
            this.mNamespace.add(varname);
        }
    }

    public void setPropertyDeclArg(String varname) {
        this.mNamespace.add(varname);
        this.mFuncDeclArgCount = 1;
    }

    private void doNestTopExitPatch() {
        IntVector vector = this.mNestVector.lastElement().ExitPatchVector;
        int count = vector.size();
        int codeSize = this.mCodeAreaPos;
        int i = 0;
        while (i < count) {
            int val = vector.get(i);
            this.mCodeArea[val + 1] = (short)(codeSize - val);
            ++i;
        }
    }

    private void doContinuePatch(NestData nestdata) {
        IntVector vector = nestdata.ContinuePatchVector;
        int count = vector.size();
        int codeSize = this.mCodeAreaPos;
        int i = 0;
        while (i < count) {
            int val = vector.get(i);
            this.mCodeArea[val + 1] = (short)(codeSize - val);
            ++i;
        }
    }

    public ExprNode makeConstValNode(Variant val) {
        ExprNode node = new ExprNode();
        this.mNodeToDeleteVector.add(node);
        node.setOpecode(385);
        node.setValue(val);
        node.setPosition(this.getLexPos());
        return node;
    }

    public static void characterCodeFrom(Variant val) throws VariantException {
        char[] ch = new char[]{(char)val.asInteger()};
        val.set(new String(ch));
    }

    public static void characterCodeOf(Variant val) throws VariantException {
        String str = val.asString();
        if (str != null) {
            int v = str.codePointAt(0);
            val.set(v);
        } else {
            val.set(0);
        }
    }

    public ExprNode makeNP0(int opecode) {
        ExprNode node = new ExprNode();
        this.mNodeToDeleteVector.add(node);
        node.setOpecode(opecode);
        node.setPosition(this.getLexPos());
        return node;
    }

    public ExprNode makeNP1(int opecode, ExprNode node1) throws VariantException {
        if (node1 != null && node1.getOpecode() == 385) {
            ExprNode ret = null;
            switch (opecode) {
                case 296: {
                    ret = this.makeConstValNode(node1.getValue().getNotValue());
                    break;
                }
                case 297: {
                    ret = this.makeConstValNode(node1.getValue().getBitNotValue());
                    break;
                }
                case 305: {
                    Variant val = new Variant(node1.getValue());
                    InterCodeGenerator.characterCodeOf(val);
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 306: {
                    Variant val = new Variant(node1.getValue());
                    InterCodeGenerator.characterCodeFrom(val);
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 369: {
                    Variant val = new Variant(node1.getValue());
                    val.toNumber();
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 370: {
                    Variant val = new Variant(node1.getValue());
                    val.changeSign();
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 359: {
                    Variant val = new Variant(node1.getValue());
                    val.toInteger();
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 360: {
                    Variant val = new Variant(node1.getValue());
                    val.toReal();
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 361: {
                    Variant val = new Variant(node1.getValue());
                    val.toString();
                    ret = this.makeConstValNode(val);
                    break;
                }
                case 362: {
                    Variant val = new Variant(node1.getValue());
                    val.toOctet();
                    ret = this.makeConstValNode(val);
                }
            }
            if (ret != null) {
                node1.clear();
                return ret;
            }
        }
        ExprNode node = new ExprNode();
        this.mNodeToDeleteVector.add(node);
        node.setOpecode(opecode);
        node.setPosition(this.getLexPos());
        node.add(node1);
        return node;
    }

    public ExprNode makeNP2(int opecode, ExprNode node1, ExprNode node2) throws VariantException {
        if (node1 != null && node1.getOpecode() == 385 && node2 != null && node2.getOpecode() == 385) {
            switch (opecode) {
                case 258: {
                    return this.makeConstValNode(node2.getValue());
                }
                case 275: {
                    return this.makeConstValNode(node1.getValue().logicOr(node2.getValue()));
                }
                case 276: {
                    return this.makeConstValNode(node1.getValue().logicAnd(node2.getValue()));
                }
                case 277: {
                    return this.makeConstValNode(node1.getValue().bitOr(node2.getValue()));
                }
                case 278: {
                    return this.makeConstValNode(node1.getValue().bitXor(node2.getValue()));
                }
                case 279: {
                    return this.makeConstValNode(node1.getValue().bitAnd(node2.getValue()));
                }
                case 280: {
                    return this.makeConstValNode(node1.getValue().notEqual(node2.getValue()));
                }
                case 281: {
                    return this.makeConstValNode(node1.getValue().equalEqual(node2.getValue()));
                }
                case 282: {
                    return this.makeConstValNode(node1.getValue().discNotEqual(node2.getValue()));
                }
                case 283: {
                    return this.makeConstValNode(node1.getValue().discernCompare(node2.getValue()));
                }
                case 285: {
                    return this.makeConstValNode(node1.getValue().lt(node2.getValue()));
                }
                case 286: {
                    return this.makeConstValNode(node1.getValue().gt(node2.getValue()));
                }
                case 287: {
                    return this.makeConstValNode(node1.getValue().ltOrEqual(node2.getValue()));
                }
                case 288: {
                    return this.makeConstValNode(node1.getValue().gtOrEqual(node2.getValue()));
                }
                case 289: {
                    return this.makeConstValNode(node1.getValue().rightShift(node2.getValue()));
                }
                case 290: {
                    return this.makeConstValNode(node1.getValue().leftShift(node2.getValue()));
                }
                case 291: {
                    return this.makeConstValNode(node1.getValue().rightBitShift(node2.getValue()));
                }
                case 303: {
                    return this.makeConstValNode(node1.getValue().add(node2.getValue()));
                }
                case 304: {
                    return this.makeConstValNode(node1.getValue().subtract(node2.getValue()));
                }
                case 292: {
                    return this.makeConstValNode(node1.getValue().residue(node2.getValue()));
                }
                case 293: {
                    return this.makeConstValNode(node1.getValue().divide(node2.getValue()));
                }
                case 294: {
                    return this.makeConstValNode(node1.getValue().idiv(node2.getValue()));
                }
                case 295: {
                    return this.makeConstValNode(node1.getValue().multiply(node2.getValue()));
                }
            }
        }
        ExprNode node = new ExprNode();
        this.mNodeToDeleteVector.add(node);
        node.setOpecode(opecode);
        node.setPosition(this.getLexPos());
        node.add(node1);
        node.add(node2);
        return node;
    }

    public ExprNode makeNP3(int opecode, ExprNode node1, ExprNode node2, ExprNode node3) {
        ExprNode node = new ExprNode();
        this.mNodeToDeleteVector.add(node);
        node.setOpecode(opecode);
        node.setPosition(this.getLexPos());
        node.add(node1);
        node.add(node2);
        node.add(node3);
        return node;
    }

    private int clearFrame(IntWrapper frame) {
        return this.clearFrame(frame, -1);
    }

    private int clearFrame(IntWrapper frame, int base) {
        if (base == -1) {
            base = this.mFrameBase;
        }
        if (frame.value - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = frame.value - 1;
        }
        if (frame.value - base >= 3) {
            frame.value = base;
        } else if (frame.value > base) {
            frame.value = base;
        }
        return frame.value;
    }

    private int clearFrame(int frame) {
        return this.clearFrame(frame, -1);
    }

    private int clearFrame(int frame, int base) {
        if (base == -1) {
            base = this.mFrameBase;
        }
        if (frame - 1 > this.mMaxFrameCount) {
            this.mMaxFrameCount = frame - 1;
        }
        if (frame - base >= 3) {
            frame = base;
        } else if (frame > base) {
            frame = base;
        }
        return frame;
    }

    private int genNodeCode(IntWrapper frame, ExprNode node, int restype, int reqresaddr, SubParam param) throws VariantException, CompileException {
        if (node == null) {
            return 0;
        }
        int node_pos = node != null ? node.getPosition() : -1;
        switch (node.getOpecode()) {
            case 385: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((restype & 1) == 0) {
                    return 0;
                }
                int dp = this.putData(node.getValue());
                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                ++this.mCodeAreaPos;
                int ret = frame.value++;
                return ret;
            }
            case 345: {
                if ((restype & 1) != 0) {
                    this.error("\u3053\u306e\u5f0f\u304b\u3089\u306f\u5024\u3092\u5f97\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
                }
                int resaddr1 = this.genNodeCode(frame, node.getNode(1), 3, 0, new SubParam());
                boolean inv = false;
                if (resaddr1 != Integer.MIN_VALUE && resaddr1 != -2147483647) {
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 5;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                } else if (resaddr1 == -2147483647) {
                    inv = true;
                }
                int addr = this.mCodeAreaPos;
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = inv ? 15 : 16;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                this.genNodeCode(frame, node.getNode(0), 0, 0, param);
                this.mCodeArea[addr + 1] = (short)(this.mCodeAreaPos - addr);
                return 0;
            }
            case 341: {
                if ((restype & 1) == 0) {
                    return 0;
                }
                int resaddr1 = this.genNodeCode(frame, node.getNode(0), 1, 0, param);
                int resaddr2 = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                if (resaddr1 <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    resaddr1 = frame.value++;
                }
                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 123;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                ++this.mCodeAreaPos;
                return resaddr1;
            }
            case 258: {
                this.genNodeCode(frame, node.getNode(0), 0, 0, new SubParam());
                return this.genNodeCode(frame, node.getNode(1), restype, reqresaddr, param);
            }
            case 284: {
                int resaddr1;
                if ((restype & 1) != 0) {
                    this.error("\u3053\u306e\u5f0f\u304b\u3089\u306f\u5024\u3092\u5f97\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
                }
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((resaddr1 = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam())) <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    resaddr1 = frame.value++;
                }
                int resaddr2 = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                SubParam param2 = new SubParam();
                param2.mSubType = 2;
                param2.mSubAddress = resaddr2;
                this.genNodeCode(frame, node.getNode(0), 0, 0, param2);
                param2.mSubType = 2;
                param2.mSubAddress = resaddr1;
                this.genNodeCode(frame, node.getNode(1), 0, 0, param2);
                return 0;
            }
            case 259: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((restype & 2) != 0) {
                    this.outputWarning("\u8ad6\u7406\u5024\u304c\u6c42\u3081\u3089\u308c\u3066\u3044\u308b\u5834\u6240\u3067 = \u6f14\u7b97\u5b50\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059(== \u6f14\u7b97\u5b50\u306e\u9593\u9055\u3044\u3067\u3059\u304b\uff1f\u4ee3\u5165\u3057\u305f\u4e0a\u3067\u30bc\u30ed\u3068\u5024\u3092\u6bd4\u8f03\u3057\u305f\u3044\u5834\u5408\u306f\u3001(A=B) != 0 \u306e\u5f62\u5f0f\u3092\u4f7f\u3046\u3053\u3068\u3092\u304a\u52e7\u3081\u3057\u307e\u3059)", node_pos);
                }
                int resaddr = this.genNodeCode(frame, node.getNode(1), 1, 0, param);
                SubParam param2 = new SubParam();
                param2.mSubType = 2;
                param2.mSubAddress = resaddr;
                this.genNodeCode(frame, node.getNode(0), 0, 0, param2);
                return resaddr;
            }
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                int resaddr = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                SubParam param2 = new SubParam();
                switch (node.getOpecode()) {
                    case 260: {
                        param2.mSubType = 42;
                        break;
                    }
                    case 261: {
                        param2.mSubType = 34;
                        break;
                    }
                    case 262: {
                        param2.mSubType = 38;
                        break;
                    }
                    case 263: {
                        param2.mSubType = 62;
                        break;
                    }
                    case 264: {
                        param2.mSubType = 58;
                        break;
                    }
                    case 265: {
                        param2.mSubType = 66;
                        break;
                    }
                    case 266: {
                        param2.mSubType = 70;
                        break;
                    }
                    case 267: {
                        param2.mSubType = 74;
                        break;
                    }
                    case 268: {
                        param2.mSubType = 78;
                        break;
                    }
                    case 269: {
                        param2.mSubType = 26;
                        break;
                    }
                    case 270: {
                        param2.mSubType = 30;
                        break;
                    }
                    case 271: {
                        param2.mSubType = 46;
                        break;
                    }
                    case 272: {
                        param2.mSubType = 50;
                        break;
                    }
                    case 273: {
                        param2.mSubType = 54;
                    }
                }
                param2.mSubAddress = resaddr;
                return this.genNodeCode(frame, node.getNode(0), restype, reqresaddr, param2);
            }
            case 274: {
                int resaddr = this.genNodeCode(frame, node.getNode(0), 3, 0, new SubParam());
                boolean inv = false;
                if (resaddr != Integer.MIN_VALUE && resaddr != -2147483647) {
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 5;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                    ++this.mCodeAreaPos;
                } else if (resaddr == -2147483647) {
                    inv = true;
                }
                int cur_frame = frame.value;
                int addr1 = this.mCodeAreaPos;
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = inv ? 15 : 16;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                int resaddr1 = this.genNodeCode(frame, node.getNode(1), restype, reqresaddr, param);
                if ((restype & 2) != 0) {
                    if (resaddr1 != Integer.MIN_VALUE && resaddr1 != -2147483647) {
                        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 5;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                        ++this.mCodeAreaPos;
                    } else if (resaddr1 == -2147483647) {
                        if (this.mCodeAreaPos >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 14;
                        ++this.mCodeAreaPos;
                    }
                } else if ((restype & 1) != 0 && resaddr1 != Integer.MIN_VALUE && resaddr1 != -2147483647 && resaddr1 <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    resaddr1 = frame.value++;
                }
                int frame1 = frame.value;
                int addr2 = this.mCodeAreaPos;
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 17;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                this.mCodeArea[addr1 + 1] = (short)(this.mCodeAreaPos - addr1);
                frame.value = cur_frame;
                int resaddr2 = this.genNodeCode(frame, node.getNode(2), restype, reqresaddr, param);
                if ((restype & 2) != 0) {
                    if (resaddr2 != Integer.MIN_VALUE && resaddr2 != -2147483647) {
                        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 5;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                        ++this.mCodeAreaPos;
                    } else if (resaddr2 == -2147483647) {
                        if (this.mCodeAreaPos >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 14;
                        ++this.mCodeAreaPos;
                    }
                } else if ((restype & 1) != 0 && resaddr1 != Integer.MIN_VALUE && resaddr1 != -2147483647 && resaddr1 != resaddr2) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                    ++this.mCodeAreaPos;
                    ++frame.value;
                }
                int frame2 = frame.value;
                this.mCodeArea[addr2 + 1] = (short)(this.mCodeAreaPos - addr2);
                frame.value = frame2 < frame1 ? frame1 : frame2;
                return (restype & 2) != 0 ? Integer.MIN_VALUE : resaddr1;
            }
            case 275: 
            case 276: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                int resaddr1 = this.genNodeCode(frame, node.getNode(0), 3, 0, new SubParam());
                boolean inv = false;
                if (resaddr1 != Integer.MIN_VALUE && resaddr1 != -2147483647) {
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 5;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                }
                if (resaddr1 == -2147483647) {
                    inv = true;
                }
                int addr1 = this.mCodeAreaPos;
                this.mJumpList.add(this.mCodeAreaPos);
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = node.getOpecode() == 275 ? (inv ? 16 : 15) : (inv ? 15 : 16);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                int resaddr2 = this.genNodeCode(frame, node.getNode(1), 3, 0, new SubParam());
                if (resaddr2 != Integer.MIN_VALUE && resaddr2 != -2147483647) {
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = inv ? 6 : 5;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                    ++this.mCodeAreaPos;
                } else if (inv != (resaddr2 == -2147483647)) {
                    if (this.mCodeAreaPos >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 14;
                    ++this.mCodeAreaPos;
                }
                this.mCodeArea[addr1 + 1] = (short)(this.mCodeAreaPos - addr1);
                if ((restype & 2) == 0) {
                    if (resaddr1 == Integer.MIN_VALUE || resaddr1 == -2147483647 || resaddr1 <= 0) {
                        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = inv ? 12 : 11;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                        ++this.mCodeAreaPos;
                        resaddr1 = frame.value++;
                    } else {
                        if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = inv ? 12 : 11;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                        ++this.mCodeAreaPos;
                    }
                }
                return (restype & 2) != 0 ? (inv ? -2147483647 : Integer.MIN_VALUE) : resaddr1;
            }
            case 309: {
                int resaddr1 = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam());
                if (resaddr1 <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    resaddr1 = frame.value++;
                }
                int resaddr2 = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 88;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                ++this.mCodeAreaPos;
                return resaddr1;
            }
            case 277: 
            case 278: 
            case 279: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 303: 
            case 304: {
                int resaddr1;
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((resaddr1 = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam())) <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    resaddr1 = frame.value++;
                }
                int resaddr2 = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                int code = 0;
                switch (node.getOpecode()) {
                    case 277: {
                        code = 34;
                        break;
                    }
                    case 278: {
                        code = 38;
                        break;
                    }
                    case 279: {
                        code = 42;
                        break;
                    }
                    case 289: {
                        code = 46;
                        break;
                    }
                    case 290: {
                        code = 50;
                        break;
                    }
                    case 291: {
                        code = 54;
                        break;
                    }
                    case 303: {
                        code = 58;
                        break;
                    }
                    case 304: {
                        code = 62;
                        break;
                    }
                    case 292: {
                        code = 66;
                        break;
                    }
                    case 293: {
                        code = 70;
                        break;
                    }
                    case 294: {
                        code = 74;
                        break;
                    }
                    case 295: {
                        code = 78;
                    }
                }
                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = (short)code;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                ++this.mCodeAreaPos;
                return resaddr1;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                int resaddr1 = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam());
                if ((restype & 2) == 0 && resaddr1 <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                    resaddr1 = frame.value++;
                }
                int resaddr2 = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                int code1 = 0;
                int code2 = 0;
                switch (node.getOpecode()) {
                    case 280: {
                        code1 = 7;
                        code2 = 12;
                        break;
                    }
                    case 281: {
                        code1 = 7;
                        code2 = 11;
                        break;
                    }
                    case 282: {
                        code1 = 8;
                        code2 = 12;
                        break;
                    }
                    case 283: {
                        code1 = 8;
                        code2 = 11;
                        break;
                    }
                    case 285: {
                        code1 = 9;
                        code2 = 11;
                        break;
                    }
                    case 286: {
                        code1 = 10;
                        code2 = 11;
                        break;
                    }
                    case 287: {
                        code1 = 10;
                        code2 = 12;
                        break;
                    }
                    case 288: {
                        code1 = 9;
                        code2 = 12;
                    }
                }
                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = (short)code1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr2;
                ++this.mCodeAreaPos;
                if ((restype & 2) == 0) {
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    this.mCodeArea[this.mCodeAreaPos] = (short)code2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr1;
                    ++this.mCodeAreaPos;
                }
                return (restype & 2) != 0 ? (code2 == 12 ? -2147483647 : Integer.MIN_VALUE) : resaddr1;
            }
            case 296: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                int resaddr = this.genNodeCode(frame, node.getNode(0), restype, reqresaddr, new SubParam());
                if ((restype & 2) == 0) {
                    if (resaddr <= 0) {
                        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 2;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        resaddr = frame.value++;
                    }
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 13;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                    ++this.mCodeAreaPos;
                    return resaddr;
                }
                if (resaddr != Integer.MIN_VALUE && resaddr != -2147483647) {
                    if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 6;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                    ++this.mCodeAreaPos;
                    return Integer.MIN_VALUE;
                }
                return resaddr == -2147483647 ? Integer.MIN_VALUE : -2147483647;
            }
            case 297: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 369: 
            case 370: 
            case 371: {
                int resaddr;
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((resaddr = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam())) <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                    ++this.mCodeAreaPos;
                    resaddr = frame.value++;
                }
                int code = 0;
                switch (node.getOpecode()) {
                    case 297: {
                        code = 82;
                        break;
                    }
                    case 305: {
                        code = 89;
                        break;
                    }
                    case 306: {
                        code = 90;
                        break;
                    }
                    case 369: {
                        code = 91;
                        break;
                    }
                    case 370: {
                        code = 92;
                        break;
                    }
                    case 308: {
                        code = 93;
                        break;
                    }
                    case 307: {
                        code = 94;
                        break;
                    }
                    case 302: {
                        code = 83;
                        break;
                    }
                    case 371: {
                        int n = code = (restype & 1) != 0 ? 86 : 87;
                        if (!TJS.mWarnOnNonGlobalEvalOperator || this.mContextType == 0) break;
                        this.outputWarning("\u30b0\u30ed\u30fc\u30d0\u30eb\u3067\u306a\u3044\u5834\u6240\u3067\u5f8c\u7f6e ! \u6f14\u7b97\u5b50\u304c\u4f7f\u308f\u308c\u3066\u3044\u307e\u3059(\u3053\u306e\u6f14\u7b97\u5b50\u306e\u6319\u52d5\u306fTJS2 version 2.4.1 \u3067\u5909\u308f\u308a\u307e\u3057\u305f\u306e\u3067\u3054\u6ce8\u610f\u304f\u3060\u3055\u3044)");
                        break;
                    }
                    case 359: {
                        code = 95;
                        break;
                    }
                    case 360: {
                        code = 96;
                        break;
                    }
                    case 361: {
                        code = 97;
                        break;
                    }
                    case 362: {
                        code = 98;
                    }
                }
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = (short)code;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                ++this.mCodeAreaPos;
                return resaddr;
            }
            case 302: {
                ExprNode cnode;
                boolean haspropnode;
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if (haspropnode = (cnode = node.getNode(0)).getOpecode() == 311 || cnode.getOpecode() == 312 || cnode.getOpecode() == 382) {
                    SubParam param2 = new SubParam();
                    param2.mSubType = 136;
                    return this.genNodeCode(frame, cnode, 1, 0, param2);
                }
                int resaddr = this.genNodeCode(frame, cnode, 1, 0, new SubParam());
                if (resaddr <= 0) {
                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                        this.expandCodeArea();
                    }
                    if (CompileState.mEnableDebugCode) {
                        this.putSrcPos(node_pos);
                    }
                    this.mCodeArea[this.mCodeAreaPos] = 2;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                    ++this.mCodeAreaPos;
                    this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                    ++this.mCodeAreaPos;
                    resaddr = frame.value++;
                }
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 83;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                ++this.mCodeAreaPos;
                return resaddr;
            }
            case 298: 
            case 299: 
            case 301: 
            case 372: 
            case 373: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                SubParam param2 = new SubParam();
                switch (node.getOpecode()) {
                    case 302: {
                        param2.mSubType = 136;
                        break;
                    }
                    case 301: {
                        param2.mSubType = 132;
                        break;
                    }
                    case 299: {
                        param2.mSubType = 128;
                        break;
                    }
                    case 298: {
                        param2.mSubType = 129;
                        break;
                    }
                    case 373: {
                        param2.mSubType = 130;
                        break;
                    }
                    case 372: {
                        param2.mSubType = 131;
                    }
                }
                return this.genNodeCode(frame, node.getNode(0), restype, reqresaddr, param2);
            }
            case 300: 
            case 310: {
                int res;
                boolean do_direct_access;
                String str;
                ExprNode cnode = node.getNode(0);
                boolean haspropnode = node.getOpecode() == 310 && (cnode.getOpecode() == 311 || cnode.getOpecode() == 312);
                boolean hasnonlocalsymbol = node.getOpecode() == 310 && cnode.getOpecode() == 386 ? (this.mAsGlobalContextMode ? true : this.mNamespace.find(str = cnode.getValue().asString()) == -1) : false;
                boolean bl = do_direct_access = haspropnode || hasnonlocalsymbol;
                if (!do_direct_access && (restype & 1) != 0) {
                    ++frame.value;
                }
                this.startFuncArg();
                int framestart = frame.value;
                try {
                    if (node.getNode(1).getSize() != 1 || node.getNode(1).getNode(0) != null) {
                        this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                    }
                    SubParam param2 = new SubParam();
                    if (do_direct_access) {
                        param2.mSubType = 133;
                        res = this.genNodeCode(frame, node.getNode(0), restype, reqresaddr, param2);
                    } else {
                        param2.mSubType = 0;
                        int resaddr = this.genNodeCode(frame, node.getNode(0), 1, 0, param2);
                        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = node.getOpecode() == 300 ? 102 : 99;
                        ++this.mCodeAreaPos;
                        res = (restype & 1) != 0 ? framestart - 1 : 0;
                        this.mCodeArea[this.mCodeAreaPos] = (short)res;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.generateFuncCallArgCode();
                        this.clearFrame(frame, framestart);
                    }
                }
                finally {
                    this.endFuncArg();
                }
                return res;
            }
            case 376: {
                if (node.getSize() >= 2 && node.getNode(1) != null) {
                    this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                }
                if (node.getNode(0) != null) {
                    ExprNode n = node.getNode(0);
                    if (n.getOpecode() == 377) {
                        if (n.getNode(0) != null) {
                            this.addFuncArg(this.genNodeCode(frame, n.getNode(0), 1, 0, new SubParam()), 1);
                        } else {
                            this.addFuncArg(0, 2);
                        }
                    } else {
                        this.addFuncArg(this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam()), 0);
                    }
                } else {
                    this.addFuncArg(0, 0);
                }
                return 0;
            }
            case 356: {
                this.addOmitArg();
                return 0;
            }
            case 311: 
            case 312: {
                boolean direct = node.getOpecode() == 311;
                SubParam param2 = new SubParam();
                param2.mSubType = 0;
                int resaddr = this.genNodeCode(frame, node.getNode(0), 1, 0, param2);
                int dp = direct ? this.putData(node.getNode(1).getValue()) : this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                switch (param.mSubType) {
                    case 0: 
                    case 134: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        if (param.mSubType == 0) {
                            this.mCodeArea[this.mCodeAreaPos] = direct ? 103 : 107;
                            ++this.mCodeAreaPos;
                        } else {
                            this.mCodeArea[this.mCodeAreaPos] = direct ? 110 : 112;
                            ++this.mCodeAreaPos;
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        ++frame.value;
                        return frame.value - 1;
                    }
                    case 2: 
                    case 135: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        if (param.mSubType == 2) {
                            if (node.getNode(0).getOpecode() == 383) {
                                this.mCodeArea[this.mCodeAreaPos] = direct ? 104 : 108;
                                ++this.mCodeAreaPos;
                            } else {
                                this.mCodeArea[this.mCodeAreaPos] = direct ? 105 : 109;
                                ++this.mCodeAreaPos;
                            }
                        } else {
                            this.mCodeArea[this.mCodeAreaPos] = direct ? 111 : 113;
                            ++this.mCodeAreaPos;
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubAddress;
                        ++this.mCodeAreaPos;
                        return param.mSubAddress;
                    }
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: 
                    case 42: 
                    case 46: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 62: 
                    case 66: 
                    case 70: 
                    case 74: 
                    case 78: {
                        if (this.mCodeAreaPos + 4 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)(param.mSubType + (direct ? 1 : 2));
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubAddress;
                        ++this.mCodeAreaPos;
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                    case 128: 
                    case 129: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)((param.mSubType == 128 ? 18 : 22) + (direct ? 1 : 2));
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                    case 130: 
                    case 131: {
                        int retresaddr = 0;
                        if ((restype & 1) != 0) {
                            if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                                this.expandCodeArea();
                            }
                            if (CompileState.mEnableDebugCode) {
                                this.putSrcPos(node_pos);
                            }
                            this.mCodeArea[this.mCodeAreaPos] = direct ? 103 : 107;
                            ++this.mCodeAreaPos;
                            this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                            ++this.mCodeAreaPos;
                            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                            ++this.mCodeAreaPos;
                            this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                            ++this.mCodeAreaPos;
                            retresaddr = frame.value++;
                        }
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)((param.mSubType == 130 ? 18 : 22) + (direct ? 1 : 2));
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = 0;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        return retresaddr;
                    }
                    case 136: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = direct ? 84 : 85;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                    case 132: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = direct ? 116 : 117;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                    case 133: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = direct ? 100 : 101;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                        ++this.mCodeAreaPos;
                        this.generateFuncCallArgCode();
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                }
                this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                return 0;
            }
            case 386: {
                int n;
                if (this.mAsGlobalContextMode) {
                    n = -1;
                } else {
                    String str = node.getValue().asString();
                    n = this.mNamespace.find(str);
                }
                if (n != -1) {
                    boolean isstnone;
                    boolean bl = isstnone = param.mSubType == 0;
                    if (!isstnone) {
                        switch (param.mSubType) {
                            case 2: {
                                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                                    this.expandCodeArea();
                                }
                                if (CompileState.mEnableDebugCode) {
                                    this.putSrcPos(node_pos);
                                }
                                this.mCodeArea[this.mCodeAreaPos] = 2;
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubAddress;
                                ++this.mCodeAreaPos;
                                break;
                            }
                            case 26: 
                            case 30: 
                            case 34: 
                            case 38: 
                            case 42: 
                            case 46: 
                            case 50: 
                            case 54: 
                            case 58: 
                            case 62: 
                            case 66: 
                            case 70: 
                            case 74: 
                            case 78: {
                                if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                                    this.expandCodeArea();
                                }
                                if (CompileState.mEnableDebugCode) {
                                    this.putSrcPos(node_pos);
                                }
                                this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubType;
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubAddress;
                                ++this.mCodeAreaPos;
                                return (restype & 1) != 0 ? -n - this.mVariableReserveCount - 1 : 0;
                            }
                            case 128: {
                                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                                    this.expandCodeArea();
                                }
                                if (CompileState.mEnableDebugCode) {
                                    this.putSrcPos(node_pos);
                                }
                                this.mCodeArea[this.mCodeAreaPos] = 18;
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                ++this.mCodeAreaPos;
                                return (restype & 1) != 0 ? -n - this.mVariableReserveCount - 1 : 0;
                            }
                            case 129: {
                                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                                    this.expandCodeArea();
                                }
                                if (CompileState.mEnableDebugCode) {
                                    this.putSrcPos(node_pos);
                                }
                                this.mCodeArea[this.mCodeAreaPos] = 22;
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                ++this.mCodeAreaPos;
                                return (restype & 1) != 0 ? -n - this.mVariableReserveCount - 1 : 0;
                            }
                            case 130: {
                                if ((restype & 1) != 0) {
                                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                                        this.expandCodeArea();
                                    }
                                    if (CompileState.mEnableDebugCode) {
                                        this.putSrcPos(node_pos);
                                    }
                                    this.mCodeArea[this.mCodeAreaPos] = 2;
                                    ++this.mCodeAreaPos;
                                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                                    ++this.mCodeAreaPos;
                                    this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                    ++this.mCodeAreaPos;
                                    ++frame.value;
                                }
                                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                                    this.expandCodeArea();
                                }
                                if (CompileState.mEnableDebugCode) {
                                    this.putSrcPos(node_pos);
                                }
                                this.mCodeArea[this.mCodeAreaPos] = 18;
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                ++this.mCodeAreaPos;
                                return (restype & 1) != 0 ? frame.value - 1 : 0;
                            }
                            case 131: {
                                if ((restype & 1) != 0) {
                                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                                        this.expandCodeArea();
                                    }
                                    if (CompileState.mEnableDebugCode) {
                                        this.putSrcPos(node_pos);
                                    }
                                    this.mCodeArea[this.mCodeAreaPos] = 2;
                                    ++this.mCodeAreaPos;
                                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                                    ++this.mCodeAreaPos;
                                    this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                    ++this.mCodeAreaPos;
                                    ++frame.value;
                                }
                                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                                    this.expandCodeArea();
                                }
                                if (CompileState.mEnableDebugCode) {
                                    this.putSrcPos(node_pos);
                                }
                                this.mCodeArea[this.mCodeAreaPos] = 22;
                                ++this.mCodeAreaPos;
                                this.mCodeArea[this.mCodeAreaPos] = (short)(-n - this.mVariableReserveCount - 1);
                                ++this.mCodeAreaPos;
                                return (restype & 1) != 0 ? frame.value - 1 : 0;
                            }
                            case 132: {
                                String str = node.getValue().asString();
                                this.mNamespace.remove(str);
                                if ((restype & 1) != 0) {
                                    int dp = this.putData(new Variant(1));
                                    if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                                        this.expandCodeArea();
                                    }
                                    if (CompileState.mEnableDebugCode) {
                                        this.putSrcPos(node_pos);
                                    }
                                    this.mCodeArea[this.mCodeAreaPos] = 1;
                                    ++this.mCodeAreaPos;
                                    this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                                    ++this.mCodeAreaPos;
                                    this.mCodeArea[this.mCodeAreaPos] = (short)dp;
                                    ++this.mCodeAreaPos;
                                    return frame.value - 1;
                                }
                                return 0;
                            }
                            default: {
                                this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                            }
                        }
                        return 0;
                    }
                    String str = node.getValue().asString();
                    int n1 = this.mNamespace.find(str);
                    return -n1 - this.mVariableReserveCount - 1;
                }
                ExprNode nodep = new ExprNode();
                nodep.setOpecode(311);
                nodep.setPosition(node_pos);
                ExprNode node1 = new ExprNode();
                this.mNodeToDeleteVector.add(node1);
                nodep.add(node1);
                node1.setOpecode(this.mAsGlobalContextMode ? 315 : 383);
                node1.setPosition(node_pos);
                ExprNode node2 = new ExprNode();
                this.mNodeToDeleteVector.add(node2);
                nodep.add(node2);
                node2.setOpecode(386);
                node2.setPosition(node_pos);
                node2.setValue(node.getValue());
                return this.genNodeCode(frame, nodep, restype, reqresaddr, param);
            }
            case 374: 
            case 375: {
                if (node.getOpecode() == (TJS.mUnaryAsteriskIgnoresPropAccess ? 375 : 374)) {
                    SubParam sp = new SubParam(param);
                    if (sp.mSubType == 0) {
                        sp.mSubType = 134;
                    } else if (sp.mSubType == 2) {
                        sp.mSubType = 135;
                    } else {
                        this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                    }
                    return this.genNodeCode(frame, node.getNode(0), restype, reqresaddr, sp);
                }
                int resaddr = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam());
                switch (param.mSubType) {
                    case 0: {
                        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 115;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        ++frame.value;
                        return frame.value - 1;
                    }
                    case 2: {
                        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = 114;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubAddress;
                        ++this.mCodeAreaPos;
                        return param.mSubAddress;
                    }
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: 
                    case 42: 
                    case 46: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 62: 
                    case 66: 
                    case 70: 
                    case 74: 
                    case 78: {
                        if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)(param.mSubType + 3);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)param.mSubAddress;
                        ++this.mCodeAreaPos;
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                    case 128: 
                    case 129: {
                        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)((param.mSubType == 128 ? 18 : 22) + 3);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)((restype & 1) != 0 ? frame.value : 0);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        if ((restype & 1) != 0) {
                            ++frame.value;
                        }
                        return (restype & 1) != 0 ? frame.value - 1 : 0;
                    }
                    case 130: 
                    case 131: {
                        int retresaddr = 0;
                        if ((restype & 1) != 0) {
                            if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                                this.expandCodeArea();
                            }
                            if (CompileState.mEnableDebugCode) {
                                this.putSrcPos(node_pos);
                            }
                            this.mCodeArea[this.mCodeAreaPos] = 115;
                            ++this.mCodeAreaPos;
                            this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                            ++this.mCodeAreaPos;
                            this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                            ++this.mCodeAreaPos;
                            retresaddr = frame.value++;
                        }
                        if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                            this.expandCodeArea();
                        }
                        if (CompileState.mEnableDebugCode) {
                            this.putSrcPos(node_pos);
                        }
                        this.mCodeArea[this.mCodeAreaPos] = (short)((param.mSubType == 130 ? 18 : 22) + 3);
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = 0;
                        ++this.mCodeAreaPos;
                        this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                        ++this.mCodeAreaPos;
                        return retresaddr;
                    }
                }
                this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                return 0;
            }
            case 314: {
                int resaddr;
                ExprNode node1;
                if (this.mParent != null && this.mParent.mContextType == 3) {
                    node1 = this.mParent.mParent.mSuperClassExpr;
                    if (node1 == null) {
                        this.error("\u30b9\u30fc\u30d1\u30fc\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u30b9\u30fc\u30d1\u30fc\u30af\u30e9\u30b9\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093");
                        return 0;
                    }
                } else if (this.mParent == null || (node1 = this.mParent.mSuperClassExpr) == null) {
                    this.error("\u30b9\u30fc\u30d1\u30fc\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u30b9\u30fc\u30d1\u30fc\u30af\u30e9\u30b9\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093");
                    return 0;
                }
                this.mAsGlobalContextMode = true;
                try {
                    resaddr = this.genNodeCode(frame, node1, restype, reqresaddr, param);
                }
                finally {
                    this.mAsGlobalContextMode = false;
                }
                return resaddr;
            }
            case 313: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                return -1;
            }
            case 383: {
                return -this.mVariableReserveCount;
            }
            case 382: {
                ExprNode nodep = new ExprNode();
                nodep.setOpecode(311);
                nodep.setPosition(node_pos);
                ExprNode node1 = new ExprNode();
                this.mNodeToDeleteVector.add(node1);
                nodep.add(node1);
                node1.setOpecode(384);
                node1.setPosition(node_pos);
                nodep.add(node.getNode(0));
                return this.genNodeCode(frame, nodep, restype, reqresaddr, param);
            }
            case 384: {
                int i = this.mNestVector.size() - 1;
                while (i >= 0) {
                    NestData data = (NestData)this.mNestVector.get(i);
                    if (data.Type == ntWith) {
                        return data.RefRegister;
                    }
                    --i;
                }
            }
            case 315: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((restype & 1) == 0) {
                    return 0;
                }
                if (this.mCodeAreaPos + 1 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 124;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                ++frame.value;
                return frame.value - 1;
            }
            case 378: {
                int arraydp = this.putData(new Variant("Array"));
                int frame0 = frame.value;
                if (this.mCodeAreaPos + 12 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 124;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 103;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)arraydp;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 102;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                int zerodp = this.putData(new Variant(0));
                this.mCodeArea[this.mCodeAreaPos] = 1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)zerodp;
                ++this.mCodeAreaPos;
                frame.value += 2;
                this.mArrayArgStack.push(new ArrayArg());
                this.mArrayArgStack.peek().Object = frame0;
                this.mArrayArgStack.peek().Counter = frame0 + 1;
                int nodesize = node.getSize();
                if (node.getSize() != 1 || node.getNode(0).getNode(0) != null) {
                    int i = 0;
                    while (i < nodesize) {
                        this.genNodeCode(frame, node.getNode(i), 1, 0, new SubParam());
                        ++i;
                    }
                }
                this.mArrayArgStack.pop();
                return (restype & 1) != 0 ? frame0 : 0;
            }
            case 379: {
                int resaddr;
                int framestart = frame.value;
                int n = resaddr = node.getNode(0) != null ? this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam()) : 0;
                if (this.mCodeAreaPos + 5 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 113;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)this.mArrayArgStack.peek().Object;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)this.mArrayArgStack.peek().Counter;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)resaddr;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 18;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)this.mArrayArgStack.peek().Counter;
                ++this.mCodeAreaPos;
                this.clearFrame(frame, framestart);
                return 0;
            }
            case 380: {
                int dicdp = this.putData(new Variant("Dictionary"));
                int frame0 = frame.value;
                if (this.mCodeAreaPos + 9 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 124;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 103;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)dicdp;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 102;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                frame.value += 2;
                this.clearFrame(frame, frame0 + 1);
                this.mArrayArgStack.push(new ArrayArg());
                this.mArrayArgStack.peek().Object = frame0;
                int nodesize = node.getSize();
                int i = 0;
                while (i < nodesize) {
                    this.genNodeCode(frame, node.getNode(i), 1, 0, new SubParam());
                    ++i;
                }
                this.mArrayArgStack.pop();
                return (restype & 1) != 0 ? frame0 : 0;
            }
            case 381: {
                int framestart = frame.value;
                int name = this.genNodeCode(frame, node.getNode(0), 1, 0, new SubParam());
                int value = this.genNodeCode(frame, node.getNode(1), 1, 0, new SubParam());
                if (this.mCodeAreaPos + 3 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 113;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)this.mArrayArgStack.peek().Object;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)name;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)value;
                ++this.mCodeAreaPos;
                this.clearFrame(frame, framestart);
                return 0;
            }
            case 387: {
                if ((restype & 1) == 0) {
                    return 0;
                }
                int regexpdp = this.putData(new Variant("RegExp"));
                int patdp = this.putData(node.getValue());
                int compiledp = this.putData(new Variant("_compile"));
                int frame0 = frame.value;
                if (this.mCodeAreaPos + 18 >= this.mCodeArea.length) {
                    this.expandCodeArea();
                }
                if (CompileState.mEnableDebugCode) {
                    this.putSrcPos(node_pos);
                }
                this.mCodeArea[this.mCodeAreaPos] = 124;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 103;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)regexpdp;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 2);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)patdp;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 102;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame.value;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 1);
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 100;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 0;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)frame0;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)compiledp;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = 1;
                ++this.mCodeAreaPos;
                this.mCodeArea[this.mCodeAreaPos] = (short)(frame.value + 2);
                ++this.mCodeAreaPos;
                frame.value += 3;
                this.clearFrame(frame, frame0 + 1);
                return frame0;
            }
            case 366: {
                if (param.mSubType != 0) {
                    this.error("\u4e0d\u6b63\u306a\u4ee3\u5165\u304b\u4e0d\u6b63\u306a\u5f0f\u306e\u64cd\u4f5c\u3067\u3059");
                }
                if ((restype & 1) == 0) {
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    private void addOmitArg() throws CompileException {
        if (this.mContextType != 1 && this.mContextType != 2) {
            this.error("\"...\" \u306f\u95a2\u6570\u5916\u3067\u306f\u4f7f\u3048\u307e\u305b\u3093");
        }
        this.mFuncArgStack.peek().IsOmit = true;
    }

    private void endFuncArg() {
        this.mFuncArgStack.pop();
    }

    private void startFuncArg() {
        FuncArg arg = new FuncArg();
        this.mFuncArgStack.push(arg);
    }

    private void outputWarning(String mes) {
        this.outputWarning(mes, -1);
    }

    private void outputWarning(String mes, int pos) {
        int errpos = pos == -1 ? this.mBlock.getLexicalAnalyzer().getCurrentPosition() : pos;
        StringBuilder strBuilder = new StringBuilder(512);
        strBuilder.append("\u8b66\u544a: ");
        strBuilder.append(mes);
        strBuilder.append(" at ");
        strBuilder.append(this.mBlock.getName());
        strBuilder.append(" line ");
        strBuilder.append(String.valueOf(1 + this.mBlock.srcPosToLine(errpos)));
        TJS.outputToConsole(strBuilder.toString());
        strBuilder = null;
    }

    private void addFuncArg(int addr, int type) {
        this.mFuncArgStack.peek().ArgVector.add(new FuncArgItem(addr, type));
        if (type == 1 || type == 2) {
            this.mFuncArgStack.peek().HasExpand = true;
        }
    }

    public void commit() throws VariantException, TJSException {
        if (this.mContextType == 6 && this.mSuperClassGetter != null) {
            this.mSuperClassGetter.commit();
        }
        if (this.mContextType != 3 && this.mContextType != 7) {
            int lexpos = this.getLexPos();
            if (this.mCodeAreaPos + 2 >= this.mCodeArea.length) {
                this.expandCodeArea();
            }
            if (CompileState.mEnableDebugCode) {
                this.putSrcPos(lexpos);
            }
            this.mCodeArea[this.mCodeAreaPos] = 118;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 0;
            ++this.mCodeAreaPos;
            this.mCodeArea[this.mCodeAreaPos] = 119;
            ++this.mCodeAreaPos;
        }
        this.registerFunction();
        if (this.mContextType != 3 && this.mContextType != 7) {
            this.fixCode();
        }
        this.mDataArray = new Variant[this.mDataArea.size()];
        this.mDataArray = this.mDataArea.toArray(this.mDataArray);
        this.mDataArea.clear();
        this.mDataArea = null;
        this.mMaxVariableCount = this.mContextType == 7 ? 2 : this.mNamespace.getMaxCount();
        this.mSuperClassExpr = null;
        this.clearNodesToDelete();
        this.mCode = new short[this.mCodeAreaPos];
        System.arraycopy(this.mCodeArea, 0, this.mCode, 0, this.mCodeAreaPos);
        this.mCurrentNodeVector.clear();
        this.mFuncArgStack = null;
        this.mFuncArgStack = new Stack();
        this.mArrayArgStack = null;
        this.mArrayArgStack = new Stack();
        this.mNestVector = null;
        this.mNestVector = new VectorWrap();
        this.mJumpList = null;
        this.mJumpList = new IntVector();
        this.mFixList = null;
        this.mFixList = new ArrayList();
        this.mNonLocalFunctionDeclVector = null;
        this.mNonLocalFunctionDeclVector = new VectorWrap();
    }

    private void clearNodesToDelete() {
        if (this.mNodeToDeleteVector.size() > 0) {
            int count = this.mNodeToDeleteVector.size();
            int i = count - 1;
            while (i >= 0) {
                ((ExprNode)this.mNodeToDeleteVector.get(i)).clear();
                --i;
            }
        }
        this.mNodeToDeleteVector.clear();
    }

    private void fixCode() {
        if (this.mContextType == 6) {
            short[] newbuff = new short[1];
            ShortBuffer code = ShortBuffer.wrap(newbuff);
            code.clear();
            code.put((short)126);
            this.mFixList.add(new FixData(this.mFunctionRegisterCodePoint, 0, 1, code, true));
        }
        if (this.mNonLocalFunctionDeclVector.size() >= 1) {
            if (this.mMaxFrameCount < 1) {
                this.mMaxFrameCount = 1;
            }
            int codesize = 2;
            for (NonLocalFunctionDecl dec : this.mNonLocalFunctionDeclVector) {
                if (dec.ChangeThis) {
                    codesize += 10;
                    continue;
                }
                codesize += 7;
            }
            short[] newbuff = new short[codesize];
            ShortBuffer code = ShortBuffer.wrap(newbuff);
            code.clear();
            for (NonLocalFunctionDecl dec : this.mNonLocalFunctionDeclVector) {
                code.put((short)1);
                code.put((short)1);
                code.put((short)dec.DataPos);
                if (dec.ChangeThis) {
                    code.put((short)123);
                    code.put((short)1);
                    code.put((short)-1);
                }
                code.put((short)111);
                code.put((short)-1);
                code.put((short)dec.NameDataPos);
                code.put((short)1);
            }
            code.put((short)3);
            code.put((short)1);
            code.flip();
            this.mFixList.add(new FixData(this.mFunctionRegisterCodePoint, 0, codesize, code, true));
            this.mNonLocalFunctionDeclVector.clear();
        }
        this.sortSourcePos();
        int count = this.mFixList.size();
        int i = 0;
        while (i < count) {
            FixData fix = this.mFixList.get(i);
            int jcount = this.mJumpList.size();
            int j = 0;
            while (j < jcount) {
                int jmp = this.mJumpList.get(j);
                int jmptarget = this.mCodeArea[jmp + 1] + jmp;
                if (jmp >= fix.StartIP && jmp < fix.Size + fix.StartIP) {
                    this.mJumpList.remove(j);
                    jmp = j + 1 < jcount ? this.mJumpList.get(++j) : 0;
                } else if (fix.BeforeInsertion ? jmptarget < fix.StartIP : jmptarget <= fix.StartIP && jmp > fix.StartIP + fix.Size || jmp < fix.StartIP && jmptarget >= fix.StartIP + fix.Size) {
                    int v = this.mCodeArea[jmp + 1];
                    this.mCodeArea[jmp + 1] = (short)(v += fix.NewSize - fix.Size);
                }
                if (jmp >= fix.StartIP + fix.Size) {
                    this.mJumpList.set(j, jmp += fix.NewSize - fix.Size);
                }
                ++j;
            }
            if (fix.NewSize > fix.Size) {
                int newBufferSize = this.mCodeAreaPos + fix.NewSize - fix.Size;
                short[] newbuff = new short[newBufferSize];
                System.arraycopy(this.mCodeArea, 0, newbuff, 0, this.mCodeAreaPos);
                this.mCodeArea = null;
                this.mCodeArea = newbuff;
            }
            if (this.mCodeAreaPos - (fix.StartIP + fix.Size) > 0) {
                int dst = fix.StartIP + fix.NewSize;
                int src = fix.StartIP + fix.Size;
                int size = this.mCodeAreaPos - (fix.StartIP + fix.Size);
                short[] newbuff = new short[size];
                System.arraycopy(this.mCodeArea, src, newbuff, 0, size);
                System.arraycopy(newbuff, 0, this.mCodeArea, dst, size);
                if (CompileState.mEnableDebugCode) {
                    int srcSize = this.mSrcPosArrayPos;
                    long[] srcPos = this.mSourcePosArray;
                    int j2 = 0;
                    while (j2 < srcSize) {
                        long val = srcPos[j2];
                        if ((val >>>= 32) >= (long)(fix.StartIP + fix.Size)) {
                            val += (long)(fix.NewSize - fix.Size);
                            srcPos[j2] = val = val << 32 | srcPos[j2] & 0xFFFFFFFFL;
                        }
                        ++j2;
                    }
                }
            }
            if (fix.NewSize > 0 && fix.Code != null) {
                int size = fix.NewSize;
                int dst = fix.StartIP;
                int j3 = 0;
                while (j3 < size) {
                    this.mCodeArea[dst + j3] = fix.Code.get(j3);
                    ++j3;
                }
            }
            this.mCodeAreaPos = this.mCodeAreaPos + fix.NewSize - fix.Size;
            ++i;
        }
        int jcount = this.mJumpList.size();
        int i2 = 0;
        while (i2 < jcount) {
            int jmp = this.mJumpList.get(i2);
            int jumptarget = this.mCodeArea[jmp + 1] + jmp;
            short jumpcode = this.mCodeArea[jmp];
            int addr = jmp;
            addr += this.mCodeArea[addr + 1];
            while (true) {
                if (this.mCodeArea[addr] == 17 || this.mCodeArea[addr] == jumpcode && (jumpcode == 15 || jumpcode == 16)) {
                    jumptarget = this.mCodeArea[addr + 1] + addr;
                    if (this.mCodeArea[addr + 1] == 0) break;
                    addr += this.mCodeArea[addr + 1];
                    continue;
                }
                if ((this.mCodeArea[addr] != 15 || jumpcode != 16) && (this.mCodeArea[addr] != 16 || jumpcode != 15)) break;
                jumptarget = addr + 2;
                addr += 2;
            }
            this.mCodeArea[jmp + 1] = (short)(jumptarget - jmp);
            ++i2;
        }
        this.mJumpList.clear();
        this.mFixList.clear();
    }

    private void sortSourcePos() {
        if (!this.mSourcePosArraySorted && this.mSourcePosArray != null) {
            if (CompileState.mEnableDebugCode) {
                Arrays.sort(this.mSourcePosArray, 0, this.mSrcPosArrayPos);
            }
            this.mSourcePosArraySorted = true;
        }
    }

    private void registerFunction() throws VariantException, TJSException {
        Variant val;
        if (this.mParent == null) {
            return;
        }
        if (this.mContextType == 4) {
            this.mParent.mPropSetter = this;
            return;
        }
        if (this.mContextType == 5) {
            this.mParent.mPropGetter = this;
            return;
        }
        if (this.mContextType == 7) {
            return;
        }
        if (this.mContextType != 1 && this.mContextType != 3 && this.mContextType != 6) {
            return;
        }
        int data = -1;
        if (this.mParent.mContextType == 0) {
            val = new Variant(this);
            data = this.mParent.putData(val);
            val = new Variant(this.mName);
            int name = this.mParent.putData(val);
            boolean changethis = this.mContextType == 1 || this.mContextType == 3;
            this.mParent.mNonLocalFunctionDeclVector.add(new NonLocalFunctionDecl(data, name, changethis));
        }
        if (this.mContextType == 1 && this.mParent.mContextType == 1) {
            if (data == -1) {
                val = new Variant(this);
                data = this.mParent.putData(val);
            }
            this.mParent.initLocalFunction(this.mName, data);
        }
        if (this.mParent.mContextType == 1 || this.mParent.mContextType == 6) {
            if (this.mProperties == null) {
                this.mProperties = new ArrayList();
            }
            this.addProperty(this.mName, this);
        }
    }

    private void addProperty(String name, InterCodeGenerator val) {
        this.mProperties.add(new Property(name, val));
    }

    ArrayList<Property> getProp() {
        return this.mProperties;
    }

    public boolean isClass() {
        return this.mContextType == 6 || this.mContextType == 0;
    }

    public void dumpClassStructure(int nest) {
        int count;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < nest) {
            builder.append("  ");
            ++i;
        }
        String space = builder.toString();
        switch (this.mContextType) {
            case 0: {
                TJS.outputToConsole(String.valueOf(space) + "Top level Name: " + this.mName);
                break;
            }
            case 1: {
                TJS.outputToConsole(String.valueOf(space) + "Function Name: " + this.mName);
                break;
            }
            case 2: {
                TJS.outputToConsole(String.valueOf(space) + "Expr function Name: " + this.mName);
                break;
            }
            case 3: {
                TJS.outputToConsole(String.valueOf(space) + "Property Name: " + this.mName);
                break;
            }
            case 4: {
                TJS.outputToConsole(String.valueOf(space) + "Property setter Name: " + this.mName);
                break;
            }
            case 5: {
                TJS.outputToConsole(String.valueOf(space) + "Property getter Name: " + this.mName);
                break;
            }
            case 6: {
                TJS.outputToConsole(String.valueOf(space) + "Class Name: " + this.mName);
                break;
            }
            case 7: {
                TJS.outputToConsole(String.valueOf(space) + "Super class getter Name: " + this.mName);
            }
        }
        TJS.outputToConsole(String.valueOf(space) + "  Max variable count: " + this.mMaxVariableCount);
        TJS.outputToConsole(String.valueOf(space) + "  Variable reserve count: " + this.mVariableReserveCount);
        TJS.outputToConsole(String.valueOf(space) + "  Max frame count: " + this.mMaxFrameCount);
        TJS.outputToConsole(String.valueOf(space) + "  Func decl arg count: " + this.mFuncDeclArgCount);
        TJS.outputToConsole(String.valueOf(space) + "  Func decl unnamed arg array base: " + this.mFuncDeclUnnamedArgArrayBase);
        TJS.outputToConsole(String.valueOf(space) + "  Func decl collapse base: " + this.mFuncDeclCollapseBase);
        if (this.mPropSetter != null) {
            TJS.outputToConsole(String.valueOf(space) + "  Prop setter:");
            this.mPropSetter.dumpClassStructure(nest + 1);
        } else {
            TJS.outputToConsole(String.valueOf(space) + "  Prop setter: not found");
        }
        if (this.mPropGetter != null) {
            TJS.outputToConsole(String.valueOf(space) + "  Prop getter: true");
            this.mPropGetter.dumpClassStructure(nest + 1);
        } else {
            TJS.outputToConsole(String.valueOf(space) + "  Prop getter: not found");
        }
        if (this.mSuperClassGetter != null) {
            TJS.outputToConsole(String.valueOf(space) + "  Super class getter:");
            this.mSuperClassGetter.dumpClassStructure(nest + 1);
        } else {
            TJS.outputToConsole(String.valueOf(space) + "  Super class getter: not found");
        }
        if (this.mProperties != null) {
            count = this.mProperties.size();
            if (count > 0) {
                TJS.outputToConsole(String.valueOf(space) + "  Members:");
                int i2 = 0;
                while (i2 < count) {
                    this.mProperties.get((int)i2).Value.dumpClassStructure(nest + 1);
                    ++i2;
                }
            } else {
                TJS.outputToConsole(String.valueOf(space) + "  Members: not found");
            }
        } else {
            TJS.outputToConsole(String.valueOf(space) + "  Members: not found");
        }
        TJS.outputToConsole(String.valueOf(space) + "  Data array members:");
        count = this.mDataArray.length;
        Variant[] da = this.mDataArray;
        int i3 = 0;
        while (i3 < count) {
            Variant d = da[i3];
            Object o = d.toJavaObject();
            if (o instanceof InterCodeGenerator) {
                ((InterCodeGenerator)o).dumpClassStructure(nest + 1);
            }
            ++i3;
        }
    }

    public ByteBuffer exportByteCode(Compiler block, ConstArrayData constarray) {
        int parent = -1;
        if (this.mParent != null) {
            parent = block.getCodeIndex(this.mParent);
        }
        int propSetter = -1;
        if (this.mPropSetter != null) {
            propSetter = block.getCodeIndex(this.mPropSetter);
        }
        int propGetter = -1;
        if (this.mPropGetter != null) {
            propGetter = block.getCodeIndex(this.mPropGetter);
        }
        int superClassGetter = -1;
        if (this.mSuperClassGetter != null) {
            superClassGetter = block.getCodeIndex(this.mSuperClassGetter);
        }
        int name = -1;
        if (this.mName != null) {
            name = constarray.putString(this.mName);
        }
        int srcpossize = 0;
        int codesize = this.mCode.length % 2 == 1 ? this.mCode.length * 2 + 2 : this.mCode.length * 2;
        int datasize = this.mDataArray.length * 4;
        int scgpsize = this.mSuperClassGetterPointer != null ? this.mSuperClassGetterPointer.size() * 4 : 0;
        int propsize = (this.mProperties != null ? this.mProperties.size() * 8 : 0) + 4;
        int size = 48 + srcpossize + codesize + datasize + scgpsize + propsize + 16;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.clear();
        IntBuffer buf = result.asIntBuffer();
        buf.clear();
        buf.put(parent);
        buf.put(name);
        buf.put(this.mContextType);
        buf.put(this.mMaxVariableCount);
        buf.put(this.mVariableReserveCount);
        buf.put(this.mMaxFrameCount);
        buf.put(this.mFuncDeclArgCount);
        buf.put(this.mFuncDeclUnnamedArgArrayBase);
        buf.put(this.mFuncDeclCollapseBase);
        buf.put(propSetter);
        buf.put(propGetter);
        buf.put(superClassGetter);
        int count = 0;
        buf.put(count);
        count = this.mCode.length;
        buf.put(count);
        ShortBuffer sbuf = result.asShortBuffer();
        sbuf.clear();
        sbuf.position(buf.position() * 2);
        sbuf.put(this.mCode);
        if (count % 2 == 1) {
            sbuf.put((short)0);
        }
        buf.position(sbuf.position() / 2);
        count = this.mDataArray.length;
        buf.put(count);
        sbuf.position(buf.position() * 2);
        int i = 0;
        while (i < count) {
            Variant val = this.mDataArray[i];
            byte type = constarray.getType(val);
            short v = (short)constarray.putVariant(val, block);
            sbuf.put(type);
            sbuf.put(v);
            ++i;
        }
        buf.position(sbuf.position() / 2);
        count = this.mSuperClassGetterPointer != null ? this.mSuperClassGetterPointer.size() : 0;
        buf.put(count);
        i = 0;
        while (i < count) {
            int v = this.mSuperClassGetterPointer.get(i);
            buf.put(v);
            ++i;
        }
        count = 0;
        if (this.mProperties != null) {
            count = this.mProperties.size();
            buf.put(count);
            if (count > 0) {
                i = 0;
                while (i < count) {
                    Property prop = this.mProperties.get(i);
                    int propname = constarray.putString(prop.Name);
                    int propobj = -1;
                    if (prop.Value != null) {
                        propobj = block.getCodeIndex(prop.Value);
                    }
                    buf.put(propname);
                    buf.put(propobj);
                    ++i;
                }
            }
        } else {
            buf.put(count);
        }
        result.limit(result.capacity());
        result.position(0);
        return result;
    }

    public ArrayList<String> toJavaCode(int start, int end) throws CompileException, VariantException {
        JavaCodeGenerator gen = new JavaCodeGenerator(this.mCode, this.mDataArray, this);
        gen.genFunCall(this.mMaxVariableCount, this.mMaxFrameCount, this.mFuncDeclArgCount, this.mFuncDeclCollapseBase);
        gen.generate(start, end, this.mFuncDeclUnnamedArgArrayBase, this.mMaxFrameCount);
        ArrayList<String> ret = gen.getSourceCode();
        gen = null;
        return ret;
    }

    public InterCodeObject creteCodeObject(ScriptBlock block) {
        this.sortSourcePos();
        LongBuffer srcPos = null;
        if (this.mSourcePosArray != null) {
            srcPos = LongBuffer.wrap(this.mSourcePosArray);
            srcPos.position(this.mSrcPosArrayPos);
        }
        return new InterCodeObject(block, this.mName, this.mContextType, this.mCode, this.mDataArray, this.mMaxVariableCount, this.mVariableReserveCount, this.mMaxFrameCount, this.mFuncDeclArgCount, this.mFuncDeclUnnamedArgArrayBase, this.mFuncDeclCollapseBase, this.mSourcePosArraySorted, srcPos, this.mSuperClassGetterPointer.toArray());
    }

    public void createSecond(InterCodeObject obj) {
        obj.setCodeObject(this.mParent != null ? this.mBlock.getCodeObject(this.mBlock.getCodeIndex(this.mParent)) : null, this.mPropSetter != null ? this.mBlock.getCodeObject(this.mBlock.getCodeIndex(this.mPropSetter)) : null, this.mPropGetter != null ? this.mBlock.getCodeObject(this.mBlock.getCodeIndex(this.mPropGetter)) : null, this.mSuperClassGetter != null ? this.mBlock.getCodeObject(this.mBlock.getCodeIndex(this.mSuperClassGetter)) : null);
    }

    @Override
    public int codePosToSrcPos(int codepos) {
        if (this.mSourcePosArray == null) {
            return 0;
        }
        int s = 0;
        int e = this.mSrcPosArrayPos;
        if (e == 0) {
            return 0;
        }
        while (e - s > 1) {
            int m = s + (e - s) / 2;
            if (this.mSourcePosArray[m] >>> 32 > (long)codepos) {
                e = m;
                continue;
            }
            s = m;
        }
        return (int)(this.mSourcePosArray[s] & 0xFFFFFFFFL);
    }

    @Override
    public int srcPosToLine(int srcpos) {
        return this.mBlock.srcPosToLine(srcpos);
    }

    @Override
    public String getLine(int line) {
        return this.mBlock.getLine(line);
    }

    @Override
    public String getScript() {
        return this.mBlock.getScript();
    }

    @Override
    public int getLineOffset() {
        return this.mBlock.getLineOffset();
    }

    public int getContextType() {
        return this.mContextType;
    }

    public InterCodeGenerator getParent() {
        return this.mParent;
    }

    static class ArrayArg {
        int Object;
        int Counter;

        ArrayArg() {
        }
    }

    static class FixData {
        int StartIP;
        int Size;
        int NewSize;
        boolean BeforeInsertion;
        ShortBuffer Code;

        public FixData(int startip, int size, int newsize, ShortBuffer code, boolean beforeinsertion) {
            this.StartIP = startip;
            this.Size = size;
            this.NewSize = newsize;
            this.Code = code;
            this.BeforeInsertion = beforeinsertion;
        }

        public FixData(FixData fixdata) {
            this.copy(fixdata);
        }

        public void copy(FixData fixdata) {
            this.Code = null;
            this.StartIP = fixdata.StartIP;
            this.Size = fixdata.Size;
            this.NewSize = fixdata.NewSize;
            this.BeforeInsertion = fixdata.BeforeInsertion;
            short[] newbuff = new short[this.NewSize];
            ShortBuffer ibuff = ShortBuffer.wrap(newbuff);
            ibuff.clear();
            ShortBuffer tmp = fixdata.Code.duplicate();
            tmp.flip();
            ibuff.put(tmp);
            this.Code = ibuff;
        }
    }

    static class FuncArg {
        public boolean IsOmit;
        public boolean HasExpand;
        public ArrayList<FuncArgItem> ArgVector = new ArrayList();
    }

    static class FuncArgItem {
        public int Register;
        public int Type;

        public FuncArgItem(int reg) {
            this(reg, 0);
        }

        public FuncArgItem(int reg, int type) {
            this.Register = reg;
            this.Type = type;
        }
    }

    static class NestData {
        int Type;
        int VariableCount;
        boolean VariableCreated;
        int RefRegister;
        int StartIP;
        int LoopStartIP;
        IntVector ContinuePatchVector = new IntVector();
        IntVector ExitPatchVector = new IntVector();
        int Patch1;
        int Patch2;
        ExprNode PostLoopExpr;
    }

    static class NonLocalFunctionDecl {
        int DataPos;
        int NameDataPos;
        boolean ChangeThis;

        public NonLocalFunctionDecl(int datapos, int namedatapos, boolean changethis) {
            this.DataPos = datapos;
            this.NameDataPos = namedatapos;
            this.ChangeThis = changethis;
        }
    }

    public static class Property {
        public String Name;
        public InterCodeGenerator Value;

        public Property(String name, InterCodeGenerator val) {
            this.Name = name;
            this.Value = val;
        }
    }

    public static class SubParam {
        public int mSubType;
        public int mSubFlag;
        public int mSubAddress;

        public SubParam() {
        }

        public SubParam(SubParam param) {
            this.mSubType = param.mSubType;
            this.mSubFlag = param.mSubFlag;
            this.mSubAddress = param.mSubAddress;
        }
    }
}

