/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import jp.kirikiri.tjs2.ArrayClass;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.CustomObject;
import jp.kirikiri.tjs2.Disassembler;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.IntWrapper;
import jp.kirikiri.tjs2.InterCodeGenerator;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.ObjectProxy;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class InterCodeObject
extends CustomObject
implements SourceCodeAccessor {
    private static final String[] mStrFuncs = new String[]{"charAt", "indexOf", "toUpperCase", "toLowerCase", "substring", "substr", "sprintf", "replace", "escape", "split", "trim", "reverse", "repeat"};
    private static final int StrMethod_charAt = 0;
    private static final int StrMethod_indexOf = 1;
    private static final int StrMethod_toUpperCase = 2;
    private static final int StrMethod_toLowerCase = 3;
    private static final int StrMethod_substring = 4;
    private static final int StrMethod_substr = 5;
    private static final int StrMethod_sprintf = 6;
    private static final int StrMethod_replace = 7;
    private static final int StrMethod_escape = 8;
    private static final int StrMethod_split = 9;
    private static final int StrMethod_trim = 10;
    private static final int StrMethod_reverse = 11;
    private static final int StrMethod_repeat = 12;
    private ScriptBlock mBlock;
    InterCodeObject mParent;
    private String mName;
    private int mContextType;
    private short[] mCode;
    private Variant[] mDataArray;
    private int mMaxVariableCount;
    private int mVariableReserveCount;
    private int mMaxFrameCount;
    private int mFuncDeclArgCount;
    private int mFuncDeclUnnamedArgArrayBase;
    private int mFuncDeclCollapseBase;
    private LongBuffer mSourcePosArray;
    private InterCodeObject mPropSetter;
    private InterCodeObject mPropGetter;
    private InterCodeObject mSuperClassGetter;
    private int[] mSuperClassGetterPointer;
    private Disassembler mDisassembler;
    private static final int NAMESPACE_DEFAULT_HASH_BITS = 3;
    private static final int VM_NOP = 0;
    private static final int VM_CONST = 1;
    private static final int VM_CP = 2;
    private static final int VM_CL = 3;
    private static final int VM_CCL = 4;
    private static final int VM_TT = 5;
    private static final int VM_TF = 6;
    private static final int VM_CEQ = 7;
    private static final int VM_CDEQ = 8;
    private static final int VM_CLT = 9;
    private static final int VM_CGT = 10;
    private static final int VM_SETF = 11;
    private static final int VM_SETNF = 12;
    private static final int VM_LNOT = 13;
    private static final int VM_NF = 14;
    private static final int VM_JF = 15;
    private static final int VM_JNF = 16;
    private static final int VM_JMP = 17;
    private static final int VM_INC = 18;
    private static final int VM_INCPD = 19;
    private static final int VM_INCPI = 20;
    private static final int VM_INCP = 21;
    private static final int VM_DEC = 22;
    private static final int VM_DECPD = 23;
    private static final int VM_DECPI = 24;
    private static final int VM_DECP = 25;
    private static final int VM_LOR = 26;
    private static final int VM_LORPD = 27;
    private static final int VM_LORPI = 28;
    private static final int VM_LORP = 29;
    private static final int VM_LAND = 30;
    private static final int VM_LANDPD = 31;
    private static final int VM_LANDPI = 32;
    private static final int VM_LANDP = 33;
    private static final int VM_BOR = 34;
    private static final int VM_BORPD = 35;
    private static final int VM_BORPI = 36;
    private static final int VM_BORP = 37;
    private static final int VM_BXOR = 38;
    private static final int VM_BXORPD = 39;
    private static final int VM_BXORPI = 40;
    private static final int VM_BXORP = 41;
    private static final int VM_BAND = 42;
    private static final int VM_BANDPD = 43;
    private static final int VM_BANDPI = 44;
    private static final int VM_BANDP = 45;
    private static final int VM_SAR = 46;
    private static final int VM_SARPD = 47;
    private static final int VM_SARPI = 48;
    private static final int VM_SARP = 49;
    private static final int VM_SAL = 50;
    private static final int VM_SALPD = 51;
    private static final int VM_SALPI = 52;
    private static final int VM_SALP = 53;
    private static final int VM_SR = 54;
    private static final int VM_SRPD = 55;
    private static final int VM_SRPI = 56;
    private static final int VM_SRP = 57;
    private static final int VM_ADD = 58;
    private static final int VM_ADDPD = 59;
    private static final int VM_ADDPI = 60;
    private static final int VM_ADDP = 61;
    private static final int VM_SUB = 62;
    private static final int VM_SUBPD = 63;
    private static final int VM_SUBPI = 64;
    private static final int VM_SUBP = 65;
    private static final int VM_MOD = 66;
    private static final int VM_MODPD = 67;
    private static final int VM_MODPI = 68;
    private static final int VM_MODP = 69;
    private static final int VM_DIV = 70;
    private static final int VM_DIVPD = 71;
    private static final int VM_DIVPI = 72;
    private static final int VM_DIVP = 73;
    private static final int VM_IDIV = 74;
    private static final int VM_IDIVPD = 75;
    private static final int VM_IDIVPI = 76;
    private static final int VM_IDIVP = 77;
    private static final int VM_MUL = 78;
    private static final int VM_MULPD = 79;
    private static final int VM_MULPI = 80;
    private static final int VM_MULP = 81;
    private static final int VM_BNOT = 82;
    private static final int VM_TYPEOF = 83;
    private static final int VM_TYPEOFD = 84;
    private static final int VM_TYPEOFI = 85;
    private static final int VM_EVAL = 86;
    private static final int VM_EEXP = 87;
    private static final int VM_CHKINS = 88;
    private static final int VM_ASC = 89;
    private static final int VM_CHR = 90;
    private static final int VM_NUM = 91;
    private static final int VM_CHS = 92;
    private static final int VM_INV = 93;
    private static final int VM_CHKINV = 94;
    private static final int VM_INT = 95;
    private static final int VM_REAL = 96;
    private static final int VM_STR = 97;
    private static final int VM_OCTET = 98;
    private static final int VM_CALL = 99;
    private static final int VM_CALLD = 100;
    private static final int VM_CALLI = 101;
    private static final int VM_NEW = 102;
    private static final int VM_GPD = 103;
    private static final int VM_SPD = 104;
    private static final int VM_SPDE = 105;
    private static final int VM_SPDEH = 106;
    private static final int VM_GPI = 107;
    private static final int VM_SPI = 108;
    private static final int VM_SPIE = 109;
    private static final int VM_GPDS = 110;
    private static final int VM_SPDS = 111;
    private static final int VM_GPIS = 112;
    private static final int VM_SPIS = 113;
    private static final int VM_SETP = 114;
    private static final int VM_GETP = 115;
    private static final int VM_DELD = 116;
    private static final int VM_DELI = 117;
    private static final int VM_SRV = 118;
    private static final int VM_RET = 119;
    private static final int VM_ENTRY = 120;
    private static final int VM_EXTRY = 121;
    private static final int VM_THROW = 122;
    private static final int VM_CHGTHIS = 123;
    private static final int VM_GLOBAL = 124;
    private static final int VM_ADDCI = 125;
    private static final int VM_REGMEMBER = 126;
    private static final int VM_DEBUGGER = 127;
    private static final int fatNormal = 0;
    private static final int fatExpand = 1;
    private static final int fatUnnamedExpand = 2;
    private static final int OP_BAND = 1;
    private static final int OP_BOR = 2;
    private static final int OP_BXOR = 3;
    private static final int OP_SUB = 4;
    private static final int OP_ADD = 5;
    private static final int OP_MOD = 6;
    private static final int OP_DIV = 7;
    private static final int OP_IDIV = 8;
    private static final int OP_MUL = 9;
    private static final int OP_LOR = 10;
    private static final int OP_LAND = 11;
    private static final int OP_SAR = 12;
    private static final int OP_SAL = 13;
    private static final int OP_SR = 14;
    private static final int OP_INC = 15;
    private static final int OP_DEC = 16;

    private static int getContextHashSize(int type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 0;
            }
        }
        return 3;
    }

    public InterCodeObject(ScriptBlock block, String name, int type, short[] code, Variant[] da, int varcount, int verrescount, int maxframe, int argcount, int arraybase, int colbase, boolean srcsorted, LongBuffer srcpos, int[] superpointer) {
        super(InterCodeObject.getContextHashSize(type));
        this.mCallFinalize = false;
        this.mBlock = block;
        this.mName = name;
        this.mContextType = type;
        this.mCode = code;
        this.mDataArray = da;
        this.mMaxVariableCount = varcount;
        this.mVariableReserveCount = verrescount;
        this.mMaxFrameCount = maxframe;
        this.mFuncDeclArgCount = argcount;
        this.mFuncDeclUnnamedArgArrayBase = arraybase;
        this.mFuncDeclCollapseBase = colbase;
        this.mSourcePosArray = srcpos;
        this.mSuperClassGetterPointer = superpointer;
    }

    public void setCodeObject(InterCodeObject parent, InterCodeObject setter, InterCodeObject getter, InterCodeObject superclass) {
        this.mParent = parent;
        this.mPropSetter = setter;
        this.mPropGetter = getter;
        this.mSuperClassGetter = superclass;
    }

    @Override
    protected void finalizeObject() throws VariantException, TJSException {
        if (this.mPropSetter != null) {
            this.mPropSetter = null;
        }
        if (this.mPropGetter != null) {
            this.mPropGetter = null;
        }
        if (this.mSuperClassGetter != null) {
            this.mSuperClassGetter = null;
        }
        this.mBlock.remove(this);
        if (this.mContextType != 0 && this.mBlock != null) {
            this.mBlock = null;
        }
        super.finalizeObject();
    }

    public void compact() {
        if (TJS.IsLowMemory) {
            this.mSourcePosArray = null;
        }
    }

    private void executeAsFunction(Dispatch2 objthis, Variant[] args, Variant result, int start_ip) throws VariantException, TJSException {
        int num_alloc = this.mMaxVariableCount + this.mVariableReserveCount + 1 + this.mMaxFrameCount;
        Variant[] regs = null;
        try {
            regs = new Variant[num_alloc];
            int i = 0;
            while (i < num_alloc) {
                regs[i] = new Variant();
                ++i;
            }
            int arrayOffset = this.mMaxVariableCount + this.mVariableReserveCount;
            if (objthis != null) {
                ObjectProxy proxy = new ObjectProxy();
                proxy.setObjects(objthis, this.mBlock.getTJS().getGlobal());
                regs[arrayOffset - 2].set(proxy);
            } else {
                Dispatch2 global = this.mBlock.getTJS().getGlobal();
                regs[arrayOffset - 2].set(global, global);
            }
            try {
                int r;
                int numargs;
                regs[arrayOffset - 1].set(objthis, objthis);
                int n = numargs = args != null ? args.length : 0;
                if (numargs >= this.mFuncDeclArgCount) {
                    if (this.mFuncDeclArgCount != 0) {
                        r = arrayOffset - 3;
                        int n2 = this.mFuncDeclArgCount;
                        int argOffset = 0;
                        while (true) {
                            regs[r].set(args[argOffset]);
                            ++argOffset;
                            if (--n2 != 0) {
                                --r;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    r = arrayOffset - 3;
                    int argOffset = 0;
                    int i2 = 0;
                    while (i2 < numargs) {
                        regs[r].set(args[argOffset]);
                        ++argOffset;
                        --r;
                        ++i2;
                    }
                    while (i2 < this.mFuncDeclArgCount) {
                        regs[r].clear();
                        --r;
                        ++i2;
                    }
                }
                if (this.mFuncDeclCollapseBase >= 0) {
                    r = arrayOffset - 3 - this.mFuncDeclCollapseBase;
                    Dispatch2 dsp = TJS.createArrayObject();
                    regs[r].set(dsp, dsp);
                    if (numargs > this.mFuncDeclCollapseBase) {
                        int c = 0;
                        int i3 = this.mFuncDeclCollapseBase;
                        while (i3 < numargs) {
                            dsp.propSetByNum(0, c, args[i3], dsp);
                            ++i3;
                            ++c;
                        }
                    }
                }
                this.executeCode(regs, arrayOffset, start_ip, args, result);
            }
            finally {
                regs = null;
            }
        }
        finally {
            regs = null;
        }
    }

    private int executeCode(Variant[] ra_org, int ra_offset, int startip, Variant[] args, Variant result) throws TJSScriptError, VariantException {
        int codesave = startip;
        try {
            int code = startip;
            Variant[] ra = ra_org;
            Variant[] da = this.mDataArray;
            short[] ca = this.mCode;
            boolean flag = false;
            block134: while (true) {
                codesave = ++code;
                switch (ca[code]) {
                    case 0: {
                        continue block134;
                    }
                    case 1: {
                        ra[ra_offset + ca[code + 1]].set(da[ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 2: {
                        ra[ra_offset + ca[code + 1]].set(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 3: {
                        ra[ra_offset + ca[code + 1]].clear();
                        code += 2;
                        continue block134;
                    }
                    case 4: {
                        this.continuousClear(ra, ra_offset, code);
                        code += 3;
                        continue block134;
                    }
                    case 5: {
                        flag = ra[ra_offset + ca[code + 1]].asBoolean();
                        code += 2;
                        continue block134;
                    }
                    case 6: {
                        flag = !ra[ra_offset + ca[code + 1]].asBoolean();
                        code += 2;
                        continue block134;
                    }
                    case 7: {
                        flag = ra[ra_offset + ca[code + 1]].normalCompare(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 8: {
                        short ri = ca[code + 2];
                        flag = ri == 0 ? ra[ra_offset + ca[code + 1]].isVoid() : ra[ra_offset + ca[code + 1]].discernCompare(ra[ra_offset + ca[code + 2]]).asBoolean();
                        code += 3;
                        continue block134;
                    }
                    case 9: {
                        flag = ra[ra_offset + ca[code + 1]].greaterThan(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 10: {
                        flag = ra[ra_offset + ca[code + 1]].littlerThan(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 11: {
                        ra[ra_offset + ca[code + 1]].set(flag ? 1 : 0);
                        code += 2;
                        continue block134;
                    }
                    case 12: {
                        ra[ra_offset + ca[code + 1]].set(flag ? 0 : 1);
                        code += 2;
                        continue block134;
                    }
                    case 13: {
                        ra[ra_offset + ca[code + 1]].logicalnot();
                        code += 2;
                        continue block134;
                    }
                    case 14: {
                        flag = !flag;
                        ++code;
                        continue block134;
                    }
                    case 15: {
                        if (flag) {
                            code += ca[code + 1];
                            continue block134;
                        }
                        code += 2;
                        continue block134;
                    }
                    case 16: {
                        if (!flag) {
                            code += ca[code + 1];
                            continue block134;
                        }
                        code += 2;
                        continue block134;
                    }
                    case 17: {
                        code += ca[code + 1];
                        continue block134;
                    }
                    case 18: {
                        ra[ra_offset + ca[code + 1]].increment();
                        code += 2;
                        continue block134;
                    }
                    case 19: {
                        this.operatePropertyDirect0(ra, ra_offset, code, 15);
                        code += 4;
                        continue block134;
                    }
                    case 20: {
                        this.operatePropertyIndirect0(ra, ra_offset, code, 15);
                        code += 4;
                        continue block134;
                    }
                    case 21: {
                        this.operateProperty0(ra, ra_offset, code, 15);
                        code += 3;
                        continue block134;
                    }
                    case 22: {
                        ra[ra_offset + ca[code + 1]].decrement();
                        code += 2;
                        continue block134;
                    }
                    case 23: {
                        this.operatePropertyDirect0(ra, ra_offset, code, 16);
                        code += 4;
                        continue block134;
                    }
                    case 24: {
                        this.operatePropertyIndirect0(ra, ra_offset, code, 16);
                        code += 4;
                        continue block134;
                    }
                    case 25: {
                        this.operateProperty0(ra, ra_offset, code, 16);
                        code += 3;
                        continue block134;
                    }
                    case 26: {
                        ra[ra_offset + ca[code + 1]].logicalorequal(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 27: {
                        this.operatePropertyDirect(ra, ra_offset, code, 10);
                        code += 5;
                        continue block134;
                    }
                    case 28: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 10);
                        code += 5;
                        continue block134;
                    }
                    case 29: {
                        this.operateProperty(ra, ra_offset, code, 10);
                        code += 4;
                        continue block134;
                    }
                    case 30: {
                        ra[ra_offset + ca[code + 1]].logicalandequal(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 31: {
                        this.operatePropertyDirect(ra, ra_offset, code, 11);
                        code += 5;
                        continue block134;
                    }
                    case 32: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 11);
                        code += 5;
                        continue block134;
                    }
                    case 33: {
                        this.operateProperty(ra, ra_offset, code, 11);
                        code += 4;
                        continue block134;
                    }
                    case 34: {
                        ra[ra_offset + ca[code + 1]].orEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 35: {
                        this.operatePropertyDirect(ra, ra_offset, code, 2);
                        code += 5;
                        continue block134;
                    }
                    case 36: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 2);
                        code += 5;
                        continue block134;
                    }
                    case 37: {
                        this.operateProperty(ra, ra_offset, code, 2);
                        code += 4;
                        continue block134;
                    }
                    case 38: {
                        ra[ra_offset + ca[code + 1]].bitXorEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 39: {
                        this.operatePropertyDirect(ra, ra_offset, code, 3);
                        code += 5;
                        continue block134;
                    }
                    case 40: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 3);
                        code += 5;
                        continue block134;
                    }
                    case 41: {
                        this.operateProperty(ra, ra_offset, code, 3);
                        code += 4;
                        continue block134;
                    }
                    case 42: {
                        ra[ra_offset + ca[code + 1]].andEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 43: {
                        this.operatePropertyDirect(ra, ra_offset, code, 1);
                        code += 5;
                        continue block134;
                    }
                    case 44: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 1);
                        code += 5;
                        continue block134;
                    }
                    case 45: {
                        this.operateProperty(ra, ra_offset, code, 1);
                        code += 4;
                        continue block134;
                    }
                    case 46: {
                        ra[ra_offset + ca[code + 1]].rightShiftEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 47: {
                        this.operatePropertyDirect(ra, ra_offset, code, 12);
                        code += 5;
                        continue block134;
                    }
                    case 48: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 12);
                        code += 5;
                        continue block134;
                    }
                    case 49: {
                        this.operateProperty(ra, ra_offset, code, 12);
                        code += 4;
                        continue block134;
                    }
                    case 50: {
                        ra[ra_offset + ca[code + 1]].leftShiftEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 51: {
                        this.operatePropertyDirect(ra, ra_offset, code, 13);
                        code += 5;
                        continue block134;
                    }
                    case 52: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 13);
                        code += 5;
                        continue block134;
                    }
                    case 53: {
                        this.operateProperty(ra, ra_offset, code, 13);
                        code += 4;
                        continue block134;
                    }
                    case 54: {
                        ra[ra_offset + ca[code + 1]].rbitshiftequal(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 55: {
                        this.operatePropertyDirect(ra, ra_offset, code, 14);
                        code += 5;
                        continue block134;
                    }
                    case 56: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 14);
                        code += 5;
                        continue block134;
                    }
                    case 57: {
                        this.operateProperty(ra, ra_offset, code, 14);
                        code += 4;
                        continue block134;
                    }
                    case 58: {
                        ra[ra_offset + ca[code + 1]].addEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 59: {
                        this.operatePropertyDirect(ra, ra_offset, code, 5);
                        code += 5;
                        continue block134;
                    }
                    case 60: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 5);
                        code += 5;
                        continue block134;
                    }
                    case 61: {
                        this.operateProperty(ra, ra_offset, code, 5);
                        code += 4;
                        continue block134;
                    }
                    case 62: {
                        ra[ra_offset + ca[code + 1]].subtractEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 63: {
                        this.operatePropertyDirect(ra, ra_offset, code, 4);
                        code += 5;
                        continue block134;
                    }
                    case 64: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 4);
                        code += 5;
                        continue block134;
                    }
                    case 65: {
                        this.operateProperty(ra, ra_offset, code, 4);
                        code += 4;
                        continue block134;
                    }
                    case 66: {
                        ra[ra_offset + ca[code + 1]].residueEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 67: {
                        this.operatePropertyDirect(ra, ra_offset, code, 6);
                        code += 5;
                        continue block134;
                    }
                    case 68: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 6);
                        code += 5;
                        continue block134;
                    }
                    case 69: {
                        this.operateProperty(ra, ra_offset, code, 6);
                        code += 4;
                        continue block134;
                    }
                    case 70: {
                        ra[ra_offset + ca[code + 1]].divideEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 71: {
                        this.operatePropertyDirect(ra, ra_offset, code, 7);
                        code += 5;
                        continue block134;
                    }
                    case 72: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 7);
                        code += 5;
                        continue block134;
                    }
                    case 73: {
                        this.operateProperty(ra, ra_offset, code, 7);
                        code += 4;
                        continue block134;
                    }
                    case 74: {
                        ra[ra_offset + ca[code + 1]].idivequal(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 75: {
                        this.operatePropertyDirect(ra, ra_offset, code, 8);
                        code += 5;
                        continue block134;
                    }
                    case 76: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 8);
                        code += 5;
                        continue block134;
                    }
                    case 77: {
                        this.operateProperty(ra, ra_offset, code, 8);
                        code += 4;
                        continue block134;
                    }
                    case 78: {
                        ra[ra_offset + ca[code + 1]].multiplyEqual(ra[ra_offset + ca[code + 2]]);
                        code += 3;
                        continue block134;
                    }
                    case 79: {
                        this.operatePropertyDirect(ra, ra_offset, code, 9);
                        code += 5;
                        continue block134;
                    }
                    case 80: {
                        this.operatePropertyIndirect(ra, ra_offset, code, 9);
                        code += 5;
                        continue block134;
                    }
                    case 81: {
                        this.operateProperty(ra, ra_offset, code, 9);
                        code += 4;
                        continue block134;
                    }
                    case 82: {
                        ra[ra_offset + ca[code + 1]].bitnot();
                        code += 2;
                        continue block134;
                    }
                    case 89: {
                        InterCodeObject.characterCodeOf(ra[ra_offset + ca[code + 1]]);
                        code += 2;
                        continue block134;
                    }
                    case 90: {
                        InterCodeObject.characterCodeFrom(ra[ra_offset + ca[code + 1]]);
                        code += 2;
                        continue block134;
                    }
                    case 91: {
                        ra[ra_offset + ca[code + 1]].tonumber();
                        code += 2;
                        continue block134;
                    }
                    case 92: {
                        ra[ra_offset + ca[code + 1]].changesign();
                        code += 2;
                        continue block134;
                    }
                    case 93: {
                        int offset = ra_offset + ca[code + 1];
                        boolean tmp = !ra[offset].isObject() ? false : ra[offset].asObjectClosure().invalidate(0, null, ra[ra_offset - 1].asObject()) == 1;
                        ra[offset].set(tmp ? 1 : 0);
                        code += 2;
                        continue block134;
                    }
                    case 94: {
                        int ret;
                        int offset = ra_offset + ca[code + 1];
                        boolean tmp = !ra[offset].isObject() ? true : (ret = ra[offset].asObjectClosure().isValid(0, null, ra[ra_offset - 1].asObject())) == 1 || ret == -1002;
                        ra[offset].set(tmp ? 1 : 0);
                        code += 2;
                        continue block134;
                    }
                    case 95: {
                        ra[ra_offset + ca[code + 1]].toInteger();
                        code += 2;
                        continue block134;
                    }
                    case 96: {
                        ra[ra_offset + ca[code + 1]].toReal();
                        code += 2;
                        continue block134;
                    }
                    case 97: {
                        ra[ra_offset + ca[code + 1]].selfToString();
                        code += 2;
                        continue block134;
                    }
                    case 98: {
                        ra[ra_offset + ca[code + 1]].toOctet();
                        code += 2;
                        continue block134;
                    }
                    case 83: {
                        this.typeOf(ra[ra_offset + ca[code + 1]]);
                        code += 2;
                        continue block134;
                    }
                    case 84: {
                        this.typeOfMemberDirect(ra, ra_offset, code, 1024);
                        code += 4;
                        continue block134;
                    }
                    case 85: {
                        this.typeOfMemberIndirect(ra, ra_offset, code, 1024);
                        code += 4;
                        continue block134;
                    }
                    case 86: {
                        this.eval(ra[ra_offset + ca[code + 1]], TJS.mEvalOperatorIsOnGlobal ? null : ra[ra_offset - 1].asObject(), true);
                        code += 2;
                        continue block134;
                    }
                    case 87: {
                        this.eval(ra[ra_offset + ca[code + 1]], TJS.mEvalOperatorIsOnGlobal ? null : ra[ra_offset - 1].asObject(), false);
                        code += 2;
                        continue block134;
                    }
                    case 88: {
                        this.instanceOf(ra[ra_offset + ca[code + 2]], ra[ra_offset + ca[code + 1]]);
                        code += 3;
                        continue block134;
                    }
                    case 99: 
                    case 102: {
                        code += this.callFunction(ra, ra_offset, code, args);
                        continue block134;
                    }
                    case 100: {
                        code += this.callFunctionDirect(ra, ra_offset, code, args);
                        continue block134;
                    }
                    case 101: {
                        code += this.callFunctionIndirect(ra, ra_offset, code, args);
                        continue block134;
                    }
                    case 103: {
                        this.getPropertyDirect(ra, ra_offset, code, 0);
                        code += 4;
                        continue block134;
                    }
                    case 110: {
                        this.getPropertyDirect(ra, ra_offset, code, 2048);
                        code += 4;
                        continue block134;
                    }
                    case 104: {
                        this.setPropertyDirect(ra, ra_offset, code, 0);
                        code += 4;
                        continue block134;
                    }
                    case 105: {
                        this.setPropertyDirect(ra, ra_offset, code, 512);
                        code += 4;
                        continue block134;
                    }
                    case 106: {
                        this.setPropertyDirect(ra, ra_offset, code, 4608);
                        code += 4;
                        continue block134;
                    }
                    case 111: {
                        this.setPropertyDirect(ra, ra_offset, code, 2560);
                        code += 4;
                        continue block134;
                    }
                    case 107: {
                        this.getPropertyIndirect(ra, ra_offset, code, 0);
                        code += 4;
                        continue block134;
                    }
                    case 112: {
                        this.getPropertyIndirect(ra, ra_offset, code, 2048);
                        code += 4;
                        continue block134;
                    }
                    case 108: {
                        this.setPropertyIndirect(ra, ra_offset, code, 0);
                        code += 4;
                        continue block134;
                    }
                    case 109: {
                        this.setPropertyIndirect(ra, ra_offset, code, 512);
                        code += 4;
                        continue block134;
                    }
                    case 113: {
                        this.setPropertyIndirect(ra, ra_offset, code, 2560);
                        code += 4;
                        continue block134;
                    }
                    case 115: {
                        this.getProperty(ra, ra_offset, code);
                        code += 3;
                        continue block134;
                    }
                    case 114: {
                        this.setProperty(ra, ra_offset, code);
                        code += 3;
                        continue block134;
                    }
                    case 116: {
                        this.deleteMemberDirect(ra, ra_offset, code);
                        code += 4;
                        continue block134;
                    }
                    case 117: {
                        this.deleteMemberIndirect(ra, ra_offset, code);
                        code += 4;
                        continue block134;
                    }
                    case 118: {
                        if (result != null) {
                            result.copyRef(ra[ra_offset + ca[code + 1]]);
                        }
                        code += 2;
                        continue block134;
                    }
                    case 119: {
                        return code + 1;
                    }
                    case 120: {
                        code = this.executeCodeInTryBlock(ra, ra_offset, code + 3, args, result, ca[code + 1] + code, ca[code + 2]);
                        continue block134;
                    }
                    case 121: {
                        return code + 1;
                    }
                    case 122: {
                        this.throwScriptException(ra[ra_offset + ca[code + 1]], this.mBlock, this.codePosToSrcPos(code));
                        code += 2;
                        continue block134;
                    }
                    case 123: {
                        ra[ra_offset + ca[code + 1]].changeClosureObjThis(ra[ra_offset + ca[code + 2]].asObject());
                        code += 3;
                        continue block134;
                    }
                    case 124: {
                        ra[ra_offset + ca[code + 1]].set(this.mBlock.getTJS().getGlobal());
                        code += 2;
                        continue block134;
                    }
                    case 125: {
                        this.addClassInstanceInfo(ra, ra_offset, code);
                        code += 3;
                        continue block134;
                    }
                    case 126: {
                        this.copyAllMembers((CustomObject)ra[ra_offset - 1].asObject());
                        ++code;
                        continue block134;
                    }
                    case 127: {
                        ++code;
                        continue block134;
                    }
                }
                InterCodeObject.throwInvalidVMCode();
            }
        }
        catch (TJSScriptException e) {
            e.addTrace(this, codesave);
            throw e;
        }
        catch (TJSScriptError e) {
            e.addTrace(this, codesave);
            throw e;
        }
        catch (TJSException e) {
            this.displayExceptionGeneratedCode(codesave, ra_org, ra_offset);
            Error.reportExceptionSource(e.getMessage(), this, this.codePosToSrcPos(codesave));
            throw new TJSScriptError(e.getMessage(), this.mBlock, this.codePosToSrcPos(codesave));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayExceptionGeneratedCode(codesave, ra_org, ra_offset);
            Error.reportExceptionSource(e.getMessage(), this, this.codePosToSrcPos(codesave));
            throw new TJSScriptError(e.getMessage(), this.mBlock, this.codePosToSrcPos(codesave));
        }
    }

    private final void operateProperty(Variant[] ra, int ra_offset, int code, int ope) throws TJSException, VariantException {
        Dispatch2 objThis;
        short offset;
        Variant result;
        short[] ca = this.mCode;
        Variant ra_code2 = ra[ra_offset + ca[code + 2]];
        Variant ra_code3 = ra[ra_offset + ca[code + 3]];
        VariantClosure clo = ra_code2.asObjectClosure();
        int hr = clo.operation(ope, null, result = (offset = ca[code + 1]) != 0 ? ra[ra_offset + offset] : null, ra_code3, objThis = clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, null);
        }
    }

    private final void operatePropertyIndirect(Variant[] ra, int ra_offset, int code, int ope) throws TJSException, VariantException {
        Dispatch2 objThis;
        short[] ca = this.mCode;
        Variant ra_code2 = ra[ra_offset + ca[code + 2]];
        Variant ra_code3 = ra[ra_offset + ca[code + 3]];
        Variant ra_code4 = ra[ra_offset + ca[code + 4]];
        VariantClosure clo = ra_code2.asObjectClosure();
        short offset = ca[code + 1];
        Variant result = offset != 0 ? ra[ra_offset + offset] : null;
        Dispatch2 dispatch2 = objThis = clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject();
        if (!ra_code3.isInteger()) {
            String str = ra_code3.asString();
            int hr = clo.operation(ope, str, result, ra_code4, objThis);
            if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error(hr, str);
            }
        } else {
            int num = ra_code3.asInteger();
            int hr = clo.operationByNum(ope, num, result, ra_code4, objThis);
            if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error_num(hr, num);
            }
        }
    }

    private final void operatePropertyDirect(Variant[] ra, int ra_offset, int code, int ope) throws TJSException, VariantException {
        Dispatch2 objThis;
        short offset;
        Variant result;
        String nameStr;
        short[] ca = this.mCode;
        Variant ra_code2 = ra[ra_offset + ca[code + 2]];
        Variant da_code3 = this.mDataArray[ca[code + 3]];
        Variant ra_code4 = ra[ra_offset + ca[code + 4]];
        VariantClosure clo = ra_code2.asObjectClosure();
        int hr = clo.operation(ope, nameStr = da_code3.getString(), result = (offset = ca[code + 1]) != 0 ? ra[ra_offset + offset] : null, ra_code4, objThis = clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, nameStr);
        }
    }

    private final void displayExceptionGeneratedCode(int codepos, Variant[] ra, int ra_offset) throws VariantException {
        StringBuilder builder = new StringBuilder(128);
        builder.append("==== An exception occured at ");
        builder.append(this.getPositionDescriptionString(codepos));
        builder.append(", VM ip = ");
        builder.append(codepos);
        builder.append(" ====");
        int info_len = builder.length();
        TJS.outputToConsole(builder.toString());
        builder.delete(0, builder.length());
        TJS.outputToConsole("-- Disassembled VM code --");
        this.disassenbleSrcLine(codepos);
        TJS.outputToConsole("-- Register dump --");
        int ra_start = ra_offset - (this.mMaxVariableCount + this.mVariableReserveCount);
        int ra_count = this.mMaxVariableCount + this.mVariableReserveCount + 1 + this.mMaxFrameCount;
        StringBuilder line = new StringBuilder(128);
        int i = 0;
        while (i < ra_count) {
            builder.append("%");
            builder.append(i - (this.mMaxVariableCount + this.mVariableReserveCount));
            builder.append('=');
            builder.append(Utils.VariantToReadableString(ra[ra_start + i]));
            if (line.length() + builder.length() + 2 > info_len) {
                TJS.outputToConsole(line.toString());
                line.delete(0, line.length());
                line.append((CharSequence)builder);
            } else {
                if (line.length() > 0) {
                    line.append("  ");
                }
                line.append((CharSequence)builder);
            }
            builder.delete(0, builder.length());
            ++i;
        }
        if (line.length() > 0) {
            TJS.outputToConsole(line.toString());
        }
        TJS.outputToConsoleSeparator("-", info_len);
    }

    private void disassenbleSrcLine(int codepos) throws VariantException {
        int start = this.findSrcLineStartCodePos(codepos);
        this.disassemble(start, codepos + 1);
    }

    private void disassemble(int start, int end) throws VariantException {
        if (this.mDisassembler == null) {
            this.mDisassembler = new Disassembler(this.mCode, this.mDataArray, this);
        } else {
            this.mDisassembler.set(this.mCode, this.mDataArray, this);
        }
        this.mDisassembler.disassemble(this.mBlock, start, end);
    }

    public void disassemble(ScriptBlock data, int start, int end) throws VariantException {
        if (this.mDisassembler == null) {
            this.mDisassembler = new Disassembler(this.mCode, this.mDataArray, this);
        } else {
            this.mDisassembler.set(this.mCode, this.mDataArray, this);
        }
        this.mDisassembler.disassemble(data, start, end);
    }

    public int findSrcLineStartCodePos(int codepos) {
        if (this.mSourcePosArray == null) {
            return 0;
        }
        int srcpos = this.codePosToSrcPos(codepos);
        int line = this.mBlock.srcPosToLine(srcpos);
        srcpos = this.mBlock.lineToSrcPos(line);
        int codeposmin = -1;
        int count = this.mSourcePosArray.position();
        int i = 0;
        while (i < count) {
            long sourcePosArray = this.mSourcePosArray.get(i);
            int sourcePos = (int)(sourcePosArray & 0xFFFFFFFFL);
            if (sourcePos >= srcpos) {
                int codePos = (int)(sourcePosArray >> 32 & 0xFFFFFFFFL);
                if (codeposmin == -1 || codePos < codeposmin) {
                    codeposmin = codePos;
                }
            }
            ++i;
        }
        if (codeposmin < 0) {
            codeposmin = 0;
        }
        return codeposmin;
    }

    private static void throwInvalidVMCode() throws TJSException {
        throw new TJSException("\u4e0d\u6b63\u306a VM \u30b3\u30fc\u30c9\u3067\u3059");
    }

    private void addClassInstanceInfo(Variant[] ra, int ra_offset, int code) throws VariantException {
        short[] ca = this.mCode;
        Dispatch2 dsp = ra[ra_offset + ca[code + 1]].asObject();
        if (dsp != null) {
            dsp.addClassInstanveInfo(ra[ra_offset + ca[code + 2]].asString());
        }
    }

    private void throwScriptException(Variant val, ScriptBlock block, int srcpos) throws TJSException, VariantException {
        String msg = null;
        if (val.isObject()) {
            Variant v2;
            String message_name;
            int hr;
            VariantClosure clo = val.asObjectClosure();
            if (clo.mObject != null && (hr = clo.propGet(0, message_name = "message", v2 = new Variant(), null)) >= 0) {
                msg = "script exception : " + v2.asString();
            }
        }
        if (msg == null || msg.length() == 0) {
            msg = "script exception";
        }
        throw new TJSScriptException(msg, block, srcpos, val);
    }

    @Override
    public int codePosToSrcPos(int codepos) {
        if (this.mSourcePosArray == null) {
            return 0;
        }
        int s = 0;
        int e = this.mSourcePosArray.position();
        if (e == 0) {
            return 0;
        }
        while (e - s > 1) {
            int m = s + (e - s) / 2;
            if (this.mSourcePosArray.get(m) >>> 32 > (long)codepos) {
                e = m;
                continue;
            }
            s = m;
        }
        return (int)(this.mSourcePosArray.get(s) & 0xFFFFFFFFL);
    }

    private int executeCodeInTryBlock(Variant[] ra, int ra_offset, int startip, Variant[] args, Variant result, int catchip, int exobjreg) throws VariantException, TJSException {
        try {
            int ret = this.executeCode(ra, ra_offset, startip, args, result);
            return ret;
        }
        catch (TJSScriptException e) {
            if (exobjreg != 0) {
                ra[ra_offset + exobjreg].set(e.getValue());
            }
            return catchip;
        }
        catch (TJSScriptError e) {
            if (exobjreg != 0) {
                Variant msg = new Variant(e.getMessage());
                Variant trace = new Variant(e.getTrace());
                Variant ret = new Variant();
                Error.getExceptionObject(this.mBlock.getTJS(), ret, msg, trace);
                ra[ra_offset + exobjreg].set(ret);
            }
            return catchip;
        }
        catch (TJSException e) {
            if (exobjreg != 0) {
                Variant msg = new Variant(e.getMessage());
                Variant ret = new Variant();
                Error.getExceptionObject(this.mBlock.getTJS(), ret, msg, null);
                ra[ra_offset + exobjreg].set(ret);
            }
            return catchip;
        }
        catch (Exception e) {
            if (exobjreg != 0) {
                Variant msg = new Variant(e.getMessage());
                Variant ret = new Variant();
                Error.getExceptionObject(this.mBlock.getTJS(), ret, msg, null);
                ra[ra_offset + exobjreg].set(ret);
            }
            return catchip;
        }
    }

    private void deleteMemberIndirect(Variant[] ra, int ra_offset, int code) throws TJSException, VariantException {
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
        String str = ra[ra_offset + ca[code + 3]].asString();
        try {
            int hr = clo.deleteMember(0, str, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
            short offset = ca[code + 1];
            if (offset != 0) {
                if (hr < 0) {
                    ra[ra_offset + offset].set(0);
                } else {
                    ra[ra_offset + offset].set(1);
                }
            }
        }
        finally {
            str = null;
            clo = null;
        }
    }

    private void deleteMemberDirect(Variant[] ra, int ra_offset, int code) throws TJSException, VariantException {
        int hr;
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
        try {
            Variant name = this.mDataArray[ca[code + 3]];
            String nameStr = name.getString();
            hr = clo.deleteMember(0, nameStr, ra[ra_offset - 1].asObject());
        }
        finally {
            clo = null;
        }
        short offset = ca[code + 1];
        if (offset != 0) {
            if (hr < 0) {
                ra[ra_offset + offset].set(0);
            } else {
                ra[ra_offset + offset].set(1);
            }
        }
    }

    private void setProperty(Variant[] ra, int ra_offset, int code) throws TJSException, VariantException {
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 1]].asObjectClosure();
        int hr = clo.propSet(0, null, ra[ra_offset + ca[code + 2]], clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, null);
        }
    }

    private static void throwFrom_tjs_error_num(int hr, int num) throws TJSException {
        Error.throwFrom_tjs_error(hr, String.valueOf(num));
    }

    private static void throwFrom_tjs_error(int hr, String name) throws TJSException {
        Error.throwFrom_tjs_error(hr, name);
    }

    private void getProperty(Variant[] ra, int ra_offset, int code) throws TJSException, VariantException {
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
        int hr = clo.propGet(0, null, ra[ra_offset + ca[code + 1]], clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, null);
        }
    }

    private void setPropertyIndirect(Variant[] ra, int ra_offset, int code, int flags) throws TJSException, VariantException {
        short[] ca = this.mCode;
        Variant ra_code1 = ra[ra_offset + ca[code + 1]];
        Variant ra_code2 = ra[ra_offset + ca[code + 2]];
        Variant ra_code3 = ra[ra_offset + ca[code + 3]];
        if (ra_code1.isObject()) {
            VariantClosure clo = ra_code1.asObjectClosure();
            if (!ra_code2.isInteger()) {
                String str = ra_code2.asString();
                int hr = clo.propSet(flags, str, ra_code3, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                if (hr < 0) {
                    InterCodeObject.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propSetByNum(flags, ra_code2.asInteger(), ra_code3, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                if (hr < 0) {
                    InterCodeObject.throwFrom_tjs_error_num(hr, ra_code2.asInteger());
                }
            }
        } else if (ra_code1.isString()) {
            this.setStringProperty(ra_code3, ra_code1, ra_code2);
        } else if (ra_code1.isOctet()) {
            this.setOctetProperty(ra_code3, ra_code1, ra_code2);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra_code1));
            throw new VariantException(mes);
        }
    }

    private void getOctetProperty(Variant result, Variant octet, Variant member) throws TJSException, VariantException {
        String name;
        if (!member.isNumber()) {
            name = member.getString();
            if (name == null) {
                InterCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                ByteBuffer o = octet.asOctet();
                if (o != null) {
                    result.set(o.capacity());
                } else {
                    result.set(0);
                }
                return;
            }
            if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                int len;
                ByteBuffer o = octet.asOctet();
                int n = Integer.valueOf(name);
                int n2 = len = o != null ? o.capacity() : 0;
                if (n < 0 || n >= len) {
                    throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                result.set(o.get(n));
                return;
            }
        } else {
            int len;
            ByteBuffer o = octet.asOctet();
            int n = member.asInteger();
            int n3 = len = o != null ? o.capacity() : 0;
            if (n < 0 || n >= len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(o.get(n));
            return;
        }
        InterCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void setOctetProperty(Variant param, Variant octet, Variant member) throws TJSException, VariantException {
        if (!member.isNumber()) {
            String name = member.getString();
            if (name == null) {
                InterCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                InterCodeObject.throwFrom_tjs_error(-1007, "");
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                InterCodeObject.throwFrom_tjs_error(-1007, "");
            }
            InterCodeObject.throwFrom_tjs_error(-1001, name);
        } else {
            InterCodeObject.throwFrom_tjs_error(-1007, "");
        }
    }

    private void getStringProperty(Variant result, Variant str, Variant member) throws TJSException, VariantException {
        String name;
        if (!member.isNumber()) {
            name = member.getString();
            if (name == null) {
                InterCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                String s = str.asString();
                if (s == null) {
                    result.set(0);
                } else {
                    result.set(s.length());
                }
                return;
            }
            if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                int len;
                String s = str.asString();
                int n = Integer.valueOf(name);
                if (n == (len = s.length())) {
                    result.set(new String());
                    return;
                }
                if (n < 0 || n > len) {
                    throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                result.set(s.substring(n, n + 1));
                return;
            }
        } else {
            int len;
            String s = str.asString();
            int n = member.asInteger();
            if (n == (len = s.length())) {
                result.set(new String());
                return;
            }
            if (n < 0 || n > len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(s.substring(n, n + 1));
            return;
        }
        InterCodeObject.throwFrom_tjs_error(-1001, name);
    }

    private void setStringProperty(Variant param, Variant str, Variant member) throws TJSException, VariantException {
        if (!member.isNumber()) {
            String name = member.getString();
            if (name == null) {
                InterCodeObject.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                InterCodeObject.throwFrom_tjs_error(-1007, "");
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                InterCodeObject.throwFrom_tjs_error(-1007, "");
            }
            InterCodeObject.throwFrom_tjs_error(-1001, name);
        } else {
            InterCodeObject.throwFrom_tjs_error(-1007, "");
        }
    }

    private void getPropertyIndirect(Variant[] ra, int ra_offset, int code, int flags) throws TJSException, VariantException {
        short[] ca = this.mCode;
        Variant ra_code1 = ra[ra_offset + ca[code + 1]];
        Variant ra_code2 = ra[ra_offset + ca[code + 2]];
        Variant ra_code3 = ra[ra_offset + ca[code + 3]];
        if (ra_code2.isObject()) {
            VariantClosure clo = ra_code2.asObjectClosure();
            if (!ra_code3.isInteger()) {
                String str = ra_code3.asString();
                int hr = clo.propGet(flags, str, ra_code1, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                if (hr < 0) {
                    InterCodeObject.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propGetByNum(flags, ra_code3.asInteger(), ra_code1, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                if (hr < 0) {
                    InterCodeObject.throwFrom_tjs_error_num(hr, ra_code3.asInteger());
                }
            }
        } else if (ra_code2.isString()) {
            this.getStringProperty(ra_code1, ra_code2, ra_code3);
        } else if (ra_code2.isOctet()) {
            this.getOctetProperty(ra_code1, ra_code2, ra_code3);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra_code2));
            throw new VariantException(mes);
        }
    }

    private void setPropertyDirect(Variant[] ra, int ra_offset, int code, int flags) throws TJSException, VariantException {
        short[] ca = this.mCode;
        Variant ra_code1 = ra[ra_offset + ca[code + 1]];
        Variant da_code2 = this.mDataArray[ca[code + 2]];
        Variant ra_code3 = ra[ra_offset + ca[code + 3]];
        if (ra_code1.isObject()) {
            int hr;
            VariantClosure clo = ra_code1.asObjectClosure();
            String name = da_code2.getString();
            Dispatch2 objThis = clo.mObjThis;
            if (objThis == null) {
                objThis = ra[ra_offset - 1].asObject();
            }
            if ((hr = clo.propSet(flags, name, ra_code3, objThis)) < 0) {
                InterCodeObject.throwFrom_tjs_error(hr, name);
            }
        } else if (ra_code1.isString()) {
            this.setStringProperty(ra_code3, ra_code1, da_code2);
        } else if (ra_code1.isOctet()) {
            this.setOctetProperty(ra_code3, ra_code1, da_code2);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra_code1));
            throw new VariantException(mes);
        }
    }

    private void getPropertyDirect(Variant[] ra, int ra_offset, int code, int flags) throws TJSException, VariantException {
        short[] ca = this.mCode;
        Variant ra_code1 = ra[ra_offset + ca[code + 1]];
        Variant ra_code2 = ra[ra_offset + ca[code + 2]];
        Variant da_code3 = this.mDataArray[ca[code + 3]];
        if (ra_code2.isObject()) {
            String nameStr;
            VariantClosure clo = ra_code2.asObjectClosure();
            int hr = clo.propGet(flags, nameStr = da_code3.getString(), ra_code1, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
            if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error(hr, nameStr);
            }
        } else if (ra_code2.isString()) {
            this.getStringProperty(ra_code1, ra_code2, da_code3);
        } else if (ra_code2.isOctet()) {
            this.getOctetProperty(ra_code1, ra_code2, da_code3);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra_code2));
            throw new VariantException(mes);
        }
    }

    private void processOctetFunction(String member, String target, Variant[] args, Variant result) throws TJSException {
        InterCodeObject.throwFrom_tjs_error(-1001, member);
    }

    public static void processStringFunction(String member, String target, Variant[] args, Variant result) throws TJSException, VariantException {
        if (member == null) {
            InterCodeObject.throwFrom_tjs_error(-1001, "");
        }
        int hash = member.hashCode();
        String s = new String(target);
        int s_len = target.length();
        if (hash == mStrFuncs[0].hashCode() && mStrFuncs[0].equals(member)) {
            if (args.length != 1) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (s_len == 0) {
                if (result != null) {
                    result.set("");
                }
                return;
            }
            int i = args[0].asInteger();
            if (i < 0 || i >= s_len) {
                if (result != null) {
                    result.set("");
                }
                return;
            }
            if (result != null) {
                result.set(s.substring(i, i + 1));
            }
            return;
        }
        if (hash == mStrFuncs[1].hashCode() && mStrFuncs[1].equals(member)) {
            if (args.length != 1 && args.length != 2) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            String pstr = args[0].asString();
            if (s == null || pstr == null) {
                if (result != null) {
                    result.set(-1);
                }
                return;
            }
            int start = args.length == 1 ? 0 : args[1].asInteger();
            if (start >= s_len) {
                if (result != null) {
                    result.set(-1);
                }
                return;
            }
            int found = s.indexOf(pstr, start);
            if (result != null) {
                result.set(found);
            }
            return;
        }
        if (hash == mStrFuncs[2].hashCode() && mStrFuncs[2].equals(member)) {
            if (args.length != 0) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result != null) {
                result.set(s.toUpperCase());
            }
            return;
        }
        if (hash == mStrFuncs[3].hashCode() && mStrFuncs[3].equals(member)) {
            if (args.length != 0) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result != null) {
                result.set(s.toLowerCase());
            }
            return;
        }
        if (hash == mStrFuncs[4].hashCode() && mStrFuncs[4].equals(member) || hash == mStrFuncs[5].hashCode() && mStrFuncs[5].equals(member)) {
            int start;
            if (args.length != 1 && args.length != 2) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if ((start = args[0].asInteger()) < 0 || start >= s_len) {
                if (result != null) {
                    result.set("");
                }
                return;
            }
            if (args.length == 2) {
                int count = args[1].asInteger();
                if (count < 0) {
                    if (result != null) {
                        result.set("");
                    }
                    return;
                }
                if (start + count > s_len) {
                    count = s_len - start;
                }
                if (result != null) {
                    result.set(s.substring(start, start + count));
                }
                return;
            }
            if (result != null) {
                result.set(s.substring(start));
            }
            return;
        }
        if (hash == mStrFuncs[6].hashCode() && mStrFuncs[6].equals(member)) {
            if (result != null) {
                String res = Utils.formatString(s, args);
                result.set(res);
            }
            return;
        }
        if (hash == mStrFuncs[7].hashCode() && mStrFuncs[7].equals(member)) {
            if (args.length < 2) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            VariantClosure clo = args[0].asObjectClosure();
            Variant str = new Variant(target);
            Variant[] params = new Variant[]{str, args[1]};
            String replace_name = "replace";
            clo.funcCall(0, "replace", result, params, null);
            return;
        }
        if (hash == mStrFuncs[8].hashCode() && mStrFuncs[8].equals(member)) {
            if (result != null) {
                result.set(LexBase.escapeC(target));
            }
            return;
        }
        if (hash == mStrFuncs[9].hashCode() && mStrFuncs[9].equals(member)) {
            if (args.length < 1) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            Dispatch2 array = TJS.createArrayObject();
            try {
                Variant str = new Variant(target);
                Variant[] params = args.length >= 3 ? new Variant[]{args[0], str, args[1], args[2]} : (args.length >= 2 ? new Variant[]{args[0], str, args[1]} : new Variant[]{args[0], str});
                String split_name = "split";
                array.funcCall(0, "split", null, params, array);
                if (result != null) {
                    result.set(new Variant(array, array));
                }
            }
            finally {
                array = null;
            }
            return;
        }
        if (hash == mStrFuncs[10].hashCode() && mStrFuncs[10].equals(member)) {
            if (args.length != 0) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result == null) {
                return;
            }
            result.set(s.trim());
            return;
        }
        if (hash == mStrFuncs[11].hashCode() && mStrFuncs[11].equals(member)) {
            if (args.length != 0) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result == null) {
                return;
            }
            StringBuilder builder = new StringBuilder(s_len);
            int i = 0;
            while (i < s_len) {
                builder.append(s.charAt(s_len - i - 1));
                ++i;
            }
            result.set(builder.toString());
            return;
        }
        if (hash == mStrFuncs[12].hashCode() && mStrFuncs[12].equals(member)) {
            if (args.length != 1) {
                InterCodeObject.throwFrom_tjs_error(-1004, null);
            }
            if (result == null) {
                return;
            }
            int count = args[0].asInteger();
            if (count <= 0 || s_len <= 0) {
                result.set("");
                return;
            }
            int destLength = s_len * count;
            StringBuilder builder = new StringBuilder(destLength);
            while (count > 0) {
                builder.append(s);
                --count;
            }
            result.set(builder.toString());
            return;
        }
        InterCodeObject.throwFrom_tjs_error(-1001, member);
    }

    private int callFunctionIndirect(Variant[] ra, int ra_offset, int code, Variant[] args) throws VariantException, TJSException {
        int hr;
        int code_size;
        String name;
        block26: {
            Variant[] pass_args;
            short[] ca = this.mCode;
            name = ra[ra_offset + ca[code + 3]].asString();
            try {
                int code_offset = code + 4;
                int pass_args_count = ca[code_offset];
                if (pass_args_count == -1) {
                    pass_args = args;
                    pass_args_count = args.length;
                    code_size = 1;
                } else if (pass_args_count == -2) {
                    int args_v_count = 0;
                    pass_args_count = 0;
                    int arg_written_count = ca[code_offset + 1];
                    code_size = (arg_written_count << 1) + 2;
                    int i = 0;
                    while (i < arg_written_count) {
                        int pos = code_offset + (i << 1) + 2;
                        switch (ca[pos]) {
                            case 0: {
                                ++pass_args_count;
                                break;
                            }
                            case 1: {
                                args_v_count += ArrayClass.getArrayElementCount(ra[ra_offset + ca[pos + 1]].asObject());
                                break;
                            }
                            case 2: {
                                pass_args_count += args.length > this.mFuncDeclUnnamedArgArrayBase ? args.length - this.mFuncDeclUnnamedArgArrayBase : 0;
                            }
                        }
                        ++i;
                    }
                    Variant[] pass_args_v = new Variant[args_v_count];
                    pass_args = new Variant[pass_args_count += args_v_count];
                    args_v_count = 0;
                    pass_args_count = 0;
                    int i2 = 0;
                    while (i2 < arg_written_count) {
                        int pos = code_offset + (i2 << 1) + 2;
                        switch (ca[pos]) {
                            case 0: {
                                pass_args[pass_args_count++] = ra[ra_offset + ca[pos + 1]];
                                break;
                            }
                            case 1: {
                                int count = ArrayClass.copyArrayElementTo(ra[ra_offset + ca[pos + 1]].asObject(), pass_args_v, args_v_count, 0, -1);
                                int j = 0;
                                while (j < count) {
                                    pass_args[pass_args_count++] = pass_args_v[j + args_v_count];
                                    ++j;
                                }
                                args_v_count += count;
                                break;
                            }
                            case 2: {
                                int count = args.length > this.mFuncDeclUnnamedArgArrayBase ? args.length - this.mFuncDeclUnnamedArgArrayBase : 0;
                                int j = 0;
                                while (j < count) {
                                    pass_args[pass_args_count++] = args[this.mFuncDeclUnnamedArgArrayBase + j];
                                    ++j;
                                }
                                break;
                            }
                        }
                        ++i2;
                    }
                    pass_args_v = null;
                } else {
                    code_size = pass_args_count + 1;
                    pass_args = new Variant[pass_args_count];
                    int i = 0;
                    while (i < pass_args_count) {
                        pass_args[i] = ra[ra_offset + ca[code_offset + 1 + i]];
                        ++i;
                    }
                }
                Variant ra_code2 = ra[ra_offset + ca[code + 2]];
                short offset = ca[code + 1];
                if (ra_code2.isObject()) {
                    VariantClosure clo = ra_code2.asObjectClosure();
                    hr = clo.funcCall(0, name, offset != 0 ? ra[ra_offset + offset] : null, pass_args, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                    break block26;
                }
                if (ra_code2.isString()) {
                    InterCodeObject.processStringFunction(name, ra_code2.asString(), pass_args, offset != 0 ? ra[ra_offset + offset] : null);
                    hr = 0;
                    break block26;
                }
                if (ra_code2.isOctet()) {
                    this.processOctetFunction(name, ra_code2.asString(), pass_args, offset != 0 ? ra[ra_offset + offset] : null);
                    hr = 0;
                    break block26;
                }
                String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra_code2));
                throw new VariantException(mes);
            }
            finally {
                pass_args = null;
            }
        }
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, name);
        }
        return code_size + 4;
    }

    private int callFunctionDirect(Variant[] ra, int ra_offset, int code, Variant[] args) throws TJSException, VariantException {
        int hr;
        int code_size;
        short[] ca;
        block26: {
            Variant[] pass_args;
            ca = this.mCode;
            try {
                int code_offset = code + 4;
                int pass_args_count = ca[code_offset];
                if (pass_args_count == -1) {
                    pass_args = args;
                    pass_args_count = args.length;
                    code_size = 1;
                } else if (pass_args_count == -2) {
                    int args_v_count = 0;
                    pass_args_count = 0;
                    int arg_written_count = ca[code_offset + 1];
                    code_size = (arg_written_count << 1) + 2;
                    int i = 0;
                    while (i < arg_written_count) {
                        int pos = code_offset + (i << 1) + 2;
                        switch (ca[pos]) {
                            case 0: {
                                ++pass_args_count;
                                break;
                            }
                            case 1: {
                                args_v_count += ArrayClass.getArrayElementCount(ra[ra_offset + ca[pos + 1]].asObject());
                                break;
                            }
                            case 2: {
                                pass_args_count += args.length > this.mFuncDeclUnnamedArgArrayBase ? args.length - this.mFuncDeclUnnamedArgArrayBase : 0;
                            }
                        }
                        ++i;
                    }
                    Variant[] pass_args_v = new Variant[args_v_count];
                    pass_args = new Variant[pass_args_count += args_v_count];
                    args_v_count = 0;
                    pass_args_count = 0;
                    int i2 = 0;
                    while (i2 < arg_written_count) {
                        int pos = code_offset + (i2 << 1) + 2;
                        switch (ca[pos]) {
                            case 0: {
                                pass_args[pass_args_count++] = ra[ra_offset + ca[pos + 1]];
                                break;
                            }
                            case 1: {
                                int count = ArrayClass.copyArrayElementTo(ra[ra_offset + ca[pos + 1]].asObject(), pass_args_v, args_v_count, 0, -1);
                                int j = 0;
                                while (j < count) {
                                    pass_args[pass_args_count++] = pass_args_v[j + args_v_count];
                                    ++j;
                                }
                                args_v_count += count;
                                break;
                            }
                            case 2: {
                                int count = args.length > this.mFuncDeclUnnamedArgArrayBase ? args.length - this.mFuncDeclUnnamedArgArrayBase : 0;
                                int j = 0;
                                while (j < count) {
                                    pass_args[pass_args_count++] = args[this.mFuncDeclUnnamedArgArrayBase + j];
                                    ++j;
                                }
                                break;
                            }
                        }
                        ++i2;
                    }
                    pass_args_v = null;
                } else {
                    code_size = pass_args_count + 1;
                    pass_args = new Variant[pass_args_count];
                    int i = 0;
                    while (i < pass_args_count) {
                        pass_args[i] = ra[ra_offset + ca[code_offset + 1 + i]];
                        ++i;
                    }
                }
                Variant ra_code2 = ra[ra_offset + ca[code + 2]];
                Variant name = this.mDataArray[ca[code + 3]];
                short offset = ca[code + 1];
                if (ra_code2.isObject()) {
                    VariantClosure clo = ra_code2.asObjectClosure();
                    String nameStr = name.getString();
                    hr = clo.funcCall(0, nameStr, offset != 0 ? ra[ra_offset + offset] : null, pass_args, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                    break block26;
                }
                if (ra_code2.isString()) {
                    InterCodeObject.processStringFunction(name.getString(), ra_code2.asString(), pass_args, offset != 0 ? ra[ra_offset + offset] : null);
                    hr = 0;
                    break block26;
                }
                if (ra_code2.isOctet()) {
                    this.processOctetFunction(name.getString(), ra_code2.asString(), pass_args, offset != 0 ? ra[ra_offset + offset] : null);
                    hr = 0;
                    break block26;
                }
                String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra_code2));
                throw new VariantException(mes);
            }
            finally {
                pass_args = null;
            }
        }
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, this.mDataArray[ca[code + 3]].asString());
        }
        return code_size + 4;
    }

    private int callFunction(Variant[] ra, int ra_offset, int code, Variant[] args) throws TJSException, VariantException {
        int hr;
        int code_size;
        Variant[] pass_args;
        short[] ca = this.mCode;
        try {
            try {
                int code_offset = code + 3;
                int pass_args_count = ca[code_offset];
                if (pass_args_count == -1) {
                    pass_args = args;
                    pass_args_count = args.length;
                    code_size = 1;
                } else if (pass_args_count == -2) {
                    int args_v_count = 0;
                    pass_args_count = 0;
                    int arg_written_count = ca[code_offset + 1];
                    code_size = (arg_written_count << 1) + 2;
                    int i = 0;
                    while (i < arg_written_count) {
                        int pos = code_offset + (i << 1) + 2;
                        switch (ca[pos]) {
                            case 0: {
                                ++pass_args_count;
                                break;
                            }
                            case 1: {
                                args_v_count += ArrayClass.getArrayElementCount(ra[ra_offset + ca[pos + 1]].asObject());
                                break;
                            }
                            case 2: {
                                pass_args_count += args.length > this.mFuncDeclUnnamedArgArrayBase ? args.length - this.mFuncDeclUnnamedArgArrayBase : 0;
                            }
                        }
                        ++i;
                    }
                    Variant[] pass_args_v = new Variant[args_v_count];
                    pass_args = new Variant[pass_args_count += args_v_count];
                    args_v_count = 0;
                    pass_args_count = 0;
                    int i2 = 0;
                    while (i2 < arg_written_count) {
                        int pos = code_offset + (i2 << 1) + 2;
                        switch (ca[pos]) {
                            case 0: {
                                pass_args[pass_args_count++] = ra[ra_offset + ca[pos + 1]];
                                break;
                            }
                            case 1: {
                                int count = ArrayClass.copyArrayElementTo(ra[ra_offset + ca[pos + 1]].asObject(), pass_args_v, args_v_count, 0, -1);
                                int j = 0;
                                while (j < count) {
                                    pass_args[pass_args_count++] = pass_args_v[j + args_v_count];
                                    ++j;
                                }
                                args_v_count += count;
                                break;
                            }
                            case 2: {
                                int count = args.length > this.mFuncDeclUnnamedArgArrayBase ? args.length - this.mFuncDeclUnnamedArgArrayBase : 0;
                                int j = 0;
                                while (j < count) {
                                    pass_args[pass_args_count++] = args[this.mFuncDeclUnnamedArgArrayBase + j];
                                    ++j;
                                }
                                break;
                            }
                        }
                        ++i2;
                    }
                    pass_args_v = null;
                } else {
                    code_size = pass_args_count + 1;
                    pass_args = new Variant[pass_args_count];
                    int i = 0;
                    while (i < pass_args_count) {
                        pass_args[i] = ra[ra_offset + ca[code_offset + 1 + i]];
                        ++i;
                    }
                }
                VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
                short offset = ca[code + 1];
                short op = ca[code];
                if (op == 99) {
                    hr = clo.funcCall(0, null, offset != 0 ? ra[ra_offset + offset] : null, pass_args, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                } else {
                    Holder<Object> dsp = new Holder<Object>(null);
                    hr = clo.createNew(0, null, dsp, pass_args, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                    if (hr >= 0 && dsp.mValue != null && offset != 0) {
                        ra[ra_offset + offset].set((Dispatch2)dsp.mValue, (Dispatch2)dsp.mValue);
                    }
                }
            }
            catch (TJSScriptException e) {
                e.printStackTrace();
                throw e;
            }
            catch (TJSScriptError e) {
                e.printStackTrace();
                throw e;
            }
            catch (TJSException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TJSException(e.getMessage());
            }
        }
        finally {
            pass_args = null;
        }
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, "");
        }
        return code_size + 3;
    }

    private void instanceOf(Variant name, Variant targ) throws VariantException, TJSException {
        String str = name.asString();
        if (str != null) {
            int hr = CustomObject.defaultIsInstanceOf(0, targ, str, null);
            if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error(hr, null);
            }
            targ.set(hr == 1 ? 1 : 0);
            return;
        }
        targ.set(0);
    }

    private void eval(Variant val, Dispatch2 objthis, boolean resneed) throws VariantException, TJSException, CompileException {
        Variant res = new Variant();
        String str = val.asString();
        if (str.length() > 0) {
            if (resneed) {
                this.mBlock.getTJS().evalExpression(str, res, objthis, null, 0);
            } else {
                this.mBlock.getTJS().evalExpression(str, null, objthis, null, 0);
            }
        }
        if (resneed) {
            val.set(res);
        }
    }

    private void typeOfMemberIndirect(Variant[] ra, int ra_offset, int code, int flags) throws TJSException, VariantException {
        short[] ca = this.mCode;
        Variant ra1 = ra[ra_offset + ca[code + 1]];
        Variant ra2 = ra[ra_offset + ca[code + 2]];
        Variant ra3 = ra[ra_offset + ca[code + 3]];
        if (ra2.isObject()) {
            VariantClosure clo = ra2.asObjectClosure();
            if (!ra3.isInteger()) {
                String str = ra3.asString();
                int hr = clo.propGet(flags, str, ra1, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                if (hr == 0) {
                    this.typeOf(ra1);
                } else if (hr == -1001) {
                    ra1.set("undefined");
                } else if (hr < 0) {
                    InterCodeObject.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propGetByNum(flags, ra3.asInteger(), ra1, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
                if (hr == 0) {
                    this.typeOf(ra1);
                } else if (hr == -1001) {
                    ra1.set("undefined");
                } else if (hr < 0) {
                    InterCodeObject.throwFrom_tjs_error_num(hr, ra3.asInteger());
                }
            }
        } else if (ra2.isString()) {
            this.getStringProperty(ra1, ra2, ra3);
            this.typeOf(ra1);
        } else if (ra2.isOctet()) {
            this.getOctetProperty(ra1, ra2, ra3);
            this.typeOf(ra1);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra2));
            throw new VariantException(mes);
        }
    }

    private void typeOfMemberDirect(Variant[] ra, int ra_offset, int code, int flags) throws TJSException, VariantException {
        short[] ca = this.mCode;
        Variant ra1 = ra[ra_offset + ca[code + 1]];
        Variant ra2 = ra[ra_offset + ca[code + 2]];
        Variant da3 = this.mDataArray[ca[code + 3]];
        if (ra2.isObject()) {
            String name;
            VariantClosure clo = ra2.asObjectClosure();
            int hr = clo.propGet(flags, name = da3.getString(), ra1, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
            if (hr == 0) {
                this.typeOf(ra1);
            } else if (hr == -1001) {
                ra1.set("undefined");
            } else if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error(hr, name);
            }
        } else if (ra2.isString()) {
            this.getStringProperty(ra1, ra2, da3);
            this.typeOf(ra1);
        } else if (ra2.isOctet()) {
            this.getOctetProperty(ra1, ra2, da3);
            this.typeOf(ra1);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(ra2));
            throw new VariantException(mes);
        }
    }

    private void typeOf(Variant val) {
        String name = val.getTypeName();
        if (name != null) {
            val.set(name);
        }
    }

    private void operateProperty0(Variant[] ra, int ra_offset, int code, int ope) throws TJSException, VariantException {
        short offset;
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
        int hr = clo.operation(ope, null, (offset = ca[code + 1]) != 0 ? ra[ra_offset + offset] : null, null, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, null);
        }
    }

    private void operatePropertyIndirect0(Variant[] ra, int ra_offset, int code, int ope) throws TJSException, VariantException {
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
        Variant ra_code3 = ra[ra_offset + ca[code + 3]];
        short offset = ca[code + 1];
        if (!ra_code3.isInteger()) {
            String str = ra_code3.asString();
            int hr = clo.operation(ope, str, offset != 0 ? ra[ra_offset + offset] : null, null, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
            if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error(hr, str);
            }
        } else {
            int hr = clo.operationByNum(ope, ra_code3.asInteger(), offset != 0 ? ra[ra_offset + offset] : null, null, clo.mObjThis != null ? clo.mObjThis : ra[ra_offset - 1].asObject());
            if (hr < 0) {
                InterCodeObject.throwFrom_tjs_error_num(hr, ra_code3.asInteger());
            }
        }
    }

    private void operatePropertyDirect0(Variant[] ra, int ra_offset, int code, int ope) throws TJSException, VariantException {
        short offset;
        Variant name;
        String nameStr;
        short[] ca = this.mCode;
        VariantClosure clo = ra[ra_offset + ca[code + 2]].asObjectClosure();
        int hr = clo.operation(ope, nameStr = (name = this.mDataArray[ca[code + 3]]).getString(), (offset = ca[code + 1]) != 0 ? ra[ra_offset + offset] : null, null, ra[ra_offset - 1].asObject());
        if (hr < 0) {
            InterCodeObject.throwFrom_tjs_error(hr, nameStr);
        }
    }

    private void continuousClear(Variant[] ra, int ra_offset, int code) {
        short[] ca = this.mCode;
        int start = ra_offset + ca[code + 1];
        int end = start + ca[code + 2];
        while (start < end) {
            ra[start].clear();
            ++start;
        }
    }

    public String getPositionDescriptionString(int codepos) {
        return String.valueOf(this.mBlock.getLineDescriptionString(this.codePosToSrcPos(codepos))) + "[" + this.getShortDescription() + "]";
    }

    private String getShortDescription() {
        String ret = "(" + this.getContextTypeName() + ")";
        String name = this.mContextType == 4 || this.mContextType == 5 ? (this.mParent != null ? this.mParent.mName : null) : this.mName;
        if (name != null) {
            ret = String.valueOf(ret) + " " + name;
        }
        return ret;
    }

    public String getContextTypeName() {
        switch (this.mContextType) {
            case 0: {
                return "top level script";
            }
            case 1: {
                return "function";
            }
            case 2: {
                return "function expression";
            }
            case 3: {
                return "property";
            }
            case 4: {
                return "property setter";
            }
            case 5: {
                return "property getter";
            }
            case 6: {
                return "class";
            }
            case 7: {
                return "super class getter proxy";
            }
        }
        return "unknown";
    }

    @Override
    public int funcCall(int flag, String membername, Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            switch (this.mContextType) {
                case 0: {
                    this.executeAsFunction(objthis != null ? objthis : this.mBlock.getTJS().getGlobal(), null, result, 0);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    this.executeAsFunction(objthis, param, result, 0);
                    break;
                }
                case 6: {
                    this.executeAsFunction(objthis, param, result, 0);
                    break;
                }
                case 3: {
                    return -1005;
                }
            }
            return 0;
        }
        int hr = super.funcCall(flag, membername, result, param, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) > 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                int v = pointer[i];
                this.mSuperClassGetter.executeAsFunction(null, null, res, v);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.funcCall(flag, membername, result, param, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int propGet(int flag, String membername, Variant result, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null && this.mContextType == 3) {
            if (this.mPropGetter != null) {
                return this.mPropGetter.funcCall(0, null, result, null, objthis);
            }
            return -1007;
        }
        int hr = super.propGet(flag, membername, result, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.propGet(flag, membername, result, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int propSet(int flag, String membername, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        int hr;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null && this.mContextType == 3) {
            if (this.mPropSetter != null) {
                Variant[] params = new Variant[]{param};
                return this.mPropSetter.funcCall(0, null, null, params, objthis);
            }
            return -1007;
        }
        if (membername != null && this.mContextType == 6 && this.mSuperClassGetter != null) {
            int[] pointer;
            int count;
            int pseudo_flag = (flag & 0x800) != 0 ? flag : flag & 0xFFFFFDFF;
            hr = super.propSet(pseudo_flag, membername, param, objthis);
            if (hr == -1001 && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
                Variant res = new Variant();
                int i = count - 1;
                while (i >= 0) {
                    this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                    VariantClosure clo = res.asObjectClosure();
                    hr = clo.propSet(pseudo_flag, membername, param, objthis);
                    if (hr != -1001) break;
                    --i;
                }
            }
            if (hr == -1001 && (flag & 0x200) != 0) {
                hr = super.propSet(flag, membername, param, objthis);
            }
        } else {
            hr = super.propSet(flag, membername, param, objthis);
        }
        return hr;
    }

    @Override
    public int createNew(int flag, String membername, Holder<Dispatch2> result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            if (this.mContextType != 6) {
                return -1005;
            }
            CustomObject dsp = new CustomObject();
            this.executeAsFunction(dsp, null, null, 0);
            this.funcCall(0, this.mName, null, param, dsp);
            result.set(dsp);
            return 0;
        }
        int hr = super.createNew(flag, membername, result, param, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.createNew(flag, membername, result, param, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int isInstanceOf(int flag, String membername, String classname, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        if (!this.getValidity()) {
            return -1006;
        }
        if (membername == null) {
            switch (this.mContextType) {
                case 0: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 1: 
                case 2: {
                    if (!"Function".equals(classname)) break;
                    return 1;
                }
                case 3: {
                    if (!"Property".equals(classname)) break;
                    return 1;
                }
                case 6: {
                    if (!"Class".equals(classname)) break;
                    return 1;
                }
            }
        }
        int hr = super.isInstanceOf(flag, membername, classname, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.isInstanceOf(flag, membername, classname, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int getCount(IntWrapper result, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.getCount(result, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.getCount(result, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int deleteMember(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.deleteMember(flag, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.deleteMember(flag, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int invalidate(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.invalidate(flag, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.invalidate(flag, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int isValid(int flag, String membername, Dispatch2 objthis) throws VariantException, TJSException {
        int[] pointer;
        int count;
        int hr = super.isValid(flag, membername, objthis);
        if (membername != null && hr == -1001 && this.mContextType == 6 && this.mSuperClassGetter != null && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
            Variant res = new Variant();
            int i = count - 1;
            while (i >= 0) {
                this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                VariantClosure clo = res.asObjectClosure();
                hr = clo.isValid(flag, membername, objthis);
                if (hr != -1001) break;
                --i;
            }
        }
        return hr;
    }

    @Override
    public int operation(int flag, String membername, Variant result, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        if (membername == null) {
            if (this.mContextType == 3) {
                return super.dispatchOperation(flag, membername, result, param, objthis);
            }
            return super.operation(flag, membername, result, param, objthis);
        }
        if (membername != null && this.mContextType == 6 && this.mSuperClassGetter != null) {
            int[] pointer;
            int count;
            int pseudo_flag = (flag & 0x800) != 0 ? flag : flag & 0xFFFFFDFF;
            int hr = super.operation(pseudo_flag, membername, result, param, objthis);
            if (hr == -1001 && (count = (pointer = this.mSuperClassGetter.mSuperClassGetterPointer).length) != 0) {
                Variant res = new Variant();
                int i = count - 1;
                while (i >= 0) {
                    this.mSuperClassGetter.executeAsFunction(null, null, res, pointer[i]);
                    VariantClosure clo = res.asObjectClosure();
                    hr = clo.operation(pseudo_flag, membername, result, param, objthis);
                    if (hr != -1001) break;
                    --i;
                }
            }
            if (hr == -1001) {
                hr = super.operation(flag, membername, result, param, objthis);
            }
            return hr;
        }
        return super.operation(flag, membername, result, param, objthis);
    }

    public static void characterCodeFrom(Variant val) throws VariantException {
        char[] ch = new char[]{(char)val.asInteger()};
        val.set(new String(ch));
    }

    public static void characterCodeOf(Variant val) throws VariantException {
        String str = val.asString();
        if (str != null) {
            int v = str.codePointAt(0);
            val.set(v);
        } else {
            val.set(0);
        }
    }

    public int getCodeSize() {
        return this.mCode.length;
    }

    public int getDataSize() {
        return this.mDataArray.length;
    }

    @Override
    public int srcPosToLine(int srcpos) {
        return this.mBlock.srcPosToLine(srcpos);
    }

    @Override
    public String getLine(int line) {
        return this.mBlock.getLine(line);
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    public void dateReplace(Compiler compiler) {
        int count = this.mDataArray.length;
        Variant[] da = this.mDataArray;
        int i = 0;
        while (i < count) {
            Variant d = da[i];
            Object o = d.toJavaObject();
            if (o instanceof InterCodeGenerator) {
                int idx = compiler.getCodeIndex((InterCodeGenerator)o);
                if (idx < 0) {
                    TJS.outputToConsole("not found");
                }
                d.set(compiler.getCodeObject(idx));
            }
            ++i;
        }
    }

    @Override
    public String getScript() {
        return this.mBlock.getScript();
    }

    @Override
    public int getLineOffset() {
        return this.mBlock.getLineOffset();
    }
}

