/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.StringStream;

public class LexBase {
    protected StringStream mStream;
    private static final int TJS_IEEE_D_SIGNIFICAND_BITS = 52;
    private static final int TJS_IEEE_D_EXP_MIN = -1022;
    private static final int TJS_IEEE_D_EXP_MAX = 1023;
    private static final long TJS_IEEE_D_EXP_BIAS = 1023L;

    public LexBase(String str) {
        this.mStream = new StringStream(str);
    }

    public LexBase() {
    }

    private boolean parseExtractNumber(int basebits) {
        boolean point_found = false;
        boolean exp_found = false;
        int offset = this.mStream.getOffset();
        int c = this.mStream.next();
        while (c != -1) {
            if (c == 46 && !point_found && !exp_found) {
                point_found = true;
                c = this.mStream.next();
                continue;
            }
            if (!(c != 112 && c != 80 || exp_found)) {
                exp_found = true;
                this.mStream.skipSpace();
                c = this.mStream.next();
                if (c != 43 && c != 45) continue;
                this.mStream.skipSpace();
                c = this.mStream.next();
                continue;
            }
            if (!((c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) && !(basebits == 3 ? c < 48 || c > 55 : basebits == 1 && c != 48 && c != 49))) break;
            c = this.mStream.next();
        }
        this.mStream.setOffset(offset);
        return point_found || exp_found;
    }

    private Double parseNonDecimalReal(boolean sign, int basebits) {
        long main = 0L;
        int exp = 0;
        int numsignif = 0;
        boolean pointpassed = false;
        int c = this.mStream.getC();
        while (c != -1) {
            if (c == 46) {
                pointpassed = true;
            } else {
                if (c == 112 || c == 80) {
                    this.mStream.skipSpace();
                    c = this.mStream.next();
                    boolean biassign = false;
                    if (c == 43) {
                        biassign = false;
                        this.mStream.skipSpace();
                        c = this.mStream.next();
                    }
                    if (c == 45) {
                        biassign = true;
                        this.mStream.skipSpace();
                        c = this.mStream.next();
                    }
                    int bias = 0;
                    while (c >= 48 && c <= 57) {
                        bias *= 10;
                        bias += c - 48;
                        c = this.mStream.next();
                    }
                    if (biassign) {
                        bias = -bias;
                    }
                    exp += bias;
                    break;
                }
                int n = -1;
                if (basebits == 4) {
                    if (c >= 48 && c <= 57) {
                        n = c - 48;
                    } else if (c >= 97 && c <= 102) {
                        n = c - 97 + 10;
                    } else {
                        if (c < 65 || c > 70) break;
                        n = c - 65 + 10;
                    }
                } else if (basebits == 3) {
                    if (c < 48 || c > 55) break;
                    n = c - 48;
                } else if (basebits == 1) {
                    if (c != 48 && c != 49) break;
                    n = c - 48;
                }
                if (numsignif == 0) {
                    int b = basebits - 1;
                    while (b >= 0) {
                        if ((1 << b & n) != 0) break;
                        --b;
                    }
                    if (++b != 0) {
                        numsignif = b;
                        main |= (long)n << 64 - numsignif;
                        exp = pointpassed ? (exp -= basebits - b + 1) : b - 1;
                    } else if (pointpassed) {
                        exp -= basebits;
                    }
                } else {
                    if (numsignif + basebits < 64) {
                        main |= (long)n << 64 - (numsignif += basebits);
                    }
                    if (!pointpassed) {
                        exp += basebits;
                    }
                }
            }
            c = this.mStream.next();
        }
        if (c != -1) {
            this.mStream.ungetC();
        }
        if ((main >>>= 11) == 0L) {
            return 0.0;
        }
        main &= 0xFFFFFFFFFFFFFL;
        if (exp < -1022) {
            return 0.0;
        }
        if (exp > 1023) {
            if (sign) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        double d = Double.longBitsToDouble((long)exp + 1023L << 52 | main);
        if (sign) {
            d = -d;
        }
        return d;
    }

    private Integer parseNonDecimalInteger16(boolean sign) {
        long v = 0L;
        int c = this.mStream.next();
        while (c != -1) {
            int n = -1;
            if (c >= 48 && c <= 57) {
                n = c - 48;
            } else if (c >= 97 && c <= 102) {
                n = c - 97 + 10;
            } else if (c >= 65 && c <= 70) {
                n = c - 65 + 10;
            } else {
                this.mStream.ungetC();
                break;
            }
            v <<= 4;
            v += (long)n;
            c = this.mStream.next();
        }
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Integer parseNonDecimalInteger8(boolean sign) {
        long v = 0L;
        int c = this.mStream.next();
        while (c != -1) {
            int n = -1;
            if (c < 48 || c > 55) {
                this.mStream.ungetC();
                break;
            }
            n = c - 48;
            v <<= 3;
            v += (long)n;
            c = this.mStream.next();
        }
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Integer parseNonDecimalInteger2(boolean sign) {
        long v = 0L;
        int c = this.mStream.next();
        while (c != -1) {
            if (c == 49) {
                v <<= 1;
                ++v;
            } else if (c == 48) {
                v <<= 1;
            } else {
                this.mStream.ungetC();
                break;
            }
            c = this.mStream.next();
        }
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Number parseNonDecimalNumber(boolean sign, int base) {
        boolean is_real = this.parseExtractNumber(base);
        if (is_real) {
            return this.parseNonDecimalReal(sign, base);
        }
        switch (base) {
            case 4: {
                return this.parseNonDecimalInteger16(sign);
            }
            case 3: {
                return this.parseNonDecimalInteger8(sign);
            }
            case 1: {
                return this.parseNonDecimalInteger2(sign);
            }
        }
        return null;
    }

    protected boolean isWAlpha(int c) {
        if ((c & 0xFF00) != 0) {
            return true;
        }
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    protected boolean isWDigit(int c) {
        if ((c & 0xFF00) != 0) {
            return false;
        }
        return c >= 48 && c <= 57;
    }

    public Number parseNumber() {
        int num = 0;
        boolean sign = false;
        boolean skipNum = false;
        int c = this.mStream.getC();
        if (c == 43) {
            sign = false;
            c = this.mStream.getC();
        } else if (c == 45) {
            sign = true;
            c = this.mStream.getC();
        }
        if (c == 116) {
            if (this.mStream.equalString("rue")) {
                return 1;
            }
        } else if (c == 102) {
            if (this.mStream.equalString("alse")) {
                return 0;
            }
        } else if (c == 78) {
            if (this.mStream.equalString("aN")) {
                return Double.NaN;
            }
        } else if (c == 73 && this.mStream.equalString("nfinity")) {
            if (sign) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (c == 48) {
            c = this.mStream.getC();
            if (c == 120 || c == 88) {
                return this.parseNonDecimalNumber(sign, 4);
            }
            if (c == 98 || c == 66) {
                return this.parseNonDecimalNumber(sign, 1);
            }
            if (c == 46) {
                skipNum = true;
            } else if (c == 101 || c == 69) {
                skipNum = true;
            } else {
                if (c == 112 || c == 80) {
                    return null;
                }
                if (c >= 48 && c <= 55) {
                    this.mStream.ungetC();
                    return this.parseNonDecimalNumber(sign, 3);
                }
            }
        }
        if (!skipNum) {
            while (c != -1) {
                if (c < 48 || c > 57) break;
                num = num * 10 + (c - 48);
                c = this.mStream.getC();
            }
        }
        if (c == 46 || c == 101 || c == 69) {
            double figure = 1.0;
            int decimal = 0;
            if (c == 46) {
                while (c != -1) {
                    c = this.mStream.getC();
                    if (c < 48 || c > 57) break;
                    decimal = decimal * 10 + (c - 48);
                    figure *= 10.0;
                }
            }
            boolean expSign = false;
            int expValue = 0;
            if (c == 101 || c == 69) {
                c = this.mStream.getC();
                if (c == 45) {
                    expSign = true;
                    c = this.mStream.getC();
                }
                while (c != -1) {
                    if (c < 48 || c > 57) break;
                    expValue = expValue * 10 + (c - 48);
                    c = this.mStream.getC();
                }
                this.mStream.ungetC();
            } else {
                this.mStream.ungetC();
            }
            double number = (double)num + (double)decimal / figure;
            if (expValue != 0) {
                number = !expSign ? (number *= Math.pow(10.0, expValue)) : (number /= Math.pow(10.0, expValue));
            }
            if (sign) {
                number = -number;
            }
            return number;
        }
        this.mStream.ungetC();
        if (sign) {
            num = -num;
        }
        return num;
    }

    public static String escapeC(char c) {
        StringBuilder ret = new StringBuilder(16);
        switch (c) {
            case '\u0007': {
                ret.append("\\a");
                break;
            }
            case '\b': {
                ret.append("\\b");
                break;
            }
            case '\f': {
                ret.append("\\f");
                break;
            }
            case '\n': {
                ret.append("\\n");
                break;
            }
            case '\r': {
                ret.append("\\r");
                break;
            }
            case '\t': {
                ret.append("\\t");
                break;
            }
            case '\u000b': {
                ret.append("\\v");
                break;
            }
            case '\\': {
                ret.append("\\\\");
                break;
            }
            case '\'': {
                ret.append("\\'");
                break;
            }
            case '\"': {
                ret.append("\\\"");
                break;
            }
            default: {
                if (c < ' ') {
                    ret.append("\\x");
                    ret.append(Integer.toHexString(c));
                    break;
                }
                ret.append(c);
            }
        }
        return ret.toString();
    }

    public static String escapeC(String str) {
        int count = str.length();
        StringBuilder ret = new StringBuilder(count * 2);
        int i = 0;
        while (i < count) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0007': {
                    ret.append("\\a");
                    break;
                }
                case '\b': {
                    ret.append("\\b");
                    break;
                }
                case '\f': {
                    ret.append("\\f");
                    break;
                }
                case '\n': {
                    ret.append("\\n");
                    break;
                }
                case '\r': {
                    ret.append("\\r");
                    break;
                }
                case '\t': {
                    ret.append("\\t");
                    break;
                }
                case '\u000b': {
                    ret.append("\\v");
                    break;
                }
                case '\\': {
                    ret.append("\\\\");
                    break;
                }
                case '\'': {
                    ret.append("\\'");
                    break;
                }
                case '\"': {
                    ret.append("\\\"");
                    break;
                }
                default: {
                    if (c < ' ') {
                        ret.append("\\x");
                        ret.append(Integer.toHexString(c));
                        break;
                    }
                    ret.append(c);
                }
            }
            ++i;
        }
        return ret.toString();
    }
}

