/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.CompileState;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.EmbeddableExpressionData;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.PreprocessorExpressionParser;
import jp.kirikiri.tjs2.StringStream;
import jp.kirikiri.tjs2.TokenPair;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;

public class Lexer
extends LexBase {
    private boolean mIsFirst;
    private boolean mIsExprMode;
    private boolean mResultNeeded;
    private boolean mRegularExpression;
    private boolean mBareWord;
    private boolean mDicFunc;
    private int mValue;
    private int mPrevToken;
    private int mPrevPos;
    private int mNestLevel;
    private int mIfLevel;
    private static final int BUFFER_CAPACITY = 1024;
    private static final int LINE_FEED = 10;
    private Queue<TokenPair> mRetValDeque;
    private ArrayList<EmbeddableExpressionData> mEmbeddableExpressionDataStack;
    private ArrayList<Object> mValues;
    private Compiler mBlock;
    private static HashMap<String, Integer> mReservedWordHash;

    Variant getValue(int idx) {
        return new Variant(this.mValues.get(idx));
    }

    String getString(int idx) {
        Object ret = this.mValues.get(idx);
        if (ret instanceof String) {
            return (String)ret;
        }
        return null;
    }

    private static void initReservedWordsHashTable() {
        if (mReservedWordHash == null) {
            mReservedWordHash = new HashMap();
        }
        if (mReservedWordHash.size() > 0) {
            return;
        }
        mReservedWordHash.put("break", 336);
        mReservedWordHash.put("continue", 323);
        mReservedWordHash.put("const", 347);
        mReservedWordHash.put("catch", 355);
        mReservedWordHash.put("class", 317);
        mReservedWordHash.put("case", 327);
        mReservedWordHash.put("debugger", 325);
        mReservedWordHash.put("default", 326);
        mReservedWordHash.put("delete", 301);
        mReservedWordHash.put("do", 344);
        mReservedWordHash.put("extends", 328);
        mReservedWordHash.put("export", 337);
        mReservedWordHash.put("enum", 348);
        mReservedWordHash.put("else", 354);
        mReservedWordHash.put("function", 324);
        mReservedWordHash.put("finally", 329);
        mReservedWordHash.put("false", 363);
        mReservedWordHash.put("for", 342);
        mReservedWordHash.put("global", 315);
        mReservedWordHash.put("getter", 353);
        mReservedWordHash.put("goto", 349);
        mReservedWordHash.put("incontextof", 341);
        mReservedWordHash.put("invalidate", 308);
        mReservedWordHash.put("instanceof", 309);
        mReservedWordHash.put("isvalid", 307);
        mReservedWordHash.put("import", 338);
        mReservedWordHash.put("int", 359);
        mReservedWordHash.put("in", 340);
        mReservedWordHash.put("if", 345);
        mReservedWordHash.put("null", 364);
        mReservedWordHash.put("new", 300);
        mReservedWordHash.put("octet", 362);
        mReservedWordHash.put("protected", 333);
        mReservedWordHash.put("property", 330);
        mReservedWordHash.put("private", 331);
        mReservedWordHash.put("public", 332);
        mReservedWordHash.put("return", 335);
        mReservedWordHash.put("real", 360);
        mReservedWordHash.put("synchronized", 357);
        mReservedWordHash.put("switch", 339);
        mReservedWordHash.put("static", 334);
        mReservedWordHash.put("setter", 352);
        mReservedWordHash.put("string", 361);
        mReservedWordHash.put("super", 314);
        mReservedWordHash.put("typeof", 302);
        mReservedWordHash.put("throw", 350);
        mReservedWordHash.put("this", 313);
        mReservedWordHash.put("true", 365);
        mReservedWordHash.put("try", 351);
        mReservedWordHash.put("void", 366);
        mReservedWordHash.put("var", 346);
        mReservedWordHash.put("while", 343);
        mReservedWordHash.put("NaN", 367);
        mReservedWordHash.put("Infinity", 368);
        mReservedWordHash.put("with", 358);
    }

    public Lexer(Compiler block, String script, boolean isexpr, boolean resultneeded) {
        Lexer.initReservedWordsHashTable();
        this.mRetValDeque = new LinkedList<TokenPair>();
        this.mEmbeddableExpressionDataStack = new ArrayList();
        this.mValues = new ArrayList();
        this.mBlock = block;
        this.mIsExprMode = isexpr;
        this.mResultNeeded = resultneeded;
        this.mPrevToken = -1;
        this.mStream = this.mIsExprMode ? new StringStream(String.valueOf(script) + ";") : (script.startsWith("#!") ? new StringStream("//" + script.substring(2)) : new StringStream(script));
        if (CompileState.mEnableDicFuncQuickHack) {
            this.mDicFunc = false;
            if (this.mIsExprMode && (script.startsWith("[") || script.startsWith("%["))) {
                this.mDicFunc = true;
            }
        }
        this.mIsFirst = true;
        this.putValue(null);
    }

    public void setStartOfRegExp() {
        this.mRegularExpression = true;
    }

    public void setNextIsBareWord() {
        this.mBareWord = true;
    }

    private String parseRegExp() throws CompileException {
        boolean ok = false;
        boolean lastbackslash = false;
        StringBuilder str = new StringBuilder(1024);
        StringBuilder flag = new StringBuilder(1024);
        int c = this.mStream.next();
        while (c != -1) {
            if (c == 92) {
                str.append((char)c);
                lastbackslash = !lastbackslash;
            } else {
                if (c == 47 && !lastbackslash) {
                    c = this.mStream.next();
                    if (c == -1) {
                        ok = true;
                        break;
                    }
                    flag.delete(0, flag.length());
                    while (c >= 97 && c <= 122) {
                        flag.append((char)c);
                        c = this.mStream.next();
                        if (c == -1) break;
                    }
                    this.mStream.ungetC();
                    str.insert(0, "//");
                    String flgStr = flag.toString();
                    str.insert(2, flgStr);
                    str.insert(2 + flgStr.length(), "/");
                    ok = true;
                    break;
                }
                lastbackslash = false;
                str.append((char)c);
            }
            c = this.mStream.next();
        }
        if (!ok) {
            throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
        }
        return str.toString();
    }

    private ByteBuffer compactByteBuffer(ByteBuffer b) {
        int count = b.position();
        ByteBuffer ret = ByteBuffer.allocateDirect(count);
        b.position(0);
        int i = 0;
        while (i < count) {
            ret.put(b.get());
            ++i;
        }
        ret.position(0);
        return ret;
    }

    private ByteBuffer parseOctet() throws CompileException {
        boolean leading = true;
        byte cur = 0;
        int count = this.mStream.countOctetTail() / 2 + 1;
        ByteBuffer buffer = ByteBuffer.allocateDirect(count);
        int c = this.mStream.peekC();
        while (c != -1) {
            if (this.mStream.skipComment() == 2) {
                throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
            }
            c = this.mStream.getC();
            int next = this.mStream.peekC();
            if (c == 37 && next == 62) {
                this.mStream.incOffset();
                if (!leading) {
                    buffer.put(cur);
                }
                return this.compactByteBuffer(buffer);
            }
            int num = this.getHexNum(c);
            if (num != -1) {
                if (leading) {
                    cur = (byte)num;
                    leading = false;
                } else {
                    cur = (byte)(cur << 4);
                    cur = (byte)(cur + num);
                    buffer.put(cur);
                    leading = true;
                }
            }
            if (leading || c != 44) continue;
            buffer.put(cur);
            leading = true;
        }
        throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
    }

    private String parseString(int delimiter) throws CompileException {
        return this.mStream.readString(delimiter, false);
    }

    private int parsePPExpression(String script) throws CompileException {
        PreprocessorExpressionParser parser = new PreprocessorExpressionParser(this.mBlock.getTJS(), script);
        return parser.parse();
    }

    private int processPPStatement() throws CompileException {
        int offset = this.mStream.getOffset();
        int c = this.mStream.getC();
        if (c == 115 && this.mStream.equalString("et")) {
            this.mBlock.notifyUsingPreProcessror();
            this.mStream.skipSpace();
            c = this.mStream.getC();
            if (c == -1 || c != 40) {
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
            }
            c = this.mStream.next();
            StringBuilder script = new StringBuilder(1024);
            int plevel = 0;
            while (c != -1 && (plevel != 0 || c != 41)) {
                if (c == 40) {
                    ++plevel;
                } else if (c == 41) {
                    --plevel;
                }
                script.append((char)c);
                c = this.mStream.getC();
            }
            if (c != -1) {
                this.mStream.ungetC();
            }
            this.parsePPExpression(script.toString());
            if (this.mStream.isEOF()) {
                return 2;
            }
            return 1;
        }
        if (c == 105 && this.mStream.equalString("f")) {
            this.mBlock.notifyUsingPreProcessror();
            this.mStream.skipSpace();
            c = this.mStream.getC();
            if (c == -1 || c != 40) {
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
            }
            c = this.mStream.next();
            StringBuilder script = new StringBuilder(1024);
            int plevel = 0;
            while (c != -1 && (plevel != 0 || c != 41)) {
                if (c == 40) {
                    ++plevel;
                } else if (c == 41) {
                    --plevel;
                }
                script.append((char)c);
                c = this.mStream.getC();
            }
            int ret = this.parsePPExpression(script.toString());
            if (ret == 0) {
                return this.skipUntilEndif();
            }
            ++this.mIfLevel;
            if (this.mStream.isEOF()) {
                return 2;
            }
            return 1;
        }
        if (c == 101 && this.mStream.equalString("ndif")) {
            --this.mIfLevel;
            if (this.mIfLevel < 0) {
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
            }
            if (this.mStream.isEOF()) {
                return 2;
            }
            return 1;
        }
        this.mStream.setOffset(offset);
        return 0;
    }

    private int skipUntilEndif() throws CompileException {
        int exl = this.mIfLevel++;
        int c = this.mStream.getC();
        block5: while (true) {
            if (c == 47) {
                this.mStream.ungetC();
                int ret = this.mStream.skipComment();
                switch (ret) {
                    case 2: {
                        throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                    }
                    case 1: {
                        continue block5;
                    }
                    case 0: {
                        c = this.mStream.next();
                        if (!this.mStream.isEOF()) continue block5;
                        throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                    }
                }
                continue;
            }
            if (c == 64) {
                boolean skipp = false;
                if (this.mStream.equalString("if")) {
                    ++this.mIfLevel;
                    skipp = true;
                } else if (this.mStream.equalString("set")) {
                    skipp = true;
                } else if (this.mStream.equalString("endif")) {
                    --this.mIfLevel;
                    if (this.mIfLevel == exl) {
                        this.mStream.skipSpace();
                        if (this.mStream.isEOF()) {
                            return 2;
                        }
                        return 1;
                    }
                } else {
                    c = this.mStream.getC();
                }
                if (!skipp) continue;
                this.mStream.skipSpace();
                if (this.mStream.isEOF()) {
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                }
                c = this.mStream.getC();
                if (c != 40) {
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                }
                c = this.mStream.next();
                int plevel = 0;
                while (c != -1 && (plevel > 0 || c != 41)) {
                    if (c == 40) {
                        ++plevel;
                    } else if (c == 41) {
                        --plevel;
                    }
                    c = this.mStream.next();
                }
                if (c == -1) {
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                }
                this.mStream.skipSpace();
                if (!this.mStream.isEOF()) continue;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
            }
            c = this.mStream.getC();
            if (c == -1) break;
        }
        throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
    }

    private int getHexNum(int c) {
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    private int putValue(Object val) {
        this.mValues.add(val);
        return this.mValues.size() - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getToken() throws CompileException {
        Integer id;
        int c;
        boolean retry;
        if (this.mStream.isEOF()) {
            return 0;
        }
        if (this.mRegularExpression) {
            this.mRegularExpression = false;
            this.mStream.setOffset(this.mPrevPos);
            this.mStream.skipSpace();
            this.mStream.next();
            String pattern = this.parseRegExp();
            this.mValue = this.putValue(pattern);
            return 387;
        }
        block45: do {
            retry = false;
            this.mStream.skipSpace();
            this.mPrevPos = this.mStream.getOffset();
            c = this.mStream.getC();
            switch (c) {
                case -1: 
                case 0: {
                    return 0;
                }
                case 62: {
                    c = this.mStream.getC();
                    if (c == 62) {
                        c = this.mStream.getC();
                        if (c == 62) {
                            c = this.mStream.getC();
                            if (c == 61) {
                                return 273;
                            }
                            this.mStream.ungetC();
                            return 291;
                        }
                        if (c == 61) {
                            return 271;
                        }
                        this.mStream.ungetC();
                        return 289;
                    }
                    if (c == 61) {
                        return 288;
                    }
                    this.mStream.ungetC();
                    return 286;
                }
                case 60: {
                    c = this.mStream.getC();
                    if (c == 60) {
                        c = this.mStream.getC();
                        if (c == 61) {
                            return 272;
                        }
                        this.mStream.ungetC();
                        return 290;
                    }
                    if (c == 45) {
                        c = this.mStream.getC();
                        if (c == 62) {
                            return 284;
                        }
                        this.mStream.ungetC();
                        this.mStream.ungetC();
                        return 285;
                    }
                    if (c == 61) {
                        return 287;
                    }
                    if (c == 37) {
                        ByteBuffer buffer = this.parseOctet();
                        this.mValue = this.putValue(buffer);
                        return 385;
                    }
                    this.mStream.ungetC();
                    return 285;
                }
                case 61: {
                    c = this.mStream.getC();
                    if (c == 61) {
                        c = this.mStream.getC();
                        if (c == 61) {
                            return 283;
                        }
                        this.mStream.ungetC();
                        return 281;
                    }
                    if (c == 62) {
                        return 258;
                    }
                    this.mStream.ungetC();
                    return 259;
                }
                case 33: {
                    c = this.mStream.getC();
                    if (c == 61) {
                        c = this.mStream.getC();
                        if (c == 61) {
                            return 282;
                        }
                        this.mStream.ungetC();
                        return 280;
                    }
                    this.mStream.ungetC();
                    return 296;
                }
                case 38: {
                    c = this.mStream.getC();
                    if (c == 38) {
                        c = this.mStream.getC();
                        if (c == 61) {
                            return 270;
                        }
                        this.mStream.ungetC();
                        return 276;
                    }
                    if (c == 61) {
                        return 260;
                    }
                    this.mStream.ungetC();
                    return 279;
                }
                case 124: {
                    c = this.mStream.getC();
                    if (c == 124) {
                        c = this.mStream.getC();
                        if (c == 61) {
                            return 269;
                        }
                        this.mStream.ungetC();
                        return 275;
                    }
                    if (c == 61) {
                        return 261;
                    }
                    this.mStream.ungetC();
                    return 277;
                }
                case 46: {
                    c = this.mStream.getC();
                    if (c >= 48 && c <= 57) {
                        this.mStream.ungetC();
                        this.mStream.ungetC();
                        Number o = this.parseNumber();
                        this.mValue = o != null ? (o instanceof Integer ? this.putValue((Integer)o) : (o instanceof Double ? this.putValue((Double)o) : this.putValue(null))) : this.putValue(null);
                        return 385;
                    }
                    if (c == 46) {
                        c = this.mStream.getC();
                        if (c == 46) {
                            return 356;
                        }
                        this.mStream.ungetC();
                        this.mStream.ungetC();
                        return 311;
                    }
                    this.mStream.ungetC();
                    return 311;
                }
                case 43: {
                    c = this.mStream.getC();
                    if (c == 43) {
                        return 299;
                    }
                    if (c == 61) {
                        return 264;
                    }
                    this.mStream.ungetC();
                    return 303;
                }
                case 45: {
                    c = this.mStream.getC();
                    if (c == 45) {
                        return 298;
                    }
                    if (c == 61) {
                        return 263;
                    }
                    this.mStream.ungetC();
                    return 304;
                }
                case 42: {
                    c = this.mStream.getC();
                    if (c == 61) {
                        return 268;
                    }
                    this.mStream.ungetC();
                    return 295;
                }
                case 47: {
                    c = this.mStream.getC();
                    if (c == 47 || c == 42) {
                        this.mStream.ungetC();
                        this.mStream.ungetC();
                        int comment = this.mStream.skipComment();
                        if (comment == 1) {
                            retry = true;
                            break;
                        }
                        if (comment == 2) {
                            return 0;
                        }
                    }
                    if (c == 61) {
                        return 266;
                    }
                    this.mStream.ungetC();
                    return 293;
                }
                case 92: {
                    c = this.mStream.getC();
                    if (c == 61) {
                        return 267;
                    }
                    this.mStream.ungetC();
                    return 294;
                }
                case 37: {
                    c = this.mStream.getC();
                    if (c == 61) {
                        return 265;
                    }
                    this.mStream.ungetC();
                    return 292;
                }
                case 94: {
                    c = this.mStream.getC();
                    if (c == 61) {
                        return 262;
                    }
                    this.mStream.ungetC();
                    return 278;
                }
                case 91: {
                    ++this.mNestLevel;
                    return 312;
                }
                case 93: {
                    --this.mNestLevel;
                    return 316;
                }
                case 40: {
                    ++this.mNestLevel;
                    return 310;
                }
                case 41: {
                    --this.mNestLevel;
                    return 318;
                }
                case 126: {
                    return 297;
                }
                case 63: {
                    return 274;
                }
                case 58: {
                    return 319;
                }
                case 44: {
                    return 258;
                }
                case 59: {
                    return 320;
                }
                case 123: {
                    ++this.mNestLevel;
                    return 321;
                }
                case 125: {
                    --this.mNestLevel;
                    return 322;
                }
                case 35: {
                    return 305;
                }
                case 36: {
                    return 306;
                }
                case 34: 
                case 39: {
                    String str = this.parseString(c);
                    this.mValue = this.putValue(str);
                    return 385;
                }
                case 64: {
                    int offset = this.mStream.getOffset();
                    this.mStream.skipSpace();
                    c = this.mStream.next();
                    if (c == 39 || c == 34) {
                        EmbeddableExpressionData data = new EmbeddableExpressionData();
                        data.mState = 0;
                        data.mWaitingNestLevel = this.mNestLevel;
                        data.mDelimiter = c;
                        data.mNeedPlus = false;
                        if (this.mStream.isEOF()) {
                            return 0;
                        }
                        this.mEmbeddableExpressionDataStack.add(data);
                        return -1;
                    }
                    this.mStream.setOffset(offset);
                    switch (this.processPPStatement()) {
                        case 1: {
                            retry = true;
                            break;
                        }
                        case 2: {
                            return 0;
                        }
                        case 0: {
                            this.mStream.setOffset(offset);
                        }
                    }
                    continue block45;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.mStream.ungetC();
                    Number o = this.parseNumber();
                    if (o == null) throw new CompileException("\u6570\u5024\u3068\u3057\u3066\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093");
                    if (o instanceof Integer) {
                        this.mValue = this.putValue((Integer)o);
                        return 385;
                    } else {
                        if (!(o instanceof Double)) throw new CompileException("\u6570\u5024\u3068\u3057\u3066\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093");
                        this.mValue = this.putValue((Double)o);
                    }
                    return 385;
                }
            }
        } while (retry);
        if (!this.isWAlpha(c) && c != 95) {
            String str = "\u4e0d\u6b63\u306a\u6587\u5b57\u3067\u3059 : '%1'".replace("%1", Lexer.escapeC((char)c));
            throw new CompileException(str);
        }
        int oldC = c;
        int offset = this.mStream.getOffset() - 1;
        int nch = 0;
        while (this.isWDigit(c) || this.isWAlpha(c) || c == 95 || c > 256 || c == 10) {
            c = this.mStream.getC();
            ++nch;
        }
        if (nch == 0) {
            String str = "\u4e0d\u6b63\u306a\u6587\u5b57\u3067\u3059 : '%1'".replace("%1", Lexer.escapeC((char)oldC));
            throw new CompileException(str);
        }
        this.mStream.ungetC();
        String str = this.mStream.substring(offset, offset + nch);
        int strLen = str.length();
        StringBuilder symStr = new StringBuilder(1024);
        int i = 0;
        while (i < strLen) {
            char t = str.charAt(i);
            if (t != '\n') {
                symStr.append(t);
            }
            ++i;
        }
        str = symStr.toString();
        int retnum = this.mBareWord ? -1 : ((id = mReservedWordHash.get(str)) != null ? id : -1);
        this.mBareWord = false;
        if (retnum == -1) {
            this.mValue = this.putValue(str);
            return 386;
        }
        switch (retnum) {
            case 363: {
                this.mValue = this.putValue(0);
                return 385;
            }
            case 364: {
                this.mValue = this.putValue(new VariantClosure(null));
                return 385;
            }
            case 365: {
                this.mValue = this.putValue(1);
                return 385;
            }
            case 367: {
                this.mValue = this.putValue(Double.NaN);
                return 385;
            }
            case 368: {
                this.mValue = this.putValue(Double.POSITIVE_INFINITY);
                return 385;
            }
        }
        return retnum;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getNext() throws CompileException {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (this.mIsExprMode && this.mResultNeeded) {
                this.mValue = 0;
                return 335;
            }
        }
        int n = 0;
        this.mValue = 0;
        do {
            if (this.mRetValDeque.size() > 0) {
                TokenPair pair = this.mRetValDeque.poll();
                this.mValue = pair.value;
                this.mPrevToken = pair.token;
                return pair.token;
            }
            try {
                if (this.mEmbeddableExpressionDataStack.size() == 0) {
                    this.mStream.skipSpace();
                    n = this.getToken();
                    if (CompileState.mEnableDicFuncQuickHack && this.mDicFunc) {
                        if (n == 292) {
                            this.mRetValDeque.offer(new TokenPair(324, 0));
                            this.mRetValDeque.offer(new TokenPair(321, 0));
                            this.mRetValDeque.offer(new TokenPair(335, 0));
                            this.mRetValDeque.offer(new TokenPair(292, 0));
                            n = -1;
                        } else if (n == 312 && this.mPrevToken != 292) {
                            this.mRetValDeque.offer(new TokenPair(324, 0));
                            this.mRetValDeque.offer(new TokenPair(321, 0));
                            this.mRetValDeque.offer(new TokenPair(335, 0));
                            this.mRetValDeque.offer(new TokenPair(312, 0));
                            n = -1;
                        } else if (n == 316) {
                            this.mRetValDeque.offer(new TokenPair(316, 0));
                            this.mRetValDeque.offer(new TokenPair(320, 0));
                            this.mRetValDeque.offer(new TokenPair(322, 0));
                            this.mRetValDeque.offer(new TokenPair(310, 0));
                            this.mRetValDeque.offer(new TokenPair(318, 0));
                            n = -1;
                        }
                    }
                } else {
                    EmbeddableExpressionData data = this.mEmbeddableExpressionDataStack.get(this.mEmbeddableExpressionDataStack.size() - 1);
                    switch (data.mState) {
                        case 0: {
                            this.mRetValDeque.offer(new TokenPair(310, 0));
                            n = -1;
                            data.mState = 1;
                            break;
                        }
                        case 1: {
                            int v;
                            String str = this.mStream.readString(data.mDelimiter, true);
                            int res = this.mStream.getStringStatus();
                            if (res == 1) {
                                if (str.length() > 0 && data.mNeedPlus) {
                                    this.mRetValDeque.offer(new TokenPair(303, 0));
                                }
                                if (str.length() > 0 || !data.mNeedPlus) {
                                    v = this.putValue(str);
                                    this.mRetValDeque.offer(new TokenPair(385, v));
                                }
                                this.mRetValDeque.offer(new TokenPair(318, 0));
                                this.mEmbeddableExpressionDataStack.remove(this.mEmbeddableExpressionDataStack.size() - 1);
                                n = -1;
                                break;
                            }
                            if (str.length() > 0) {
                                if (data.mNeedPlus) {
                                    this.mRetValDeque.offer(new TokenPair(303, 0));
                                }
                                v = this.putValue(str);
                                this.mRetValDeque.offer(new TokenPair(385, v));
                                data.mNeedPlus = true;
                            }
                            if (data.mNeedPlus) {
                                this.mRetValDeque.offer(new TokenPair(303, 0));
                            }
                            this.mRetValDeque.offer(new TokenPair(361, 0));
                            this.mRetValDeque.offer(new TokenPair(310, 0));
                            data.mState = 2;
                            if (res == 2) {
                                data.mWaitingToken = 320;
                            } else if (res == 3) {
                                data.mWaitingToken = 322;
                                ++this.mNestLevel;
                            }
                            n = -1;
                            break;
                        }
                        case 2: {
                            this.mStream.skipSpace();
                            n = this.getToken();
                            if (n != data.mWaitingToken || this.mNestLevel != data.mWaitingNestLevel) break;
                            this.mRetValDeque.offer(new TokenPair(318, 0));
                            data.mNeedPlus = true;
                            data.mState = 1;
                            n = -1;
                        }
                    }
                }
                if (n == 0 && this.mIfLevel != 0) {
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                }
            }
            catch (CompileException e) {
                this.mBlock.error(e.getMessage());
                return 0;
            }
        } while (n < 0);
        this.mPrevToken = n;
        return n;
    }

    public int getCurrentPosition() {
        int offset = this.mStream.getOffset();
        return offset > 0 ? offset - 1 : 0;
    }
}

