/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.CompileState;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.EmbeddableExpressionData;
import jp.kirikiri.tjs2.LongQue;
import jp.kirikiri.tjs2.PreprocessorExpressionParser;
import jp.kirikiri.tjs2.ReservedWordToken;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;

public class LexicalAnalyzer {
    private boolean mIsFirst;
    private boolean mIsExprMode;
    private boolean mResultNeeded;
    private boolean mRegularExpression;
    private boolean mBareWord;
    private boolean mDicFunc;
    private int mValue;
    private int mPrevToken;
    private int mPrevPos;
    private int mNestLevel;
    private int mIfLevel;
    private static final int BUFFER_CAPACITY = 1024;
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int TAB = 9;
    private static final int SPACE = 32;
    private static final int NOT_COMMENT = 0;
    private static final int CONTINUE = 1;
    private static final int ENDED = 2;
    private static final int NONE = 0;
    private static final int DELIMITER = 1;
    private static final int AMPERSAND = 2;
    private static final int DOLLAR = 3;
    private LongQue mRetValDeque = new LongQue();
    private ArrayList<EmbeddableExpressionData> mEmbeddableExpressionDataStack = new ArrayList();
    private ArrayList<Object> mValues = new ArrayList();
    private Compiler mBlock;
    private char[] mText;
    private int mCurrent;
    private int mStringStatus;
    private static StringBuilder mWorkBuilder;
    private static final int TJS_IEEE_D_SIGNIFICAND_BITS = 52;
    private static final int TJS_IEEE_D_EXP_MIN = -1022;
    private static final int TJS_IEEE_D_EXP_MAX = 1023;
    private static final long TJS_IEEE_D_EXP_BIAS = 1023L;

    Variant getValue(int idx) {
        return new Variant(this.mValues.get(idx));
    }

    String getString(int idx) {
        Object ret = this.mValues.get(idx);
        if (ret instanceof String) {
            return (String)ret;
        }
        return null;
    }

    public static void initialize() {
        mWorkBuilder = new StringBuilder(1024);
    }

    public static void finalizeApplication() {
        mWorkBuilder = null;
    }

    public LexicalAnalyzer(Compiler block, String script, boolean isexpr, boolean resultneeded) {
        this.mBlock = block;
        this.mIsExprMode = isexpr;
        this.mResultNeeded = resultneeded;
        this.mPrevToken = -1;
        int scriptLen = script.length();
        if (this.mIsExprMode) {
            this.mText = new char[scriptLen + 2];
            script.getChars(0, scriptLen, this.mText, 0);
            this.mText[scriptLen] = 59;
            this.mText[scriptLen + 1] = '\u0000';
        } else if (script.startsWith("#!")) {
            this.mText = new char[scriptLen + 1];
            script.getChars(2, scriptLen, this.mText, 2);
            this.mText[1] = 47;
            this.mText[0] = 47;
            this.mText[scriptLen] = '\u0000';
        } else {
            this.mText = new char[scriptLen + 1];
            script.getChars(0, scriptLen, this.mText, 0);
            this.mText[scriptLen] = '\u0000';
        }
        if (CompileState.mEnableDicFuncQuickHack) {
            char c = script.charAt(0);
            if (this.mIsExprMode && (c == '[' || c == '%' && script.charAt(1) == '[')) {
                this.mDicFunc = true;
            }
        }
        this.mIsFirst = true;
        this.putValue(null);
    }

    /*
     * Unable to fully structure code
     */
    private final int skipComment() throws CompileException {
        block10: {
            ptr = this.mText;
            cur = this.mCurrent;
            if (ptr[cur] != '/') {
                return 0;
            }
            c = ptr[cur + 1];
            if (c == '/') {
                c = ptr[cur += 2];
                while (c != '\u0000' && c != '\r' && c != '\n') {
                    c = ptr[++cur];
                }
                if (c != '\u0000' && c == '\r' && (c = ptr[++cur]) == '\n') {
                    c = ptr[++cur];
                }
                while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                    c = ptr[++cur];
                }
                this.mCurrent = cur;
                if (c == '\u0000') {
                    return 2;
                }
                return 1;
            }
            if (c != '*') break block10;
            c = ptr[cur += 2];
            if (c == '\u0000') {
                this.mCurrent = cur;
                throw new CompileException("\u30b3\u30e1\u30f3\u30c8\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f", this.mBlock, cur);
            }
            level = 0;
            do {
                block12: {
                    block13: {
                        block11: {
                            if (c != '/' || ptr[cur + 1] != '*') break block11;
                            ++level;
                            break block12;
                        }
                        if (c != '*' || ptr[cur + 1] != '/') break block12;
                        if (level != 0) break block13;
                        c = ptr[cur += 2];
                        if (true) ** GOTO lbl46
                    }
                    --level;
                }
                c = ptr[++cur];
                if (c != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
            } while (c != '\u0000');
            this.mCurrent = cur;
            throw new CompileException("\u30b3\u30e1\u30f3\u30c8\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f", this.mBlock, cur);
            do {
                c = ptr[++cur];
lbl46:
                // 2 sources

            } while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' '));
            this.mCurrent = cur;
            if (c == '\u0000') {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private boolean parseExtractNumber(int basebits) {
        boolean point_found = false;
        boolean exp_found = false;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '.' && !point_found && !exp_found) {
                point_found = true;
                if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
                continue;
            }
            if (!(c != 'p' && c != 'P' || exp_found)) {
                exp_found = true;
                c = ptr[++cur];
                while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                    c = ptr[++cur];
                }
                if (c != '+' && c != '-') continue;
                c = ptr[++cur];
                while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                    c = ptr[++cur];
                }
                continue;
            }
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F') || (basebits != 3 ? basebits == 1 && c != '0' && c != '1' : c < '0' || c > '7')) break;
            if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        return point_found || exp_found;
    }

    private Double parseNonDecimalReal(boolean sign, int basebits) {
        long main = 0L;
        int exp = 0;
        int numsignif = 0;
        boolean pointpassed = false;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '.') {
                pointpassed = true;
            } else {
                if (c == 'p' || c == 'P') {
                    c = ptr[++cur];
                    while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                        c = ptr[++cur];
                    }
                    boolean biassign = false;
                    if (c == '+') {
                        biassign = false;
                        c = ptr[++cur];
                        while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                            c = ptr[++cur];
                        }
                    }
                    if (c == '-') {
                        biassign = true;
                        c = ptr[++cur];
                        while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                            c = ptr[++cur];
                        }
                    }
                    int bias = 0;
                    while (c >= '0' && c <= '9') {
                        bias *= 10;
                        bias += c - 48;
                        if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                        c = ptr[++cur];
                    }
                    if (biassign) {
                        bias = -bias;
                    }
                    exp += bias;
                    break;
                }
                int n = -1;
                if (basebits == 4) {
                    if (c >= '0' && c <= '9') {
                        n = c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        n = c - 97 + 10;
                    } else {
                        if (c < 'A' || c > 'F') break;
                        n = c - 65 + 10;
                    }
                } else if (basebits == 3) {
                    if (c < '0' || c > '7') break;
                    n = c - 48;
                } else if (basebits == 1) {
                    if (c != '0' && c != '1') break;
                    n = c - 48;
                }
                if (numsignif == 0) {
                    int b = basebits - 1;
                    while (b >= 0) {
                        if ((1 << b & n) != 0) break;
                        --b;
                    }
                    if (++b != 0) {
                        numsignif = b;
                        main |= (long)n << 64 - numsignif;
                        exp = pointpassed ? (exp -= basebits - b + 1) : b - 1;
                    } else if (pointpassed) {
                        exp -= basebits;
                    }
                } else {
                    if (numsignif + basebits < 64) {
                        main |= (long)n << 64 - (numsignif += basebits);
                    }
                    if (!pointpassed) {
                        exp += basebits;
                    }
                }
            }
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if ((main >>>= 11) == 0L) {
            return 0.0;
        }
        main &= 0xFFFFFFFFFFFFFL;
        if (exp < -1022) {
            return 0.0;
        }
        if (exp > 1023) {
            if (sign) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        double d = Double.longBitsToDouble((long)exp + 1023L << 52 | main);
        if (sign) {
            d = -d;
        }
        return d;
    }

    private Integer parseNonDecimalInteger16(boolean sign) {
        long v = 0L;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            int n = -1;
            if (c >= '0' && c <= '9') {
                n = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                n = c - 97 + 10;
            } else {
                if (c < 'A' || c > 'F') break;
                n = c - 65 + 10;
            }
            v <<= 4;
            v += (long)n;
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Integer parseNonDecimalInteger8(boolean sign) {
        long v = 0L;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            int n = -1;
            if (c < '0' || c > '7') break;
            n = c - 48;
            v <<= 3;
            v += (long)n;
            if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Integer parseNonDecimalInteger2(boolean sign) {
        long v = 0L;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '1') {
                v <<= 1;
                ++v;
            } else {
                if (c != '0') break;
                v <<= 1;
            }
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Number parseNonDecimalNumber(boolean sign, int base) {
        boolean is_real = this.parseExtractNumber(base);
        if (is_real) {
            return this.parseNonDecimalReal(sign, base);
        }
        switch (base) {
            case 4: {
                return this.parseNonDecimalInteger16(sign);
            }
            case 3: {
                return this.parseNonDecimalInteger8(sign);
            }
            case 1: {
                return this.parseNonDecimalInteger2(sign);
            }
        }
        return null;
    }

    private Number parseNumber() {
        int num = 0;
        boolean sign = false;
        boolean skipNum = false;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        if (c == '+') {
            sign = false;
            c = ptr[++cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                return null;
            }
        } else if (c == '-') {
            sign = true;
            c = ptr[++cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                return null;
            }
        }
        if (c > '9') {
            if (c == 't' && ptr[cur + 1] == 'r' && ptr[cur + 2] == 'u' && ptr[cur + 3] == 'e') {
                this.mCurrent = cur += 4;
                return 1;
            }
            if (c == 'f' && ptr[cur + 1] == 'a' && ptr[cur + 2] == 'l' && ptr[cur + 3] == 's' && ptr[cur + 4] == 'e') {
                this.mCurrent = cur += 5;
                return 0;
            }
            if (c == 'N' && ptr[cur + 1] == 'a' && ptr[cur + 2] == 'N') {
                this.mCurrent = cur += 3;
                return Double.NaN;
            }
            if (c == 'I' && ptr[cur + 1] == 'n' && ptr[cur + 2] == 'f' && ptr[cur + 3] == 'i' && ptr[cur + 4] == 'n' && ptr[cur + 5] == 'i' && ptr[cur + 6] == 't' && ptr[cur + 7] == 'y') {
                this.mCurrent = cur += 8;
                if (sign) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
        }
        if (c == '0') {
            if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                return 0;
            }
            if (c == 'x' || c == 'X') {
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                this.mCurrent = cur;
                if (c == '\u0000') {
                    return null;
                }
                return this.parseNonDecimalNumber(sign, 4);
            }
            if (c == 'b' || c == 'B') {
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                this.mCurrent = cur;
                if (c == '\u0000') {
                    return null;
                }
                return this.parseNonDecimalNumber(sign, 1);
            }
            if (c == '.') {
                skipNum = true;
            } else if (c == 'e' || c == 'E') {
                skipNum = true;
            } else {
                if (c == 'p' || c == 'P') {
                    this.mCurrent = cur;
                    return null;
                }
                if (c >= '0' && c <= '7') {
                    this.mCurrent = cur;
                    return this.parseNonDecimalNumber(sign, 3);
                }
            }
        }
        if (!skipNum) {
            while (c != '\u0000') {
                if (c < '0' || c > '9') break;
                num = num * 10 + (c - 48);
                if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
            }
        }
        if (c == '.' || c == 'e' || c == 'E') {
            double figure = 1.0;
            int decimal = 0;
            if (c == '.') {
                do {
                    if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                    if (c < '0' || c > '9') break;
                    decimal = decimal * 10 + (c - 48);
                    figure *= 10.0;
                } while (c != '\u0000');
            }
            boolean expSign = false;
            int expValue = 0;
            if (c == 'e' || c == 'E') {
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c == '-') {
                    expSign = true;
                    if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                }
                while (c != '\u0000') {
                    if (c < '0' || c > '9') break;
                    expValue = expValue * 10 + (c - 48);
                    if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                    c = ptr[++cur];
                }
            }
            double number = (double)num + (double)decimal / figure;
            if (expValue != 0) {
                number = !expSign ? (number *= Math.pow(10.0, expValue)) : (number /= Math.pow(10.0, expValue));
            }
            if (sign) {
                number = -number;
            }
            this.mCurrent = cur;
            return number;
        }
        if (sign) {
            num = -num;
        }
        this.mCurrent = cur;
        return num;
    }

    private final String readString(int delimiter, boolean embexpmode) throws CompileException {
        this.mStringStatus = 0;
        int cur = this.mCurrent;
        char[] ptr = this.mText;
        StringBuilder str = mWorkBuilder;
        str.delete(0, str.length());
        while (ptr[cur] != '\u0000') {
            int offset;
            int c = ptr[cur];
            if (c == 92) {
                int code;
                if ((c = ptr[++cur]) == 13 && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c == 0) break;
                if (c == 120 || c == 88) {
                    if ((c = ptr[++cur]) == 13 && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                    if (c == 0) break;
                    code = 0;
                    int count = 0;
                    while (count < 4) {
                        int n = -1;
                        if (c >= 48 && c <= 57) {
                            n = c - 48;
                        } else if (c >= 97 && c <= 102) {
                            n = c - 97 + 10;
                        } else {
                            if (c < 65 || c > 70) break;
                            n = c - 65 + 10;
                        }
                        code <<= 4;
                        code += n;
                        ++count;
                        c = ptr[++cur];
                        if (c == 13 && ptr[cur + 1] == '\n') {
                            c = ptr[++cur];
                        }
                        if (c == 0) break;
                    }
                    if (c == 0) break;
                    str.append((char)code);
                    continue;
                }
                if (c == 48) {
                    if ((c = ptr[++cur]) == 13 && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                    if (c == 0) break;
                    code = 0;
                    do {
                        int n = -1;
                        if (c < 48 || c > 55) break;
                        n = c - 48;
                        code <<= 3;
                        code += n;
                        if ((c = ptr[++cur]) != 13 || ptr[cur + 1] != '\n') continue;
                        c = ptr[++cur];
                    } while (c != 0);
                    str.append((char)code);
                    continue;
                }
                switch (c) {
                    case 'a': {
                        c = 7;
                        break;
                    }
                    case 'b': {
                        c = 8;
                        break;
                    }
                    case 'f': {
                        c = 12;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    case 't': {
                        c = 9;
                        break;
                    }
                    case 'v': {
                        c = 11;
                    }
                }
                str.append((char)c);
                c = ptr[++cur];
                if (c != 13 || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
                continue;
            }
            if (c == delimiter) {
                if ((c = ptr[++cur]) == 13 && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c == 0) {
                    this.mStringStatus = 1;
                    break;
                }
                offset = cur;
                while (c != 0 && c <= 32 && (c == 13 || c == 10 || c == 9 || c == 32)) {
                    c = ptr[++cur];
                }
                if (c == delimiter) {
                    if ((c = ptr[++cur]) != 13 || ptr[cur + 1] != '\n') continue;
                    c = ptr[++cur];
                    continue;
                }
                cur = offset;
                this.mStringStatus = 1;
                break;
            }
            if (embexpmode && c == 38) {
                if ((c = ptr[++cur]) == 13 && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c == 0) break;
                this.mStringStatus = 2;
                break;
            }
            if (embexpmode && c == 36) {
                offset = cur++;
                c = ptr[cur];
                if (c == 13 && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c == 0) break;
                if (c == 123) {
                    if ((c = ptr[++cur]) == 13 && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                    if (c == 0) break;
                    this.mStringStatus = 3;
                    break;
                }
                cur = offset;
                c = ptr[cur];
                str.append((char)c);
                c = ptr[++cur];
                if (c != 13 || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
                continue;
            }
            str.append((char)c);
            c = ptr[++cur];
            if (c != 13 || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (this.mStringStatus == 0) {
            throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f", this.mBlock, this.mCurrent);
        }
        return str.toString();
    }

    public void setStartOfRegExp() {
        this.mRegularExpression = true;
    }

    public void setNextIsBareWord() {
        this.mBareWord = true;
    }

    private String parseRegExp() throws CompileException {
        boolean ok = false;
        boolean lastbackslash = false;
        StringBuilder str = mWorkBuilder;
        str.delete(0, str.length());
        StringBuilder flag = null;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '\\') {
                str.append(c);
                lastbackslash = !lastbackslash;
            } else {
                if (c == '/' && !lastbackslash) {
                    if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                    if (c == '\u0000') {
                        ok = true;
                        break;
                    }
                    if (flag == null) {
                        flag = new StringBuilder(1024);
                    } else {
                        flag.delete(0, flag.length());
                    }
                    while (c >= 'a' && c <= 'z') {
                        flag.append(c);
                        c = ptr[++cur];
                        if (c == '\r' && ptr[cur + 1] == '\n') {
                            c = ptr[++cur];
                        }
                        if (c == '\u0000') break;
                    }
                    str.insert(0, "//");
                    String flgStr = flag.toString();
                    str.insert(2, flgStr);
                    str.insert(2 + flgStr.length(), "/");
                    ok = true;
                    break;
                }
                lastbackslash = false;
                str.append(c);
            }
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (!ok) {
            throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
        }
        return str.toString();
    }

    private ByteBuffer compactByteBuffer(ByteBuffer b) {
        int count = b.position();
        ByteBuffer ret = ByteBuffer.allocate(count);
        b.position(0);
        int i = 0;
        while (i < count) {
            ret.put(b.get());
            ++i;
        }
        ret.position(0);
        return ret;
    }

    private ByteBuffer parseOctet() throws CompileException {
        char[] ptr = this.mText;
        int cur = this.mCurrent + 1;
        char c = ptr[cur];
        if (c == '\r' && ptr[cur + 1] == '\n') {
            c = ptr[++cur];
        }
        boolean leading = true;
        byte oct = 0;
        int count = 0;
        if (c != '\u0000') {
            int offset = cur;
            int len = ptr.length;
            while (offset + 1 < len) {
                if (ptr[offset] == '%' && ptr[offset + 1] == '>') break;
                ++offset;
            }
            count = offset - cur;
        }
        count = count / 2 + 1;
        ByteBuffer buffer = ByteBuffer.allocate(count);
        while (c != '\u0000') {
            if (c == '/' && this.skipComment() == 2) {
                this.mCurrent = cur;
                throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f", this.mBlock, cur);
            }
            c = ptr[cur];
            int n = cur + 1;
            char next = ptr[n];
            if (next == '\r' && ptr[n + 1] == '\n') {
                c = ptr[++n];
            }
            if (c == '%' && next == '>') {
                cur = n;
                if (ptr[cur] != '\u0000' && (c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (!leading) {
                    buffer.put(oct);
                }
                this.mCurrent = cur;
                return this.compactByteBuffer(buffer);
            }
            int num = c >= '0' && c <= '9' ? c - 48 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : -1));
            if (num != -1) {
                if (leading) {
                    oct = (byte)num;
                    leading = false;
                } else {
                    oct = (byte)(oct << 4);
                    oct = (byte)(oct + num);
                    buffer.put(oct);
                    leading = true;
                }
            }
            if (!leading && c == ',') {
                buffer.put(oct);
                leading = true;
            }
            cur = n;
        }
        this.mCurrent = cur;
        throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f", this.mBlock, cur);
    }

    private int parsePPExpression(String script) throws CompileException {
        PreprocessorExpressionParser parser = new PreprocessorExpressionParser(this.mBlock.getTJS(), script);
        return parser.parse();
    }

    private int processPPStatement() throws CompileException {
        char[] ptr = this.mText;
        int cur = this.mCurrent + 1;
        char c = ptr[cur];
        if (c == 's' && ptr[cur + 1] == 'e' && ptr[cur + 2] == 't') {
            this.mBlock.notifyUsingPreProcessror();
            c = ptr[cur += 3];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
            }
            if (c != '(') {
                this.mCurrent = cur;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
            }
            if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            StringBuilder script = mWorkBuilder;
            script.delete(0, script.length());
            int plevel = 0;
            while (c != '\u0000' && (plevel != 0 || c != ')')) {
                if (c == '(') {
                    ++plevel;
                } else if (c == ')') {
                    --plevel;
                }
                script.append(c);
                c = ptr[++cur];
                if (c != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
            }
            if (c != '\u0000' && (c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            this.parsePPExpression(script.toString());
            c = ptr[cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            this.mCurrent = cur;
            if (c == '\u0000') {
                return 2;
            }
            return 1;
        }
        if (c == 'i' && ptr[cur + 1] == 'f') {
            int ret;
            this.mBlock.notifyUsingPreProcessror();
            c = ptr[cur += 2];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
            }
            if (c != '(') {
                this.mCurrent = cur;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
            }
            if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            StringBuilder script = mWorkBuilder;
            script.delete(0, script.length());
            int plevel = 0;
            while (c != '\u0000' && (plevel != 0 || c != ')')) {
                if (c == '(') {
                    ++plevel;
                } else if (c == ')') {
                    --plevel;
                }
                script.append(c);
                c = ptr[++cur];
                if (c != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
            }
            if (c != '\u0000' && (c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            if ((ret = this.parsePPExpression(script.toString())) == 0) {
                this.mCurrent = cur;
                return this.skipUntilEndif();
            }
            ++this.mIfLevel;
            c = ptr[cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            this.mCurrent = cur;
            if (c == '\u0000') {
                return 2;
            }
            return 1;
        }
        if (c == 'e' && ptr[cur + 1] == 'n' && ptr[cur + 2] == 'd' && ptr[cur + 3] == 'i' && ptr[cur + 4] == 'f') {
            cur += 5;
            --this.mIfLevel;
            if (this.mIfLevel < 0) {
                this.mCurrent = cur;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
            }
            c = ptr[cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            this.mCurrent = cur;
            if (c == '\u0000') {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private int skipUntilEndif() throws CompileException {
        int exl = this.mIfLevel++;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        block5: while (true) {
            if (c == '/') {
                this.mCurrent = cur;
                int ret = this.skipComment();
                cur = this.mCurrent;
                switch (ret) {
                    case 2: {
                        this.mCurrent = cur;
                        throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
                    }
                    case 1: {
                        c = ptr[cur];
                        continue block5;
                    }
                    case 0: {
                        c = ptr[++cur];
                        if (c == '\r' && ptr[cur + 1] == '\n') {
                            c = ptr[++cur];
                        }
                        if (c != '\u0000') continue block5;
                        this.mCurrent = cur;
                        throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
                    }
                }
                continue;
            }
            if (c == '@') {
                c = ptr[++cur];
                boolean skipp = false;
                if (c == 'i' && ptr[cur + 1] == 'f') {
                    ++this.mIfLevel;
                    c = ptr[cur += 2];
                    skipp = true;
                } else if (c == 's' && ptr[cur + 1] == 'e' && ptr[cur + 2] == 't') {
                    c = ptr[cur += 3];
                    skipp = true;
                } else if (c == 'e' && ptr[cur + 1] == 'n' && ptr[cur + 2] == 'd' && ptr[cur + 3] == 'i' && ptr[cur + 4] == 'f') {
                    c = ptr[cur += 5];
                    --this.mIfLevel;
                    if (this.mIfLevel == exl) {
                        while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                            c = ptr[++cur];
                        }
                        this.mCurrent = cur;
                        if (c == '\u0000') {
                            return 2;
                        }
                        return 1;
                    }
                }
                if (!skipp) continue;
                while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                    c = ptr[++cur];
                }
                if (c == '\u0000') {
                    this.mCurrent = cur;
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
                }
                if (c != '(') {
                    this.mCurrent = cur;
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
                }
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                int plevel = 0;
                while (c != '\u0000' && (plevel > 0 || c != ')')) {
                    if (c == '(') {
                        ++plevel;
                    } else if (c == ')') {
                        --plevel;
                    }
                    c = ptr[++cur];
                    if (c != '\r' || ptr[cur + 1] != '\n') continue;
                    c = ptr[++cur];
                }
                if (c == '\u0000') {
                    this.mCurrent = cur;
                    throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
                }
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c != '\u0000') continue;
                this.mCurrent = cur;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
            }
            if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            if (c == '\u0000') break;
        }
        this.mCurrent = cur;
        throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, cur);
    }

    private static final String escapeC(char c) {
        switch (c) {
            case '\u0007': {
                return "\\a";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\u000b': {
                return "\\v";
            }
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
        }
        if (c < ' ') {
            StringBuilder ret = mWorkBuilder;
            ret.delete(0, ret.length());
            ret.append("\\x");
            ret.append(Integer.toHexString(c));
            return ret.toString();
        }
        return String.valueOf(c);
    }

    private int putValue(Object val) {
        this.mValues.add(val);
        return this.mValues.size() - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getToken() throws CompileException {
        int retnum;
        boolean retry;
        char[] ptr = this.mText;
        int c = ptr[this.mCurrent];
        if (c == 0) {
            return 0;
        }
        if (this.mRegularExpression) {
            this.mRegularExpression = false;
            this.mCurrent = this.mPrevPos;
            ++this.mCurrent;
            if (this.mText[this.mCurrent] == '\r' && this.mText[this.mCurrent + 1] == '\n') {
                ++this.mCurrent;
            }
            String pattern = this.parseRegExp();
            this.mValue = this.putValue(pattern);
            return 387;
        }
        block45: do {
            retry = false;
            this.mPrevPos = this.mCurrent;
            c = ptr[this.mCurrent];
            switch (c) {
                case 0: {
                    return 0;
                }
                case 62: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 62) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c == 62) {
                            ++this.mCurrent;
                            c = ptr[this.mCurrent];
                            if (c != 61) return 291;
                            ++this.mCurrent;
                            return 273;
                        }
                        if (c != 61) return 289;
                        ++this.mCurrent;
                        return 271;
                    }
                    if (c != 61) return 286;
                    ++this.mCurrent;
                    return 288;
                }
                case 60: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 60) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c != 61) return 290;
                        ++this.mCurrent;
                        return 272;
                    }
                    if (c == 45) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c == 62) {
                            ++this.mCurrent;
                            return 284;
                        }
                        --this.mCurrent;
                        return 285;
                    }
                    if (c == 61) {
                        ++this.mCurrent;
                        return 287;
                    }
                    if (c != 37) return 285;
                    ByteBuffer buffer = this.parseOctet();
                    this.mValue = this.putValue(buffer);
                    return 385;
                }
                case 61: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 61) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c != 61) return 281;
                        ++this.mCurrent;
                        return 283;
                    }
                    if (c != 62) return 259;
                    ++this.mCurrent;
                    return 258;
                }
                case 33: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c != 61) return 296;
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c != 61) return 280;
                    ++this.mCurrent;
                    return 282;
                }
                case 38: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 38) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c != 61) return 276;
                        ++this.mCurrent;
                        return 270;
                    }
                    if (c != 61) return 279;
                    ++this.mCurrent;
                    return 260;
                }
                case 124: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 124) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c != 61) return 275;
                        ++this.mCurrent;
                        return 269;
                    }
                    if (c != 61) return 277;
                    ++this.mCurrent;
                    return 261;
                }
                case 46: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c >= 48 && c <= 57) {
                        --this.mCurrent;
                        Number o = this.parseNumber();
                        this.mValue = o != null ? (o instanceof Integer ? this.putValue((Integer)o) : (o instanceof Double ? this.putValue((Double)o) : this.putValue(null))) : this.putValue(null);
                        return 385;
                    }
                    if (c != 46) return 311;
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 46) {
                        ++this.mCurrent;
                        return 356;
                    }
                    --this.mCurrent;
                    return 311;
                }
                case 43: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 43) {
                        ++this.mCurrent;
                        return 299;
                    }
                    if (c != 61) return 303;
                    ++this.mCurrent;
                    return 264;
                }
                case 45: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 45) {
                        ++this.mCurrent;
                        return 298;
                    }
                    if (c != 61) return 304;
                    ++this.mCurrent;
                    return 263;
                }
                case 42: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c != 61) return 295;
                    ++this.mCurrent;
                    return 268;
                }
                case 47: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c == 47 || c == 42) {
                        --this.mCurrent;
                        int comment = this.skipComment();
                        if (comment == 1) {
                            retry = true;
                            break;
                        }
                        if (comment == 2) {
                            return 0;
                        }
                    }
                    if (c != 61) return 293;
                    ++this.mCurrent;
                    return 266;
                }
                case 92: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c != 61) return 294;
                    ++this.mCurrent;
                    return 267;
                }
                case 37: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c != 61) return 292;
                    ++this.mCurrent;
                    return 265;
                }
                case 94: {
                    ++this.mCurrent;
                    c = ptr[this.mCurrent];
                    if (c != 61) return 278;
                    ++this.mCurrent;
                    return 262;
                }
                case 91: {
                    ++this.mNestLevel;
                    ++this.mCurrent;
                    return 312;
                }
                case 93: {
                    --this.mNestLevel;
                    ++this.mCurrent;
                    return 316;
                }
                case 40: {
                    ++this.mNestLevel;
                    ++this.mCurrent;
                    return 310;
                }
                case 41: {
                    --this.mNestLevel;
                    ++this.mCurrent;
                    return 318;
                }
                case 126: {
                    ++this.mCurrent;
                    return 297;
                }
                case 63: {
                    ++this.mCurrent;
                    return 274;
                }
                case 58: {
                    ++this.mCurrent;
                    return 319;
                }
                case 44: {
                    ++this.mCurrent;
                    return 258;
                }
                case 59: {
                    ++this.mCurrent;
                    return 320;
                }
                case 123: {
                    ++this.mNestLevel;
                    ++this.mCurrent;
                    return 321;
                }
                case 125: {
                    --this.mNestLevel;
                    ++this.mCurrent;
                    return 322;
                }
                case 35: {
                    ++this.mCurrent;
                    return 305;
                }
                case 36: {
                    ++this.mCurrent;
                    return 306;
                }
                case 34: 
                case 39: {
                    ++this.mCurrent;
                    if (this.mText[this.mCurrent] == '\r' && this.mText[this.mCurrent + 1] == '\n') {
                        ++this.mCurrent;
                    }
                    String str = this.readString(c, false);
                    this.mValue = this.putValue(str);
                    return 385;
                }
                case 64: {
                    int org = this.mCurrent++;
                    c = ptr[this.mCurrent];
                    if (c == 13 && ptr[this.mCurrent + 1] == '\n') {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                    }
                    while (c != 0 && c <= 32 && (c == 13 || c == 10 || c == 9 || c == 32)) {
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                    }
                    if (c == 0) {
                        return 0;
                    }
                    if (c == 39 || c == 34) {
                        EmbeddableExpressionData data = new EmbeddableExpressionData();
                        data.mState = 0;
                        data.mWaitingNestLevel = this.mNestLevel;
                        data.mDelimiter = c;
                        data.mNeedPlus = false;
                        ++this.mCurrent;
                        c = ptr[this.mCurrent];
                        if (c == 13 && ptr[this.mCurrent + 1] == '\n') {
                            ++this.mCurrent;
                            c = ptr[this.mCurrent];
                        }
                        if (c == 0) {
                            return 0;
                        }
                        this.mEmbeddableExpressionDataStack.add(data);
                        return -1;
                    }
                    this.mCurrent = org;
                    switch (this.processPPStatement()) {
                        case 1: {
                            retry = true;
                            break;
                        }
                        case 2: {
                            return 0;
                        }
                        case 0: {
                            this.mCurrent = org;
                        }
                    }
                    continue block45;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    Number o = this.parseNumber();
                    if (o == null) throw new CompileException("\u6570\u5024\u3068\u3057\u3066\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093", this.mBlock, this.mCurrent);
                    if (o instanceof Integer) {
                        this.mValue = this.putValue((Integer)o);
                        return 385;
                    } else {
                        if (!(o instanceof Double)) throw new CompileException("\u6570\u5024\u3068\u3057\u3066\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093", this.mBlock, this.mCurrent);
                        this.mValue = this.putValue((Double)o);
                    }
                    return 385;
                }
            }
        } while (retry);
        if (!((c & 0xFF00) != 0 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95)) {
            String str = "\u4e0d\u6b63\u306a\u6587\u5b57\u3067\u3059 : '%1'".replace("%1", LexicalAnalyzer.escapeC((char)c));
            throw new CompileException(str, this.mBlock, this.mCurrent);
        }
        int oldC = c;
        int offset = this.mCurrent;
        int nch = 0;
        while (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95 || c >= 48 && c <= 57 || (c & 0xFF00) != 0) {
            ++this.mCurrent;
            c = ptr[this.mCurrent];
            ++nch;
        }
        if (nch == 0) {
            String str = "\u4e0d\u6b63\u306a\u6587\u5b57\u3067\u3059 : '%1'".replace("%1", LexicalAnalyzer.escapeC((char)oldC));
            throw new CompileException(str, this.mBlock, this.mCurrent);
        }
        String str = new String(ptr, offset, nch);
        if (this.mBareWord) {
            retnum = -1;
            this.mBareWord = false;
        } else {
            retnum = ReservedWordToken.getToken(str);
        }
        if (retnum == -1) {
            this.mValue = this.putValue(str);
            return 386;
        }
        switch (retnum) {
            case 363: {
                this.mValue = this.putValue(0);
                return 385;
            }
            case 364: {
                this.mValue = this.putValue(new VariantClosure(null));
                return 385;
            }
            case 365: {
                this.mValue = this.putValue(1);
                return 385;
            }
            case 367: {
                this.mValue = this.putValue(Double.NaN);
                return 385;
            }
            case 368: {
                this.mValue = this.putValue(Double.POSITIVE_INFINITY);
                return 385;
            }
        }
        return retnum;
    }

    public final int getValue() {
        return this.mValue;
    }

    public final int getNext() throws CompileException {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (this.mIsExprMode && this.mResultNeeded) {
                this.mValue = 0;
                return 335;
            }
        }
        int n = 0;
        this.mValue = 0;
        do {
            if (!this.mRetValDeque.isEmpty()) {
                long pair = this.mRetValDeque.pop_front();
                this.mValue = (int)(pair >>> 32);
                this.mPrevToken = (int)(pair & 0xFFFFFFFFL);
                return this.mPrevToken;
            }
            try {
                if (this.mEmbeddableExpressionDataStack.size() == 0) {
                    char c = this.mText[this.mCurrent];
                    while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                        ++this.mCurrent;
                        c = this.mText[this.mCurrent];
                    }
                    n = this.getToken();
                    if (CompileState.mEnableDicFuncQuickHack && this.mDicFunc) {
                        if (n == 292) {
                            this.mRetValDeque.push_back(324L);
                            this.mRetValDeque.push_back(321L);
                            this.mRetValDeque.push_back(335L);
                            this.mRetValDeque.push_back(292L);
                            n = -1;
                        } else if (n == 312 && this.mPrevToken != 292) {
                            this.mRetValDeque.push_back(324L);
                            this.mRetValDeque.push_back(321L);
                            this.mRetValDeque.push_back(335L);
                            this.mRetValDeque.push_back(312L);
                            n = -1;
                        } else if (n == 316) {
                            this.mRetValDeque.push_back(316L);
                            this.mRetValDeque.push_back(320L);
                            this.mRetValDeque.push_back(322L);
                            this.mRetValDeque.push_back(310L);
                            this.mRetValDeque.push_back(318L);
                            n = -1;
                        }
                    }
                } else {
                    EmbeddableExpressionData data = this.mEmbeddableExpressionDataStack.get(this.mEmbeddableExpressionDataStack.size() - 1);
                    switch (data.mState) {
                        case 0: {
                            this.mRetValDeque.push_back(310L);
                            n = -1;
                            data.mState = 1;
                            break;
                        }
                        case 1: {
                            int v;
                            String str = this.readString(data.mDelimiter, true);
                            int res = this.mStringStatus;
                            if (this.mStringStatus == 1) {
                                if (str.length() > 0 && data.mNeedPlus) {
                                    this.mRetValDeque.push_back(303L);
                                }
                                if (str.length() > 0 || !data.mNeedPlus) {
                                    v = this.putValue(str);
                                    this.mRetValDeque.push_back(0x181 | v << 32);
                                }
                                this.mRetValDeque.push_back(318L);
                                this.mEmbeddableExpressionDataStack.remove(this.mEmbeddableExpressionDataStack.size() - 1);
                                n = -1;
                                break;
                            }
                            if (str.length() > 0) {
                                if (data.mNeedPlus) {
                                    this.mRetValDeque.push_back(303L);
                                }
                                v = this.putValue(str);
                                this.mRetValDeque.push_back(0x181 | v << 32);
                                data.mNeedPlus = true;
                            }
                            if (data.mNeedPlus) {
                                this.mRetValDeque.push_back(303L);
                            }
                            this.mRetValDeque.push_back(361L);
                            this.mRetValDeque.push_back(310L);
                            data.mState = 2;
                            if (res == 2) {
                                data.mWaitingToken = 320;
                            } else if (res == 3) {
                                data.mWaitingToken = 322;
                                ++this.mNestLevel;
                            }
                            n = -1;
                            break;
                        }
                        case 2: {
                            char c = this.mText[this.mCurrent];
                            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                                ++this.mCurrent;
                                c = this.mText[this.mCurrent];
                            }
                            n = this.getToken();
                            if (n != data.mWaitingToken || this.mNestLevel != data.mWaitingNestLevel) break;
                            this.mRetValDeque.push_back(318L);
                            data.mNeedPlus = true;
                            data.mState = 1;
                            n = -1;
                        }
                    }
                }
                if (n != 0 || this.mIfLevel == 0) continue;
                throw new CompileException("\u6761\u4ef6\u30b3\u30f3\u30d1\u30a4\u30eb\u5f0f\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", this.mBlock, this.mCurrent);
            }
            catch (CompileException e) {
                e.printStackTrace();
                this.mBlock.error(e.getMessage());
                return 0;
            }
        } while (n < 0);
        this.mPrevToken = n;
        return n;
    }

    public int getCurrentPosition() {
        return this.mCurrent;
    }
}

