/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.LocalSymbolList;
import jp.kirikiri.tjs2.MaxCountWriter;
import jp.kirikiri.tjs2.VectorWrap;

public class LocalNamespace {
    private VectorWrap<LocalSymbolList> mLevels = new VectorWrap();
    private int mMaxCount;
    private int mCurrentCount;
    private MaxCountWriter mMaxCountWriter;

    public void setMaxCountWriter(MaxCountWriter writer) {
        this.mMaxCountWriter = writer;
    }

    public int getCount() {
        int count = 0;
        int size = this.mLevels.size();
        int i = 0;
        while (i < size) {
            LocalSymbolList list = (LocalSymbolList)this.mLevels.get(i);
            count += list.getCount();
            ++i;
        }
        return count;
    }

    public void push() {
        this.mCurrentCount = this.getCount();
        this.mLevels.add(new LocalSymbolList(this.mCurrentCount));
    }

    public void pop() {
        LocalSymbolList list = this.mLevels.lastElement();
        this.commit();
        this.mCurrentCount = list.getLocalCountStart();
        this.mLevels.remove(this.mLevels.size() - 1);
        list = null;
    }

    public int find(String name) {
        int count = this.mLevels.size();
        int i = count - 1;
        while (i >= 0) {
            LocalSymbolList list = (LocalSymbolList)this.mLevels.get(i);
            int lindex = list.find(name);
            if (lindex != -1) {
                return lindex + list.getLocalCountStart();
            }
            --i;
        }
        return -1;
    }

    public int getLevel() {
        return this.mLevels.size();
    }

    public void add(String name) {
        LocalSymbolList top = this.getTopSymbolList();
        if (top == null) {
            return;
        }
        top.add(name);
    }

    public void remove(String name) {
        int count = this.mLevels.size();
        int i = count - 1;
        while (i >= 0) {
            LocalSymbolList list = (LocalSymbolList)this.mLevels.get(i);
            int lindex = list.find(name);
            if (lindex != -1) {
                list.remove(lindex);
                return;
            }
            --i;
        }
    }

    public void commit() {
        int count = 0;
        int i = this.mLevels.size() - 1;
        while (i >= 0) {
            LocalSymbolList list = (LocalSymbolList)this.mLevels.get(i);
            count += list.getCount();
            --i;
        }
        if (this.mMaxCount < count) {
            this.mMaxCount = count;
            if (this.mMaxCountWriter != null) {
                this.mMaxCountWriter.setMaxCount(count);
            }
        }
    }

    public LocalSymbolList getTopSymbolList() {
        if (this.mLevels.size() == 0) {
            return null;
        }
        return this.mLevels.lastElement();
    }

    public void clear() {
        while (this.mLevels.size() > 0) {
            this.pop();
        }
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }
}

