/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.Random;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class MathClass
extends NativeClass {
    public static int mClassID;
    private static Random mRandomGenerator;
    private static final String CLASS_NAME = "Math";

    public static void initialize() {
        mRandomGenerator = null;
    }

    public static void finalizeApplication() {
        mRandomGenerator = null;
    }

    public MathClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        if (mRandomGenerator == null) {
            mRandomGenerator = new Random(System.currentTimeMillis());
        }
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        mClassID = NCM_CLASSID;
        this.registerNCM(CLASS_NAME, new NativeClassConstructor(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("abs", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.abs(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("acos", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.acos(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("asin", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.asin(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("atan", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.atan(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("atan2", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 2) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.atan2(param[0].asDouble(), param[1].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("ceil", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.ceil(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("exp", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.exp(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("floor", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.floor(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("log", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.log(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("pow", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 2) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.pow(param[0].asDouble(), param[1].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("max", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (result != null) {
                    double r = Double.NEGATIVE_INFINITY;
                    int count = param.length;
                    int i = 0;
                    while (i < count) {
                        double v = param[i].asDouble();
                        if (Double.isNaN(v)) {
                            result.set(Double.NaN);
                            return 0;
                        }
                        if (Double.compare(v, r) > 0) {
                            r = v;
                        }
                        ++i;
                    }
                    result.set(r);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("min", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (result != null) {
                    double r = Double.POSITIVE_INFINITY;
                    int count = param.length;
                    int i = 0;
                    while (i < count) {
                        double v = param[i].asDouble();
                        if (Double.isNaN(v)) {
                            result.set(Double.NaN);
                            return 0;
                        }
                        if (Double.compare(v, r) < 0) {
                            r = v;
                        }
                        ++i;
                    }
                    result.set(r);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("random", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (result != null) {
                    result.set(mRandomGenerator.nextDouble());
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("round", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.round(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("sin", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.sin(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("cos", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.cos(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("sqrt", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.sqrt(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("tan", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(Math.tan(param[0].asDouble()));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("E", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(Math.E);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("LOG2E", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(1.4426950408889634);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("LOG10E", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(0.4342944819032518);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("LN10", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(2.302585092994046);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("LN2", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(0.6931471805599453);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("PI", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(Math.PI);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("SQRT1_2", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(0.7071067811865476);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("SQRT2", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(1.4142135623730951);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
    }
}

