/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import jp.kirikiri.tjs2.MersenneTwisterData;

public class MersenneTwister
extends MersenneTwisterData {
    private static final int MT_N = 624;
    private static final int N = 624;
    private static final int M = 397;
    private static final long MATRIX_A = 2567483615L;
    private static final long UMASK = 0x80000000L;
    private static final long LMASK = Integer.MAX_VALUE;

    public MersenneTwister() {
        this(5489L);
    }

    public MersenneTwister(long s) {
        this.left = 1;
        this.init_genrand(s);
    }

    public MersenneTwister(int[] init_key) {
        this.init_genrand(19650218L);
        int i = 1;
        int j = 0;
        int k = 624 > init_key.length ? 624 : init_key.length;
        while (k > 0) {
            this.state.put(i, (this.state.get(i) ^ (this.state.get(i - 1) ^ this.state.get(i - 1) >> 30) * 1664525L) + (long)init_key[j] + (long)j & 0xFFFFFFFFL);
            ++j;
            if (++i >= 624) {
                this.state.put(0, this.state.get(623));
                i = 1;
            }
            if (j >= init_key.length) {
                j = 0;
            }
            --k;
        }
        k = 623;
        while (k > 0) {
            this.state.put(i, (this.state.get(i) ^ (this.state.get(i - 1) ^ this.state.get(i - 1) >> 30) * 1566083941L) - (long)i & 0xFFFFFFFFL);
            if (++i >= 624) {
                this.state.put(0, this.state.get(623));
                i = 1;
            }
            --k;
        }
        this.state.put(0, 0x80000000L);
        this.left = 1;
        this.next = 0;
    }

    public MersenneTwister(MersenneTwisterData data) {
        this.setData(data);
    }

    private void init_genrand(long s) {
        this.state.put(0, s & 0xFFFFFFFFL);
        int j = 1;
        while (j < 624) {
            this.state.put(j, 1812433253L * (this.state.get(j - 1) ^ this.state.get(j - 1) >> 30) + (long)j & 0xFFFFFFFFL);
            ++j;
        }
        this.left = 1;
        this.next = 0;
    }

    private void next_state() {
        long y;
        long x;
        int p = 0;
        this.left = 624;
        this.next = 0;
        int j = 228;
        while (--j > 0) {
            x = this.state.get(p) & 0x80000000L | this.state.get(p + 1) & Integer.MAX_VALUE;
            y = this.state.get(p + 397) ^ x >>> 1 ^ ((x & 1L) != 0L ? 2567483615L : 0L);
            this.state.put(p, y);
            ++p;
        }
        j = 397;
        while (--j > 0) {
            x = this.state.get(p) & 0x80000000L | this.state.get(p + 1) & Integer.MAX_VALUE;
            y = this.state.get(p + 397 - 624) ^ x >>> 1 ^ ((x & 1L) != 0L ? 2567483615L : 0L);
            this.state.put(p, y);
            ++p;
        }
        x = this.state.get(p) & 0x80000000L | this.state.get(0) & Integer.MAX_VALUE;
        y = this.state.get(-227) ^ x >>> 1 ^ ((x & 1L) != 0L ? 2567483615L : 0L);
        this.state.put(p, y);
    }

    public int int32() {
        long num;
        if (--this.left == 0) {
            this.next_state();
        }
        int y = (int)((num = this.state.get(this.next)) > Integer.MAX_VALUE ? num - 0x100000000L : num);
        ++this.next;
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    public int int31() {
        long num;
        if (--this.left == 0) {
            this.next_state();
        }
        int y = (int)((num = this.state.get(this.left)) > Integer.MAX_VALUE ? num - 0x100000000L : num);
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 1;
    }

    double real1() {
        if (--this.left == 0) {
            this.next_state();
        }
        long y = this.state.get(this.next);
        ++this.next;
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >>> 18;
        return (double)y * 2.3283064370807974E-10;
    }

    public double real2() {
        if (--this.left == 0) {
            this.next_state();
        }
        long y = this.state.get(this.next);
        ++this.next;
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >>> 18;
        return (double)y * 2.3283064365386963E-10;
    }

    public double real3() {
        if (--this.left == 0) {
            this.next_state();
        }
        long y = this.state.get(this.next);
        ++this.next;
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >>> 18;
        return ((double)y + 0.5) * 2.3283064365386963E-10;
    }

    public double res53() {
        if (--this.left == 0) {
            this.next_state();
        }
        long a = this.state.get(this.next);
        ++this.next;
        a ^= a >>> 11;
        a ^= a << 7 & 0xFFFFFFFF9D2C5680L;
        a ^= a << 15 & 0xFFFFFFFFEFC60000L;
        a ^= a >>> 18;
        a >>>= 5;
        if (--this.left == 0) {
            this.next_state();
        }
        long b = this.state.get(this.next);
        ++this.next;
        b ^= b >>> 11;
        b ^= b << 7 & 0xFFFFFFFF9D2C5680L;
        b ^= b << 15 & 0xFFFFFFFFEFC60000L;
        b ^= b >>> 18;
        return ((double)a * 6.7108864E7 + (double)(b >>>= 6)) * (double)1.110223E-16f;
    }

    public double rand_double() {
        if (--this.left == 0) {
            this.next_state();
        }
        long y = this.state.get(this.next);
        ++this.next;
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >>> 18;
        long v = (y & 0xFFFFFFFFL) << 32;
        if (--this.left == 0) {
            this.next_state();
        }
        y = this.state.get(this.next);
        ++this.next;
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >>> 18;
        v |= y & 0xFFFFFFFFL;
        v &= 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(v |= 0x3FF0000000000000L) - 1.0;
    }

    public final MersenneTwisterData getData() {
        return this;
    }

    public void setData(MersenneTwisterData rhs) {
        LongBuffer src = rhs.state.duplicate();
        src.position(0);
        src.limit(624);
        ByteBuffer buff = ByteBuffer.allocateDirect(4992);
        buff.order(ByteOrder.nativeOrder());
        this.state = buff.asLongBuffer();
        this.state.clear();
        this.state.put(src);
        this.next = rhs.next;
        this.left = rhs.left;
    }
}

