/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.TJS;

public class MessageMapper {
    HashMap<String, MessageHolder> mHash = new HashMap();

    public void register(String name, MessageHolder holder) {
        this.mHash.put(name, holder);
    }

    public void unregister(String name) {
        this.mHash.remove(name);
    }

    public boolean assignMessage(String name, String newmsg) {
        MessageHolder holder = this.mHash.get(name);
        if (holder != null) {
            holder.assignMessage(newmsg);
            return true;
        }
        return false;
    }

    public String get(String name) {
        MessageHolder holder = this.mHash.get(name);
        if (holder != null) {
            return holder.getMessage();
        }
        return null;
    }

    public String createMessageMapString() {
        StringBuilder script = new StringBuilder();
        Set<Map.Entry<String, MessageHolder>> ite = this.mHash.entrySet();
        for (Map.Entry entry : ite) {
            String name = (String)entry.getKey();
            MessageHolder h = (MessageHolder)entry.getValue();
            script.append("\tr(\"");
            script.append(LexBase.escapeC(name));
            script.append("\", \"");
            script.append(LexBase.escapeC(h.getMessage()));
            script.append("\");\n");
        }
        return script.toString();
    }

    public static class MessageHolder {
        final String mName;
        final String mDefaultMessage;
        String mAssignedMessage;

        public MessageHolder(String name, String defmsg) {
            this.mDefaultMessage = defmsg;
            this.mName = name;
            TJS.registerMessageMap(this.mName, this);
        }

        public MessageHolder(String name, String defmsg, boolean regist) {
            this.mDefaultMessage = defmsg;
            if (regist) {
                this.mName = name;
                TJS.registerMessageMap(this.mName, this);
            } else {
                this.mName = null;
            }
        }

        protected void finalize() {
            if (this.mName != null) {
                TJS.unregisterMessageMap(this.mName);
            }
            if (this.mAssignedMessage != null) {
                this.mAssignedMessage = null;
            }
        }

        public void assignMessage(String msg) {
            if (this.mAssignedMessage != null) {
                this.mAssignedMessage = null;
            }
            this.mAssignedMessage = msg;
        }

        public String getMessage() {
            return this.mAssignedMessage != null ? this.mAssignedMessage : this.mDefaultMessage;
        }
    }
}

