/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashSet;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.NativeJavaClassConstructor;
import jp.kirikiri.tjs2.NativeJavaClassMethod;
import jp.kirikiri.tjs2.NativeJavaClassProperty;
import jp.kirikiri.tjs2.NativeJavaInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class NativeJavaClass
extends NativeClass {
    private Class<?> mJavaClass;
    private int mClassID;

    public NativeJavaClass(String name, Class<?> c) throws VariantException, TJSException {
        super(name);
        this.mJavaClass = c;
        String classname = name;
        this.mClassID = TJS.registerNativeClass(classname);
        try {
            Method[] methods;
            HashSet<String> registProp = new HashSet<String>();
            Method[] methodArray = methods = c.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                String methodName = m.getName();
                int modif = m.getModifiers();
                int flag = 0;
                if (Modifier.isStatic(modif)) {
                    flag |= 0x10000;
                }
                if ("constructor".equals(methodName)) {
                    this.registerNCM(classname, new NativeJavaClassConstructor(m, this.mClassID), classname, 1, flag);
                } else if (methodName.startsWith("prop_")) {
                    Class<?>[] p;
                    int n3;
                    int n4;
                    Method[] methodArray2;
                    Class<?>[] params = m.getParameterTypes();
                    Method setMethod = null;
                    Method getMethod = null;
                    String propName = null;
                    if (methodName.startsWith("prop_set_")) {
                        if (params.length == 1) {
                            setMethod = m;
                            propName = methodName.substring("prop_set_".length());
                            if (!registProp.contains(propName)) {
                                String getMethodName = "prop_get_" + propName;
                                methodArray2 = methods;
                                n4 = methods.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    Method getm = methodArray2[n3];
                                    if (getm.getName().equals(getMethodName) && (p = getm.getParameterTypes()).length == 0 && !getm.getReturnType().equals(Void.TYPE)) {
                                        getMethod = getm;
                                        break;
                                    }
                                    ++n3;
                                }
                            }
                        }
                    } else if (methodName.startsWith("prop_get_") && params.length == 0 && !m.getReturnType().equals(Void.TYPE)) {
                        getMethod = m;
                        propName = methodName.substring("prop_get_".length());
                        if (!registProp.contains(propName)) {
                            String setMethodName = "prop_set_" + propName;
                            methodArray2 = methods;
                            n4 = methods.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Method setm = methodArray2[n3];
                                if (setm.getName().equals(setMethodName) && (p = setm.getParameterTypes()).length == 1) {
                                    setMethod = setm;
                                    break;
                                }
                                ++n3;
                            }
                        }
                    }
                    if (!(propName == null || registProp.contains(propName) || setMethod == null && getMethod == null)) {
                        this.registerNCM(propName, new NativeJavaClassProperty(getMethod, setMethod, this.mClassID), classname, 2, flag);
                        registProp.add(propName);
                    }
                } else {
                    this.registerNCM(methodName, new NativeJavaClassMethod(m, this.mClassID), classname, 1, flag);
                }
                ++n2;
            }
            registProp = null;
        }
        catch (SecurityException e) {
            throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e.toString());
        }
    }

    @Override
    protected NativeInstance createNativeInstance() {
        Object obj;
        try {
            obj = this.mJavaClass.newInstance();
        }
        catch (InstantiationException e) {
            TJS.outputExceptionToConsole(e.toString());
            return null;
        }
        catch (IllegalAccessException e) {
            TJS.outputExceptionToConsole(e.toString());
            return null;
        }
        if (obj != null) {
            return new NativeJavaInstance(obj);
        }
        return null;
    }

    public static Object variantToJavaObject(Variant param, Class<?> type) throws VariantException {
        if (type.isPrimitive()) {
            if (type.equals(Integer.TYPE)) {
                return param.asInteger();
            }
            if (type.equals(Double.TYPE)) {
                return param.asDouble();
            }
            if (type.equals(Boolean.TYPE)) {
                return param.asInteger() != 0;
            }
            if (type.equals(Float.TYPE)) {
                return Float.valueOf((float)param.asDouble());
            }
            if (type.equals(Long.TYPE)) {
                return (long)param.asInteger();
            }
            if (type.equals(Character.TYPE)) {
                return Character.valueOf((char)param.asInteger());
            }
            if (type.equals(Byte.TYPE)) {
                return (byte)param.asInteger();
            }
            if (type.equals(Short.TYPE)) {
                return (short)param.asInteger();
            }
            return null;
        }
        if (type.equals(String.class)) {
            return param.asString();
        }
        if (type.equals(ByteBuffer.class)) {
            return param.asOctet();
        }
        if (type.equals(Variant.class)) {
            return param;
        }
        if (type.equals(VariantClosure.class)) {
            return param.asObjectClosure();
        }
        if (type.equals(Dispatch2.class)) {
            return param.asObject();
        }
        if (type.equals(param.toJavaObject().getClass())) {
            return param.toJavaObject();
        }
        return null;
    }

    public static void javaObjectToVariant(Variant result, Class<?> type, Object src) {
        if (result == null) {
            return;
        }
        if (type.isPrimitive()) {
            if (type.equals(Integer.TYPE)) {
                result.set((Integer)src);
            } else if (type.equals(Double.TYPE)) {
                result.set((Double)src);
            } else if (type.equals(Boolean.TYPE)) {
                result.set((Boolean)src != false ? 1 : 0);
            } else if (type.equals(Float.TYPE)) {
                result.set(((Float)src).doubleValue());
            } else if (type.equals(Long.TYPE)) {
                result.set(((Long)src).intValue());
            } else if (type.equals(Character.TYPE)) {
                result.set(((Character)src).charValue());
            } else if (type.equals(Byte.TYPE)) {
                result.set(((Byte)src).intValue());
            } else if (type.equals(Short.TYPE)) {
                result.set(((Short)src).intValue());
            } else {
                result.clear();
            }
        } else if (type.equals(String.class)) {
            result.set((String)src);
        } else if (type.equals(ByteBuffer.class)) {
            result.set((ByteBuffer)src);
        } else if (type.equals(Variant.class)) {
            result.set((Variant)src);
        } else if (type.equals(VariantClosure.class)) {
            result.set(((VariantClosure)src).mObject, ((VariantClosure)src).mObjThis);
        } else if (type.equals(Dispatch2.class)) {
            result.set((Dispatch2)src);
        } else {
            result.setJavaObject(src);
        }
    }

    public static Object[] variantArrayToJavaObjectArray(Variant[] params, Class<?>[] types) throws VariantException {
        if (types.length == 0) {
            return null;
        }
        if (params.length < types.length) {
            return null;
        }
        int count = types.length;
        Object[] ret = new Object[count];
        int i = 0;
        while (i < count) {
            Class<?> type = types[i];
            Variant param = params[i];
            ret[i] = type.isPrimitive() ? (type.equals(Integer.TYPE) ? Integer.valueOf(param.asInteger()) : (type.equals(Double.TYPE) ? Double.valueOf(param.asDouble()) : (type.equals(Boolean.TYPE) ? Boolean.valueOf(param.asInteger() != 0) : (type.equals(Float.TYPE) ? Float.valueOf((float)param.asDouble()) : (type.equals(Long.TYPE) ? Long.valueOf(param.asInteger()) : (type.equals(Character.TYPE) ? (Serializable)Character.valueOf((char)param.asInteger()) : (Serializable)(type.equals(Byte.TYPE) ? (Number)((byte)param.asInteger()) : (Number)(type.equals(Short.TYPE) ? Short.valueOf((short)param.asInteger()) : null)))))))) : (type.equals(String.class) ? param.asString() : (type.equals(ByteBuffer.class) ? param.asOctet() : (type.equals(Variant.class) ? param : (type.equals(VariantClosure.class) ? param.asObjectClosure() : (type.equals(Dispatch2.class) ? param.asObject() : (type.equals(param.toJavaObject().getClass()) ? param.toJavaObject() : null))))));
            ++i;
        }
        return ret;
    }
}

